/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.net;

import com.xnx3.BaseVO;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HuaweiSMSUtil {
    private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";
    private static final String url = "https://rtcsms.cn-north-1.myhuaweicloud.com:10743/sms/batchSendSms/v1";
    private String appKey;
    private String appSecret;
    private String sender;
    private String signature;

    public HuaweiSMSUtil(String appKey, String appSecret, String sender, String signature) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.sender = sender;
        this.signature = signature;
    }

    public BaseVO send(String phone, String templateId, String templateParas) {
        String statusCallBack;
        String body;
        if (phone.indexOf("+") != 0) {
            phone = "+86" + phone;
        }
        if (null == (body = HuaweiSMSUtil.buildRequestBody(this.sender, phone, templateId, templateParas, statusCallBack = "", this.signature)) || body.isEmpty()) {
            return BaseVO.failure((String)"body is null.");
        }
        String wsseHeader = HuaweiSMSUtil.buildWsseHeader(this.appKey, this.appSecret);
        if (null == wsseHeader || wsseHeader.isEmpty()) {
            return BaseVO.failure((String)"wsse header is null.");
        }
        CloseableHttpClient client = null;
        try {
            client = HttpClients.custom().setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build()).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
            return BaseVO.failure((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return BaseVO.failure((String)e.getMessage());
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return BaseVO.failure((String)e.getMessage());
        }
        try {
            JSONObject json;
            CloseableHttpResponse response = client.execute(RequestBuilder.create((String)"POST").setUri(url).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", AUTH_HEADER_VALUE).addHeader("X-WSSE", wsseHeader).setEntity((HttpEntity)new StringEntity(body)).build());
            String responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            if (responseContent != null && (json = JSONObject.fromObject((Object)responseContent)).get("code") != null && json.getString("code").equals("000000")) {
                return BaseVO.success((String)"success");
            }
            return BaseVO.failure((String)responseContent);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            return BaseVO.failure((String)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return BaseVO.failure((String)e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            return BaseVO.failure((String)e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        String appKey = "3RwC21LkS2xxxxxxxxxx";
        String appSecret = "IWLr67lg4TshegBTlxxxxxxxxxxxx";
        String sender = "10690400999000000000";
        String signature = "\u534e\u4e3a\u4e91\u77ed\u4fe1\u6d4b\u8bd5";
        HuaweiSMSUtil sms = new HuaweiSMSUtil(appKey, appSecret, sender, signature);
        sms.send("17000000000", "58972990fb1b4b16abf312d991a00e00", "[\"369751\"]");
    }

    static String buildRequestBody(String sender, String receiver, String templateId, String templateParas, String statusCallbackUrl, String signature) {
        if (null == sender || null == receiver || null == templateId || sender.isEmpty() || receiver.isEmpty() || templateId.isEmpty()) {
            System.out.println("buildRequestBody(): sender, receiver or templateId is null.");
            return null;
        }
        ArrayList<BasicNameValuePair> keyValues = new ArrayList<BasicNameValuePair>();
        keyValues.add(new BasicNameValuePair("from", sender));
        keyValues.add(new BasicNameValuePair("to", receiver));
        keyValues.add(new BasicNameValuePair("templateId", templateId));
        if (null != templateParas && !templateParas.isEmpty()) {
            keyValues.add(new BasicNameValuePair("templateParas", templateParas));
        }
        if (null != statusCallbackUrl && !statusCallbackUrl.isEmpty()) {
            keyValues.add(new BasicNameValuePair("statusCallback", statusCallbackUrl));
        }
        if (null != signature && !signature.isEmpty()) {
            keyValues.add(new BasicNameValuePair("signature", signature));
        }
        return URLEncodedUtils.format(keyValues, (Charset)Charset.forName("UTF-8"));
    }

    static String buildWsseHeader(String appKey, String appSecret) {
        if (null == appKey || null == appSecret || appKey.isEmpty() || appSecret.isEmpty()) {
            System.out.println("buildWsseHeader(): appKey or appSecret is null.");
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String time = sdf.format(new Date());
        String nonce = UUID.randomUUID().toString().replace("-", "");
        byte[] passwordDigest = DigestUtils.sha256((String)(nonce + time + appSecret));
        String hexDigest = Hex.encodeHexString((byte[])passwordDigest);
        String passwordDigestBase64Str = Base64.getEncoder().encodeToString(hexDigest.getBytes());
        return String.format(WSSE_HEADER_FORMAT, appKey, passwordDigestBase64Str, nonce, time);
    }
}

