/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util.actionLog;

import com.xnx3.Lang;
import com.xnx3.StringUtil;
import com.xnx3.elasticsearch.ElasticSearchUtil;
import com.xnx3.elasticsearch.jsonFormat.JsonFormatInterface;
import com.xnx3.j2ee.Global;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.ApplicationPropertiesUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.actionLog.ActionLogInterface;
import com.xnx3.j2ee.vo.ActionLogListVO;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class ElasticSearchMode
implements ActionLogInterface {
    public static final String indexName = "useraction";
    public static ElasticSearchUtil es;

    public static void main(String[] args) {
        String queryString = "time > 0";
        Global.system.put("a", "");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CountRequest countRequest = new CountRequest();
        if (queryString != null && queryString.length() > 0) {
            QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)queryString);
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
        }
        countRequest.indices(new String[]{indexName}).source(searchSourceBuilder);
        CountResponse countResponse = null;
        try {
            countResponse = es.getRestHighLevelClient().count(countRequest, RequestOptions.DEFAULT);
            System.out.println("countResponse.getCount(): " + countResponse.getCount());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void add(Map<String, Object> map) {
        if (es == null) {
            return;
        }
        es.cache(map, indexName);
    }

    @Override
    public boolean cacheCommit() {
        es.cacheSubmit(indexName);
        return true;
    }

    @Override
    public ActionLogListVO list(String query, int everyPageNumber, HttpServletRequest request) {
        return this.list(indexName, query, everyPageNumber, request);
    }

    @Override
    public ActionLogListVO list(String indexName, String query, int everyPageNumber, HttpServletRequest request) {
        ActionLogListVO vo = new ActionLogListVO();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CountRequest countRequest = new CountRequest();
        if (query != null && query.length() > 0) {
            QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query);
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
        }
        countRequest.indices(new String[]{indexName}).source(searchSourceBuilder);
        long count = 0L;
        CountResponse countResponse = null;
        try {
            countResponse = es.getRestHighLevelClient().count(countRequest, RequestOptions.DEFAULT);
            count = countResponse.getCount();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Page page = new Page((int)count, everyPageNumber, request);
        int limitNumber = everyPageNumber;
        if (page.isCurrentLastPage()) {
            limitNumber = (int)(count - (long)page.getLimitStart());
        }
        long max_result_window = 10000L;
        try {
            Response res = es.getRestClient().performRequest(new Request("GET", "/" + indexName + "/_settings"));
            String text = StringUtil.inputStreamToString((InputStream)res.getEntity().getContent(), (String)"UTF-8");
            JSONObject setJson = JSONObject.fromObject((Object)text);
            JSONObject indexJson = setJson.getJSONObject(indexName).getJSONObject("settings").getJSONObject("index");
            if (indexJson.get("max_result_window") != null) {
                max_result_window = indexJson.getLong("max_result_window");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((long)(page.getLimitStart() + limitNumber) > max_result_window) {
            vo.setBaseVO(0, "\u663e\u793a\u6700\u5927\u6761\u6570\u8d85\u8fc7\u7cfb\u7edf\u9884\u8bbe\u4f18\u5316\u7684\u6700\u5927\u6761\u6570" + max_result_window + "\u6761\u3002");
            ConsoleUtil.log("\u663e\u793a\u6700\u5927\u6761\u6570\u8d85\u8fc7\u7cfb\u7edf\u9884\u8bbe\u4f18\u5316\u7684\u6700\u5927\u6761\u6570" + max_result_window + "\u6761\u3002\u4f60\u53ef\u4ee5\u8bbe\u7f6eElasticSearch\u4e2d\uff0c" + indexName + "\u7d22\u5f15\u7684max_result_window\u5c5e\u6027\u6765\u8bbe\u7f6e\u66f4\u5927\u6761\u6570\u3002");
            return vo;
        }
        List list = es.search(indexName, query, Integer.valueOf(page.getLimitStart()), Integer.valueOf(limitNumber), SortBuilders.fieldSort((String)"time").order(SortOrder.DESC));
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            Object timeObj = map.get("time");
            if (timeObj == null) {
                map.put("logtime", 0L);
                continue;
            }
            map.put("logtime", timeObj);
        }
        vo.setJsonArray(JSONArray.fromObject((Object)list));
        vo.setPage(page);
        return vo;
    }

    static {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String hostname = ApplicationPropertiesUtil.getProperty("wm.elasticsearch.hostname");
                int port = Lang.stringToInt((String)ApplicationPropertiesUtil.getProperty("wm.elasticsearch.port"), (int)9200);
                String scheme = ApplicationPropertiesUtil.getProperty("wm.elasticsearch.scheme");
                String username = ApplicationPropertiesUtil.getProperty("wm.elasticsearch.username");
                String password = ApplicationPropertiesUtil.getProperty("wm.elasticsearch.password");
                if (hostname != null && hostname.length() > 0) {
                    es = new ElasticSearchUtil(hostname, port, scheme);
                    if (username != null && username.length() > 0 && password != null && password.length() > 0) {
                        es.setUsernameAndPassword(username, password);
                    }
                    ConsoleUtil.info("\u5f00\u542fElasticSearch\u8fdb\u884c\u64cd\u4f5c\u8bb0\u5f55");
                    if (!es.existIndex(ElasticSearchMode.indexName)) {
                        try {
                            CreateIndexResponse res = es.createIndex(ElasticSearchMode.indexName);
                            ConsoleUtil.info("\u68c0\u6d4b\u5230\u7528\u6237\u52a8\u4f5c\u7684\u5b58\u50a8\u7d22\u5f15\u4e0d\u5b58\u5728\uff0c\u5df2\u81ea\u52a8\u521b\u5efauseraction\u7d22\u5f15\u3002");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    es.setJsonFormatInterface(new JsonFormatInterface(){

                        public String mapToJsonString(Map<String, Object> params) {
                            if (params == null) {
                                params = new HashMap<String, Object>();
                            }
                            return JSONObject.fromObject(params).toString();
                        }
                    });
                    ActionLogUtil.actionLogInterface = new ElasticSearchMode();
                }
            }
        }).start();
    }
}

