/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util.actionLog;

import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.exception.LogException;
import com.xnx3.j2ee.Global;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.util.actionLog.ActionLogInterface;
import com.xnx3.j2ee.vo.ActionLogListVO;
import com.xnx3.net.AliyunLogPageUtil;
import com.xnx3.net.AliyunLogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;

public class AliyunSLSMode
implements ActionLogInterface {
    public static AliyunLogUtil aliyunLogUtil = null;
    static String keyId;
    static String keySecret;
    static String endpoint;
    static String project;

    @Override
    public void add(Map<String, Object> map) {
        if (aliyunLogUtil == null) {
            return;
        }
        LogItem logItem = aliyunLogUtil.newLogItem();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String value = null;
            value = entry.getValue() == null ? "" : entry.getValue().toString() + "";
            logItem.PushBack(entry.getKey(), value);
        }
        try {
            aliyunLogUtil.cacheLog(logItem);
        }
        catch (LogException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Object> logitemToMap(LogItem logItem) {
        if (logItem == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList array = logItem.GetLogContents();
        for (int i = 0; i < array.size(); ++i) {
            LogContent log = (LogContent)array.get(i);
            map.put(log.GetKey(), log.GetValue());
        }
        return map;
    }

    @Override
    public boolean cacheCommit() {
        if (aliyunLogUtil != null) {
            try {
                if (AliyunSLSMode.aliyunLogUtil.logGroupCache.size() > 0) {
                    aliyunLogUtil.cacheCommit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public ActionLogListVO list(String query, int everyPageNumber, HttpServletRequest request) {
        AliyunLogPageUtil log = new AliyunLogPageUtil(aliyunLogUtil);
        return this.list(log, query, everyPageNumber, request);
    }

    @Override
    public ActionLogListVO list(String indexName, String query, int everyPageNumber, HttpServletRequest request) {
        AliyunLogPageUtil log = new AliyunLogPageUtil(endpoint, keyId, keySecret, project, indexName);
        return this.list(log, query, everyPageNumber, request);
    }

    private ActionLogListVO list(AliyunLogPageUtil aliyunLogPageUtil, String query, int everyPageNumber, HttpServletRequest request) {
        JSONArray jsonArray = null;
        try {
            jsonArray = aliyunLogPageUtil.list(query, "", true, everyPageNumber, request);
        }
        catch (LogException e) {
            e.printStackTrace();
        }
        if (jsonArray == null) {
            jsonArray = new JSONArray();
        }
        Page page = aliyunLogPageUtil.getPage();
        ActionLogListVO vo = new ActionLogListVO();
        vo.setJsonArray(jsonArray);
        vo.setPage(page);
        return vo;
    }

    static {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (Global.system.size() < 1) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (ActionLogUtil.actionLogInterface != null) {
                    return;
                }
                String use = SystemUtil.get("ALIYUN_SLS_USE");
                if (use != null && use.equals("1")) {
                    int log_cache_max_number;
                    keyId = SystemUtil.get("ALIYUN_ACCESSKEYID");
                    keySecret = SystemUtil.get("ALIYUN_ACCESSKEYSECRET");
                    endpoint = SystemUtil.get("ALIYUN_SLS_ENDPOINT");
                    project = SystemUtil.get("ALIYUN_SLS_PROJECT");
                    String logstore = SystemUtil.get("ALIYUN_SLS_USERACTION_LOGSTORE");
                    int log_cache_max_time = SystemUtil.getInt("ALIYUN_SLS_CACHE_MAX_TIME");
                    if (log_cache_max_time == 0) {
                        log_cache_max_time = 120;
                    }
                    if ((log_cache_max_number = SystemUtil.getInt("ALIYUN_SLS_CACHE_MAX_NUMBER")) == 0) {
                        log_cache_max_number = 100;
                    }
                    if (keyId.length() > 10) {
                        aliyunLogUtil = new AliyunLogUtil(endpoint, keyId, keySecret, project, logstore);
                        aliyunLogUtil.setStackTraceDeep(5);
                        aliyunLogUtil.setCacheAutoSubmit(log_cache_max_number, log_cache_max_time);
                        ConsoleUtil.info("\u5f00\u542f\u963f\u91cc\u4e91\u65e5\u5fd7\u670d\u52a1\u8fdb\u884c\u64cd\u4f5c\u8bb0\u5f55");
                    }
                    ActionLogUtil.actionLogInterface = new AliyunSLSMode();
                }
                ActionLogUtil.aliyunLogUtil = aliyunLogUtil;
            }
        }).start();
    }
}

