/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util;

import com.google.gson.Gson;
import com.xnx3.j2ee.bean.ActiveUser;
import com.xnx3.j2ee.bean.PermissionMark;
import com.xnx3.j2ee.bean.PermissionTree;
import com.xnx3.j2ee.entity.Permission;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.shiro.ShiroFunc;
import com.xnx3.j2ee.util.CacheUtil;
import com.xnx3.j2ee.util.RedisUtil;
import com.xnx3.j2ee.util.SystemUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;

public class SessionUtil
extends ShiroFunc {
    public static final String PLUGIN_NAME_UEDITOR_ALLOW_UPLOAD = "system:ueditor:allowUploadForUEditor";
    public static final String PLUGIN_NAME_UEDITOR_UPLOAD_PARAM_1 = "system:ueditor:ueUploadParam1";
    public static final String PLUGIN_NAME_LANGUAGE_PACKAGE_NAME = "system:languagePackageName";
    public static final String REDIS_PLUGIN_MAP_NAME = "com.xnx3.j2ee.bean.ActiveUser.plugin.userid";
    public static final int REDIS_PLUGIN_MAP_EXPIRETIME = 172800;

    public static boolean isLogin() {
        Subject subject = SecurityUtils.getSubject();
        return subject.getPrincipal() != null;
    }

    public static ActiveUser getActiveUser() {
        if (SecurityUtils.getSubject() == null) {
            return null;
        }
        Subject subject = SecurityUtils.getSubject();
        ActiveUser activeUser = null;
        Object obj = subject.getPrincipal();
        if (obj == null) {
            return null;
        }
        if (SystemUtil.isJarRun()) {
            if (obj instanceof ActiveUser) {
                activeUser = (ActiveUser)obj;
            } else {
                Gson gson = new Gson();
                activeUser = (ActiveUser)gson.fromJson(gson.toJson(obj), ActiveUser.class);
            }
        } else {
            activeUser = (ActiveUser)obj;
        }
        if (activeUser != null) {
            return activeUser;
        }
        return null;
    }

    public static ActiveUser getActiveUser(String token) {
        Session se;
        if (CacheUtil.isUseRedis()) {
            SimpleSession s;
            SimplePrincipalCollection principal;
            ActiveUser activeUser;
            Object obj = CacheUtil.get((String)("shiro:session:" + token));
            if (obj != null && (activeUser = (ActiveUser)(principal = (SimplePrincipalCollection)(s = (SimpleSession)obj).getAttribute((Object)"org.apache.shiro.subject.support.DefaultSubjectContext_PRINCIPALS_SESSION_KEY")).getPrimaryPrincipal()) != null) {
                return activeUser;
            }
            return null;
        }
        DefaultSessionKey sessionKey = new DefaultSessionKey((Serializable)((Object)token));
        SecurityManager manager = SecurityUtils.getSecurityManager();
        try {
            se = manager.getSession((SessionKey)sessionKey);
        }
        catch (UnknownSessionException e) {
            return null;
        }
        if (se == null) {
            return null;
        }
        Object obj = se.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
        if (obj == null) {
            return null;
        }
        SimplePrincipalCollection coll = (SimplePrincipalCollection)obj;
        if (coll == null) {
            return null;
        }
        Object p = coll.getPrimaryPrincipal();
        if (p != null) {
            return (ActiveUser)p;
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(SessionUtil.getActiveUser("s"));
    }

    public static Object getPluginObject(ActiveUser activeUser, String key) {
        if (activeUser == null) {
            return null;
        }
        Object obj = null;
        User user = activeUser.getUser();
        if (user == null) {
            return null;
        }
        if (CacheUtil.isUseRedis()) {
            Object redisObj = CacheUtil.get((String)("com.xnx3.j2ee.bean.ActiveUser.plugin.userid:" + user.getId()));
            if (redisObj == null) {
                return null;
            }
            HashMap map = (HashMap)redisObj;
            obj = map.get(key);
        } else {
            obj = activeUser.getPluginMap().get(key);
        }
        if (obj == null) {
            return null;
        }
        return obj;
    }

    public static <T> T getPlugin(String key) {
        ActiveUser activeUser = SessionUtil.getActiveUser();
        Object obj = SessionUtil.getPluginObject(activeUser, key);
        if (obj == null) {
            return null;
        }
        return (T)obj;
    }

    public static Object getPluginObject(String key) {
        ActiveUser activeUser = SessionUtil.getActiveUser();
        return SessionUtil.getPluginObject(activeUser, key);
    }

    public static void setPlugin(ActiveUser activeUser, String key, Object value) {
        if (activeUser == null) {
            return;
        }
        User user = activeUser.getUser();
        if (user == null) {
            return;
        }
        if (RedisUtil.isUse()) {
            HashMap<String, Object> map = null;
            Object obj = RedisUtil.getObject("com.xnx3.j2ee.bean.ActiveUser.plugin.userid:" + user.getId());
            map = obj == null ? new HashMap<String, Object>() : (HashMap<String, Object>)obj;
            map.put(key, value);
            RedisUtil.setObject("com.xnx3.j2ee.bean.ActiveUser.plugin.userid:" + user.getId(), map, 172800);
        } else {
            activeUser.getPluginMap().put(key, value);
        }
    }

    public static void setPlugin(String key, Object value) {
        ActiveUser activeUser = SessionUtil.getActiveUser();
        SessionUtil.setPlugin(activeUser, key, value);
    }

    public static boolean isAllowUploadForUEditor() {
        Object obj = SessionUtil.getPluginObject(PLUGIN_NAME_UEDITOR_ALLOW_UPLOAD);
        if (obj == null) {
            return true;
        }
        return (Boolean)obj;
    }

    public static void setAllowUploadForUEditor(boolean isAllow) {
        SessionUtil.setPlugin(PLUGIN_NAME_UEDITOR_ALLOW_UPLOAD, isAllow);
    }

    public static String getUeUploadParam1() {
        String param = (String)SessionUtil.getPlugin(PLUGIN_NAME_UEDITOR_UPLOAD_PARAM_1);
        if (param == null) {
            return "defaultparam1";
        }
        return param;
    }

    public static void setUeUploadParam1(String param) {
        SessionUtil.setPlugin(PLUGIN_NAME_UEDITOR_UPLOAD_PARAM_1, param);
    }

    public static String getLanguagePackageName() {
        return (String)SessionUtil.getPlugin(PLUGIN_NAME_LANGUAGE_PACKAGE_NAME);
    }

    public static void setLanguagePackageName(String name) {
        SessionUtil.setPlugin(PLUGIN_NAME_LANGUAGE_PACKAGE_NAME, name);
    }

    public static void logout() {
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            int userid = SessionUtil.getUserId();
            if (userid > 0) {
                // empty if block
            }
            subject.logout();
        }
    }

    public static void setUser(User user) {
        ActiveUser activeUser = SessionUtil.getActiveUser();
        if (activeUser == null) {
            return;
        }
        activeUser.setUser(user);
    }

    public static void removeSession(int userid) {
        DefaultWebSecurityManager securityManager = (DefaultWebSecurityManager)SecurityUtils.getSecurityManager();
        DefaultWebSessionManager sessionManager = (DefaultWebSessionManager)securityManager.getSessionManager();
        Collection sessions = sessionManager.getSessionDAO().getActiveSessions();
        if (sessions.size() > 0) {
            for (Session onlineSession : sessions) {
                ActiveUser activeUser;
                User user;
                Object obj;
                SimplePrincipalCollection principalCollection = (SimplePrincipalCollection)onlineSession.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                if (principalCollection == null || (obj = principalCollection.getPrimaryPrincipal()) == null || (user = (activeUser = (ActiveUser)obj).getUser()) == null || user.getId() - userid != 0) continue;
                sessionManager.getSessionDAO().delete(onlineSession);
            }
        }
    }

    public static String getUserMenuHTML() {
        StringBuffer sb = new StringBuffer();
        ActiveUser activeUser = SessionUtil.getActiveUser();
        if (activeUser == null) {
            return "";
        }
        List<PermissionTree> list = activeUser.getPermissionTreeList();
        for (int i = 0; i < list.size(); ++i) {
            PermissionTree ptree = list.get(i);
            Permission firstPermission = ptree.getPermissionMark().getPermission();
            if (firstPermission.getMenu() == null || firstPermission.getMenu() - 1 != 0) continue;
            StringBuffer subSB = new StringBuffer();
            if (ptree.getList() == null) continue;
            List<PermissionMark> subList = ptree.getList();
            subSB.append("<dl class=\"layui-nav-child\">");
            boolean haveSubMenu = false;
            for (int j = 0; j < subList.size(); ++j) {
                Permission subPermission = subList.get(j).getPermission();
                if (subPermission.getMenu() == null || subPermission.getMenu() - 1 != 0) continue;
                subSB.append("<dd id=\"" + subPermission.getId() + "\" class=\"twoMenu\"><a id=\"" + subPermission.getId() + "_a\" class=\"subMenuItem wm_menu\" href=\"" + subPermission.getUrl() + "\">" + subPermission.getName() + "</a></dd>");
                haveSubMenu = true;
            }
            subSB.append("</dl>");
            sb.append("<li class=\"layui-nav-item\" id=\"" + firstPermission.getId() + "\"><a id=\"" + firstPermission.getId() + "_a\" href=\"" + (haveSubMenu ? "javascript:;" : firstPermission.getUrl()) + "\" class=\"wm_menu\"><i class=\"layui-icon firstMenuIcon\" id=\"" + firstPermission.getPercode() + "_icon\">" + (firstPermission.getIcon().length() > 0 ? firstPermission.getIcon() : "") + "</i><span class=\"firstMenuFont\">" + firstPermission.getName() + "</span>" + (haveSubMenu ? "<span class=\"layui-nav-more\"></span>" : "") + "</a>");
            if (haveSubMenu) {
                sb.append(subSB);
            }
            sb.append("</li>");
        }
        return sb.toString();
    }
}

