/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.xnx3.bean.FileBean;
import com.xnx3.j2ee.util.ConsoleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class SFTPUtil {
    private String host = "127.0.0.1";
    private String username = "root";
    private String password = "\u7ba1\u96f7\u9e23";
    private int port = 22;
    private ChannelSftp sftp = null;

    public void connect() {
        try {
            if (this.sftp != null) {
                ConsoleUtil.debug("connect , sftp is not null");
            }
            JSch jsch = new JSch();
            jsch.getSession(this.username, this.host, this.port);
            Session sshSession = jsch.getSession(this.username, this.host, this.port);
            ConsoleUtil.debug("connect , Session created.");
            sshSession.setPassword(this.password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(sshConfig);
            sshSession.connect();
            ConsoleUtil.debug("connect , Session connected,Opening Channel.");
            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            this.sftp = (ChannelSftp)channel;
            ConsoleUtil.debug("connect , Connected to " + this.host);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.sftp != null) {
            if (this.sftp.isConnected()) {
                this.sftp.disconnect();
            } else if (this.sftp.isClosed()) {
                ConsoleUtil.debug("disconnect , sftp closed");
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ChannelSftp getSftp() {
        return this.sftp;
    }

    public void setSftp(ChannelSftp sftp) {
        this.sftp = sftp;
    }

    public List<FileBean> list(String dir) {
        try {
            Vector ls = this.sftp.ls(dir);
            return this._buildFiles(ls, dir);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<FileBean> _buildFiles(Vector ls, String dir) throws Exception {
        if (ls != null && ls.size() >= 0) {
            ArrayList<FileBean> list = new ArrayList<FileBean>();
            for (int i = 0; i < ls.size(); ++i) {
                ChannelSftp.LsEntry f = (ChannelSftp.LsEntry)ls.get(i);
                String nm = f.getFilename();
                if (nm.equals(".") || nm.equals("..")) continue;
                SftpATTRS attr = f.getAttrs();
                FileBean fileBean = new FileBean();
                if (attr.isDir()) {
                    fileBean.setDir(true);
                } else {
                    fileBean.setDir(false);
                }
                fileBean.setAttrs(attr);
                fileBean.setFilePath(dir);
                fileBean.setFileName(nm);
                list.add(fileBean);
            }
            return list;
        }
        return null;
    }
}

