/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util;

import com.xnx3.Lang;
import com.xnx3.j2ee.util.ApplicationPropertiesUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.SerializeUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public final class RedisUtil {
    public static String host = "127.0.0.1";
    public static int port = 6379;
    public static String password = null;
    private static int MAX_ACTIVE = 1024;
    private static int MAX_IDLE = 200;
    private static int MAX_WAIT = 10000;
    public static int timeout = 3000;
    private static boolean TEST_ON_BORROW = true;
    private static JedisPool jedisPool = null;

    public static boolean isUse() {
        return jedisPool != null;
    }

    public static synchronized Jedis getJedis() {
        try {
            if (jedisPool != null) {
                Jedis resource = jedisPool.getResource();
                return resource;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void returnResource(Jedis jedis) {
        if (jedis != null) {
            jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(String key) {
        try (Jedis jedis = null;){
            jedis = jedisPool.getResource();
            byte[] bytes = jedis.get(key.getBytes());
            if (!StringUtils.isEmpty((Object)bytes)) {
                Object object = SerializeUtils.deserialize(bytes);
                return object;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setObject(String key, Object value) {
        try (Jedis jedis = null;){
            jedis = jedisPool.getResource();
            String string = jedis.set(key.getBytes(), SerializeUtils.serialize(value));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setObject(String key, Object value, int expiretime) {
        String result = "";
        try (Jedis jedis = null;){
            jedis = jedisPool.getResource();
            result = jedis.set(key.getBytes(), SerializeUtils.serialize(value));
            if (result.equals("OK")) {
                jedis.expire(key.getBytes(), expiretime);
            }
            String string = result;
            return string;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long delkeyObject(String key) {
        try (Jedis jedis = null;){
            jedis = jedisPool.getResource();
            Long l = jedis.del(key.getBytes());
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean existsObject(String key) {
        try (Jedis jedis = null;){
            jedis = jedisPool.getResource();
            Boolean bl = jedis.exists(key.getBytes());
            return bl;
        }
    }

    public static Object deserialize(byte[] bytes) {
        Object result = null;
        if (RedisUtil.isEmpty(bytes)) {
            return null;
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteStream);
                try {
                    result = objectInputStream.readObject();
                }
                catch (ClassNotFoundException ex) {
                    throw new Exception("Failed to deserialize object type", ex);
                }
            }
            catch (Throwable ex) {
                throw new Exception("Failed to deserialize", ex);
            }
        }
        catch (Exception e) {
            ConsoleUtil.debug(e.getMessage());
        }
        return result;
    }

    public static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    public static byte[] serialize(Object object) {
        byte[] result = null;
        if (object == null) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(128);
            try {
                if (!(object instanceof Serializable)) {
                    throw new IllegalArgumentException(SerializeUtils.class.getSimpleName() + " requires a Serializable payload but received an object of type [" + object.getClass().getName() + "]");
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                result = byteStream.toByteArray();
            }
            catch (Throwable ex) {
                throw new Exception("Failed to serialize", ex);
            }
        }
        catch (Exception ex) {
            ConsoleUtil.debug(ex.getMessage());
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(RedisUtil.delkeyObject("plugin_map_userid_*"));
    }

    static {
        host = ApplicationPropertiesUtil.getProperty("spring.redis.host");
        String portStr = ApplicationPropertiesUtil.getProperty("spring.redis.port");
        if (portStr != null && (port = Lang.stringToInt((String)portStr, (int)-1)) == -1) {
            ConsoleUtil.info("redis\u672a\u8bbe\u7f6eport\uff0c\u5219\u4f7f\u7528\u9ed8\u8ba4\u76846379");
            port = 6379;
        }
        password = ApplicationPropertiesUtil.getProperty("spring.redis.password");
        timeout = Lang.stringToInt((String)ApplicationPropertiesUtil.getProperty("spring.redis.timeout"), (int)3000);
        if (host != null) {
            try {
                JedisPoolConfig config = new JedisPoolConfig();
                config.setMaxTotal(MAX_ACTIVE);
                config.setMaxIdle(MAX_IDLE);
                config.setMaxWaitMillis((long)MAX_WAIT);
                config.setTestOnBorrow(TEST_ON_BORROW);
                jedisPool = new JedisPool((GenericObjectPoolConfig)config, host, port, timeout, password);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

