/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.xnx3.Lang;
import com.xnx3.j2ee.util.ApplicationPropertiesUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.mq.JavaMQUtil;
import com.xnx3.j2ee.util.mq.MQReceive;
import com.xnx3.j2ee.util.mq.RabbitUtil;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class MQUtil {
    public static boolean rabbitIsUse = false;
    public static RabbitUtil rabbitUtil;

    public static void send(String pluginId, String content) {
        if (rabbitIsUse) {
            try {
                rabbitUtil.sendTopicMessage("com.xnx3.wangmarket.plugin." + pluginId, content);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        } else {
            JavaMQUtil.sendMessage(pluginId, content);
        }
    }

    public static void receive(String pluginId, final MQReceive mqReceive) {
        if (rabbitIsUse) {
            try {
                String queue = rabbitUtil.getChannel().queueDeclare().getQueue();
                ConsoleUtil.info("\u521b\u5efa\u4e34\u65f6\u961f\u5217\uff0c routingKey\uff1acom.xnx3.wangmarket.plugin." + pluginId + " , queue: " + queue);
                rabbitUtil.getChannel().queueBind(queue, "amq.direct", "com.xnx3.wangmarket.plugin." + pluginId);
                rabbitUtil.getChannel().basicConsume(queue, true, (Consumer)new DefaultConsumer(rabbitUtil.getChannel()){

                    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                        String content = new String(body, "UTF-8");
                        mqReceive.receive(content);
                    }
                });
            }
            catch (IOException | TimeoutException e) {
                e.printStackTrace();
            }
        } else {
            JavaMQUtil.addReceiveListener(pluginId, mqReceive);
        }
    }

    public static RabbitUtil getRabbitUtil() {
        return rabbitUtil;
    }

    static {
        String host = ApplicationPropertiesUtil.getProperty("spring.rabbitmq.host");
        if (host == null) {
            rabbitIsUse = false;
        } else {
            int port = Lang.stringToInt((String)ApplicationPropertiesUtil.getProperty("spring.rabbitmq.port"), (int)5672);
            String username = ApplicationPropertiesUtil.getProperty("spring.rabbitmq.username");
            String password = ApplicationPropertiesUtil.getProperty("spring.rabbitmq.password");
            rabbitUtil = new RabbitUtil(host, username, password, port);
            rabbitIsUse = true;
        }
    }
}

