/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util;

import com.xnx3.Lang;
import com.xnx3.StringUtil;
import com.xnx3.elasticsearch.jsonFormat.JsonFormatInterface;
import com.xnx3.j2ee.Global;
import com.xnx3.j2ee.util.ApplicationPropertiesUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.vo.ElasticSearchPageListVO;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Component;

@Component
public class ElasticSearchUtil {
    private static com.xnx3.elasticsearch.ElasticSearchUtil es;
    private static boolean starting;

    public static com.xnx3.elasticsearch.ElasticSearchUtil getElasticSearch() {
        if (ElasticSearchUtil.isStarting()) {
            ConsoleUtil.debug("elasticsearch \u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u63a7\u5236\u5728\u9879\u76ee\u542f\u52a8\u6210\u529f\u540e\u518d\u8c03\u7528\u6b64");
            return null;
        }
        if (!ElasticSearchUtil.isUsed()) {
            ConsoleUtil.debug("elasticsearch \u672a\u4f7f\u7528\u3002\u82e5\u8981\u4f7f\u7528\uff0c\u53ef\u914d\u7f6e application.properties \u4e2d wm.elasticsearch \u76f8\u5173\u53c2\u6570");
            return null;
        }
        return es;
    }

    public static boolean isUsed() {
        return es != null;
    }

    public static boolean isStarting() {
        return starting;
    }

    public static void projectStartCheckCreateIndex(final String indexName) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (ElasticSearchUtil.isStarting()) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (!ElasticSearchUtil.isUsed()) {
                    return;
                }
                if (!es.existIndex(indexName)) {
                    ConsoleUtil.info("\u81ea\u52a8\u521b\u5efa ElasticSearch \u7684 index : " + indexName);
                    try {
                        es.createIndex(indexName);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    public static ElasticSearchPageListVO list(String indexName, String query, int everyPageNumber, HttpServletRequest request) {
        return ElasticSearchUtil.list(indexName, query, everyPageNumber, SortBuilders.fieldSort((String)"time").order(SortOrder.DESC), request);
    }

    public static ElasticSearchPageListVO list(String indexName, String query, int everyPageNumber, SortBuilder sort, HttpServletRequest request) {
        ElasticSearchPageListVO vo = new ElasticSearchPageListVO();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CountRequest countRequest = new CountRequest();
        if (query != null && query.length() > 0) {
            QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query);
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
        }
        countRequest.indices(new String[]{indexName}).source(searchSourceBuilder);
        long count = 0L;
        CountResponse countResponse = null;
        try {
            countResponse = ElasticSearchUtil.getElasticSearch().getRestHighLevelClient().count(countRequest, RequestOptions.DEFAULT);
            count = countResponse.getCount();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Page page = new Page((int)count, everyPageNumber, request);
        int limitNumber = everyPageNumber;
        if (page.isCurrentLastPage()) {
            limitNumber = (int)(count - (long)page.getLimitStart());
        }
        long max_result_window = 10000L;
        try {
            Response res = ElasticSearchUtil.getElasticSearch().getRestClient().performRequest(new Request("GET", "/" + indexName + "/_settings"));
            String text = StringUtil.inputStreamToString((InputStream)res.getEntity().getContent(), (String)"UTF-8");
            JSONObject setJson = JSONObject.fromObject((Object)text);
            JSONObject indexJson = setJson.getJSONObject(indexName).getJSONObject("settings").getJSONObject("index");
            if (indexJson.get("max_result_window") != null) {
                max_result_window = indexJson.getLong("max_result_window");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((long)(page.getLimitStart() + limitNumber) > max_result_window) {
            vo.setBaseVO(0, "\u663e\u793a\u6700\u5927\u6761\u6570\u8d85\u8fc7\u7cfb\u7edf\u9884\u8bbe\u4f18\u5316\u7684\u6700\u5927\u6761\u6570" + max_result_window + "\u6761\u3002");
            ConsoleUtil.log("\u663e\u793a\u6700\u5927\u6761\u6570\u8d85\u8fc7\u7cfb\u7edf\u9884\u8bbe\u4f18\u5316\u7684\u6700\u5927\u6761\u6570" + max_result_window + "\u6761\u3002\u4f60\u53ef\u4ee5\u8bbe\u7f6eElasticSearch\u4e2d\uff0c" + indexName + "\u7d22\u5f15\u7684max_result_window\u5c5e\u6027\u6765\u8bbe\u7f6e\u66f4\u5927\u6761\u6570\u3002");
            return vo;
        }
        List list = ElasticSearchUtil.getElasticSearch().search(indexName, query, Integer.valueOf(page.getLimitStart()), Integer.valueOf(limitNumber), SortBuilders.fieldSort((String)"time").order(SortOrder.DESC));
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            Object timeObj = map.get("time");
            if (timeObj == null) {
                map.put("logtime", 0L);
                continue;
            }
            map.put("logtime", timeObj);
        }
        vo.setList(list);
        vo.setPage(page);
        return vo;
    }

    static {
        starting = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (Global.system.size() < 1) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                String hostname = ApplicationPropertiesUtil.getProperty("wm.elasticsearch.hostname");
                int port = Lang.stringToInt((String)ApplicationPropertiesUtil.getProperty("wm.elasticsearch.port"), (int)9200);
                String scheme = ApplicationPropertiesUtil.getProperty("wm.elasticsearch.scheme");
                String username = ApplicationPropertiesUtil.getProperty("wm.elasticsearch.username");
                String password = ApplicationPropertiesUtil.getProperty("wm.elasticsearch.password");
                if (hostname != null && hostname.length() > 0) {
                    es = new com.xnx3.elasticsearch.ElasticSearchUtil(hostname, port, scheme);
                    if (username != null && username.length() > 0 && password != null && password.length() > 0) {
                        es.setUsernameAndPassword(username, password);
                    }
                    ConsoleUtil.info("\u5f00\u542fElasticSearch\u8fdb\u884c\u64cd\u4f5c\u8bb0\u5f55");
                    es.setJsonFormatInterface(new JsonFormatInterface(){

                        public String mapToJsonString(Map<String, Object> params) {
                            if (params == null) {
                                params = new HashMap<String, Object>();
                            }
                            return JSONObject.fromObject(params).toString();
                        }
                    });
                }
                starting = false;
            }
        }).start();
    }
}

