/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtil {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private int age;

    public CookieUtil(HttpServletRequest request, HttpServletResponse response, int age) {
        this.request = request;
        this.response = response;
        this.age = age;
    }

    public CookieUtil(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.age = 31536000;
    }

    public void addCookie(String name, String value) {
        Cookie cookies = new Cookie(name, value);
        cookies.setPath("/");
        cookies.setMaxAge(this.age);
        this.response.addCookie(cookies);
    }

    public String getCookieValue(String cookieName) {
        Cookie cookie;
        if (cookieName != null && (cookie = this.getCookie(cookieName)) != null) {
            return cookie.getValue();
        }
        return null;
    }

    public Cookie getCookie(String cookieName) {
        Cookie[] cookies = this.request.getCookies();
        Cookie cookie = null;
        try {
            if (cookies != null && cookies.length > 0) {
                for (int i = 0; i < cookies.length; ++i) {
                    cookie = cookies[i];
                    if (!cookie.getName().equals(cookieName)) continue;
                    return cookie;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void deleteCookie(String cookieName) {
        Cookie cookie;
        if (cookieName != null && (cookie = this.getCookie(cookieName)) != null) {
            cookie.setMaxAge(0);
            cookie.setPath("/");
            this.response.addCookie(cookie);
        }
    }
}

