/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util;

import com.aliyun.openservices.oss.model.ObjectMetadata;
import com.xnx3.Lang;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.Global;
import com.xnx3.j2ee.util.ApplicationPropertiesUtil;
import com.xnx3.j2ee.util.AttachmentMode.AliyunOSSMode;
import com.xnx3.j2ee.util.AttachmentMode.HuaweiyunOBSMode;
import com.xnx3.j2ee.util.AttachmentMode.LocalServerMode;
import com.xnx3.j2ee.util.AttachmentMode.StorageModeInterface;
import com.xnx3.j2ee.util.AttachmentMode.bean.SubFileBean;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.LanguageUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.UploadFileVO;
import com.xnx3.media.ImageUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Component
public class AttachmentUtil {
    private static String maxFileSize;
    private static int maxFileSizeKB;
    public static String mode;
    public static final String MODE_ALIYUN_OSS = "aliyunOSS";
    public static final String MODE_LOCAL_FILE = "localFile";
    public static final String MODE_HUAWEIYUN_OBS = "huaWeiYunOBS";
    public static final String MODE_KUOZHAN = "kuozhan";
    public static StorageModeInterface storageMode;
    public static String netUrl;
    public static String localFilePath;
    private static boolean isSetStorageMode;
    public static String[] allowUploadSuffixs;

    public AttachmentUtil() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (Global.system.size() < 1) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (isSetStorageMode) {
                    return;
                }
                if (storageMode == null) {
                    mode = SystemUtil.get("ATTACHMENT_FILE_MODE");
                    if (mode == null) {
                        mode = AttachmentUtil.MODE_LOCAL_FILE;
                        ConsoleUtil.info("AttachmentUtil.mode = " + mode);
                    }
                    if (AttachmentUtil.netUrl() == null) {
                        ConsoleUtil.debug("\u672a\u53d1\u73b0\u5f53\u524d\u4e0a\u4f20\u56fe\u7247\u3001\u9644\u4ef6\u6240\u4f7f\u7528\u7684\u57df\u540d\u3002");
                        ConsoleUtil.debug("    \u8bbe\u7f6e\u65b9\u5f0f\uff1a");
                        ConsoleUtil.debug("    1. \u672c\u9879\u76ee\u5728\u5f00\u542f\u540e\uff0c\u53d6\u7b2c\u4e00\u6b21\u8bbf\u95ee\u65f6\u4f7f\u7528\u7684url\uff0c\u4f5c\u4e3a\u5f53\u524d\u7684 ATTACHMENT_FILE_URL");
                        ConsoleUtil.debug("    2. \u8fdb\u5165\u603b\u7ba1\u7406\u540e\u53f0\uff0d\u7cfb\u7edf\u7ba1\u7406\uff0d\u7cfb\u7edf\u53d8\u91cf\uff0c\u8bbe\u7f6eATTACHMENT_FILE_URL\u53d8\u91cf\uff0c\u52a0\u4e0a\u56fe\u7247\u7b49\u9644\u4ef6\u7684\u8bbf\u95ee\u57df\u540d\uff0c\u683c\u5f0f\u5982\uff1a http://res.weiunity.com/");
                        ConsoleUtil.debug("    3. \u60a8\u5728\u7a0b\u5e8f\u4e2d\u81ea\u884c\u8fdb\u884c\u8bbe\u7f6eAttachmentUtil.setNetUrl(url);");
                    }
                    ConsoleUtil.debug("AttachmentUtil.url : " + AttachmentUtil.netUrl());
                }
            }
        }).start();
        localFilePath = SystemUtil.getProjectPath();
    }

    public static void setStorageMode(StorageModeInterface storageMode) {
        AttachmentUtil.storageMode = storageMode;
        isSetStorageMode = true;
        mode = MODE_KUOZHAN;
    }

    public static StorageModeInterface getStorageMode() {
        if (storageMode == null && mode != null) {
            if (AttachmentUtil.isMode(MODE_ALIYUN_OSS)) {
                storageMode = new AliyunOSSMode();
            } else if (AttachmentUtil.isMode(MODE_LOCAL_FILE)) {
                storageMode = new LocalServerMode();
            } else if (AttachmentUtil.isMode(MODE_HUAWEIYUN_OBS)) {
                storageMode = new HuaweiyunOBSMode();
            } else {
                ConsoleUtil.info("mode : MODE_KUOZHAN");
            }
        }
        return storageMode;
    }

    public static String getMaxFileSize() {
        if (maxFileSize == null) {
            try {
                maxFileSize = ApplicationPropertiesUtil.getProperty("spring.servlet.multipart.max-file-size");
                ConsoleUtil.debug("\u52a0\u8f7d application.properties \u7684\u6587\u4ef6\u4e0a\u4f20\u9650\u5236\uff1a" + maxFileSize);
            }
            catch (Exception e) {
                maxFileSize = "3MB";
                ConsoleUtil.error("\u51fa\u9519---\u5f3a\u5236\u5c06\u5927\u5c0f\u8bbe\u7f6e\u4e3a3MB");
                e.printStackTrace();
            }
        }
        return maxFileSize;
    }

    public static int getMaxFileSizeKB() {
        if (maxFileSizeKB == -1) {
            maxFileSize = AttachmentUtil.getMaxFileSize();
            if (maxFileSize.indexOf("KB") > 0) {
                maxFileSizeKB = Lang.stringToInt((String)maxFileSize.replace("KB", "").trim(), (int)0);
                if (maxFileSizeKB == 0) {
                    ConsoleUtil.error("application.properties --> spring.servlet.multipart.max-file-size use KB\uff0c but !!! string to int failure !");
                }
            } else if (maxFileSize.indexOf("MB") > 0) {
                maxFileSizeKB = Lang.stringToInt((String)maxFileSize.replace("MB", "").trim(), (int)0) * 1024;
                if (maxFileSizeKB == 0) {
                    ConsoleUtil.error("application.properties --> spring.servlet.multipart.max-file-size use MB\uff0c but !!! string to int failure !");
                }
            } else if (maxFileSize.indexOf("GB") > 0) {
                maxFileSizeKB = Lang.stringToInt((String)maxFileSize.replace("GB", "").trim(), (int)0) * 1024 * 1024;
                if (maxFileSizeKB == 0) {
                    ConsoleUtil.error("application.properties --> spring.servlet.multipart.max-file-size use GB\uff0c but !!! string to int failure !");
                }
            } else {
                ConsoleUtil.error("application.properties --> spring.servlet.multipart.max-file-size not find unit\uff0cyour are KB ? MB ? GB ? Please use one of them");
            }
        }
        return maxFileSizeKB;
    }

    public static boolean isMode(String mode) {
        if (mode == null || mode == null) {
            return false;
        }
        if (AttachmentUtil.mode == null) {
            return false;
        }
        return AttachmentUtil.mode.equalsIgnoreCase(mode);
    }

    public static String netUrl() {
        if (netUrl == null) {
            netUrl = SystemUtil.get("ATTACHMENT_FILE_URL");
        }
        return netUrl;
    }

    public static void setNetUrl(String url) {
        url = netUrl;
    }

    public static void uploadStringFile(String filePath, String text, String encode) {
        AttachmentUtil.getStorageMode().putStringFile(filePath, text, encode);
    }

    public static void uploadStringFile(String filePath, String text) {
        AttachmentUtil.uploadStringFile(filePath, text, "UTF-8");
    }

    public static void putStringFile(String path, String text) {
        AttachmentUtil.uploadStringFile(path, text, "UTF-8");
    }

    public static void putStringFile(String filePath, String text, String encode) {
        AttachmentUtil.uploadStringFile(filePath, text, encode);
    }

    public static UploadFileVO verifyFileMaxLength(File file) {
        UploadFileVO vo = new UploadFileVO();
        if (file != null) {
            int lengthKB = (int)Math.ceil(file.length() / 1024L);
            vo = AttachmentUtil.verifyFileMaxLength(lengthKB);
        }
        return vo;
    }

    public static UploadFileVO verifyFileMaxLength(int lengthKB) {
        UploadFileVO vo = new UploadFileVO();
        if (AttachmentUtil.getMaxFileSizeKB() > 0 && lengthKB > AttachmentUtil.getMaxFileSizeKB()) {
            vo.setBaseVO(0, "\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236\uff01\u4e0a\u4f20\u5927\u5c0f\u5728 " + maxFileSize + " \u4ee5\u5185");
            return vo;
        }
        return vo;
    }

    public static UploadFileVO uploadFile(String filePath, String localPath) {
        File localFile = new File(localPath);
        return AttachmentUtil.uploadFile(filePath, localFile);
    }

    public static UploadFileVO put(String filePath, String localPath) {
        return AttachmentUtil.uploadFile(filePath, localPath);
    }

    public static UploadFileVO uploadFile(String filePath, File localFile) {
        UploadFileVO vo = new UploadFileVO();
        vo = AttachmentUtil.verifyFileMaxLength(localFile);
        if (vo.getResult() - 0 == 0) {
            return vo;
        }
        try {
            FileInputStream localInput = new FileInputStream(localFile);
            return AttachmentUtil.put(filePath, localInput);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            vo.setBaseVO(0, "\u4e0a\u4f20\u51fa\u9519\uff0c\u8981\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return vo;
        }
    }

    public static UploadFileVO put(String filePath, File localFile) {
        return AttachmentUtil.uploadFile(filePath, localFile);
    }

    public static UploadFileVO put(String path, InputStream inputStream) {
        return AttachmentUtil.uploadFile(path, inputStream);
    }

    public static UploadFileVO uploadFile(String path, InputStream inputStream) {
        UploadFileVO vo = new UploadFileVO();
        int lengthKB = 0;
        try {
            lengthKB = (int)Math.ceil(inputStream.available() / 1024);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        vo = AttachmentUtil.verifyFileMaxLength(lengthKB);
        if (vo.getResult() - 0 == 0) {
            return vo;
        }
        vo.setSize(lengthKB);
        UploadFileVO modeVO = AttachmentUtil.getStorageMode().put(path, inputStream);
        modeVO.setSize(vo.getSize());
        return modeVO;
    }

    public static UploadFileVO uploadImageByUrl(String filePath, String imageUrl) {
        if (imageUrl == null) {
            return null;
        }
        String suffix = Lang.findFileSuffix((String)imageUrl);
        BufferedImage bufferedImage = ImageUtil.getBufferedImageByUrl((String)imageUrl);
        if (suffix == null) {
            suffix = "jpg";
        }
        return AttachmentUtil.uploadFile(filePath + Lang.uuid() + "." + suffix, ImageUtil.bufferedImageToInputStream((BufferedImage)bufferedImage, (String)suffix));
    }

    public static UploadFileVO putImageByUrl(String filePath, String imageUrl) {
        return AttachmentUtil.uploadImageByUrl(filePath, imageUrl);
    }

    public static String getTextByPath(String path) {
        return AttachmentUtil.getStorageMode().getTextByPath(path);
    }

    public static void deleteObject(String filePath) {
        AttachmentUtil.getStorageMode().deleteObject(filePath);
    }

    public static void copyObject(String originalFilePath, String newFilePath) {
        AttachmentUtil.getStorageMode().copyObject(originalFilePath, newFilePath);
    }

    public static void putForUEditor(String filePath, InputStream input, ObjectMetadata meta) {
        AttachmentUtil.put(filePath, input);
    }

    public static UploadFileVO uploadFile(String filePath, MultipartFile multipartFile) {
        UploadFileVO vo = new UploadFileVO();
        if (multipartFile == null) {
            vo.setBaseVO(0, LanguageUtil.show("oss_pleaseSelectUploadFile"));
            return vo;
        }
        InputStream inputStream = null;
        try {
            inputStream = multipartFile.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (inputStream == null) {
            vo.setBaseVO(0, LanguageUtil.show("oss_pleaseSelectUploadFile"));
            return vo;
        }
        String fileSuffix = null;
        fileSuffix = Lang.findFileSuffix((String)multipartFile.getOriginalFilename());
        if (!AttachmentUtil.allowUploadSuffix(fileSuffix)) {
            vo.setBaseVO(0, LanguageUtil.show("oss_uploadFileNotInSuffixList"));
            return vo;
        }
        vo = AttachmentUtil.uploadFileByInputStream(filePath, inputStream, fileSuffix);
        return vo;
    }

    public static UploadFileVO uploadFileByMultipartFile(String filePath, MultipartFile multipartFile) {
        return AttachmentUtil.uploadFile(filePath, multipartFile);
    }

    public static UploadFileVO uploadImageByMultipartFile(String filePath, MultipartFile multipartFile, int maxWidth) {
        UploadFileVO vo = new UploadFileVO();
        if (multipartFile == null) {
            vo.setBaseVO(0, LanguageUtil.show("oss_pleaseSelectUploadFile"));
            return vo;
        }
        InputStream inputStream = null;
        try {
            inputStream = multipartFile.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (inputStream == null) {
            vo.setBaseVO(0, LanguageUtil.show("oss_pleaseSelectUploadFile"));
            return vo;
        }
        String fileSuffix = null;
        fileSuffix = Lang.findFileSuffix((String)multipartFile.getOriginalFilename());
        if (!AttachmentUtil.allowUploadSuffix(fileSuffix)) {
            vo.setBaseVO(0, LanguageUtil.show("oss_uploadFileNotInSuffixList"));
            return vo;
        }
        vo = AttachmentUtil.uploadImageByInputStream(filePath, inputStream, fileSuffix, maxWidth);
        return vo;
    }

    public static UploadFileVO uploadImageByMultipartFile(String filePath, MultipartFile multipartFile) {
        return AttachmentUtil.uploadImageByMultipartFile(filePath, multipartFile, 0);
    }

    public static UploadFileVO uploadFileByInputStream(String filePath, InputStream inputStream, String fileSuffix) {
        UploadFileVO vo = new UploadFileVO();
        if (!AttachmentUtil.allowUploadSuffix(fileSuffix)) {
            vo.setBaseVO(0, LanguageUtil.show("oss_uploadFileNotInSuffixList"));
            return vo;
        }
        if (inputStream == null) {
            vo.setBaseVO(0, LanguageUtil.show("oss_pleaseSelectUploadFile"));
            return vo;
        }
        return AttachmentUtil.put(filePath, "." + fileSuffix, inputStream);
    }

    public static UploadFileVO uploadImageByInputStream(String filePath, InputStream inputStream, String fileSuffix, int maxWidth) {
        UploadFileVO vo = new UploadFileVO();
        if (!AttachmentUtil.allowUploadSuffix(fileSuffix)) {
            vo.setBaseVO(0, LanguageUtil.show("oss_uploadFileNotInSuffixList"));
            return vo;
        }
        if (inputStream == null) {
            vo.setBaseVO(0, LanguageUtil.show("oss_pleaseSelectUploadFile"));
            return vo;
        }
        if (maxWidth > 0) {
            inputStream = ImageUtil.proportionZoom((InputStream)inputStream, (int)maxWidth, (String)fileSuffix);
        }
        return AttachmentUtil.put(filePath, "." + fileSuffix, inputStream);
    }

    public static boolean allowUploadSuffix(String fileSuffix) {
        if (allowUploadSuffixs == null) {
            int i;
            String[] ss = Global.ossFileUploadImageSuffixList.split("\\|");
            ArrayList<String> list = new ArrayList<String>();
            for (i = 0; i < ss.length; ++i) {
                String s = ss[i].trim();
                if (s == null || s.length() <= 0) continue;
                list.add(s);
            }
            allowUploadSuffixs = new String[list.size()];
            for (i = 0; i < list.size(); ++i) {
                AttachmentUtil.allowUploadSuffixs[i] = (String)list.get(i);
            }
        }
        for (int j = 0; j < allowUploadSuffixs.length; ++j) {
            if (!allowUploadSuffixs[j].equalsIgnoreCase(fileSuffix)) continue;
            return true;
        }
        return false;
    }

    public static UploadFileVO put(String filePath, String fileName, InputStream inputStream) {
        UploadFileVO vo = new UploadFileVO();
        if (fileName == null || fileName.indexOf(".") == -1) {
            vo.setBaseVO(0, "\u4e0a\u4f20\u7684\u6587\u4ef6\u540d(\u540e\u7f00)\u6821\u9a8c\u5931\u8d25\uff01\u4f20\u5165\u7684\u4e3a\uff1a" + fileName + "\uff0c\u5141\u8bb8\u4f20\u5165\u7684\u503c\u5982\uff1aa.jpg\u6216.jpg");
            return vo;
        }
        String fileSuffix = StringUtil.subString((String)fileName, (String)".", null, (int)3);
        String name = Lang.uuid() + "." + fileSuffix;
        String path = filePath + name;
        return AttachmentUtil.put(path, inputStream);
    }

    public static UploadFileVO uploadImage(String filePath, HttpServletRequest request, String formFileName, int maxWidth) {
        UploadFileVO uploadFileVO = new UploadFileVO();
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            List imageList = multipartRequest.getFiles(formFileName);
            if (imageList.size() > 0 && !((MultipartFile)imageList.get(0)).isEmpty()) {
                MultipartFile multi = (MultipartFile)imageList.get(0);
                uploadFileVO = AttachmentUtil.uploadImageByMultipartFile(filePath, multi, maxWidth);
            } else {
                uploadFileVO.setResult(2);
                uploadFileVO.setInfo(LanguageUtil.show("oss_uploadNotFile"));
            }
        } else {
            uploadFileVO.setResult(2);
            uploadFileVO.setInfo(LanguageUtil.show("oss_uploadNotFile"));
        }
        return uploadFileVO;
    }

    public static UploadFileVO uploadFile(String filePath, HttpServletRequest request, String formFileName) {
        UploadFileVO uploadFileVO = new UploadFileVO();
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            List list = multipartRequest.getFiles(formFileName);
            if (list.size() > 0 && !((MultipartFile)list.get(0)).isEmpty()) {
                MultipartFile multi = (MultipartFile)list.get(0);
                uploadFileVO = AttachmentUtil.uploadFileByMultipartFile(filePath, multi);
            } else {
                uploadFileVO.setResult(2);
                uploadFileVO.setInfo(LanguageUtil.show("oss_uploadNotFile"));
            }
        } else {
            uploadFileVO.setResult(2);
            uploadFileVO.setInfo(LanguageUtil.show("oss_uploadNotFile"));
        }
        return uploadFileVO;
    }

    public static long getDirectorySize(String path) {
        return AttachmentUtil.getStorageMode().getDirectorySize(path);
    }

    public static void directoryInit(String path) {
        LocalServerMode.directoryInit(path);
    }

    public static List<SubFileBean> getSubFileList(String path) {
        return AttachmentUtil.getStorageMode().getSubFileList(path);
    }

    public static long getFileSize(String path) {
        return AttachmentUtil.getStorageMode().getFileSize(path);
    }

    public static void createFolder(String path) {
        AttachmentUtil.getStorageMode().createFolder(path);
    }

    static {
        maxFileSizeKB = -1;
        netUrl = null;
        localFilePath = "";
        isSetStorageMode = false;
    }
}

