/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util.AttachmentMode.hander;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.S3Bucket;
import com.obs.services.model.StorageClassEnum;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.vo.UploadFileVO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class OBSHandler {
    private String accessKeyId;
    private String accessKeySecret;
    public String endpoint;
    private String obsBucketName;
    private String url;
    private ObsClient obsClient;

    public OBSHandler(String accessKeyId, String accessKeySecret, String endpoint) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.endpoint = endpoint;
    }

    public OBSHandler(String accessKeyId, String accessKeySecret, String endpoint, String obsBucketName) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.endpoint = endpoint;
        this.obsBucketName = obsBucketName;
    }

    public void setUrlForCDN(String url) {
        if (url == null) {
            return;
        }
        if ((url = url.trim()).length() < 2) {
            this.url = url;
            return;
        }
        if (!url.substring(url.length() - 1, url.length()).equals("/")) {
            url = url + "/";
        }
        this.url = url;
    }

    public void setObsBucketName(String obsBucketName) {
        this.obsBucketName = obsBucketName;
    }

    public ObsClient getObsClient() {
        if (this.obsClient == null) {
            this.obsClient = new ObsClient(this.accessKeyId, this.accessKeySecret, this.endpoint);
        }
        return this.obsClient;
    }

    public byte[] getFileByteArray(String bucketName, String filePath) throws IOException {
        int len;
        ObsObject obsObject = null;
        try {
            obsObject = this.getObsClient().getObject(bucketName, filePath);
        }
        catch (Exception e) {
            ConsoleUtil.log(e.getMessage());
            return null;
        }
        InputStream input = obsObject.getObjectContent();
        byte[] b = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = input.read(b)) != -1) {
            bos.write(b, 0, len);
        }
        bos.close();
        input.close();
        return bos.toByteArray();
    }

    public Integer getFolderObjectsSize(String bucketName, String filePath) {
        ListObjectsRequest request = new ListObjectsRequest(bucketName);
        if (filePath != null && !filePath.trim().equals("")) {
            request.setPrefix(filePath);
        }
        ObjectListing result = this.getObsClient().listObjects(request);
        return new Integer(result.getObjects().size());
    }

    public List<ObsObject> getFolderObjects(String bucketName, String filePath) {
        ObjectListing result;
        ArrayList<ObsObject> list = new ArrayList<ObsObject>();
        ListObjectsRequest request = new ListObjectsRequest(bucketName);
        if (filePath != null && !filePath.trim().equals("")) {
            request.setPrefix(filePath);
        }
        request.setMaxKeys(100);
        do {
            result = this.getObsClient().listObjects(request);
            for (ObsObject obsObject : result.getObjects()) {
                list.add(obsObject);
            }
            request.setMarker(result.getNextMarker());
        } while (result.isTruncated());
        return list;
    }

    public DeleteObjectResult deleteObject(String bucketName, String fileName) {
        return this.getObsClient().deleteObject(bucketName, fileName);
    }

    public PutObjectResult mkdirFolder(String bucketName, String fileName) {
        return this.getObsClient().putObject(bucketName, fileName, (InputStream)new ByteArrayInputStream(new byte[0]));
    }

    public UploadFileVO putStringFile(String bucketName, String fileName, String content, String encode) throws ObsException, UnsupportedEncodingException {
        PutObjectResult result = this.getObsClient().putObject(bucketName, fileName, (InputStream)new ByteArrayInputStream(content.getBytes(encode)));
        return this.getUploadFileVO(result);
    }

    public UploadFileVO putLocalFile(String bucketName, String fileName, File localFile) {
        PutObjectResult result = this.getObsClient().putObject(bucketName, fileName, localFile);
        return this.getUploadFileVO(result);
    }

    public UploadFileVO putFileByStream(String bucketName, String fileName, InputStream inputStream) {
        PutObjectResult result = this.getObsClient().putObject(bucketName, fileName, inputStream);
        return this.getUploadFileVO(result);
    }

    public UploadFileVO putFilebyInstreamAndMeta(String bucketName, String fileName, InputStream inputStream, ObjectMetadata metaData) {
        PutObjectResult result = this.getObsClient().putObject(bucketName, fileName, inputStream, metaData);
        return this.getUploadFileVO(result);
    }

    public void copyObject(String sourceBucketName, String sourcePath, String destBucketName, String destPath) {
        this.getObsClient().copyObject(sourceBucketName, sourcePath, destBucketName, destPath);
    }

    public String getOriginalUrlForOBS() {
        String endpoint_ = "";
        endpoint_ = this.endpoint.indexOf("https://") > -1 ? this.endpoint.substring(8, this.endpoint.length()) : this.endpoint;
        return "//" + this.obsBucketName + "." + endpoint_ + "/";
    }

    public String getUrlByBucketName(String bucketName, String endpoint) {
        String url = null;
        if (url == null || url.length() == 0) {
            url = "//" + bucketName + "." + endpoint + ".myhuaweicloud.com/";
        }
        return url;
    }

    public String createOBSBucket(String obsBucketName) {
        if (this.endpoint == null || this.endpoint.length() == 0) {
            ConsoleUtil.error("error ! obs endpoint is null");
            return "endpoint is null";
        }
        String location = StringUtil.subString((String)this.endpoint, (String)"obs.", (String)".myhuaweicloud.com");
        ConsoleUtil.log("setLocation : " + location);
        this.obsBucketName = obsBucketName;
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(obsBucketName);
        obsBucket.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        obsBucket.setBucketStorageClass(StorageClassEnum.STANDARD);
        obsBucket.setLocation(location);
        this.getObsClient().createBucket(obsBucket);
        String json = "{\"Statement\":[{\"Sid\":\"\u4e3a\u6388\u6743\u7528\u6237\u521b\u5efaOBS\u4f7f\u7528\u7684\u6876\u7b56\u7565\",\"Principal\":{\"ID\" : \"*\"},\"Effect\":\"Allow\",\"Action\":[\"GetObject\",\"GetObjectVersion\"],\"Resource\": [\"" + obsBucketName + "/*\"]}]}";
        this.getObsClient().setBucketPolicy(obsBucketName, json);
        return obsBucketName;
    }

    public List<S3Bucket> getBuckets() {
        return this.getObsClient().listBuckets();
    }

    public void closeOBSClient() {
        if (this.getObsClient() != null) {
            try {
                this.getObsClient().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getObsBucketName() {
        return this.obsBucketName;
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = this.getOriginalUrlForOBS();
        }
        return this.url;
    }

    private UploadFileVO getUploadFileVO(PutObjectResult result) {
        UploadFileVO vo = new UploadFileVO();
        if (result.getStatusCode() == 200) {
            vo.setResult(1);
            vo.setInfo("success");
            vo.setPath(result.getObjectKey());
            if (this.getUrl() == null || this.getUrl().length() == 0) {
                vo.setUrl(result.getObjectUrl());
            } else {
                vo.setUrl(this.getUrl() + result.getObjectKey());
            }
            return vo;
        }
        vo.setBaseVO(0, "\u4e0a\u4f20\u5931\u8d25!statusCode:" + result.getStatusCode() + ",RequestId:" + result.getRequestId());
        return vo;
    }
}

