/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util.AttachmentMode;

import com.xnx3.FileUtil;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.util.AttachmentMode.StorageModeInterface;
import com.xnx3.j2ee.util.AttachmentMode.bean.SubFileBean;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.vo.UploadFileVO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class LocalServerMode
implements StorageModeInterface {
    @Override
    public void putStringFile(String path, String text, String encode) {
        LocalServerMode.directoryInit(path);
        try {
            FileUtil.write((String)(AttachmentUtil.localFilePath + path), (String)text, (String)encode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public UploadFileVO put(String path, InputStream inputStream) {
        UploadFileVO vo = new UploadFileVO();
        LocalServerMode.directoryInit(path);
        File file = new File(AttachmentUtil.localFilePath + path);
        try {
            FileOutputStream os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            inputStream.close();
            vo.setFileName(file.getName());
            vo.setInfo("success");
            vo.setPath(path);
            vo.setUrl(AttachmentUtil.netUrl() + path);
        }
        catch (IOException e) {
            vo.setBaseVO(0, e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public String getTextByPath(String path) {
        String text = FileUtil.read((String)(AttachmentUtil.localFilePath + path), (String)"UTF-8");
        if (text != null && text.length() == 0) {
            text = null;
        }
        return text;
    }

    @Override
    public void deleteObject(String filePath) {
        FileUtil.deleteFile((String)(AttachmentUtil.localFilePath + filePath));
    }

    @Override
    public long getDirectorySize(String path) {
        LocalServerMode.directoryInit(path);
        return FileUtils.sizeOfDirectory((File)new File(AttachmentUtil.localFilePath + path));
    }

    @Override
    public void copyObject(String originalFilePath, String newFilePath) {
        LocalServerMode.directoryInit(newFilePath);
        FileUtil.copyFile((String)(AttachmentUtil.localFilePath + originalFilePath), (String)(AttachmentUtil.localFilePath + newFilePath));
    }

    public static void directoryInit(String path) {
        if (path == null) {
            return;
        }
        if (path.indexOf("\\") > 1) {
            path = StringUtil.replaceAll((String)path, (String)"\\\\", (String)"/");
        }
        if (path.length() - path.lastIndexOf("/") > 1) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        if (!FileUtil.exists((String)path)) {
            String[] ps = path.split("/");
            String xiangdui = "";
            for (int i = 0; i < ps.length; ++i) {
                if (ps[i].length() <= 0) continue;
                xiangdui = xiangdui + ps[i] + "/";
                if (FileUtil.exists((String)(AttachmentUtil.localFilePath + xiangdui))) continue;
                File file = new File(AttachmentUtil.localFilePath + xiangdui);
                file.mkdir();
            }
        }
    }

    @Override
    public List<SubFileBean> getSubFileList(String path) {
        ArrayList<SubFileBean> list = new ArrayList<SubFileBean>();
        if (path == null || path.length() == 0) {
            return list;
        }
        File file = new File(AttachmentUtil.localFilePath + path);
        if (!file.exists()) {
            return list;
        }
        File[] subFiles = file.listFiles();
        for (int i = 0; i < subFiles.length; ++i) {
            File subFile = subFiles[i];
            SubFileBean bean = new SubFileBean();
            bean.setPath(subFile.getPath().replace(AttachmentUtil.localFilePath + path, ""));
            bean.setSize(subFile.length());
            bean.setLastModified(subFile.lastModified());
            bean.setFolder(subFile.isDirectory());
            list.add(bean);
        }
        return list;
    }

    @Override
    public long getFileSize(String path) {
        File file = new File(AttachmentUtil.localFilePath + path);
        if (!file.exists()) {
            return -1L;
        }
        return file.length();
    }

    @Override
    public void createFolder(String path) {
        LocalServerMode.directoryInit(path);
    }
}

