/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util.AttachmentMode;

import com.obs.services.exception.ObsException;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.xnx3.j2ee.util.AttachmentMode.StorageModeInterface;
import com.xnx3.j2ee.util.AttachmentMode.bean.SubFileBean;
import com.xnx3.j2ee.util.AttachmentMode.hander.OBSHandler;
import com.xnx3.j2ee.util.DSAUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.UploadFileVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class HuaweiyunOBSMode
implements StorageModeInterface {
    public static OBSHandler obsHandler;
    public static String obsBucketName;

    public static OBSHandler getObsHander() {
        if (obsHandler == null) {
            String key = SystemUtil.get("HUAWEIYUN_ACCESSKEYID").trim();
            String secret = SystemUtil.get("HUAWEIYUN_ACCESSKEYSECRET");
            if (key.length() > 20) {
                key = DSAUtil.dsa.decrypt(key);
                secret = DSAUtil.dsa.decrypt(secret);
            }
            obsHandler = new OBSHandler(key, secret, SystemUtil.get("HUAWEIYUN_OBS_ENDPOINT"));
            obsHandler.setUrlForCDN(SystemUtil.get("ATTACHMENT_FILE_URL"));
            obsHandler.setObsBucketName(SystemUtil.get("HUAWEIYUN_OBS_BUCKETNAME"));
            obsBucketName = obsHandler.getObsBucketName();
        }
        return obsHandler;
    }

    @Override
    public void putStringFile(String path, String text, String encode) {
        try {
            HuaweiyunOBSMode.getObsHander().putStringFile(obsBucketName, path, text, encode);
        }
        catch (ObsException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public UploadFileVO put(String path, InputStream inputStream) {
        return HuaweiyunOBSMode.getObsHander().putFileByStream(obsBucketName, path, inputStream);
    }

    @Override
    public String getTextByPath(String path) {
        String content = null;
        byte[] bytes = null;
        try {
            bytes = HuaweiyunOBSMode.getObsHander().getFileByteArray(obsBucketName, path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (bytes == null) {
            return null;
        }
        try {
            content = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return content;
    }

    @Override
    public void deleteObject(String filePath) {
        HuaweiyunOBSMode.getObsHander().deleteObject(obsBucketName, filePath);
    }

    @Override
    public long getDirectorySize(String path) {
        return HuaweiyunOBSMode.getObsHander().getFolderObjectsSize(obsBucketName, path).intValue();
    }

    @Override
    public void copyObject(String originalFilePath, String newFilePath) {
        HuaweiyunOBSMode.getObsHander().copyObject(obsBucketName, originalFilePath, obsBucketName, newFilePath);
    }

    @Override
    public List<SubFileBean> getSubFileList(String path) {
        ObjectListing result;
        ArrayList<SubFileBean> list = new ArrayList<SubFileBean>();
        if (path == null || path.length() == 0) {
            return list;
        }
        ListObjectsRequest request = new ListObjectsRequest(obsBucketName);
        request.setPrefix(path);
        request.setMaxKeys(100);
        do {
            result = HuaweiyunOBSMode.getObsHander().getObsClient().listObjects(request);
            for (ObsObject obsObject : result.getObjects()) {
                SubFileBean bean = new SubFileBean();
                bean.setPath(obsObject.getObjectKey());
                bean.setSize(obsObject.getMetadata().getContentLength());
                bean.setLastModified(obsObject.getMetadata().getLastModified().getTime());
                if (path != null && bean.getSize() < 1L && bean.getPath().lastIndexOf("/") == bean.getPath().length() - 1) {
                    bean.setFolder(true);
                }
                list.add(bean);
            }
            request.setMarker(result.getNextMarker());
        } while (result.isTruncated());
        return list;
    }

    @Override
    public long getFileSize(String path) {
        ObjectMetadata metadata = HuaweiyunOBSMode.getObsHander().getObsClient().getObjectMetadata(obsBucketName, path);
        if (metadata == null) {
            return 0L;
        }
        return metadata.getContentLength();
    }

    @Override
    public void createFolder(String path) {
        HuaweiyunOBSMode.getObsHander().mkdirFolder(obsBucketName, path);
    }
}

