/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util.AttachmentMode;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.Global;
import com.xnx3.j2ee.util.AttachmentMode.StorageModeInterface;
import com.xnx3.j2ee.util.AttachmentMode.bean.SubFileBean;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.UploadFileVO;
import com.xnx3.net.OSSUtil;
import com.xnx3.net.ossbean.PutResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class AliyunOSSMode
implements StorageModeInterface {
    @Override
    public void putStringFile(String path, String text, String encode) {
        OSSUtil.putStringFile((String)path, (String)text, (String)encode);
    }

    @Override
    public UploadFileVO put(String path, InputStream inputStream) {
        return AliyunOSSMode.PutResultToUploadFileVO(OSSUtil.put((String)path, (InputStream)inputStream));
    }

    @Override
    public String getTextByPath(String path) {
        OSSObject ossObject = null;
        try {
            ossObject = OSSUtil.getOSSClient().getObject(OSSUtil.bucketName, path);
        }
        catch (OSSException e) {
            return null;
        }
        if (ossObject == null) {
            return null;
        }
        try {
            return IOUtils.toString((InputStream)ossObject.getObjectContent(), (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void deleteObject(String filePath) {
        OSSUtil.getOSSClient().deleteObject(OSSUtil.bucketName, filePath);
    }

    @Override
    public long getDirectorySize(String path) {
        return OSSUtil.getFolderSize((String)path);
    }

    @Override
    public void copyObject(String originalFilePath, String newFilePath) {
        OSSUtil.getOSSClient().copyObject(OSSUtil.bucketName, originalFilePath, OSSUtil.bucketName, newFilePath);
    }

    private static UploadFileVO PutResultToUploadFileVO(PutResult pr) {
        UploadFileVO vo = new UploadFileVO();
        if (pr == null || pr.getFileName() == null || pr.getUrl() == null) {
            vo.setBaseVO(0, "\u4e0a\u4f20\u5931\u8d25\uff01");
        } else {
            vo.setFileName(pr.getFileName());
            vo.setInfo("success");
            vo.setPath(pr.getPath());
            vo.setUrl(pr.getUrl());
        }
        return vo;
    }

    @Override
    public List<SubFileBean> getSubFileList(String path) {
        ArrayList<SubFileBean> list = new ArrayList<SubFileBean>();
        if (path == null || path.length() == 0) {
            return list;
        }
        HashMap<String, SubFileBean> subFolderMap = new HashMap<String, SubFileBean>();
        List subList = OSSUtil.getFolderObjectList((String)path);
        for (int i = 0; i < subList.size(); ++i) {
            OSSObjectSummary sum = (OSSObjectSummary)subList.get(i);
            SubFileBean bean = new SubFileBean();
            bean.setSize(sum.getSize());
            bean.setPath(sum.getKey().replace(path, ""));
            bean.setLastModified(sum.getLastModified().getTime());
            if (bean.getPath().indexOf("/") > 0) {
                String folderName = StringUtil.subString((String)bean.getPath(), null, (String)"/", (int)2);
                if (subFolderMap.get(subFolderMap) != null) continue;
                bean.setPath(folderName);
                bean.setFolder(true);
                subFolderMap.put(folderName, bean);
                continue;
            }
            if (bean.getPath().length() <= 0) continue;
            bean.setFolder(false);
            list.add(bean);
        }
        ArrayList folderList = new ArrayList();
        for (Map.Entry entry : subFolderMap.entrySet()) {
            folderList.add(entry.getValue());
        }
        list.addAll(0, folderList);
        return list;
    }

    @Override
    public long getFileSize(String path) {
        return OSSUtil.getOSSClient().getObjectMetadata(OSSUtil.bucketName, path).getContentLength();
    }

    @Override
    public void createFolder(String path) {
        OSSUtil.createFolder((String)path);
    }

    static {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (Global.system.size() < 1) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ConsoleUtil.info("AliyunOSSMode init start...");
                OSSUtil.accessKeyId = SystemUtil.get("ALIYUN_ACCESSKEYID");
                OSSUtil.accessKeySecret = SystemUtil.get("ALIYUN_ACCESSKEYSECRET");
                OSSUtil.bucketName = SystemUtil.get("ALIYUN_OSS_BUCKETNAME");
                OSSUtil.endpoint = SystemUtil.get("ALIYUN_OSS_ENDPOINT");
                OSSUtil.url = AttachmentUtil.netUrl();
                if (OSSUtil.accessKeyId == null || OSSUtil.accessKeySecret.length() < 10) {
                    ConsoleUtil.info("OSS\u5bf9\u8c61\u5b58\u50a8\u521d\u59cb\u5316\u65f6\uff0caccessKeyId \u6216 accessKeyId \u65e0\u6709\u6548\u503c\uff08\u5b57\u7b26\u5c0f\u4e8e10\uff09");
                    return;
                }
                OSSUtil.getOSSClient();
                ConsoleUtil.info("AliyunOSSMode init finish.");
            }
        }).start();
    }
}

