/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.util;

import com.aliyun.openservices.log.common.LogItem;
import com.xnx3.DateUtil;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.shiro.ShiroFunc;
import com.xnx3.j2ee.util.ApplicationPropertiesUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.IpUtil;
import com.xnx3.j2ee.util.actionLog.ActionLogInterface;
import com.xnx3.j2ee.util.actionLog.AliyunSLSMode;
import com.xnx3.j2ee.util.actionLog.ElasticSearchMode;
import com.xnx3.j2ee.util.actionLog.HuaWeiCloudLtsMode;
import com.xnx3.j2ee.vo.ActionLogListVO;
import com.xnx3.net.AliyunLogUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ActionLogUtil {
    public static final String TYPE_NORMAL = "NORMAL";
    public static final String TYPE_ERROR = "ERROR";
    public static final String TYPE_UPDATE_DATABASE = "UPDATE_DATABASE";
    public static AliyunLogUtil aliyunLogUtil = null;
    public static ActionLogInterface actionLogInterface;

    public static boolean isUse() {
        return actionLogInterface != null;
    }

    public static synchronized void logExtend(LogItem logItem, HttpServletRequest request, Integer goalid, String action, String remark, String type) {
        if (!ActionLogUtil.isUse()) {
            return;
        }
        Map<String, Object> params = AliyunSLSMode.logitemToMap(logItem);
        ActionLogUtil.logExtend(params, request, goalid, action, remark, type);
    }

    public static synchronized void logExtend(Map<String, Object> params, HttpServletRequest request, Integer goalid, String action, String remark, String type) {
        User user;
        if (!ActionLogUtil.isUse()) {
            return;
        }
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        if ((user = ShiroFunc.getUser()) != null) {
            params.put("userid", user.getId());
            params.put("username", user.getUsername());
        }
        if (goalid != null) {
            params.put("goalid", goalid);
        }
        if (action != null) {
            params.put("action", action);
        }
        if (remark != null) {
            params.put("remark", remark);
        }
        if (request != null) {
            params.put("ip", IpUtil.getIpAddress(request));
            params.put("param", request.getQueryString());
            params.put("url", request.getRequestURL().toString());
            params.put("referer", request.getHeader("referer"));
            params.put("userAgent", request.getHeader("User-Agent"));
        }
        if (type == null || type.length() == 0) {
            type = TYPE_NORMAL;
        }
        params.put("type", type);
        params.put("time", DateUtil.timeForUnix13());
        ActionLogUtil.logExtend(params);
    }

    public static synchronized void logExtend(LogItem logItem) {
        if (!ActionLogUtil.isUse()) {
            return;
        }
        actionLogInterface.add(AliyunSLSMode.logitemToMap(logItem));
    }

    public static synchronized void logExtend(Map<String, Object> params) {
        if (!ActionLogUtil.isUse()) {
            return;
        }
        if (params == null) {
            return;
        }
        if (params.size() == 0) {
            return;
        }
        actionLogInterface.add(params);
    }

    public static synchronized void insert(LogItem logItem, HttpServletRequest request, Integer goalid, String action, String remark, String type) {
        ActionLogUtil.logExtend(AliyunSLSMode.logitemToMap(logItem), request, goalid, action, remark, type);
    }

    public static synchronized void insert(Map<String, Object> params, HttpServletRequest request, Integer goalid, String action, String remark, String type) {
        ActionLogUtil.logExtend(params, request, goalid, action, remark, type);
    }

    public static synchronized void insert(LogItem logItem, HttpServletRequest request, Integer goalid, String action, String remark) {
        ActionLogUtil.logExtend(AliyunSLSMode.logitemToMap(logItem), request, goalid, action, remark, TYPE_NORMAL);
    }

    public static synchronized void insert(Map<String, Object> params, HttpServletRequest request, Integer goalid, String action, String remark) {
        ActionLogUtil.logExtend(params, request, goalid, action, remark, TYPE_NORMAL);
    }

    public static synchronized void insert(HttpServletRequest request, Integer goalid, String action, String remark) {
        ActionLogUtil.logExtend(new HashMap<String, Object>(), request, goalid, action, remark, TYPE_NORMAL);
    }

    public static void insert(HttpServletRequest request, String action, String remark) {
        ActionLogUtil.logExtend(new HashMap<String, Object>(), request, null, action, remark, TYPE_NORMAL);
    }

    public static void insert(HttpServletRequest request, Integer goalid, String action) {
        ActionLogUtil.logExtend(new HashMap<String, Object>(), request, goalid, action, null, TYPE_NORMAL);
    }

    public static void insert(HttpServletRequest request, String action) {
        ActionLogUtil.logExtend(new HashMap<String, Object>(), request, null, action, null, TYPE_NORMAL);
    }

    public static synchronized void insertUpdateDatabase(LogItem logItem, HttpServletRequest request, Integer goalid, String action, String remark) {
        ActionLogUtil.logExtend(AliyunSLSMode.logitemToMap(logItem), request, goalid, action, remark, TYPE_UPDATE_DATABASE);
    }

    public static synchronized void insertUpdateDatabase(Map<String, Object> params, HttpServletRequest request, Integer goalid, String action, String remark) {
        ActionLogUtil.logExtend(params, request, goalid, action, remark, TYPE_UPDATE_DATABASE);
    }

    public static synchronized void insertUpdateDatabase(HttpServletRequest request, Integer goalid, String action, String remark) {
        ActionLogUtil.logExtend(new HashMap<String, Object>(), request, goalid, action, remark, TYPE_UPDATE_DATABASE);
    }

    public static void insertUpdateDatabase(HttpServletRequest request, String action, String remark) {
        ActionLogUtil.logExtend(new HashMap<String, Object>(), request, null, action, remark, TYPE_UPDATE_DATABASE);
    }

    public static void insertUpdateDatabase(HttpServletRequest request, Integer goalid, String action) {
        ActionLogUtil.logExtend(new HashMap<String, Object>(), request, goalid, action, "", TYPE_UPDATE_DATABASE);
    }

    public static void insertUpdateDatabase(HttpServletRequest request, String action) {
        ActionLogUtil.logExtend(new HashMap<String, Object>(), request, null, action, "", TYPE_UPDATE_DATABASE);
    }

    public static void insertError(HttpServletRequest request, String remark) {
        ActionLogUtil.logExtend(new HashMap<String, Object>(), request, null, "ERROR LOG", remark, TYPE_ERROR);
    }

    public static boolean cacheCommit() {
        return actionLogInterface.cacheCommit();
    }

    public static ActionLogListVO list(String query, int everyPageNumber, HttpServletRequest request) {
        ActionLogListVO interfaceVO = actionLogInterface.list(query, everyPageNumber, request);
        return interfaceVO;
    }

    public static ActionLogListVO list(String indexName, String query, int everyPageNumber, HttpServletRequest request) {
        return actionLogInterface.list(indexName, query, everyPageNumber, request);
    }

    static {
        new ElasticSearchMode();
        new AliyunSLSMode();
        String huaweiAccessKey = ApplicationPropertiesUtil.getProperty("wm.huaweicloud.lts.accessKey");
        if (huaweiAccessKey != null && huaweiAccessKey.length() > 0) {
            ConsoleUtil.info("\u4f7f\u7528\u534e\u4e3a\u4e91\u65e5\u5fd7\u670d\u52a1\uff0c\u6ce8\u610f\u534e\u4e3a\u4e91\u65e5\u5fd7\u670d\u52a1\u8981\u624b\u52a8\u52a0\u5165\u4e09\u4e2ajar\u5305\u3002\u8be6\u89c1wm\u4e2d\u5f15\u5165\u7684\u4e09\u4e2a\u672c\u5730jar\uff0c\u4e0d\u7136\u542f\u52a8\u65f6\u4f1a\u62a5\u9519");
            new HuaWeiCloudLtsMode();
        }
        actionLogInterface = null;
    }
}

