/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.system;

import com.xnx3.j2ee.pluginManage.interfaces.manage.ShiroFilterPluginManage;
import com.xnx3.j2ee.shiro.CustomRealm;
import com.xnx3.j2ee.shiro.SessionManager;
import com.xnx3.j2ee.util.RedisUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisCacheManager;
import org.crazycake.shiro.RedisManager;
import org.crazycake.shiro.RedisSessionDAO;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=100002)
public class ShiroConfiguration {
    @Bean(name={"shiroFilter"})
    @ConditionalOnBean(name={"PluginManageForShiroFilter"})
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        shiroFilterFactoryBean.setLoginUrl("/login.do");
        shiroFilterFactoryBean.setUnauthorizedUrl("/403.do");
        Map<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/logout", "logout");
        filterChainDefinitionMap.put("/", "anon");
        filterChainDefinitionMap.put("/cache/**", "anon");
        filterChainDefinitionMap.put("/head/**", "anon");
        filterChainDefinitionMap.put("/js/**", "anon");
        filterChainDefinitionMap.put("/install/*.do", "anon");
        filterChainDefinitionMap.put("/*.jsp", "anon");
        filterChainDefinitionMap.put("/*.do", "anon");
        filterChainDefinitionMap.put("/*.json", "anon");
        filterChainDefinitionMap.put("/*.html", "anon");
        filterChainDefinitionMap.put("/*.xml", "anon");
        filterChainDefinitionMap.put("/*.txt", "anon");
        filterChainDefinitionMap.put("/wm/**", "anon");
        filterChainDefinitionMap.put("/help/*.do", "anon");
        filterChainDefinitionMap.put("/plugin/**", "anon");
        filterChainDefinitionMap.put("/websiteTemplate/**", "anon");
        filterChainDefinitionMap.put("/template/getTemplateList.do", "anon");
        filterChainDefinitionMap.put("/module/**", "anon");
        filterChainDefinitionMap.put("/site/**", "anon");
        try {
            filterChainDefinitionMap = ShiroFilterPluginManage.manage(filterChainDefinitionMap);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        filterChainDefinitionMap.put("/**", "authc");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }

    @Bean(name={"securityManager"})
    public SecurityManager securityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)this.myShiroRealm());
        if (RedisUtil.isUse()) {
            RedisCacheManager redisCacheManager = new RedisCacheManager();
            redisCacheManager.setRedisManager((IRedisManager)this.redisManager());
            securityManager.setCacheManager((CacheManager)redisCacheManager);
        } else {
            securityManager.setCacheManager((CacheManager)this.ehCacheManager());
        }
        securityManager.setSessionManager(this.sessionManager());
        securityManager.setRememberMeManager((RememberMeManager)this.rememberMeManager());
        return securityManager;
    }

    @Bean
    public MethodInvokingFactoryBean getMethodInvokingFactoryBean() {
        MethodInvokingFactoryBean methodInvokingFactoryBean = new MethodInvokingFactoryBean();
        methodInvokingFactoryBean.setStaticMethod("org.apache.shiro.SecurityUtils.setSecurityManager");
        methodInvokingFactoryBean.setArguments(new Object[]{this.securityManager()});
        return methodInvokingFactoryBean;
    }

    @Bean
    public org.apache.shiro.session.mgt.SessionManager sessionManager() {
        SessionManager sessionManager = new SessionManager();
        if (RedisUtil.isUse()) {
            sessionManager.setSessionDAO((SessionDAO)this.sessionDAO());
        }
        ArrayList listeners = new ArrayList();
        sessionManager.setSessionListeners(listeners);
        SimpleCookie cookie = new SimpleCookie("iwSID");
        cookie.setHttpOnly(true);
        sessionManager.setSessionIdCookie((Cookie)cookie);
        sessionManager.setSessionIdCookieEnabled(true);
        sessionManager.setGlobalSessionTimeout(1296000000L);
        sessionManager.setSessionIdUrlRewritingEnabled(false);
        return sessionManager;
    }

    @Bean
    @DependsOn(value={"lifecycleBeanPostProcessor"})
    public EhCacheManager ehCacheManager() {
        EhCacheManager em = new EhCacheManager();
        em.setCacheManagerConfigFile("classpath:shiro-ehcache.xml");
        return em;
    }

    public CustomRealm myShiroRealm() {
        CustomRealm realm = new CustomRealm();
        realm.setCredentialsMatcher((CredentialsMatcher)this.hashedCredentialsMatcher());
        return realm;
    }

    public SimpleCookie rememberMeCookie() {
        SimpleCookie simpleCookie = new SimpleCookie("rememberMe");
        simpleCookie.setMaxAge(2592000);
        return simpleCookie;
    }

    public CookieRememberMeManager rememberMeManager() {
        CookieRememberMeManager cookieRememberMeManager = new CookieRememberMeManager();
        cookieRememberMeManager.setCookie((Cookie)this.rememberMeCookie());
        return cookieRememberMeManager;
    }

    @Bean(name={"hashedCredentialsMatcher"})
    public HashedCredentialsMatcher hashedCredentialsMatcher() {
        HashedCredentialsMatcher credentialsMatcher = new HashedCredentialsMatcher();
        credentialsMatcher.setHashAlgorithmName("MD5");
        credentialsMatcher.setHashIterations(2);
        credentialsMatcher.setStoredCredentialsHexEncoded(true);
        return credentialsMatcher;
    }

    @Bean
    public LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    @DependsOn(value={"lifecycleBeanPostProcessor"})
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(DefaultWebSecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager((SecurityManager)securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    public RedisManager redisManager() {
        String host = "127.0.0.1";
        if (RedisUtil.host != null && RedisUtil.host.length() > 0) {
            host = RedisUtil.host;
        }
        int port = 6379;
        if (RedisUtil.port > 0) {
            port = RedisUtil.port;
        }
        String password = null;
        if (RedisUtil.password != null && RedisUtil.password.length() > 0) {
            password = RedisUtil.password;
        }
        int timeout = 3000;
        if (RedisUtil.timeout > 0) {
            timeout = RedisUtil.timeout;
        }
        RedisManager redisManager = new RedisManager();
        redisManager.setHost(host + ":" + port);
        if (password != null) {
            redisManager.setPassword(password);
        }
        redisManager.setTimeout(timeout);
        return redisManager;
    }

    @Bean
    public RedisSessionDAO sessionDAO() {
        RedisSessionDAO redisSessionDAO = new RedisSessionDAO();
        redisSessionDAO.setExpire(1296000);
        redisSessionDAO.setRedisManager((IRedisManager)this.redisManager());
        return redisSessionDAO;
    }
}

