/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.shiro;

import com.xnx3.DateUtil;
import com.xnx3.j2ee.bean.ActiveUser;
import com.xnx3.j2ee.bean.PermissionTree;
import com.xnx3.j2ee.entity.Permission;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.service.RoleService;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.shiro.ShiroFunc;
import com.xnx3.j2ee.util.CacheUtil;
import com.xnx3.j2ee.util.SpringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;

public class CustomRealm
extends AuthorizingRealm {
    public void setName(String name) {
        super.setName("CustomRealm");
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String username = (String)token.getPrincipal();
        SqlService sqlService = SpringUtil.getSqlService();
        RoleService roleService = (RoleService)SpringUtil.getBean("roleService");
        String userhql = "FROM User u WHERE u.username = :username";
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("username", username);
        List userList = sqlService.findByHql(userhql, parameterMap);
        User user = null;
        if (userList.size() > 0) {
            String hql = "update User u set u.lasttime=" + DateUtil.timeForUnix10() + " WHERE u.username = :username";
            sqlService.executeByHql(hql, parameterMap);
            user = (User)userList.get(0);
        }
        if (user != null) {
            String sessionid;
            ActiveUser activeUser = new ActiveUser();
            activeUser.setUser(user);
            List<Permission> permissions = roleService.findPermissionByUser(user);
            activeUser.setPermissions(permissions);
            List<PermissionTree> permissionTreeList = new ShiroFunc().PermissionToTree(new ArrayList<Permission>(), permissions);
            activeUser.setPermissionTreeList(permissionTreeList);
            String md5Password = new Md5Hash((Object)user.getUsername(), (Object)user.getSalt(), 2).toString();
            SimpleAuthenticationInfo simpleAuthenticationInfo = new SimpleAuthenticationInfo((Object)activeUser, (Object)md5Password, ByteSource.Util.bytes((String)user.getSalt()), this.getName());
            Subject subject = SecurityUtils.getSubject();
            if (subject != null && subject.getSession() != null && (sessionid = (String)((Object)subject.getSession().getId())) != null) {
                String shiro_userid_key = "shiro:userid:{userid}".replace("{userid}", user.getId() + "");
                ArrayList<String> list = (ArrayList<String>)CacheUtil.get((String)shiro_userid_key);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                boolean find = false;
                for (int i = 0; i < list.size(); ++i) {
                    String olds = (String)list.get(i);
                    if (olds == null || !olds.equals(sessionid)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    list.add(sessionid);
                    CacheUtil.set((String)shiro_userid_key, list);
                }
            }
            return simpleAuthenticationInfo;
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        ActiveUser activeUser = (ActiveUser)principals.getPrimaryPrincipal();
        List<Permission> permissionList = null;
        try {
            permissionList = activeUser.getPermissions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> permissions = new ArrayList<String>();
        if (permissionList != null) {
            for (Permission permission : permissionList) {
                permissions.add(permission.getPercode());
            }
        }
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
        simpleAuthorizationInfo.addStringPermissions(permissions);
        return simpleAuthorizationInfo;
    }

    public void clearCached() {
        PrincipalCollection principals = SecurityUtils.getSubject().getPrincipals();
        super.clearCache(principals);
    }
}

