/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.service.impl;

import com.xnx3.DateUtil;
import com.xnx3.Lang;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.Global;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.entity.SmsLog;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.entity.UserRole;
import com.xnx3.j2ee.service.UserService;
import com.xnx3.j2ee.shiro.ShiroFunc;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.IpUtil;
import com.xnx3.j2ee.util.LanguageUtil;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.j2ee.util.SessionUtil;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.j2ee.vo.UploadFileVO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.apache.shiro.subject.Subject;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class UserServiceImpl
implements UserService {
    @Resource
    private SqlDAO sqlDAO;

    public SqlDAO getSqlDAO() {
        return this.sqlDAO;
    }

    public void setSqlDAO(SqlDAO sqlDAO) {
        this.sqlDAO = sqlDAO;
    }

    @Override
    public User findByPhone(Object phone) {
        List<User> list = this.sqlDAO.findByProperty(User.class, "phone", phone);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public BaseVO loginByUsernameAndPassword(HttpServletRequest request) {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        return this.loginByUsernameAndPassword(request, username, password);
    }

    @Override
    public BaseVO loginByUsernameAndPassword(HttpServletRequest request, String username, String password) {
        username = SafetyUtil.filter(username);
        BaseVO baseVO = new BaseVO();
        if (username == null || username.length() == 0) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginUserOrEmailNotNull"));
            return baseVO;
        }
        if (password == null || password.length() == 0) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginPasswordNotNull"));
            return baseVO;
        }
        List<User> l = this.sqlDAO.findByProperty(User.class, username.indexOf("@") > -1 ? "email" : "username", username);
        if (l != null && l.size() > 0) {
            User user = l.get(0);
            String md5Password = new Md5Hash((Object)password, (Object)user.getSalt(), 2).toString();
            if (md5Password.equals(user.getPassword())) {
                if (user.getIsfreeze() == User.ISFREEZE_FREEZE) {
                    baseVO.setBaseVO(0, LanguageUtil.show("user_loginUserFreeze"));
                    return baseVO;
                }
                String ip = SafetyUtil.filter(IpUtil.getIpAddress(request));
                this.sqlDAO.executeSql("UPDATE user SET lasttime = " + DateUtil.timeForUnix10() + ", lastip = '" + ip + "' WHERE id = " + user.getId());
                UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), user.getUsername());
                Subject currentUser = SecurityUtils.getSubject();
                try {
                    currentUser.login((AuthenticationToken)token);
                }
                catch (UnknownAccountException uae) {
                    System.out.println("UnknownAccountException:" + uae.getMessage());
                }
                catch (IncorrectCredentialsException ice) {
                    System.out.println("IncorrectCredentialsException:" + ice.getMessage());
                }
                catch (LockedAccountException lae) {
                    System.out.println("LockedAccountException:" + lae.getMessage());
                }
                catch (ExcessiveAttemptsException eae) {
                    System.out.println("ExcessiveAttemptsException:" + eae.getMessage());
                }
                catch (AuthenticationException ae) {
                    System.out.println("AuthenticationException:" + ae.getMessage());
                }
                baseVO.setBaseVO(1, user.getId() + "");
            } else {
                baseVO.setBaseVO(0, LanguageUtil.show("user_loginPasswordFailure"));
            }
        } else {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginUserNotFind"));
        }
        return baseVO;
    }

    @Override
    public BaseVO reg(User user, HttpServletRequest request) {
        int referrerid;
        BaseVO baseVO = new BaseVO();
        user.setEmail(SafetyUtil.xssFilter(user.getEmail()));
        user.setNickname(SafetyUtil.xssFilter(user.getNickname()));
        user.setPhone(SafetyUtil.xssFilter(user.getPhone()));
        user.setUsername(SafetyUtil.xssFilter(user.getUsername()));
        if (user.getNickname() == null || user.getNickname().equals("")) {
            user.setNickname(user.getUsername());
        }
        if (user.getUsername() == null || user.getUsername().equals("") || user.getPassword() == null || user.getPassword().equals("")) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_regDataNotAll"));
        }
        if (user.getEmail() != null && user.getEmail().length() > 0 && this.sqlDAO.findByProperty(User.class, "email", user.getEmail()).size() > 0) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_regFailureForEmailAlreadyExist"));
            return baseVO;
        }
        if (this.sqlDAO.findByProperty(User.class, "username", user.getUsername()).size() > 0) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_regFailureForUsernameAlreadyExist"));
            return baseVO;
        }
        if (user.getPhone() != null && user.getPhone().length() > 0 && this.findByPhone(user.getUsername()) != null) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_regFailureForPhoneAlreadyExist"));
            return baseVO;
        }
        user.setRegip(IpUtil.getIpAddress(request));
        user.setLastip(IpUtil.getIpAddress(request));
        user.setRegtime(DateUtil.timeForUnix10());
        user.setLasttime(DateUtil.timeForUnix10());
        user.setAuthority(Global.system.get("USER_REG_ROLE"));
        user.setCurrency(0);
        user.setReferrerid(0);
        user.setFreezemoney(0);
        user.setMoney(0);
        user.setIsfreeze(User.ISFREEZE_NORMAL);
        user.setHead("default.png");
        String inviteid = null;
        if (request.getSession().getAttribute("inviteid") != null) {
            inviteid = request.getSession().getAttribute("inviteid").toString();
        }
        User referrerUser1 = null;
        if (inviteid != null && inviteid.length() > 0 && (referrerUser1 = this.sqlDAO.findById(User.class, referrerid = Lang.stringToInt((String)inviteid, (int)0))) != null) {
            user.setReferrerid(referrerid);
        }
        if (user.getUsername().length() > 40) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_userNameToLong"));
        }
        Random random = new Random();
        user.setSalt(random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "");
        String md5Password = new Md5Hash((Object)user.getPassword(), (Object)user.getSalt(), 2).toString();
        user.setPassword(md5Password);
        this.sqlDAO.save(user);
        if (user.getId() > 0) {
            UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), user.getUsername());
            token.setRememberMe(false);
            Subject currentUser = SecurityUtils.getSubject();
            try {
                currentUser.login((AuthenticationToken)token);
            }
            catch (UnknownAccountException unknownAccountException) {
            }
            catch (IncorrectCredentialsException incorrectCredentialsException) {
            }
            catch (LockedAccountException lockedAccountException) {
            }
            catch (ExcessiveAttemptsException excessiveAttemptsException) {
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
            UserRole userRole = new UserRole();
            userRole.setRoleid(Lang.stringToInt((String)Global.system.get("USER_REG_ROLE"), (int)0));
            userRole.setUserid(user.getId());
            this.sqlDAO.save(userRole);
            if (user.getReferrerid() > 0) {
                User referrerUser2;
                this.referrerAddAward(referrerUser1, Global.system.get("INVITEREG_AWARD_ONE"), user);
                if (referrerUser1.getReferrerid() > 0 && (referrerUser2 = this.sqlDAO.findById(User.class, referrerUser1.getReferrerid())) != null) {
                    User referrerUser3;
                    this.referrerAddAward(referrerUser2, Global.system.get("INVITEREG_AWARD_TWO"), user);
                    if (referrerUser2.getReferrerid() > 0 && (referrerUser3 = this.sqlDAO.findById(User.class, referrerUser2.getReferrerid())) != null) {
                        User referrerUser4;
                        this.referrerAddAward(referrerUser3, Global.system.get("INVITEREG_AWARD_THREE"), user);
                        if (referrerUser3.getReferrerid() > 0 && (referrerUser4 = this.sqlDAO.findById(User.class, referrerUser3.getReferrerid())) != null) {
                            this.referrerAddAward(referrerUser4, Global.system.get("INVITEREG_AWARD_FOUR"), user);
                        }
                    }
                }
            }
            baseVO.setBaseVO(1, user.getId() + "");
        } else {
            baseVO.setBaseVO(0, LanguageUtil.show("user_regFailure"));
        }
        return baseVO;
    }

    private void referrerAddAward(User user, String addCurrency_, User regUser) {
        int addCurrency = Lang.stringToInt((String)addCurrency_, (int)0);
        if (addCurrency > 0) {
            user.setCurrency(user.getCurrency() + addCurrency);
            this.sqlDAO.save(user);
        }
    }

    @Override
    public void regInit(HttpServletRequest request) {
        int inviteid;
        User user;
        String inviteid_ = request.getParameter("inviteid");
        if (inviteid_ != null && inviteid_.length() > 0 && (user = this.sqlDAO.findById(User.class, inviteid = Lang.stringToInt((String)inviteid_, (int)0))) != null) {
            request.getSession().setAttribute("inviteid", (Object)inviteid);
        }
    }

    @Override
    public BaseVO loginByPhoneAndCode(HttpServletRequest request) {
        SmsLog smsLog;
        BaseVO baseVO = new BaseVO();
        String phone = SafetyUtil.xssFilter(request.getParameter("phone"));
        String code = SafetyUtil.filter(request.getParameter("code"));
        if (phone == null || phone.length() != 11) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneAndCodePhoneFailure"));
            return baseVO;
        }
        if (code == null || code.length() != 6) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneAndCodeCodeFailure"));
            return baseVO;
        }
        int queryAddtime = 0;
        if (SmsLog.codeValidity > 0) {
            int currentTime = DateUtil.timeForUnix10();
            queryAddtime = currentTime - SmsLog.codeValidity;
        }
        if ((smsLog = this.findByPhoneAddtimeUsedTypeCode(phone, queryAddtime, (short)0, (short)1, code)) != null) {
            User user = this.findByPhone(phone);
            int userid = 0;
            if (user != null && user.getId() != null) {
                userid = user.getId();
            }
            smsLog.setUserid(userid);
            smsLog.setUsed((short)1);
            this.sqlDAO.save(smsLog);
            if (user == null) {
                baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneAndCodeRegFailure"));
                return baseVO;
            }
            if (user.getIsfreeze() == User.ISFREEZE_FREEZE) {
                baseVO.setBaseVO(0, LanguageUtil.show("user_loginUserFreeze"));
                return baseVO;
            }
            user.setLasttime(DateUtil.timeForUnix10());
            user.setLastip(IpUtil.getIpAddress(request));
            this.sqlDAO.save(user);
            UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), user.getUsername());
            token.setRememberMe(false);
            Subject currentUser = SecurityUtils.getSubject();
            try {
                currentUser.login((AuthenticationToken)token);
            }
            catch (UnknownAccountException uae) {
                uae.printStackTrace();
            }
            catch (IncorrectCredentialsException ice) {
                ice.printStackTrace();
            }
            catch (LockedAccountException lae) {
                lae.printStackTrace();
            }
            catch (ExcessiveAttemptsException eae) {
                eae.printStackTrace();
            }
            catch (AuthenticationException ae) {
                ae.printStackTrace();
            }
            baseVO.setBaseVO(1, LanguageUtil.show("user_loginSuccess"));
            return baseVO;
        }
        baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneAndCodeCodeNotFind"));
        return baseVO;
    }

    private SmsLog findByPhoneAddtimeUsedTypeCode(String phone, int addtime, Short used, Short type, String code) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("phone", phone);
        parameterMap.put("addtime", addtime);
        parameterMap.put("used", used);
        parameterMap.put("type", type);
        parameterMap.put("code", code);
        List list = this.sqlDAO.findByHql("from SmsLog as model where model.phone= :phone and model.addtime > :addtime and model.used = :used and model.type = :type and model.code = :code", parameterMap, 0);
        if (list.size() > 0) {
            return (SmsLog)list.get(0);
        }
        return null;
    }

    @Override
    public BaseVO loginByPhone(HttpServletRequest request) {
        BaseVO baseVO = new BaseVO();
        String phone = SafetyUtil.xssFilter(request.getParameter("phone"));
        if (phone == null) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhonePhoneFailure"));
            return baseVO;
        }
        if ((phone = phone.replaceAll(" ", "")).length() != 11) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhonePhoneFailure"));
            return baseVO;
        }
        User user = this.findByPhone(phone);
        if (user == null) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneUserNotFind"));
            return baseVO;
        }
        String ip = IpUtil.getIpAddress(request);
        if (!user.getLastip().equals(ip) && !user.getRegip().equals(ip)) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneIpFailure"));
            return baseVO;
        }
        if (user.getIsfreeze() == User.ISFREEZE_FREEZE) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginUserFreeze"));
            return baseVO;
        }
        ConsoleUtil.debug("\u68c0\u9a8c\u6b64\u7528\u6237\u72b6\u6001\u662f\u5426\u6b63\u5e38\uff0c\u662f\u5426\u88ab\u51bb\u7ed3\uff0c\u672a\u51bb\u7ed3\uff0c\u6b63\u5e38");
        ip = SafetyUtil.filter(ip);
        this.sqlDAO.executeSql("UPDATE user SET lasttime = " + DateUtil.timeForUnix10() + ", lastip = '" + ip + "' WHERE id = " + user.getId());
        UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), user.getUsername());
        token.setRememberMe(false);
        Subject currentUser = SecurityUtils.getSubject();
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (UnknownAccountException uae) {
            uae.printStackTrace();
        }
        catch (IncorrectCredentialsException ice) {
            ice.printStackTrace();
        }
        catch (LockedAccountException lae) {
            lae.printStackTrace();
        }
        catch (ExcessiveAttemptsException eae) {
            eae.printStackTrace();
        }
        catch (AuthenticationException ae) {
            ae.printStackTrace();
        }
        baseVO.setBaseVO(1, LanguageUtil.show("user_loginSuccess"));
        return baseVO;
    }

    @Override
    public void logout() {
        SessionUtil.logout();
    }

    @Override
    public BaseVO freezeUser(int id) {
        BaseVO baseVO = new BaseVO();
        if (id > 0) {
            User user = this.sqlDAO.findById(User.class, id);
            if (user == null) {
                baseVO.setBaseVO(0, LanguageUtil.show("user_freezeUserIsNotFind"));
            } else {
                user.setIsfreeze(User.ISFREEZE_FREEZE);
                this.sqlDAO.save(user);
            }
        } else {
            baseVO.setBaseVO(0, LanguageUtil.show("user_freezeUserPleaseEntryId"));
        }
        return baseVO;
    }

    @Override
    public BaseVO unfreezeUser(int id) {
        BaseVO baseVO = new BaseVO();
        if (id > 0) {
            User user = this.sqlDAO.findById(User.class, id);
            if (user == null) {
                baseVO.setBaseVO(0, LanguageUtil.show("user_unfreezeUserIsNotFind"));
            } else {
                user.setIsfreeze(User.ISFREEZE_NORMAL);
                this.sqlDAO.save(user);
            }
        } else {
            baseVO.setBaseVO(0, LanguageUtil.show("user_unfreezeUserPleaseEntryId"));
        }
        return baseVO;
    }

    @Override
    public UploadFileVO updateHeadByOSS(MultipartFile head) {
        UploadFileVO uploadFileVO = new UploadFileVO();
        if (head == null || head.isEmpty()) {
            uploadFileVO.setBaseVO(0, LanguageUtil.show("user_uploadHeadImageNotFind"));
            return uploadFileVO;
        }
        User user = ShiroFunc.getUser();
        String fileSuffix = "png";
        fileSuffix = Lang.findFileSuffix((String)SafetyUtil.filter(head.getOriginalFilename()));
        String newHead = Lang.uuid() + "." + fileSuffix;
        try {
            uploadFileVO = AttachmentUtil.put(SystemUtil.get("USER_HEAD_PATH") + newHead, head.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            uploadFileVO.setBaseVO(0, e.getMessage());
            return uploadFileVO;
        }
        User u = this.sqlDAO.findById(User.class, user.getId());
        if (u.getHead() != null && u.getHead().length() > 0 && !u.getHead().equals("default.png")) {
            AttachmentUtil.deleteObject("image/head/" + u.getHead());
        }
        u.setHead(newHead);
        this.sqlDAO.save(u);
        ShiroFunc.getUser().setHead(newHead);
        return uploadFileVO;
    }

    @Override
    public BaseVO updateSex(HttpServletRequest request) {
        BaseVO baseVO = new BaseVO();
        String sex = SafetyUtil.filter(request.getParameter("sex"));
        if (sex == null || sex.length() < 0) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_updateSexSexNotIsNull"));
            return baseVO;
        }
        if (!sex.equals("\u7537") && !sex.equals("\u5973")) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_updateSexEntryFailure"));
            return baseVO;
        }
        User u = this.sqlDAO.findById(User.class, ShiroFunc.getUser().getId());
        u.setSex(sex);
        this.sqlDAO.save(u);
        ShiroFunc.getUser().setSex(sex);
        return baseVO;
    }

    @Override
    public BaseVO updateNickname(HttpServletRequest request) {
        BaseVO baseVO = new BaseVO();
        String nickname = StringUtil.filterXss((String)request.getParameter("nickname"));
        if (nickname == null) {
            nickname = "";
        }
        if (nickname.length() == 0) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_updateNicknameNotNull"));
            return baseVO;
        }
        if (nickname.length() > 15) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_updateNicknameSizeFailure"));
            return baseVO;
        }
        User u = this.sqlDAO.findById(User.class, ShiroFunc.getUser().getId());
        u.setNickname(nickname);
        this.sqlDAO.save(u);
        ShiroFunc.getUser().setNickname(nickname);
        baseVO.setInfo(nickname);
        return baseVO;
    }

    @Override
    public BaseVO updateSign(HttpServletRequest request) {
        BaseVO baseVO = new BaseVO();
        String sign = request.getParameter("sign");
        if (sign == null) {
            sign = "";
        }
        if ((sign = SafetyUtil.filter(StringUtil.filterHtmlTag((String)sign))).length() > 40) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_updateSignSizeFailure"));
            return baseVO;
        }
        User u = this.sqlDAO.findById(User.class, ShiroFunc.getUser().getId());
        u.setSign(sign);
        this.sqlDAO.save(u);
        ShiroFunc.getUser().setSign(sign);
        return baseVO;
    }

    @Override
    public UploadFileVO updateHeadByOSS(HttpServletRequest request, String formFileName) {
        return this.updateHeadByOSS(request, formFileName, 0);
    }

    @Override
    public UploadFileVO updateHeadByOSS(HttpServletRequest request, String formFileName, int maxWidth) {
        UploadFileVO uploadFileVO = new UploadFileVO();
        MultipartFile multipartFile = null;
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            List imageList = multipartRequest.getFiles(formFileName);
            if (imageList.size() == 0) {
                ConsoleUtil.debug("\u4e0a\u4f20\u5934\u50cf\u65f6\uff0c\u672a\u53d1\u73b0\u5934\u50cf ------" + LanguageUtil.show("user_uploadHeadImageNotFind"));
                uploadFileVO.setResult(2);
                uploadFileVO.setInfo(LanguageUtil.show("user_uploadHeadImageNotFind"));
                return uploadFileVO;
            }
            ConsoleUtil.debug("\u4e0a\u4f20\u5934\u50cf\uff0c\u5df2\u53d1\u73b0\u5934\u50cf\u7684multipartFile");
            multipartFile = (MultipartFile)imageList.get(0);
        }
        if (multipartFile == null || multipartFile.isEmpty()) {
            uploadFileVO.setBaseVO(0, LanguageUtil.show("user_uploadHeadImageNotFind"));
            ConsoleUtil.debug("\u4e0a\u4f20\u5934\u50cf\u7684multipartFile\u4e3a\u7a7a\uff0c\u4e0d\u5b58\u5728\u4e0a\u4f20\u7684\u5934\u50cf ------" + LanguageUtil.show("user_uploadHeadImageNotFind"));
            return uploadFileVO;
        }
        User user = ShiroFunc.getUser();
        uploadFileVO = AttachmentUtil.uploadFileByMultipartFile(SystemUtil.get("USER_HEAD_PATH"), multipartFile);
        if (uploadFileVO.getResult() - 0 == 0) {
            return uploadFileVO;
        }
        User u = this.sqlDAO.findById(User.class, user.getId());
        if (u.getHead() != null && u.getHead().length() > 0 && !u.getHead().equals("default.png")) {
            AttachmentUtil.deleteObject(SystemUtil.get("USER_HEAD_PATH") + u.getHead());
        }
        u.setHead(uploadFileVO.getFileName());
        this.sqlDAO.save(u);
        ShiroFunc.getUser().setHead(uploadFileVO.getFileName());
        return uploadFileVO;
    }

    @Override
    public BaseVO loginByUserid(HttpServletRequest request, int userid) {
        BaseVO baseVO = new BaseVO();
        User user = this.sqlDAO.findById(User.class, userid);
        if (user == null) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneUserNotFind"));
            return baseVO;
        }
        String ip = IpUtil.getIpAddress(request);
        if (!user.getLastip().equals(ip) && !user.getRegip().equals(ip)) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneIpFailure"));
            return baseVO;
        }
        if (user.getIsfreeze() == User.ISFREEZE_FREEZE) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginUserFreeze"));
            return baseVO;
        }
        user.setLasttime(DateUtil.timeForUnix10());
        user.setLastip(IpUtil.getIpAddress(request));
        this.sqlDAO.save(user);
        UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), user.getUsername());
        token.setRememberMe(false);
        Subject currentUser = SecurityUtils.getSubject();
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (UnknownAccountException uae) {
            uae.printStackTrace();
        }
        catch (IncorrectCredentialsException ice) {
            ice.printStackTrace();
        }
        catch (LockedAccountException lae) {
            lae.printStackTrace();
        }
        catch (ExcessiveAttemptsException eae) {
            eae.printStackTrace();
        }
        catch (AuthenticationException ae) {
            ae.printStackTrace();
        }
        baseVO.setBaseVO(1, LanguageUtil.show("user_loginSuccess"));
        return baseVO;
    }

    @Override
    public BaseVO loginForUserId(HttpServletRequest request, int userId) {
        BaseVO baseVO = new BaseVO();
        User user = this.sqlDAO.findById(User.class, userId);
        if (user == null) {
            ConsoleUtil.debug("\u7528\u6237\u4e0d\u5b58\u5728");
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneUserNotFind"));
            return baseVO;
        }
        if (user.getIsfreeze() == User.ISFREEZE_FREEZE) {
            ConsoleUtil.debug("\u6b64\u7528\u6237\u88ab\u51bb\u7ed3\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u767b\u9646\u7528\u6237");
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginUserFreeze"));
            return baseVO;
        }
        String ip = SafetyUtil.filter(IpUtil.getIpAddress(request));
        this.sqlDAO.executeSql("UPDATE user SET lasttime = " + DateUtil.timeForUnix10() + ", lastip = '" + ip + "' WHERE id = " + user.getId());
        UsernamePasswordToken token = new UsernamePasswordToken(user.getUsername(), user.getUsername());
        token.setRememberMe(false);
        Subject currentUser = SecurityUtils.getSubject();
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (UnknownAccountException uae) {
            uae.printStackTrace();
        }
        catch (IncorrectCredentialsException ice) {
            ice.printStackTrace();
        }
        catch (LockedAccountException lae) {
            lae.printStackTrace();
        }
        catch (ExcessiveAttemptsException eae) {
            eae.printStackTrace();
        }
        catch (AuthenticationException ae) {
            ae.printStackTrace();
        }
        baseVO.setBaseVO(1, LanguageUtil.show("user_loginSuccess"));
        return baseVO;
    }

    @Override
    public BaseVO updatePassword(int userid, String newPassword) {
        BaseVO baseVO = new BaseVO();
        if (userid <= 0) {
            return BaseVO.failure("userid is null");
        }
        if (newPassword == null || newPassword.length() == 0) {
            return BaseVO.failure("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = this.sqlDAO.findById(User.class, userid);
        String md5Password = new Md5Hash((Object)newPassword, (Object)user.getSalt(), 2).toString();
        user.setPassword(md5Password);
        this.sqlDAO.save(user);
        return baseVO;
    }

    @Override
    public BaseVO createUser(User user, HttpServletRequest request) {
        user.setUsername(SafetyUtil.xssFilter(user.getUsername()));
        user.setPassword(user.getPassword());
        if (user.getUsername() == null || user.getUsername().equals("")) {
            return BaseVO.failure("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (user.getPassword() == null || user.getPassword().equals("")) {
            return BaseVO.failure("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (user.getUsername().length() > 40) {
            return BaseVO.failure(LanguageUtil.show("user_userNameToLong"));
        }
        if (user.getEmail() != null && user.getEmail().length() > 0 && this.sqlDAO.findByProperty(User.class, "email", user.getEmail()).size() > 0) {
            return BaseVO.failure(LanguageUtil.show("user_regFailureForEmailAlreadyExist"));
        }
        if (this.sqlDAO.findByProperty(User.class, "username", user.getUsername()).size() > 0) {
            return BaseVO.failure(LanguageUtil.show("user_regFailureForUsernameAlreadyExist"));
        }
        if (user.getPhone() != null && user.getPhone().length() > 0 && this.findByPhone(user.getUsername()) != null) {
            return BaseVO.failure(LanguageUtil.show("user_regFailureForPhoneAlreadyExist"));
        }
        if (user.getRegip() == null) {
            user.setRegip(IpUtil.getIpAddress(request));
        }
        if (user.getLastip() == null) {
            user.setLastip(IpUtil.getIpAddress(request));
        }
        if (user.getRegtime() == null) {
            user.setRegtime(DateUtil.timeForUnix10());
        }
        if (user.getLasttime() == null) {
            user.setLasttime(DateUtil.timeForUnix10());
        }
        if (user.getNickname() == null) {
            user.setNickname(user.getUsername());
        } else {
            user.setNickname(StringUtil.filterXss((String)Sql.filter(user.getNickname())));
        }
        if (user.getAuthority() == null) {
            user.setAuthority(SystemUtil.get("USER_REG_ROLE"));
        }
        if (user.getCurrency() == null) {
            user.setCurrency(0);
        }
        if (user.getReferrerid() == null) {
            user.setReferrerid(ShiroFunc.getUserId());
        }
        if (user.getIsfreeze() == null) {
            user.setIsfreeze(User.ISFREEZE_NORMAL);
        }
        if (user.getHead() == null) {
            user.setHead("default.png");
        } else {
            user.setHead(SafetyUtil.filter(user.getHead()));
        }
        if (user.getId() != null) {
            user.setId(null);
        }
        Random random = new Random();
        user.setSalt(random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "");
        String md5Password = this.generateMd5Password(user.getPassword(), user.getSalt());
        user.setPassword(md5Password);
        this.sqlDAO.save(user);
        if (user.getId() > 0) {
            UserRole userRole = new UserRole();
            userRole.setRoleid(Lang.stringToInt((String)user.getAuthority(), (int)SystemUtil.getInt("USER_REG_ROLE")));
            userRole.setUserid(user.getId());
            this.sqlDAO.save(userRole);
            BaseVO vo = new BaseVO();
            vo.setBaseVO(1, user.getId() + "");
            return vo;
        }
        return BaseVO.failure(LanguageUtil.show("user_regFailure"));
    }

    @Override
    public String getHead(String defaultHead) {
        String head = null;
        User user = ShiroFunc.getUser();
        head = user == null ? defaultHead : (user.getHead() != null && user.getHead().length() > 10 ? (user.getHead().indexOf("http:") == 0 || user.getHead().indexOf("https:") == 0 || user.getHead().indexOf("//") == 0 ? user.getHead() : (user.getHead().equals("default.png") ? defaultHead : AttachmentUtil.netUrl() + SystemUtil.get("USER_HEAD_PATH") + user.getHead())) : defaultHead);
        return head;
    }

    @Override
    public String generateMd5Password(String originalPassword, String salt) {
        return new Md5Hash((Object)originalPassword, (Object)salt, 2).toString();
    }

    @Override
    public UploadFileVO updateHead(MultipartFile head) {
        UploadFileVO uploadFileVO = new UploadFileVO();
        if (head == null || head.isEmpty()) {
            uploadFileVO.setBaseVO(0, LanguageUtil.show("user_uploadHeadImageNotFind"));
            return uploadFileVO;
        }
        User user = SessionUtil.getUser();
        String fileSuffix = "png";
        fileSuffix = Lang.findFileSuffix((String)SafetyUtil.filter(head.getOriginalFilename()));
        String newHead = Lang.uuid() + "." + fileSuffix;
        try {
            uploadFileVO = AttachmentUtil.put(SystemUtil.get("USER_HEAD_PATH") + newHead, head.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            uploadFileVO.setBaseVO(0, e.getMessage());
            return uploadFileVO;
        }
        User u = this.sqlDAO.findById(User.class, user.getId());
        if (u.getHead() != null && u.getHead().length() > 0 && !u.getHead().equals("default.png")) {
            AttachmentUtil.deleteObject("image/head/" + u.getHead());
        }
        u.setHead(newHead);
        this.sqlDAO.save(u);
        SessionUtil.setUser(u);
        return uploadFileVO;
    }

    @Override
    public String getHead(User user) {
        String head = null;
        if (user != null) {
            head = user.getHead();
        }
        if (head == null || head.length() == 0) {
            head = "default.png";
        }
        if (head.indexOf("http:") == 0 || head.indexOf("https:") == 0 || head.indexOf("//") == 0) {
            return head;
        }
        return AttachmentUtil.netUrl() + SystemUtil.get("USER_HEAD_PATH") + head;
    }
}

