/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.service.impl;

import com.xnx3.MD5Util;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.service.SqlCacheService;
import com.xnx3.j2ee.util.CacheUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;

public class SqlCacheServiceImpl
implements SqlCacheService {
    public static final String CACHE_KEY_BY_ID = "sql:{entity}:id:{id}";
    public static final String CACHE_KEY_BY_PROPERTY_ALONE = "sql:{entity}:{property}:{value}:alone";
    public static final String CACHE_KEY_BY_PROPERTY = "sql:{entity}:{property}:{value}";
    public static final String CACHE_KEY_BY_WHERE = "sql:{entity}:where:{where}";
    public static final int YEAR_SECOND = 31536000;
    @Resource
    private SqlDAO sqlDAO;

    public SqlDAO getSqlDAO() {
        return this.sqlDAO;
    }

    public void setSqlDAO(SqlDAO sqlDAO) {
        this.sqlDAO = sqlDAO;
    }

    @Override
    public <E> E findById(Class<E> entity, Object id) {
        return this.findById(entity, id, 31536000);
    }

    @Override
    public void deleteCacheById(Class entity, Object id) {
        String key = CACHE_KEY_BY_ID.replace("{entity}", entity.getName()).replace("{id}", id.toString());
        CacheUtil.delete((String)key);
    }

    @Override
    public <E> E findAloneByProperty(Class<E> entity, String propertyName, Object value) {
        return this.findAloneByProperty(entity, propertyName, value, 31536000);
    }

    @Override
    public void deleteCacheByProperty(Class entity, String propertyName, Object value) {
        String key = CACHE_KEY_BY_PROPERTY.replace("{entity}", entity.getName()).replace("{property}", propertyName).replace("{value}", value.toString());
        CacheUtil.delete((String)key);
        String aloneKey = CACHE_KEY_BY_PROPERTY_ALONE.replace("{entity}", entity.getName()).replace("{property}", propertyName).replace("{value}", value.toString());
        CacheUtil.delete((String)aloneKey);
    }

    @Override
    public <E> E findBySql(Class<E> entity, String where) {
        return this.findBySql(entity, where, 31536000);
    }

    @Override
    public void deleteCacheBySql(Class entity, String where) {
        String key = CACHE_KEY_BY_WHERE.replace("{entity}", entity.getName()).replace("{where}", SqlCacheServiceImpl.sqlWhereToKey(where));
        CacheUtil.delete((String)key);
    }

    private static String sqlWhereToKey(String where) {
        String key_where = where.replaceAll("=", "_").replaceAll("'", "").replaceAll("\\s+", "");
        return key_where;
    }

    @Override
    public <E> List<E> findByProperty(Class<E> entity, String propertyName, Object value) {
        return this.findByProperty(entity, propertyName, value, 31536000);
    }

    @Override
    public <E> List<E> findByProperty(Class<E> entity, String propertyName, Object value, int expiretime) {
        String key = CACHE_KEY_BY_PROPERTY.replace("{entity}", entity.getName()).replace("{property}", propertyName).replace("{value}", value.toString());
        List<E> list = (List<E>)CacheUtil.get((String)key);
        if (list == null && (list = this.sqlDAO.findByProperty(entity, propertyName, value)) != null && list.size() > 0) {
            CacheUtil.set((String)key, list, (int)expiretime);
        }
        return list;
    }

    @Override
    public <E> E findById(Class<E> entity, Object id, int expiretime) {
        String key = CACHE_KEY_BY_ID.replace("{entity}", entity.getName()).replace("{id}", id.toString());
        Object e = CacheUtil.get((String)key);
        if (e == null && (e = this.sqlDAO.findById(entity, id)) != null) {
            CacheUtil.set((String)key, (Object)e, (int)expiretime);
        }
        return (E)e;
    }

    @Override
    public <E> E findAloneByProperty(Class<E> entity, String propertyName, Object value, int expiretime) {
        String key = CACHE_KEY_BY_PROPERTY_ALONE.replace("{entity}", entity.getName()).replace("{property}", propertyName).replace("{value}", value.toString());
        Object e = CacheUtil.get((String)key);
        if (e == null && (e = this.sqlDAO.findAloneByProperty(entity, propertyName, value)) != null) {
            CacheUtil.set((String)key, (Object)e, (int)expiretime);
        }
        return (E)e;
    }

    @Override
    public <E> E findBySql(Class<E> entity, String where, int expiretime) {
        List<E> list;
        String tableName = SqlDAO.getDatabaseTableName(entity);
        String key = CACHE_KEY_BY_WHERE.replace("{entity}", entity.getName()).replace("{where}", SqlCacheServiceImpl.sqlWhereToKey(where));
        Object e = CacheUtil.get((String)key);
        if (e == null && (list = this.sqlDAO.findBySqlQuery("SELECT * FROM " + tableName + " WHERE " + where + " LIMIT 0,1", entity)) != null && list.size() > 0) {
            e = list.get(0);
            CacheUtil.set((String)key, (Object)e, (int)expiretime);
        }
        return (E)e;
    }

    @Override
    public <E> List<E> findBySqlQuery(String sqlQuery, Class<E> entityClass, int expiretime) {
        String key = MD5Util.MD5((String)("sql:findBySqlQuery:" + sqlQuery));
        List<E> list = (List<E>)CacheUtil.get((String)key);
        if (list == null) {
            list = this.sqlDAO.findBySqlQuery(sqlQuery, entityClass);
            if (list == null) {
                list = new ArrayList();
            }
            CacheUtil.set((String)key, list, (int)expiretime);
        }
        return list;
    }
}

