/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.service.impl;

import com.xnx3.BaseVO;
import com.xnx3.DateUtil;
import com.xnx3.Lang;
import com.xnx3.SMSUtil;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.entity.SmsLog;
import com.xnx3.j2ee.service.SmsService;
import com.xnx3.j2ee.util.ApplicationPropertiesUtil;
import com.xnx3.j2ee.util.IpUtil;
import com.xnx3.j2ee.util.LanguageUtil;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.net.AliyunSMSUtil;
import com.xnx3.net.HuaweiSMSUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

public class SmsServiceImpl
implements SmsService {
    public static SMSUtil smsUtil;
    @Resource
    private SqlDAO sqlDAO;

    public SqlDAO getSqlDAO() {
        return this.sqlDAO;
    }

    public void setSqlDAO(SqlDAO sqlDAO) {
        this.sqlDAO = sqlDAO;
    }

    @Override
    public int findByPhoneNum(String phone, Short type) {
        int weeHours = DateUtil.dateToInt10((Date)DateUtil.weeHours((Date)new Date()));
        return this.sqlDAO.count("sms_log", "WHERE addtime > " + weeHours + " AND phone = '" + Sql.filter(phone) + "' AND type = " + type);
    }

    @Override
    public int findByIpNum(String ip, Short type) {
        int weeHours = DateUtil.dateToInt10((Date)DateUtil.weeHours((Date)new Date()));
        return this.sqlDAO.count("sms_log", "WHERE addtime > " + weeHours + " AND ip = '" + Sql.filter(ip) + "' AND type = " + type);
    }

    @Override
    public com.xnx3.j2ee.vo.BaseVO sendPhoneLoginCode(HttpServletRequest request) {
        String phone = StringUtil.filterXss((String)request.getParameter("phone"));
        com.xnx3.j2ee.vo.BaseVO baseVO = this.sendSMS(request, phone, (short)1);
        if (baseVO.getResult() - 1 == 0) {
            String result = com.xnx3.net.SMSUtil.send((String)phone, (String)LanguageUtil.show("sms_loginSendCodeText").replaceAll("\\$\\{code\\}", baseVO.getInfo() + ""));
            if (result == null) {
                baseVO.setBaseVO(1, LanguageUtil.show("sms_codeSendYourPhoneSuccess"));
            } else {
                baseVO.setBaseVO(0, LanguageUtil.show("sms_saveFailure") + "-" + result);
            }
        }
        return baseVO;
    }

    @Override
    public com.xnx3.j2ee.vo.BaseVO sendSms(HttpServletRequest request, String phone, String content, Short type) {
        com.xnx3.j2ee.vo.BaseVO baseVO = this.sendSMS(request, phone, type);
        if (baseVO.getResult() - 1 == 0) {
            if (smsUtil != null) {
                BaseVO vo = smsUtil.send(phone, content.replaceAll("\\$\\{code\\}", baseVO.getInfo() + ""));
                baseVO.setBaseVO(vo);
            } else {
                String result = com.xnx3.net.SMSUtil.send((String)phone, (String)content.replaceAll("\\$\\{code\\}", baseVO.getInfo() + ""));
                if (result == null) {
                    baseVO.setBaseVO(1, LanguageUtil.show("sms_codeSendYourPhoneSuccess"));
                } else {
                    baseVO.setBaseVO(0, LanguageUtil.show("sms_saveFailure") + "-" + result);
                }
            }
        }
        return baseVO;
    }

    @Override
    public com.xnx3.j2ee.vo.BaseVO verifyPhoneAndCode(String phone, String code, Short type, int overdue) {
        SmsLog smsLog;
        com.xnx3.j2ee.vo.BaseVO baseVO = new com.xnx3.j2ee.vo.BaseVO();
        if (phone == null || phone.length() != 11) {
            baseVO.setBaseVO(0, LanguageUtil.show("sms_sendSmsPhoneNumberFailure"));
            return baseVO;
        }
        if (code == null || code.length() != 6) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneAndCodeCodeFailure"));
            return baseVO;
        }
        int queryAddtime = 0;
        if (type - 1 == 0) {
            overdue = SmsLog.codeValidity;
        }
        if (overdue > 0) {
            int currentTime = DateUtil.timeForUnix10();
            queryAddtime = currentTime - overdue;
        }
        if ((smsLog = this.findByPhoneAddtimeUsedTypeCode(phone, queryAddtime, (short)0, type, code)) != null) {
            smsLog.setUserid(0);
            smsLog.setUsed((short)1);
            this.sqlDAO.save(smsLog);
            baseVO.setResult(1);
            return baseVO;
        }
        baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneAndCodeCodeNotFind"));
        return baseVO;
    }

    @Override
    public com.xnx3.j2ee.vo.BaseVO sendByAliyunSMS(HttpServletRequest request, AliyunSMSUtil aliyunSMSUtil, String signName, String templateCode, String phone, Short type) {
        com.xnx3.j2ee.vo.BaseVO baseVO = this.sendSMS(request, phone, type);
        if (baseVO.getResult() - 1 == 0) {
            baseVO.setBaseVOForSuper(aliyunSMSUtil.send(signName, templateCode, "{\"code\":\"" + baseVO.getInfo() + "\"}", "" + phone + ""));
        }
        return baseVO;
    }

    private com.xnx3.j2ee.vo.BaseVO sendSMS(HttpServletRequest request, String phone, Short type) {
        int ipNum;
        int phoneNum;
        com.xnx3.j2ee.vo.BaseVO baseVO = new com.xnx3.j2ee.vo.BaseVO();
        if (!this.useSMS()) {
            baseVO.setBaseVO(0, "\u8bf7\u5148\u914d\u7f6e\u77ed\u4fe1\u53d1\u9001\u901a\u9053");
            return baseVO;
        }
        if (phone == null || phone.length() != 11) {
            baseVO.setBaseVO(0, LanguageUtil.show("sms_sendSmsPhoneNumberFailure"));
            return baseVO;
        }
        if (SmsLog.everyDayPhoneNum > 0 && (phoneNum = this.findByPhoneNum(phone, type)) >= SmsLog.everyDayPhoneNum) {
            baseVO.setBaseVO(0, LanguageUtil.show("sms_thisPhoneNumberDayUpperLimit"));
            return baseVO;
        }
        if (SmsLog.everyDayIpNum > 0 && (ipNum = this.findByIpNum(IpUtil.getIpAddress(request), type)) >= SmsLog.everyDayIpNum) {
            baseVO.setBaseVO(0, LanguageUtil.show("sms_thisIpDayUpperLimit"));
            return baseVO;
        }
        Random random = new Random();
        String code = random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10);
        SmsLog smsLog = new SmsLog();
        smsLog.setAddtime(DateUtil.timeForUnix10());
        smsLog.setCode(code);
        smsLog.setIp(IpUtil.getIpAddress(request));
        smsLog.setPhone(SafetyUtil.filter(phone));
        smsLog.setType(type);
        smsLog.setUsed((short)0);
        smsLog.setUserid(0);
        this.sqlDAO.save(smsLog);
        if (smsLog.getId() > 0) {
            baseVO.setBaseVO(1, code);
            return baseVO;
        }
        baseVO.setBaseVO(0, LanguageUtil.show("sms_saveFailure"));
        return baseVO;
    }

    @Override
    public SmsLog findByPhoneAddtimeUsedTypeCode(String phone, int addtime, Short used, Short type, String code) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("phone", phone);
        parameterMap.put("addtime", addtime);
        parameterMap.put("used", used);
        parameterMap.put("type", type);
        parameterMap.put("code", code);
        List list = this.sqlDAO.findByHql("from SmsLog as model where model.phone= :phone and model.addtime > :addtime and model.used = :used and model.type = :type and model.code = :code", parameterMap, 0);
        if (list.size() > 0) {
            return (SmsLog)list.get(0);
        }
        return null;
    }

    @Override
    public com.xnx3.j2ee.vo.BaseVO sendByHuaweiSMS(HttpServletRequest request, HuaweiSMSUtil huaweiSMSUtil, String templateId, String phone, Short type) {
        com.xnx3.j2ee.vo.BaseVO baseVO = this.sendSMS(request, phone, type);
        if (baseVO.getResult() - 1 == 0) {
            baseVO.setBaseVOForSuper(huaweiSMSUtil.send(phone, templateId, "[\"" + baseVO.getInfo() + "\"]"));
        }
        return baseVO;
    }

    @Override
    public boolean useSMS() {
        return smsUtil != null;
    }

    @Override
    public com.xnx3.j2ee.vo.BaseVO getBalance() {
        if (smsUtil == null) {
            return com.xnx3.j2ee.vo.BaseVO.failure("\u672a\u914d\u7f6e\u77ed\u4fe1\u901a\u9053");
        }
        BaseVO bvo = smsUtil.getBalance();
        com.xnx3.j2ee.vo.BaseVO vo = new com.xnx3.j2ee.vo.BaseVO();
        vo.setBaseVO(bvo);
        return vo;
    }

    @Override
    public com.xnx3.j2ee.vo.BaseVO sendSms(HttpServletRequest request, String phone, String content) {
        com.xnx3.j2ee.vo.BaseVO baseVO = new com.xnx3.j2ee.vo.BaseVO();
        if (!this.useSMS()) {
            baseVO.setBaseVO(0, "\u8bf7\u5148\u914d\u7f6e\u77ed\u4fe1\u53d1\u9001\u901a\u9053");
            return baseVO;
        }
        if (phone == null || phone.length() != 11) {
            baseVO.setBaseVO(0, LanguageUtil.show("sms_sendSmsPhoneNumberFailure"));
            return baseVO;
        }
        if (smsUtil == null) {
            baseVO.setBaseVO(0, "\u6545\u969c\uff0c\u77ed\u4fe1\u53d1\u9001\u6a21\u5757\u672a\u521d\u59cb\u5316");
            return baseVO;
        }
        BaseVO vo = smsUtil.send(phone, content);
        baseVO.setBaseVO(vo);
        return baseVO;
    }

    static {
        String uid = ApplicationPropertiesUtil.getProperty("sms.uid");
        String password = ApplicationPropertiesUtil.getProperty("sms.password");
        if (uid != null && password != null) {
            int intUid = Lang.stringToInt((String)uid, (int)0);
            smsUtil = new SMSUtil(intUid, password);
        }
    }
}

