/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.service.impl;

import com.xnx3.DateUtil;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.entity.SmsLog;
import com.xnx3.j2ee.service.SmsLogService;
import com.xnx3.j2ee.util.IpUtil;
import com.xnx3.j2ee.util.LanguageUtil;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.net.AliyunSMSUtil;
import com.xnx3.net.SMSUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class SmsLogServiceImpl
implements SmsLogService {
    @Resource
    private SqlDAO sqlDAO;

    public SqlDAO getSqlDAO() {
        return this.sqlDAO;
    }

    public void setSqlDAO(SqlDAO sqlDAO) {
        this.sqlDAO = sqlDAO;
    }

    @Override
    public int findByPhoneNum(String phone, Short type) {
        int weeHours = DateUtil.dateToInt10((Date)DateUtil.weeHours((Date)new Date()));
        return this.sqlDAO.count("sms_log", "WHERE addtime > " + weeHours + " AND phone = '" + Sql.filter(phone) + "' AND type = " + type);
    }

    @Override
    public int findByIpNum(String ip, Short type) {
        int weeHours = DateUtil.dateToInt10((Date)DateUtil.weeHours((Date)new Date()));
        return this.sqlDAO.count("sms_log", "WHERE addtime > " + weeHours + " AND ip = '" + Sql.filter(ip) + "' AND type = " + type);
    }

    @Override
    public BaseVO sendPhoneLoginCode(HttpServletRequest request) {
        String phone = StringUtil.filterXss((String)request.getParameter("phone"));
        BaseVO baseVO = this.sendSMS(request, phone, (short)1);
        if (baseVO.getResult() - 1 == 0) {
            String result = SMSUtil.send((String)phone, (String)LanguageUtil.show("sms_loginSendCodeText").replaceAll("\\$\\{code\\}", baseVO.getInfo() + ""));
            if (result == null) {
                baseVO.setBaseVO(1, LanguageUtil.show("sms_codeSendYourPhoneSuccess"));
            } else {
                baseVO.setBaseVO(0, LanguageUtil.show("sms_saveFailure") + "-" + result);
            }
        }
        return baseVO;
    }

    @Override
    public BaseVO sendSms(HttpServletRequest request, String phone, String content, Short type) {
        BaseVO baseVO = this.sendSMS(request, phone, type);
        if (baseVO.getResult() - 1 == 0) {
            String result = SMSUtil.send((String)phone, (String)content.replaceAll("\\$\\{code\\}", baseVO.getInfo() + ""));
            if (result == null) {
                baseVO.setBaseVO(1, LanguageUtil.show("sms_codeSendYourPhoneSuccess"));
            } else {
                baseVO.setBaseVO(0, LanguageUtil.show("sms_saveFailure") + "-" + result);
            }
        }
        return baseVO;
    }

    @Override
    public BaseVO verifyPhoneAndCode(String phone, String code, Short type, int overdue) {
        SmsLog smsLog;
        BaseVO baseVO = new BaseVO();
        if (phone == null || phone.length() != 11) {
            baseVO.setBaseVO(0, LanguageUtil.show("sms_sendSmsPhoneNumberFailure"));
            return baseVO;
        }
        if (code == null || code.length() != 6) {
            baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneAndCodeCodeFailure"));
            return baseVO;
        }
        int queryAddtime = 0;
        if (type - 1 == 0) {
            overdue = SmsLog.codeValidity;
        }
        if (overdue > 0) {
            int currentTime = DateUtil.timeForUnix10();
            queryAddtime = currentTime - overdue;
        }
        if ((smsLog = this.findByPhoneAddtimeUsedTypeCode(phone, queryAddtime, (short)0, type, code)) != null) {
            smsLog.setUserid(0);
            smsLog.setUsed((short)1);
            this.sqlDAO.save(smsLog);
            baseVO.setResult(1);
            return baseVO;
        }
        baseVO.setBaseVO(0, LanguageUtil.show("user_loginByPhoneAndCodeCodeNotFind"));
        return baseVO;
    }

    @Override
    public BaseVO sendByAliyunSMS(HttpServletRequest request, AliyunSMSUtil aliyunSMSUtil, String signName, String templateCode, String phone, Short type) {
        BaseVO baseVO = this.sendSMS(request, phone, type);
        if (baseVO.getResult() - 1 == 0) {
            baseVO.setBaseVOForSuper(aliyunSMSUtil.send(signName, templateCode, "{\"code\":\"" + baseVO.getInfo() + "\"}", "" + phone + ""));
        }
        return baseVO;
    }

    private BaseVO sendSMS(HttpServletRequest request, String phone, Short type) {
        int ipNum;
        int phoneNum;
        BaseVO baseVO = new BaseVO();
        if (phone == null || phone.length() != 11) {
            baseVO.setBaseVO(0, LanguageUtil.show("sms_sendSmsPhoneNumberFailure"));
            return baseVO;
        }
        if (SmsLog.everyDayPhoneNum > 0 && (phoneNum = this.findByPhoneNum(phone, type)) >= SmsLog.everyDayPhoneNum) {
            baseVO.setBaseVO(0, LanguageUtil.show("sms_thisPhoneNumberDayUpperLimit"));
            return baseVO;
        }
        if (SmsLog.everyDayIpNum > 0 && (ipNum = this.findByIpNum(IpUtil.getIpAddress(request), type)) >= SmsLog.everyDayIpNum) {
            baseVO.setBaseVO(0, LanguageUtil.show("sms_thisIpDayUpperLimit"));
            return baseVO;
        }
        Random random = new Random();
        String code = random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10);
        SmsLog smsLog = new SmsLog();
        smsLog.setAddtime(DateUtil.timeForUnix10());
        smsLog.setCode(code);
        smsLog.setIp(IpUtil.getIpAddress(request));
        smsLog.setPhone(SafetyUtil.filter(phone));
        smsLog.setType(type);
        smsLog.setUsed((short)0);
        smsLog.setUserid(0);
        this.sqlDAO.save(smsLog);
        if (smsLog.getId() > 0) {
            baseVO.setBaseVO(1, code);
            return baseVO;
        }
        baseVO.setBaseVO(0, LanguageUtil.show("sms_saveFailure"));
        return baseVO;
    }

    @Override
    public SmsLog findByPhoneAddtimeUsedTypeCode(String phone, int addtime, Short used, Short type, String code) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("phone", phone);
        parameterMap.put("addtime", addtime);
        parameterMap.put("used", used);
        parameterMap.put("type", type);
        parameterMap.put("code", code);
        List list = this.sqlDAO.findByHql("from SmsLog as model where model.phone= :phone and model.addtime > :addtime and model.used = :used and model.type = :type and model.code = :code", parameterMap, 0);
        if (list.size() > 0) {
            return (SmsLog)list.get(0);
        }
        return null;
    }
}

