/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.service.impl;

import com.xnx3.Lang;
import com.xnx3.j2ee.bean.RoleMark;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.entity.Permission;
import com.xnx3.j2ee.entity.Role;
import com.xnx3.j2ee.entity.RolePermission;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.entity.UserRole;
import com.xnx3.j2ee.service.RoleService;
import com.xnx3.j2ee.vo.BaseVO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;

public class RoleServiceImpl
implements RoleService {
    @Resource
    private SqlDAO sqlDAO;

    public SqlDAO getSqlDAO() {
        return this.sqlDAO;
    }

    public void setSqlDAO(SqlDAO sqlDAO) {
        this.sqlDAO = sqlDAO;
    }

    @Override
    public List<Permission> findPermissionByRoleId(Integer roleId) {
        List<Permission> list = this.sqlDAO.findBySqlQuery("SELECT permission.* FROM permission,role_permission WHERE role_permission.permissionid=permission.id AND role_permission.roleid=" + roleId, Permission.class);
        return list;
    }

    @Override
    public BaseVO saveRolePermission(int roleId, String permission) {
        int j;
        boolean haveRP;
        int i;
        if (roleId == 0) {
            return BaseVO.failure("\u4f20\u5165\u7684\u7f16\u53f7\u4e0d\u6b63\u786e\uff01");
        }
        if (permission == null || permission.trim().length() == 0) {
            permission = "";
        }
        List<RolePermission> myRolePermissionList = this.sqlDAO.findBySqlQuery("SELECT * FROM role_permission WHERE roleid = " + roleId, RolePermission.class);
        String[] permissionArray = permission.split(",");
        for (i = 0; i < permissionArray.length; ++i) {
            int pid = Lang.stringToInt((String)permissionArray[i], (int)0);
            if (pid <= 0) continue;
            haveRP = false;
            for (j = 0; j < myRolePermissionList.size(); ++j) {
                RolePermission myrp = myRolePermissionList.get(j);
                if (myrp.getPermissionid() != pid) continue;
                haveRP = true;
                break;
            }
            if (haveRP) continue;
            RolePermission rp = new RolePermission();
            rp.setRoleid(roleId);
            rp.setPermissionid(pid);
            this.sqlDAO.save(rp);
        }
        for (i = 0; i < myRolePermissionList.size(); ++i) {
            RolePermission myrp = myRolePermissionList.get(i);
            haveRP = false;
            for (j = 0; j < permissionArray.length; ++j) {
                int pid = Lang.stringToInt((String)permissionArray[j], (int)0);
                if (pid <= 0 || myrp.getPermissionid() != pid) continue;
                haveRP = true;
                break;
            }
            if (haveRP) continue;
            this.sqlDAO.delete(myrp);
        }
        return BaseVO.success();
    }

    @Override
    public List<RoleMark> getUserRoleMarkList(int userid) {
        ArrayList<RoleMark> roleMarkList = new ArrayList<RoleMark>();
        List<Role> myList = this.sqlDAO.findBySqlQuery("SELECT role.* FROM user_role,role WHERE user_role.roleid=role.id AND user_role.userid=" + userid, Role.class);
        List<Role> allList = this.sqlDAO.findAll(Role.class);
        for (int i = 0; i < allList.size(); ++i) {
            Role role = allList.get(i);
            RoleMark roleMark = new RoleMark();
            roleMark.setRole(role);
            for (int j = 0; j < myList.size(); ++j) {
                Role myRole = myList.get(j);
                if (myRole.getId() != role.getId()) continue;
                roleMark.setSelected(true);
                break;
            }
            roleMarkList.add(roleMark);
        }
        return roleMarkList;
    }

    @Override
    public BaseVO saveUserRole(int userid, String role) {
        int j;
        boolean haveUR;
        int i;
        if (userid == 0) {
            return BaseVO.failure("\u4f20\u5165\u7684\u7528\u6237id\u4e0d\u6b63\u786e");
        }
        User user = this.sqlDAO.findById(User.class, userid);
        if (user == null) {
            return BaseVO.failure("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        List<UserRole> myUserRoleList = this.sqlDAO.findByProperty(UserRole.class, "userid", userid);
        String[] roleArray = role.split(",");
        for (i = 0; i < roleArray.length; ++i) {
            int rid = Lang.stringToInt((String)roleArray[i], (int)0);
            if (rid <= 0) continue;
            haveUR = false;
            for (j = 0; j < myUserRoleList.size(); ++j) {
                UserRole myUR = myUserRoleList.get(j);
                if (myUR.getRoleid() != rid) continue;
                haveUR = true;
                break;
            }
            if (haveUR) continue;
            UserRole ur = new UserRole();
            ur.setRoleid(rid);
            ur.setUserid(userid);
            this.sqlDAO.save(ur);
        }
        for (i = 0; i < myUserRoleList.size(); ++i) {
            UserRole myUR = myUserRoleList.get(i);
            haveUR = false;
            for (j = 0; j < roleArray.length; ++j) {
                int rid = Lang.stringToInt((String)roleArray[j], (int)0);
                if (rid <= 0 || myUR.getRoleid() != rid) continue;
                haveUR = true;
                break;
            }
            if (haveUR) continue;
            this.sqlDAO.delete(myUR);
        }
        user.setAuthority(role);
        this.sqlDAO.save(user);
        return BaseVO.success();
    }

    @Override
    public List<Permission> findPermissionByUser(User user) {
        List<Permission> list = null;
        String roles = user.getAuthority();
        if (roles == null || roles.length() == 0) {
            list = new ArrayList<Permission>();
            return list;
        }
        list = this.sqlDAO.findBySqlQuery("SELECT permission.* FROM permission,role_permission WHERE role_permission.permissionid=permission.id AND role_permission.roleid IN(" + roles + ") ORDER BY permission.rank ASC", Permission.class);
        return list;
    }
}

