/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.service.impl;

import com.xnx3.Lang;
import com.xnx3.MD5Util;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.service.ApiService;
import com.xnx3.j2ee.shiro.ShiroFunc;
import com.xnx3.j2ee.vo.UserVO;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;

public class ApiServiceImpl
implements ApiService {
    @Resource
    private SqlDAO sqlDAO;

    public SqlDAO getSqlDAO() {
        return this.sqlDAO;
    }

    public void setSqlDAO(SqlDAO sqlDAO) {
        this.sqlDAO = sqlDAO;
    }

    @Override
    public UserVO identityVerify(String key) {
        UserVO vo = new UserVO();
        if (key.length() < 128 || key.indexOf("_") == -1) {
            vo.setBaseVO(0, "key\u9519\u8bef1");
            return vo;
        }
        String[] ks = key.split("_");
        if (ks[0].length() == 0 || ks[1].length() == 0) {
            vo.setBaseVO(0, "key\u9519\u8bef2");
            return vo;
        }
        int userid = Lang.stringToInt((String)ks[0], (int)0);
        if (userid == 0) {
            vo.setBaseVO(0, "key\u9519\u8bef3");
            return vo;
        }
        String pwd = StringUtil.removeBlank((String)ks[1]);
        if (pwd.length() != 128) {
            vo.setBaseVO(0, "key\u9519\u8bef4");
            return vo;
        }
        User user = this.sqlDAO.findById(User.class, userid);
        if (user == null) {
            vo.setBaseVO(0, "key\u9519\u8bef5");
            return vo;
        }
        if (!ApiServiceImpl.passwordMD5(user.getPassword()).equals(pwd)) {
            vo.setBaseVO(0, "key\u9519\u8bef6");
            return vo;
        }
        vo.setUser(user);
        return vo;
    }

    private static String passwordMD5(String password) {
        String p1 = password.substring(0, 8);
        String p2 = password.substring(8, 16);
        String p3 = password.substring(16, 24);
        String p4 = password.substring(24, 32);
        return MD5Util.MD5((String)p1) + MD5Util.MD5((String)p2) + MD5Util.MD5((String)p3) + MD5Util.MD5((String)p4);
    }

    @Override
    public UserVO identityVerifyAndSession(String key) {
        UserVO vo = this.identityVerify(key);
        if (vo.getResult() - 0 == 0) {
            return vo;
        }
        UsernamePasswordToken token = new UsernamePasswordToken(vo.getUser().getUsername(), vo.getUser().getUsername());
        token.setRememberMe(false);
        Subject currentUser = SecurityUtils.getSubject();
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (UnknownAccountException uae) {
            uae.printStackTrace();
        }
        catch (IncorrectCredentialsException ice) {
            ice.printStackTrace();
        }
        catch (LockedAccountException lae) {
            lae.printStackTrace();
        }
        catch (ExcessiveAttemptsException eae) {
            eae.printStackTrace();
        }
        catch (AuthenticationException ae) {
            ae.printStackTrace();
        }
        return vo;
    }

    @Override
    public String getKey() {
        User user = ShiroFunc.getUser();
        if (user == null) {
            return null;
        }
        return user.getId() + "_" + ApiServiceImpl.passwordMD5(user.getPassword());
    }
}

