/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.pluginManage.controller;

import com.xnx3.j2ee.Func;
import com.xnx3.j2ee.controller.BaseController;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.shiro.ShiroFunc;
import com.xnx3.j2ee.util.SystemUtil;

public class BasePluginController
extends BaseController {
    public boolean isAuthorityBySpecific(String authority, String roleId) {
        return Func.isAuthorityBySpecific(authority, roleId);
    }

    public boolean isAuthorityBySpecific(String authority, int roleId) {
        return this.isAuthorityBySpecific(authority, roleId + "");
    }

    public boolean haveAuthority(int roleId) {
        User user = this.getUser();
        if (user == null) {
            return false;
        }
        return this.isAuthorityBySpecific(user.getAuthority(), roleId);
    }

    public static boolean haveSuperAdminAuth() {
        User user = ShiroFunc.getUser();
        if (user == null) {
            return false;
        }
        return Func.isAuthorityBySpecific(user.getAuthority(), SystemUtil.get("ROLE_SUPERADMIN_ID"));
    }

    public static boolean haveSiteAuth() {
        User user = ShiroFunc.getUser();
        if (user == null) {
            return false;
        }
        return Func.isAuthorityBySpecific(user.getAuthority(), SystemUtil.get("ROLE_USER_ID"));
    }

    public static boolean haveAgencyAuth() {
        User user = ShiroFunc.getUser();
        if (user == null) {
            return false;
        }
        return Func.isAuthorityBySpecific(user.getAuthority(), SystemUtil.get("AGENCY_ROLE"));
    }

    public static boolean haveUser() {
        User user = ShiroFunc.getUser();
        return user != null;
    }
}

