/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.pluginManage;

import com.xnx3.ScanClassUtil;
import com.xnx3.j2ee.pluginManage.PluginRegister;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.PluginUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluginManage {
    public static Map<String, PluginRegister> cmsSiteClassManage = new HashMap<String, PluginRegister>();
    public static Map<String, PluginRegister> agencyClassManage = new HashMap<String, PluginRegister>();
    public static Map<String, PluginRegister> superAdminClassManage = new HashMap<String, PluginRegister>();

    public static void main(String[] args) {
        try {
            PluginManage.scanPluginClass();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void scanPluginClass() throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        ConsoleUtil.info("PluginManage Scan Plugin ...");
        List<Class<?>> classList = ScanClassUtil.getClassSearchAnnotationsName(ScanClassUtil.getClasses("com.xnx3.wangmarket"), "PluginRegister");
        for (Class<?> clazz : classList) {
            final String pluginId = PluginUtil.getPluginId(clazz.getName());
            Annotation[] ans = clazz.getAnnotations();
            for (int i = 0; i < ans.length; ++i) {
                Annotation an = ans[i];
                String anClassName = an.annotationType().getName();
                if (!anClassName.equalsIgnoreCase("com.xnx3.j2ee.pluginManage.PluginRegister")) continue;
                Method[] pluginRegisterMethods = PluginRegister.class.getDeclaredMethods();
                HashMap<String, String> methodMap = new HashMap<String, String>();
                for (Method m : pluginRegisterMethods) {
                    methodMap.put(m.getName(), "");
                }
                Method[] methods = an.getClass().getDeclaredMethods();
                final HashMap<String, Object> map = new HashMap<String, Object>();
                for (Method m : methods) {
                    String name = m.getName();
                    if (methodMap.get(name) == null) continue;
                    Object value = m.invoke((Object)an, null);
                    map.put(name, value);
                }
                PluginRegister plugin = new PluginRegister(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return null;
                    }

                    @Override
                    public String versionMin() {
                        return map.get("versionMin").toString();
                    }

                    @Override
                    public String versionCheckUrl() {
                        return map.get("versionCheckUrl").toString();
                    }

                    @Override
                    public String version() {
                        return map.get("version").toString();
                    }

                    @Override
                    public String menuTitle() {
                        return map.get("menuTitle").toString();
                    }

                    @Override
                    public String menuHref() {
                        return map.get("menuHref").toString();
                    }

                    @Override
                    public String intro() {
                        return map.get("intro").toString();
                    }

                    @Override
                    public String id() {
                        return pluginId;
                    }

                    @Override
                    public String detailUrl() {
                        return map.get("detailUrl").toString();
                    }

                    @Override
                    public boolean applyToSuperAdmin() {
                        return map.get("applyToSuperAdmin").toString().equalsIgnoreCase("true");
                    }

                    @Override
                    public boolean applyToCMS() {
                        return map.get("applyToCMS").toString().equalsIgnoreCase("true");
                    }

                    @Override
                    public boolean applyToAgency() {
                        return map.get("applyToAgency").toString().equalsIgnoreCase("true");
                    }
                };
                PluginManage.registerPlugin(plugin, pluginId);
                ConsoleUtil.info("\u6ce8\u518c\u63d2\u4ef6\uff1a" + clazz.getName());
            }
        }
        if (ScanClassUtil.classExist("com.xnx3.wangmarket.admin.pluginManage.PluginManage")) {
            try {
                Class<?> c = Class.forName("com.xnx3.wangmarket.admin.pluginManage.PluginManage");
                Object invoke = c.newInstance();
                Method m = c.getMethod("scanPluginClass", new Class[0]);
                m.invoke(invoke, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void removePluginCache(String pluginId) {
        if (pluginId == null || pluginId.length() == 0) {
            return;
        }
        if (cmsSiteClassManage.get(pluginId) != null) {
            cmsSiteClassManage.remove(pluginId);
        }
        if (agencyClassManage.get(pluginId) != null) {
            agencyClassManage.remove(pluginId);
        }
        if (superAdminClassManage.get(pluginId) != null) {
            superAdminClassManage.remove(pluginId);
        }
    }

    public static boolean registerPlugin(Class c) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        PluginRegister plugin = c.getAnnotation(PluginRegister.class);
        String pluginId = PluginUtil.getPluginId(c.getName());
        return PluginManage.registerPlugin(plugin, pluginId);
    }

    public static boolean registerPlugin(PluginRegister plugin, String pluginId) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        if (plugin == null) {
            return false;
        }
        if (pluginId == null || pluginId.length() == 0) {
            return false;
        }
        if (plugin.id() == null || plugin.id().length() <= 0) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(plugin);
            try {
                Field value = invocationHandler.getClass().getDeclaredField("memberValues");
                value.setAccessible(true);
                Map memberValues = (Map)value.get(invocationHandler);
                memberValues.put("id", pluginId);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (plugin != null) {
            if (plugin.applyToCMS()) {
                cmsSiteClassManage.put(plugin.id(), plugin);
            }
            if (plugin.applyToAgency()) {
                agencyClassManage.put(plugin.id(), plugin);
            }
            if (plugin.applyToSuperAdmin()) {
                superAdminClassManage.put(plugin.id(), plugin);
            }
        }
        return true;
    }

    public static Map<String, PluginRegister> getAllInstallPlugin() {
        HashMap<String, PluginRegister> pluginMap = new HashMap<String, PluginRegister>();
        for (Map.Entry<String, PluginRegister> entry : superAdminClassManage.entrySet()) {
            pluginMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, PluginRegister> entry : agencyClassManage.entrySet()) {
            pluginMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, PluginRegister> entry : cmsSiteClassManage.entrySet()) {
            pluginMap.put(entry.getKey(), entry.getValue());
        }
        return pluginMap;
    }
}

