/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.init;

import com.xnx3.ConfigManagerUtil;
import com.xnx3.j2ee.Global;
import com.xnx3.j2ee.generateCache.Role;
import com.xnx3.j2ee.generateCache.SmsLog;
import com.xnx3.j2ee.generateCache.User;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.net.OSSUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class InitApplication
implements CommandLineRunner {
    @Resource
    private SqlService sqlService;
    @Value(value="${spring.datasource.driver-class-name}")
    private String databaseSourceDriverClassName;

    public void run(String ... args) throws Exception {
        block7: {
            ConsoleUtil.debug("\u9879\u76ee\u542f\u52a8\u540e\u5f00\u542f\u81ea\u52a8\u521d\u59cb\u5316\u7f13\u5b58\u6570\u636e\u52a0\u8f7d.");
            boolean checkDb = ConfigManagerUtil.getSingleton((String)"systemConfig.xml").getValue("startAutoCheck.db").equals("true");
            try {
                if (checkDb) {
                    this.checkDb();
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                if (!checkDb) break block7;
                ConsoleUtil.info("\u68c0\u6d4b\u5230spring\u4e2d\u6ca1\u6709sqlService\u8fd9\u4e2abean\uff0c\u4e5f\u5c31\u662f\u5f53\u524d\u9879\u76ee\u672a\u4f7f\u7528\u6570\u636e\u5e93\uff01\u6570\u636e\u5e93\u81ea\u52a8\u68c0\u6d4b\u7565\u8fc7");
            }
        }
        try {
            new SmsLog();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            new User();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void checkDb() {
        boolean useDB = false;
        if (this.databaseSourceDriverClassName.equals("org.sqlite.JDBC")) {
            ConsoleUtil.info("Using the database : Sqlite");
            useDB = true;
        } else {
            ConsoleUtil.info("Using the database : Mysql");
            List<Map<String, Object>> map = this.sqlService.findMapBySqlQuery("SHOW TABLES LIKE '%system%'");
            if (map.size() > 0) {
                useDB = true;
            }
        }
        if (useDB) {
            this.readSystemTable();
            try {
                new Role().role(this.sqlService);
            }
            catch (Throwable e) {
                ConsoleUtil.debug("\u6743\u9650\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage() + "\uff0c\u5982\u679c\u60a8\u5f53\u524d\u9879\u76ee\u4f7f\u7528\u4e0d\u5230\u6743\u9650\u7f16\u8f91\u64cd\u4f5c\uff0c\u6b64\u9879\u5ffd\u7565\u5373\u53ef");
            }
        } else {
            Global.databaseCreateFinish = false;
            Global.databaseCreateFinish_explain = "\u6570\u636e\u5e93\u5f02\u5e38\uff1a\u8bf7\u5c06\u6570\u636e\u5e93\u4e2d\u7684\u521d\u59cb\u6570\u636e\u5bfc\u5165\uff0c\u6570\u636e\u6587\u4ef6\u5730\u5740  https://github.com/xnx3/iw/blob/master/iw.sql";
            ConsoleUtil.debug(Global.databaseCreateFinish_explain);
        }
    }

    public void readSystemTable() {
        Global.system.clear();
        ConsoleUtil.debug("\u5f00\u59cb\u88c5\u8f7dSystem\u6570\u636e\u8868\u4fe1\u606f");
        List<Map<String, Object>> list = this.sqlService.findMapBySqlQuery("SELECT name,value FROM system");
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            String name = map.get("name").toString();
            String value = map.get("value") != null ? map.get("value").toString() : "";
            Global.system.put(name, value);
            ConsoleUtil.debug(name + "=" + value);
        }
        ConsoleUtil.info("system \u8868\u6570\u636e\u8f7d\u5165\u5185\u5b58\u5b8c\u6bd5\uff0c\u5171" + list.size() + "\u6761\u6570\u636e");
    }

    public void initOssConfig() {
        ConsoleUtil.info("initOssConfig start...");
        try {
            new OSSUtil();
        }
        catch (Exception exception) {
            // empty catch block
        }
        OSSUtil.accessKeyId = SystemUtil.get("ALIYUN_ACCESSKEYID");
        OSSUtil.accessKeySecret = SystemUtil.get("ALIYUN_ACCESSKEYSECRET");
        OSSUtil.bucketName = SystemUtil.get("ALIYUN_OSS_BUCKETNAME");
        OSSUtil.endpoint = SystemUtil.get("ALIYUN_OSS_ENDPOINT");
        OSSUtil.url = AttachmentUtil.netUrl();
        boolean checkOss = ConfigManagerUtil.getSingleton((String)"systemConfig.xml").getValue("startAutoCheck.oss").equals("true");
        if (!checkOss) {
            return;
        }
        if (OSSUtil.accessKeyId == null || OSSUtil.accessKeySecret.length() < 10) {
            ConsoleUtil.info("OSS\u5bf9\u8c61\u5b58\u50a8\u521d\u59cb\u5316\u65f6\uff0caccessKeyId \u6216 accessKeyId \u65e0\u6709\u6548\u503c\uff08\u5b57\u7b26\u5c0f\u4e8e10\uff09");
            return;
        }
        ConsoleUtil.info("initOssConfig finish.");
    }
}

