/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.dao;

import com.xnx3.Lang;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.func.ApplicationProperties;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.Sql;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.Table;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Repository
@Order(value=1)
public class SqlDAO {
    public static boolean showsql = false;
    @PersistenceContext
    EntityManager entityManager;

    public SqlDAO() {
        ConsoleUtil.info("Spring Scan : SqlDAO");
    }

    public int count(String tableName, String where) {
        if (where == null) {
            where = "";
        }
        String queryString = "SELECT count(*) FROM " + tableName + " " + where;
        long startTime = showsql ? SqlDAO.time() : 0L;
        Query query = this.entityManager.createNativeQuery(queryString);
        List list = query.getResultList();
        SqlDAO.printShowsql(startTime, queryString);
        this.entityManager.close();
        String count = list.get(0).toString();
        return Lang.stringToInt((String)count, (int)0);
    }

    public List<Map<String, Object>> findMapBySql(Sql sql) {
        return this.findMapBySqlQuery(sql.getSql());
    }

    public List<Map<String, Object>> findMapBySqlQuery(String sqlQuery) {
        long startTime = showsql ? SqlDAO.time() : 0L;
        Query query = this.entityManager.createNativeQuery(sqlQuery);
        ((org.hibernate.query.Query)query.unwrap(org.hibernate.query.Query.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        SqlDAO.printShowsql(startTime, sqlQuery);
        this.entityManager.close();
        return list;
    }

    public <E> List<E> findBySqlQuery(String sqlQuery, Class<E> entityClass) {
        long startTime = showsql ? SqlDAO.time() : 0L;
        Query query = this.entityManager.createNativeQuery(sqlQuery, entityClass);
        List list = query.getResultList();
        SqlDAO.printShowsql(startTime, sqlQuery);
        this.entityManager.close();
        return list;
    }

    public <E> E findAloneBySqlQuery(String sqlQuery, Class<E> entityClass) {
        List<E> list;
        if (sqlQuery.toUpperCase().indexOf(" LIMIT ") == -1) {
            sqlQuery = sqlQuery + " LIMIT 0,1";
        }
        if ((list = this.findBySqlQuery(sqlQuery, entityClass)).size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public void save(Object entity) {
        long startTime = showsql ? SqlDAO.time() : 0L;
        this.entityManager.persist(entity);
        SqlDAO.printShowsql(startTime, "\u6839\u636e\u5b9e\u4f53\u7c7b [" + entity.getClass().getSimpleName() + "] \u6267\u884csave\u64cd\u4f5c");
    }

    public void delete(Object entity) {
        long startTime = showsql ? SqlDAO.time() : 0L;
        this.entityManager.remove(this.entityManager.merge(entity));
        SqlDAO.printShowsql(startTime, "\u6839\u636e\u5b9e\u4f53\u7c7b [" + entity.getClass().getSimpleName() + "]\u6267\u884cdelete\u64cd\u4f5c");
    }

    public <E> E findById(Class<E> c, Object id) {
        long startTime = showsql ? SqlDAO.time() : 0L;
        Object e = this.entityManager.find(c, id);
        SqlDAO.printShowsql(startTime, "\u6839\u636e\u5b9e\u4f53\u7c7b [" + c.getSimpleName() + "] \uff0c\u901a\u8fc7\u5176id\u4e3b\u952e (" + id + ") \u83b7\u53d6\u8fd9\u6761\u6570\u636e");
        return (E)e;
    }

    public <E> E findById(Class<E> c, int id) {
        long startTime = showsql ? SqlDAO.time() : 0L;
        Object e = this.entityManager.find(c, (Object)id);
        SqlDAO.printShowsql(startTime, "\u6839\u636e\u5b9e\u4f53\u7c7b [" + c.getSimpleName() + "] \uff0c\u901a\u8fc7\u5176id\u4e3b\u952e (" + id + ") \u83b7\u53d6\u8fd9\u6761\u6570\u636e");
        return (E)e;
    }

    public <E> List<E> findByProperty(Class<E> c, String propertyName, Object value) {
        String hql = "FROM " + c.getSimpleName() + " c WHERE c." + propertyName + " = :c1";
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("c1", value);
        return this.findByHql(hql, parameterMap, 0);
    }

    public <E> E findAloneByProperty(Class<E> c, String propertyName, Object value) {
        String hql = "FROM " + c.getSimpleName() + " c WHERE c." + propertyName + " = :c1";
        long startTime = showsql ? SqlDAO.time() : 0L;
        Query query = this.entityManager.createQuery(hql);
        query.setParameter("c1", value);
        query.setMaxResults(1);
        List list = query.getResultList();
        SqlDAO.printShowsql(startTime, "\u6839\u636e\u5b9e\u4f53\u7c7b [" + c.getSimpleName() + "] \uff0c\u901a\u8fc7\u5176\u6307\u5b9a\u5b57\u6bb5 (" + propertyName + " = " + value + ") \u83b7\u53d6\u4e00\u6761\u6570\u636e (findAloneByProperty\u65b9\u6cd5\u4ea7\u751f)");
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public int executeSql(String sql) {
        long startTime = showsql ? SqlDAO.time() : 0L;
        Query query = this.entityManager.createNativeQuery(sql);
        int result = query.executeUpdate();
        SqlDAO.printShowsql(startTime, sql);
        return result;
    }

    public void addOne(String tableName, String fieldName, String where) {
        this.executeSql("UPDATE " + tableName + " SET " + fieldName + " = " + fieldName + "+1 WHERE " + where);
    }

    public void subtractOne(String tableName, String fieldName, String where) {
        this.executeSql("UPDATE " + tableName + " SET " + fieldName + " = " + fieldName + "-1 WHERE " + where);
    }

    public <E> List<E> findAll(Class<E> entityClass) {
        return this.findBySqlQuery("SELECT * FROM " + SqlDAO.getDatabaseTableName(entityClass), entityClass);
    }

    public static SqlDAO getFromApplicationContext(ApplicationContext ctx) {
        return (SqlDAO)ctx.getBean("SqlDAO");
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public List findByHql(String hql, Map<String, Object> parameterMap, int maxNumber) {
        long startTime = showsql ? SqlDAO.time() : 0L;
        Query query = this.entityManager.createQuery(hql);
        for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        if (maxNumber > 0) {
            query.setMaxResults(maxNumber);
        }
        List list = query.getResultList();
        SqlDAO.printShowsql(startTime, hql + "\t(HQL\u8bed\u53e5,findByHql\u4ea7\u751f)");
        this.entityManager.close();
        return list;
    }

    public int executeByHql(String hql, Map<String, Object> parameterMap) {
        long startTime = showsql ? SqlDAO.time() : 0L;
        Query query = this.entityManager.createQuery(hql);
        for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        int result = query.executeUpdate();
        SqlDAO.printShowsql(startTime, hql + "\t(HQL\u8bed\u53e5,executeByHql\u4ea7\u751f)");
        return result;
    }

    public int updateByHql(Class c, String setPropertyName, String setPropertyValue, String wherePropertyName, Object wherePropertyValue) {
        String hql = "update " + c.getSimpleName() + " c set c." + setPropertyName + "= :c1 WHERE c." + wherePropertyName + " = :c2";
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("c1", setPropertyValue);
        parameterMap.put("c2", wherePropertyValue);
        return this.executeByHql(hql, parameterMap);
    }

    public static String getDatabaseTableName(Class c) {
        Table table = c.getAnnotation(Table.class);
        String tableName = null;
        tableName = table != null && table.name() != null && table.name().length() > 0 ? table.name() : StringUtil.firstCharToLowerCase((String)c.getSimpleName());
        return tableName;
    }

    public static void printShowsql(long startTime, String sql) {
        if (showsql) {
            long time = SqlDAO.time() - startTime;
            System.out.println("[" + time + "ms]\t" + sql + "\t -- wm.showsql");
        }
    }

    public static long time() {
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        return date.getTime();
    }

    static {
        String sq = ApplicationProperties.getProperty("wm.showsql");
        if (sq != null && sq.equalsIgnoreCase("true")) {
            showsql = true;
            ConsoleUtil.info("\u5df2\u5f00\u542f wm.database.showsql \u68c0\u6d4b\uff0c\u6267\u884c\u7684sql\u5c06\u5728\u63a7\u5236\u53f0\u8f93\u51fa\u5e76\u8bb0\u5f55\u6267\u884c\u65f6\u95f4");
        }
    }
}

