/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.controller.admin;

import com.xnx3.j2ee.controller.BaseController;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.service.UserService;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.BaseVO;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="WMUserAdminController")
@RequestMapping(value={"/admin/user"})
public class UserAdminController
extends BaseController {
    @Resource
    private UserService userService;
    @Resource
    private SqlService sqlService;

    @RequiresPermissions(value={"adminUserDelete"})
    @RequestMapping(value={"deleteUser${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO deleteUser(HttpServletRequest request, @RequestParam(value="id", required=true) int id) {
        User u;
        if (id > 0 && (u = this.sqlService.findById(User.class, id)) != null) {
            this.sqlService.delete(u);
            ActionLogUtil.insertUpdateDatabase(request, u.getId(), "\u603b\u7ba1\u7406\u540e\u53f0,\u5220\u9664\u7528\u6237", u.toString());
            return this.success();
        }
        return this.error("\u5220\u9664\u5931\u8d25");
    }

    @RequiresPermissions(value={"adminUserList"})
    @RequestMapping(value={"list${url.suffix}"})
    public String list(HttpServletRequest request, Model model) {
        Sql sql = new Sql(request);
        sql.setSearchColumn(new String[]{"username", "email", "nickname", "authority", "referrerid", "phone", "id=", "regtime(date:yyyy-MM-dd hh:mm:ss)>"});
        int count = this.sqlService.count("user", sql.getWhere());
        Page page = new Page(count, SystemUtil.getInt("LIST_EVERYPAGE_NUMBER"), request);
        sql.setSelectFromAndPage("SELECT * FROM user", page);
        sql.setDefaultOrderBy("user.id DESC");
        sql.setOrderByField(new String[]{"id", "lasttime", "money", "currency"});
        List<User> list = this.sqlService.findBySql(sql, User.class);
        ActionLogUtil.insert(request, "\u603b\u7ba1\u7406\u540e\u53f0-\u7528\u6237\u5217\u8868", "\u7b2c" + page.getCurrentPageNumber() + "\u9875");
        model.addAttribute("page", (Object)page);
        model.addAttribute("list", list);
        return "/wm/admin/user/list";
    }

    @RequiresPermissions(value={"adminUserView"})
    @RequestMapping(value={"view${url.suffix}"})
    public String view(HttpServletRequest request, @RequestParam(value="id", required=true) int id, Model model) {
        User user = this.sqlService.findById(User.class, id);
        if (user == null) {
            return this.error(model, "\u8981\u67e5\u770b\u7684\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (user.getReferrerid() == null || user.getReferrerid() - 0 == 0) {
            model.addAttribute("referrer", (Object)"\u65e0\u9080\u8bf7\u4eba");
        } else {
            User parentUser = this.sqlService.findById(User.class, user.getReferrerid());
            model.addAttribute("referrer", (Object)("<a href='view.do?id=" + user.getReferrerid() + "'>id:" + user.getReferrerid() + "," + parentUser.getUsername() + "</a>"));
        }
        ActionLogUtil.insert(request, user.getId(), "\u603b\u7ba1\u7406\u540e\u53f0-\u7528\u6237\u8be6\u60c5", user.toString());
        model.addAttribute("u", (Object)user);
        return "/wm/admin/user/view";
    }

    @RequiresPermissions(value={"adminUserUpdateFreeze"})
    @RequestMapping(value={"updateFreeze${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO updateFreeze(HttpServletRequest request, @RequestParam(value="id", required=true) int id, @RequestParam(value="isfreeze", required=true) int isfreeze, Model model) {
        BaseVO baseVO = new BaseVO();
        if (isfreeze == User.ISFREEZE_FREEZE) {
            baseVO = this.userService.freezeUser(id);
            ActionLogUtil.insertUpdateDatabase(request, id, "\u603b\u7ba1\u7406\u540e\u53f0-\u51bb\u7ed3\u7528\u6237", baseVO.getInfo());
        } else if (isfreeze == User.ISFREEZE_NORMAL) {
            baseVO = this.userService.unfreezeUser(id);
            ActionLogUtil.insertUpdateDatabase(request, id, "\u603b\u7ba1\u7406\u540e\u53f0-\u89e3\u9664\u51bb\u7ed3\u7528\u6237", baseVO.getInfo());
        } else {
            baseVO.setBaseVO(0, "\u672a\u77e5\u53c2\u6570\uff01");
            ActionLogUtil.insertError(request, "\u6b64\u63a5\u53e3\u8981\u4e48\u51bb\u7ed3\uff0c\u8981\u4e48\u89e3\u51bb\uff0c\u51fa\u73b0\u4e86\u975e\u6b63\u5e38\u60c5\u51b5\uff01");
        }
        if (baseVO.getResult() == 1) {
            return this.success("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return this.error("\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"adminUserUpdatePassword"})
    @RequestMapping(value={"updatePassword${url.suffix}"})
    public String updatePassword(HttpServletRequest request) {
        ActionLogUtil.insert(request, "\u6253\u5f00\u4fee\u6539\u5bc6\u7801\u9875\u9762");
        return "/wm/admin/user/updatePassword";
    }

    @ResponseBody
    @RequiresPermissions(value={"adminUserUpdatePassword"})
    @RequestMapping(value={"updatePassword.json"}, method={RequestMethod.POST})
    public BaseVO updatePassword(HttpServletRequest request, String oldPassword, String newPassword, Model model) {
        if (oldPassword == null) {
            ActionLogUtil.insert(request, "\u4fee\u6539\u5bc6\u7801", "\u5931\u8d25\uff1a\u672a\u8f93\u5165\u5bc6\u7801");
            return this.error("\u8bf7\u8f93\u5165\u65e7\u5bc6\u7801");
        }
        User uu = this.sqlService.findById(User.class, this.getUser().getId());
        if (new Md5Hash((Object)oldPassword, (Object)uu.getSalt(), 2).toString().equals(uu.getPassword())) {
            BaseVO vo = this.userService.updatePassword(this.getUserId(), newPassword);
            if (vo.getResult() - 1 == 0) {
                ActionLogUtil.insertUpdateDatabase(request, "\u4fee\u6539\u5bc6\u7801", "\u6210\u529f");
                return this.success("\u4fee\u6539\u6210\u529f");
            }
            ActionLogUtil.insert(request, "\u4fee\u6539\u5bc6\u7801", "\u5931\u8d25\uff1a" + vo.getInfo());
            return this.error(vo.getInfo());
        }
        ActionLogUtil.insert(request, "\u4fee\u6539\u5bc6\u7801", "\u5931\u8d25\uff1a\u539f\u5bc6\u7801\u9519\u8bef");
        return this.error("\u539f\u5bc6\u7801\u9519\u8bef\uff01");
    }
}

