/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.controller.admin;

import com.xnx3.DateUtil;
import com.xnx3.j2ee.controller.BaseController;
import com.xnx3.j2ee.entity.System;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.service.SystemService;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.j2ee.vo.BaseVO;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="WMSystemAdminController")
@RequestMapping(value={"/admin/system"})
public class SystemAdminController
extends BaseController {
    @Resource
    private SqlService sqlService;
    @Resource
    private SystemService systemService;

    @RequiresPermissions(value={"adminSystemVariable"})
    @RequestMapping(value={"variableList${url.suffix}"})
    public String variableList(HttpServletRequest request, Model model) {
        Sql sql = new Sql(request);
        sql.setSearchColumn(new String[]{"name", "description"});
        int count = this.sqlService.count("system", sql.getWhere());
        Page page = new Page(count, 1000, request);
        sql.setSelectFromAndPage("SELECT * FROM system", page);
        sql.setDefaultOrderBy("id DESC");
        sql.setOrderByField(new String[]{"id", "lasttime", "name"});
        List<System> systemList = this.sqlService.findBySql(sql, System.class);
        ActionLogUtil.insert(request, "\u7cfb\u7edf\u53d8\u91cf\u5217\u8868");
        model.addAttribute("page", (Object)page);
        model.addAttribute("systemList", systemList);
        return "/wm/admin/system/variableList";
    }

    @RequiresPermissions(value={"adminSystemVariable"})
    @RequestMapping(value={"variable${url.suffix}"})
    public String variable(@RequestParam(value="name", required=false, defaultValue="") String name, Model model, HttpServletRequest request) {
        System system;
        if (name.length() == 0) {
            system = new System();
            ActionLogUtil.insert(request, "\u8fdb\u5165\u65b0\u589e\u7cfb\u7edf\u53d8\u91cf\u9875\u9762");
        } else {
            system = this.sqlService.findAloneByProperty(System.class, "name", name);
            if (system == null) {
                system = new System();
                system.setName(name);
                ActionLogUtil.insert(request, "\u8fdb\u5165\u4fee\u6539\u7cfb\u7edf\u53d8\u91cf\u9875\u9762,\u65b0\u589e\u53d8\u91cf", system.getName());
            } else {
                ActionLogUtil.insert(request, "\u8fdb\u5165\u4fee\u6539\u7cfb\u7edf\u53d8\u91cf\u9875\u9762,\u4fee\u6539\u53d8\u91cf", system.getName());
            }
        }
        model.addAttribute("system", (Object)system);
        return "/wm/admin/system/variable";
    }

    @RequiresPermissions(value={"adminSystemVariable"})
    @RequestMapping(value={"variableSave${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO variableSave(System sys, Model model, HttpServletRequest request) {
        System system = this.sqlService.findAloneByProperty(System.class, "name", sys.getName());
        if (system == null) {
            system = new System();
            system.setName(sys.getName());
        }
        system.setDescription(sys.getDescription());
        system.setLasttime(DateUtil.timeForUnix10());
        system.setValue(sys.getValue());
        this.sqlService.save(system);
        this.systemService.refreshSystemCache();
        ActionLogUtil.insertUpdateDatabase(request, system.getId(), "\u4fdd\u5b58\u7cfb\u7edf\u53d8\u91cf", system.getName() + "=" + system.getValue());
        return this.success();
    }

    @RequiresPermissions(value={"adminSystemDeleteVariable"})
    @RequestMapping(value={"deleteVariable${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO deleteVariable(@RequestParam(value="id", required=false, defaultValue="0") int id, HttpServletRequest request) {
        System system = this.sqlService.findById(System.class, id);
        if (system == null) {
            return this.error("\u8981\u5220\u9664\u7684\u53d8\u91cf\u4e0d\u5b58\u5728");
        }
        this.sqlService.delete(system);
        this.systemService.refreshSystemCache();
        ActionLogUtil.insertUpdateDatabase(request, system.getId(), "\u5220\u9664\u7cfb\u7edf\u53d8\u91cf", system.getName() + "=" + system.getValue());
        return this.success();
    }
}

