/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.controller.admin;

import com.xnx3.j2ee.bean.PermissionTree;
import com.xnx3.j2ee.bean.RoleMark;
import com.xnx3.j2ee.entity.Permission;
import com.xnx3.j2ee.entity.Role;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.service.RoleService;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.service.UserService;
import com.xnx3.j2ee.shiro.ShiroFunc;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.wm.controller.BaseController;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="WMRoleAdminController")
@RequestMapping(value={"/admin/role"})
public class RoleAdminController
extends BaseController {
    @Resource
    private RoleService roleService;
    @Resource
    private UserService userService;
    @Resource
    private SqlService sqlService;

    @RequestMapping(value={"role${url.suffix}"})
    @RequiresPermissions(value={"adminRoleRole"})
    public String role(@RequestParam(value="id", required=true) int id, Model model, HttpServletRequest request) {
        if (id > 0) {
            Role role = this.sqlService.findById(Role.class, id);
            if (role != null) {
                ActionLogUtil.insert(request, role.getId(), "\u8fdb\u5165\u7f16\u8f91\u89d2\u8272\u9875\u9762", role.getName() + "\uff0c" + role.getDescription());
                model.addAttribute("role", (Object)role);
            }
        } else {
            ActionLogUtil.insert(request, "\u8fdb\u5165\u6dfb\u52a0\u89d2\u8272\u9875\u9762");
        }
        return "wm/admin/role/role";
    }

    @RequestMapping(value={"saveRole${url.suffix}"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"adminRoleRole"})
    @ResponseBody
    public BaseVO saveRole(Role role, Model model, HttpServletRequest request) {
        if (role.getId() != null && role.getId() > 0) {
            Role editrole = this.sqlService.findById(Role.class, role.getId());
            editrole.setName(role.getName());
            editrole.setDescription(role.getDescription());
            this.sqlService.save(editrole);
        } else {
            this.sqlService.save(role);
        }
        ActionLogUtil.insertUpdateDatabase(request, role.getId(), "\u89d2\u8272\u4fdd\u5b58", role.getName() + "\uff0c" + role.getDescription());
        return this.success();
    }

    @RequestMapping(value={"deleteRole${url.suffix}"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"adminRoleDeleteRole"})
    @ResponseBody
    public BaseVO deleteRole(@RequestParam(value="id", required=true) int id, Model model, HttpServletRequest request) {
        Role role;
        if (id > 0 && (role = this.sqlService.findById(Role.class, id)) != null) {
            this.sqlService.delete(role);
            ActionLogUtil.insertUpdateDatabase(request, role.getId(), "\u5220\u9664\u89d2\u8272", role.getName() + "\uff0c" + role.getDescription());
            return this.success();
        }
        return this.error("\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"roleList${url.suffix}"})
    @RequiresPermissions(value={"adminRoleRoleList"})
    public String roleList(Model model, HttpServletRequest request) {
        List<Role> list = this.sqlService.findAll(Role.class);
        ActionLogUtil.insert(request, "\u89d2\u8272\u5217\u8868");
        model.addAttribute("list", list);
        return "wm/admin/role/roleList";
    }

    @RequiresPermissions(value={"adminRolePermission"})
    @RequestMapping(value={"addPermission${url.suffix}"})
    public String addPermission(@RequestParam(value="parentId", required=true) int parentId, Model model, HttpServletRequest request) {
        Permission parentPermission = this.sqlService.findById(Permission.class, parentId);
        String parentPermissionDescription = "\u9876\u7ea7";
        if (parentPermission != null) {
            parentPermissionDescription = parentPermission.getName() + "," + parentPermission.getDescription();
        }
        Permission permission = new Permission();
        permission.setParentId(parentId);
        ActionLogUtil.insert(request, parentId, "\u8fdb\u5165\u6dfb\u52a0\u8d44\u6e90Permission\u9875\u9762", "\u6240\u5c5e\u4e0a\u7ea7\uff1a" + parentPermissionDescription);
        model.addAttribute("permission", (Object)permission);
        model.addAttribute("parentPermissionDescription", (Object)parentPermissionDescription);
        return "wm/admin/role/permission";
    }

    @RequiresPermissions(value={"adminRolePermission"})
    @RequestMapping(value={"editPermission${url.suffix}"})
    public String editPermission(@RequestParam(value="id", required=true) int id, Model model, HttpServletRequest request) {
        Permission permission;
        if (id > 0 && (permission = this.sqlService.findById(Permission.class, id)) != null) {
            String parentPermissionDescription = "\u9876\u7ea7";
            if (permission.getParentId() > 0) {
                Permission parentPermission = this.sqlService.findById(Permission.class, permission.getParentId());
                parentPermissionDescription = parentPermission.getName() + "," + parentPermission.getDescription();
            }
            ActionLogUtil.insert(request, permission.getId(), "\u8fdb\u5165\u4fee\u6539\u8d44\u6e90Permission\u9875\u9762", "\u6240\u5c5e\u4e0a\u7ea7\uff1a" + parentPermissionDescription);
            model.addAttribute("permission", (Object)permission);
            model.addAttribute("parentPermissionDescription", (Object)parentPermissionDescription);
            return "wm/admin/role/permission";
        }
        return this.error(model, "\u51fa\u9519\uff0c\u53c2\u6570\u9519\u8bef");
    }

    @RequiresPermissions(value={"adminRolePermission"})
    @RequestMapping(value={"savePermission${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO savePermission(Permission permissionInput, Model model, HttpServletRequest request) {
        Permission permission;
        if (permissionInput.getId() != null && permissionInput.getId() > 0) {
            permission = this.sqlService.findById(Permission.class, permissionInput.getId());
            if (permission == null) {
                return this.error("\u4fee\u6539\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
            }
        } else {
            permission = new Permission();
        }
        permission.setDescription(permissionInput.getDescription());
        permission.setName(permissionInput.getName());
        permission.setParentId(permissionInput.getParentId());
        permission.setPercode(permissionInput.getPercode());
        permission.setUrl(permissionInput.getUrl());
        permission.setIcon(permissionInput.getIcon() + "");
        this.sqlService.save(permission);
        ActionLogUtil.insertUpdateDatabase(request, permission.getId(), "\u8d44\u6e90Permission\u4fdd\u5b58", permission.getName() + "\uff0c" + permission.getDescription());
        return this.success();
    }

    @RequiresPermissions(value={"adminRoleDeletePermission"})
    @RequestMapping(value={"deletePermission${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO deletePermission(@RequestParam(value="id", required=true) int id, HttpServletRequest request) {
        Permission permission;
        if (id > 0 && (permission = this.sqlService.findById(Permission.class, id)) != null) {
            this.sqlService.delete(permission);
            ActionLogUtil.insertUpdateDatabase(request, permission.getId(), "\u5220\u9664\u8d44\u6e90Permission", permission.getName() + "\uff0c" + permission.getDescription());
            return this.success();
        }
        return this.error("\u5220\u9664\u5931\u8d25");
    }

    @RequiresPermissions(value={"adminRolePermissionList"})
    @RequestMapping(value={"permissionList${url.suffix}"})
    public String permissionList(HttpServletRequest request, Model model) {
        Sql sql = new Sql(request);
        sql.setSearchColumn(new String[]{"description", "url", "name", "parent_id", "percode", "menu"});
        int count = this.sqlService.count("permission", sql.getWhere());
        Page page = new Page(count, 1000, request);
        sql.setSelectFromAndPage("SELECT * FROM permission", page);
        sql.setDefaultOrderBy("permission.rank ASC");
        List<Permission> list = this.sqlService.findBySql(sql, Permission.class);
        List<PermissionTree> permissionTreeList = new ShiroFunc().PermissionToTree(new ArrayList<Permission>(), list);
        ActionLogUtil.insert(request, "\u8d44\u6e90Permission\u5217\u8868", "\u7b2c" + page.getCurrentPageNumber() + "\u9875");
        model.addAttribute("page", (Object)page);
        model.addAttribute("list", permissionTreeList);
        return "wm/admin/role/permissionList";
    }

    @RequiresPermissions(value={"adminRoleEditRolePermission"})
    @RequestMapping(value={"editRolePermission${url.suffix}"})
    public String editRolePermission(@RequestParam(value="roleId", required=true) int roleId, Model model, HttpServletRequest request) {
        if (roleId > 0) {
            List<Permission> myList = this.roleService.findPermissionByRoleId(roleId);
            List<Permission> allList = this.sqlService.findAll(Permission.class);
            List<PermissionTree> list = new ShiroFunc().PermissionToTree(myList, allList);
            Role role = this.sqlService.findById(Role.class, roleId);
            ActionLogUtil.insert(request, role.getId(), "\u7f16\u8f91\u67d0\u4e2a\u6743\u9650\u4e0b\u62e5\u6709\u7684\u8d44\u6e90", role.getName());
            model.addAttribute("role", (Object)role);
            model.addAttribute("list", list);
            return "wm/admin/role/rolePermission";
        }
        return null;
    }

    @RequiresPermissions(value={"adminRoleEditRolePermission"})
    @RequestMapping(value={"saveRolePermission${url.suffix}"}, method={RequestMethod.POST})
    public String saveRolePermission(@RequestParam(value="roleId", required=true) int roleId, @RequestParam(value="permission", required=false) String permission, Model model, HttpServletRequest request) {
        BaseVO vo = this.roleService.saveRolePermission(roleId, permission);
        if (vo.getResult() - 1 == 0) {
            ActionLogUtil.insertUpdateDatabase(request, roleId, "\u4fdd\u5b58\u89d2\u8272\u6240\u7ba1\u7406\u7684\u8d44\u6e90");
            return this.success(model, "\u4fdd\u5b58\u6210\u529f", "admin/role/roleList.do");
        }
        return this.error(model, "\u4fdd\u5b58\u5931\u8d25\uff1a" + vo.getInfo());
    }

    @RequiresPermissions(value={"adminRoleEditUserRole"})
    @RequestMapping(value={"editUserRole${url.suffix}"})
    public String editUserRole(@RequestParam(value="userid", required=true) int userid, Model model, HttpServletRequest request) {
        User user = this.sqlService.findById(User.class, userid);
        List<RoleMark> list = this.roleService.getUserRoleMarkList(userid);
        ActionLogUtil.insert(request, "\u7ba1\u7406\u540e\u53f0\uff0c\u7f16\u8f91\u7528\u6237\uff0d\u6743\u9650\u5173\u7cfb");
        model.addAttribute("currentUser", (Object)user);
        model.addAttribute("list", list);
        return "wm/admin/role/userRole";
    }

    @RequiresPermissions(value={"adminRoleEditUserRole"})
    @RequestMapping(value={"saveUserRole${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO saveUserRole(@RequestParam(value="userid", required=true) int userid, @RequestParam(value="role", required=false) String role, Model model, HttpServletRequest request) {
        BaseVO vo = this.roleService.saveUserRole(userid, role);
        if (vo.getResult() - 1 == 0) {
            ActionLogUtil.insertUpdateDatabase(request, "\u4fee\u6539\u7528\u6237\u7684\u89d2\u8272\u6743\u9650");
            return this.success();
        }
        return this.error(vo.getInfo());
    }

    @RequiresPermissions(value={"adminRoleEditPermissionMenu"})
    @RequestMapping(value={"editPermissionMenu${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO editPermissionMenu(@RequestParam(value="permissionid", required=true, defaultValue="0") int permissionid, @RequestParam(value="menu", required=false, defaultValue="0") short menu, Model model, HttpServletRequest request) {
        Permission permission = this.sqlService.findById(Permission.class, permissionid);
        if (permission == null) {
            return this.error("\u8981\u64cd\u4f5c\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
        permission.setMenu((short)(menu - 1 == 0 ? 1 : 0));
        this.sqlService.save(permission);
        ActionLogUtil.insertUpdateDatabase(request, permission.getId(), "\u4fee\u6539\u8d44\u6e90\u662f\u5426\u662f\u83dc\u5355", permission.toString());
        return this.success();
    }

    @RequiresPermissions(value={"adminRoleEditPermissionRank"})
    @RequestMapping(value={"/savePermissionRank${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO savePermissionRank(HttpServletRequest request, @RequestParam(value="permissionid", required=false, defaultValue="0") int permissionid, @RequestParam(value="rank", required=false, defaultValue="0") int rank) {
        Permission permission = this.sqlService.findById(Permission.class, permissionid);
        if (permission == null) {
            return this.error("\u8981\u64cd\u4f5c\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
        permission.setRank(rank);
        this.sqlService.save(permission);
        ActionLogUtil.insertUpdateDatabase(request, permission.getId(), "\u4fdd\u5b58\u6743\u9650\u8d44\u6e90\u7684\u6392\u5e8f", permission.toString());
        return this.success();
    }
}

