/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.j2ee.controller;

import com.xnx3.CacheUtil;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.controller.BaseController;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.service.UserService;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.ApplicationPropertiesUtil;
import com.xnx3.j2ee.util.IpUtil;
import com.xnx3.j2ee.util.SessionUtil;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.j2ee.vo.LoginVO;
import com.xnx3.media.CaptchaUtil;
import java.awt.Font;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="WMLoginController")
@RequestMapping(value={"/"})
public class LoginController
extends BaseController {
    @Resource
    private UserService userService;
    @Resource
    private SqlService sqlService;

    @RequestMapping(value={"/captcha${url.suffix}"})
    public void captcha(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ActionLogUtil.insert(request, "\u83b7\u53d6\u9a8c\u8bc1\u7801\u663e\u793a");
        CaptchaUtil captchaUtil = new CaptchaUtil();
        captchaUtil.setCodeCount(5);
        captchaUtil.setFont(new Font("Fixedsys", 1, 21));
        captchaUtil.setHeight(18);
        captchaUtil.setWidth(110);
        com.xnx3.j2ee.util.CaptchaUtil.showImage(captchaUtil, request, response);
    }

    @RequestMapping(value={"login${url.suffix}"})
    public String login(HttpServletRequest request, Model model) {
        if (this.getUser() != null) {
            ActionLogUtil.insert(request, "\u8fdb\u5165\u767b\u5f55\u9875\u9762", "\u5df2\u7ecf\u767b\u5f55\u6210\u529f\uff0c\u65e0\u9700\u518d\u767b\u5f55\uff0c\u8fdb\u884c\u8df3\u8f6c");
            return this.redirect("admin/index/index.do");
        }
        ActionLogUtil.insert(request, "\u8fdb\u5165\u767b\u5f55\u9875\u9762");
        return "wm/login/login";
    }

    @RequestMapping(value={"loginSubmit${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public LoginVO loginSubmit(HttpServletRequest request, Model model) {
        LoginVO vo = new LoginVO();
        String wmLogin = ApplicationPropertiesUtil.getProperty("wm.login");
        if (wmLogin != null && wmLogin.equalsIgnoreCase("false")) {
            vo.setBaseVO(0, "\u6b64\u63a5\u53e3\u4e0d\u5141\u8bb8\u88ab\u4f7f\u7528\uff01\u60a8\u53ef\u4fee\u6539application.properties\u4e2d\u7684wm.login=true \uff0c\u91cd\u542f\u9879\u76ee\uff0c\u5373\u53ef\u4f7f\u7528\u672c\u63a5\u53e3");
            return vo;
        }
        BaseVO capVO = com.xnx3.j2ee.util.CaptchaUtil.compare(request.getParameter("code"), request);
        if (capVO.getResult() == 0) {
            ActionLogUtil.insert(request, "\u7528\u6237\u540d\u5bc6\u7801\u6a21\u5f0f\u767b\u5f55\u5931\u8d25", "\u9a8c\u8bc1\u7801\u51fa\u9519\uff0c\u63d0\u4ea4\u7684\u9a8c\u8bc1\u7801\uff1a" + StringUtil.filterXss((String)request.getParameter("code")));
            vo.setBaseVO(capVO);
            return vo;
        }
        BaseVO baseVO = this.userService.loginByUsernameAndPassword(request);
        vo.setBaseVO(baseVO);
        if (baseVO.getResult() == 1) {
            ActionLogUtil.insert(request, "\u7528\u6237\u540d\u5bc6\u7801\u6a21\u5f0f\u767b\u5f55\u6210\u529f");
            vo.setInfo("admin/index/index.do");
            HttpSession session = request.getSession();
            vo.setToken(session.getId());
            vo.setUser(this.getUser());
        } else {
            ActionLogUtil.insert(request, "\u7528\u6237\u540d\u5bc6\u7801\u6a21\u5f0f\u767b\u5f55\u5931\u8d25", baseVO.getInfo());
        }
        return vo;
    }

    @RequestMapping(value={"loginByUsernameAndPassword.json"}, method={RequestMethod.POST})
    @ResponseBody
    public LoginVO loginByUsernameAndPassword(HttpServletRequest request, Model model) {
        LoginVO vo = new LoginVO();
        String wmLogin = ApplicationPropertiesUtil.getProperty("wm.login");
        if (wmLogin != null && wmLogin.equalsIgnoreCase("false")) {
            vo.setBaseVO(0, "\u6b64\u63a5\u53e3\u4e0d\u5141\u8bb8\u88ab\u4f7f\u7528\uff01\u60a8\u53ef\u4fee\u6539application.properties\u4e2d\u7684wm.login=true \uff0c\u91cd\u542f\u9879\u76ee\uff0c\u5373\u53ef\u4f7f\u7528\u672c\u63a5\u53e3");
            return vo;
        }
        String ip = IpUtil.getIpAddress(request);
        Object cacheObj = CacheUtil.get((String)ip);
        int ipCishu = 0;
        if (cacheObj != null) {
            ipCishu = (Integer)cacheObj;
        }
        if (ipCishu > 4) {
            vo.setBaseVO(0, "\u60a8\u5f53\u524d\u5c1d\u8bd5\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u4e00\u5c0f\u65f6\u540e\u518d\u8bd5");
            return vo;
        }
        BaseVO baseVO = this.userService.loginByUsernameAndPassword(request);
        vo.setBaseVO(baseVO);
        if (baseVO.getResult() == 1) {
            ActionLogUtil.insert(request, "\u7528\u6237\u540d\u5bc6\u7801\u6a21\u5f0f\u767b\u5f55\u6210\u529f");
            vo.setInfo("admin/index/index.do");
            HttpSession session = request.getSession();
            vo.setToken(session.getId());
            vo.setUser(this.getUser());
        } else {
            CacheUtil.set((String)ip, (Object)ipCishu++, (int)3600);
        }
        return vo;
    }

    @RequestMapping(value={"logout${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO logout(HttpServletRequest request, Model model) {
        SessionUtil.logout();
        return this.success();
    }

    @RequestMapping(value={"logout.json"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO logoutjson(HttpServletRequest request, Model model) {
        SessionUtil.logout();
        return this.success();
    }
}

