/*
 * Decompiled with CFR 0.152.
 */
package com.qikemi.packages.alibaba.aliyun.oss;

import com.aliyun.openservices.oss.OSSClient;
import com.aliyun.openservices.oss.model.ListObjectsRequest;
import com.aliyun.openservices.oss.model.OSSObjectSummary;
import com.aliyun.openservices.oss.model.ObjectListing;
import com.aliyun.openservices.oss.model.ObjectMetadata;
import com.qikemi.packages.utils.SystemUtil;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class ObjectService {
    public boolean upload(JSONObject stateJson, HttpServletRequest request) {
        String key = stateJson.getString("url").replaceFirst("/", "");
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(SystemUtil.getProjectRootPath() + key));
            ObjectService.putObject(key, fileInputStream);
            return true;
        }
        catch (FileNotFoundException e) {
            ConsoleUtil.error("upload file to aliyun OSS object server occur FileNotFoundException.");
        }
        catch (NumberFormatException e) {
            ConsoleUtil.error("upload file to aliyun OSS object server occur NumberFormatException.");
        }
        catch (IOException e) {
            ConsoleUtil.error("upload file to aliyun OSS object server occur IOException.");
        }
        return false;
    }

    public static void putObject(String key, InputStream content) throws NumberFormatException, IOException {
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentLength((long)Integer.parseInt(String.valueOf(content.available())));
        meta.addUserMetadata("filename", key);
        ConsoleUtil.debug("putObject--filename : " + key);
        AttachmentUtil.putForUEditor(key, content, meta);
    }

    public static List<String> listObject(OSSClient client, String bucketName, String delimiter, String prefix) {
        boolean hasNext = false;
        String marker = "";
        ArrayList<String> filePathList = new ArrayList<String>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
        listObjectsRequest.setDelimiter(delimiter);
        listObjectsRequest.setMaxKeys(Integer.valueOf(20));
        listObjectsRequest.setPrefix(prefix);
        do {
            listObjectsRequest.setMarker(marker);
            ObjectListing sublisting = client.listObjects(listObjectsRequest);
            if (sublisting.isTruncated()) {
                hasNext = true;
                marker = sublisting.getNextMarker();
            } else {
                hasNext = false;
                marker = "";
            }
            for (OSSObjectSummary objectSummary : sublisting.getObjectSummaries()) {
                filePathList.add("/" + objectSummary.getKey());
            }
        } while (hasNext);
        return filePathList;
    }
}

