/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.upload.Base64Uploader;
import com.baidu.ueditor.upload.BinaryUploader;
import com.qikemi.packages.alibaba.aliyun.oss.properties.OSSClientProperties;
import com.qikemi.packages.baidu.ueditor.upload.AsynUploaderThreader;
import com.qikemi.packages.baidu.ueditor.upload.SynUploader;
import com.qikemi.packages.utils.SystemUtil;
import com.xnx3.DateUtil;
import com.xnx3.UrlUtil;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.SessionUtil;
import com.xnx3.j2ee.vo.UploadFileVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class Uploader {
    private HttpServletRequest request = null;
    private Map<String, Object> conf = null;

    public Uploader(HttpServletRequest request, Map<String, Object> conf) {
        this.request = request;
        this.conf = conf;
    }

    public State doExecss() {
        String uploadFilePath;
        File uploadFile;
        State state = null;
        state = BinaryUploader.save(this.request, this.conf);
        JSONObject stateJson = new JSONObject(state.toJSONString());
        if (OSSClientProperties.useAsynUploader) {
            ConsoleUtil.debug(state.toJSONString());
            AsynUploaderThreader asynThreader = new AsynUploaderThreader();
            asynThreader.init(stateJson, this.request);
            Thread uploadThreader = new Thread(asynThreader);
            uploadThreader.start();
        } else {
            ConsoleUtil.debug(state.toJSONString());
            SynUploader synUploader = new SynUploader();
            synUploader.upload(stateJson, this.request);
        }
        if (!OSSClientProperties.useLocalStorager && (uploadFile = new File(uploadFilePath = (String)this.conf.get("rootPath") + (String)stateJson.get("url"))).isFile() && uploadFile.exists()) {
            uploadFile.delete();
        }
        state.putInfo("url", OSSClientProperties.ossEndPoint + stateJson.getString("url"));
        ConsoleUtil.debug("state.url : " + OSSClientProperties.ossEndPoint + stateJson.getString("url"));
        ConsoleUtil.debug("state.url : " + state.toJSONString());
        return state;
    }

    public final State doExec() {
        ConsoleUtil.debug("doExec--");
        State state = null;
        if (OSSClientProperties.astrictUpload && !SessionUtil.isAllowUploadForUEditor()) {
            return new BaseState(false, OSSClientProperties.astrictUploadMessage);
        }
        String filedName = (String)this.conf.get("fieldName");
        if ("true".equals(this.conf.get("isBase64"))) {
            state = Base64Uploader.save(this.request.getParameter(filedName), this.conf);
            ConsoleUtil.debug("doExec--isBase64--" + state.toJSONString());
        } else {
            ConsoleUtil.debug("doExec--not isBase64");
            state = BinaryUploader.save(this.request, this.conf);
            JSONObject stateJson = new JSONObject(state.toJSONString());
            ConsoleUtil.debug("doExec--OSSClientProperties.useStatus: " + OSSClientProperties.useStatus);
            if (AttachmentUtil.isMode("aliyunOSS")) {
                String uploadPath;
                SynUploader synUploader = new SynUploader();
                synUploader.upload(stateJson, this.request);
                String uploadFilePath = (String)this.conf.get("rootPath") + (String)stateJson.get("url");
                File uploadFile = new File(uploadFilePath);
                if (uploadFile.isFile() && uploadFile.exists()) {
                    uploadFile.delete();
                }
                if ((uploadPath = stateJson.getString("url")).indexOf("/") == 0 && OSSClientProperties.ossEndPoint.lastIndexOf("/") + 1 == OSSClientProperties.ossEndPoint.length()) {
                    uploadPath = uploadPath.substring(1, uploadPath.length());
                }
                state.putInfo("url", OSSClientProperties.ossEndPoint + uploadPath);
                ConsoleUtil.debug("doExec--\u4e0a\u4f20\u5230\u963f\u91cc\u4e91oss\u5bf9\u8c61\u5b58\u50a8\uff1a " + OSSClientProperties.ossEndPoint + uploadPath);
            } else if (AttachmentUtil.isMode("huaWeiYunOBS")) {
                String uploadPath;
                SynUploader synUploader = new SynUploader();
                synUploader.upload(stateJson, this.request);
                String uploadFilePath = (String)this.conf.get("rootPath") + (String)stateJson.get("url");
                File uploadFile = new File(uploadFilePath);
                if (uploadFile.isFile() && uploadFile.exists()) {
                    uploadFile.delete();
                }
                if ((uploadPath = stateJson.getString("url")).indexOf("/") == 0 && OSSClientProperties.ossEndPoint.lastIndexOf("/") + 1 == OSSClientProperties.ossEndPoint.length()) {
                    uploadPath = uploadPath.substring(1, uploadPath.length());
                }
                state.putInfo("url", AttachmentUtil.netUrl() + uploadPath);
                ConsoleUtil.debug("doExec--\u4e0a\u4f20\u5230\u534e\u4e3a\u4e91obs\u5bf9\u8c61\u5b58\u50a8\uff1a " + AttachmentUtil.netUrl() + uploadPath);
            } else if (AttachmentUtil.isMode("kuozhan")) {
                String uploadFilePath;
                File uploadFile;
                String fileName = UrlUtil.getFileName((String)((String)stateJson.get("url")));
                String key = stateJson.getString("url").replaceFirst("/", "");
                UploadFileVO uploadFileVO = null;
                try {
                    FileInputStream fileInputStream = new FileInputStream(new File(SystemUtil.getProjectRootPath() + key));
                    uploadFileVO = AttachmentUtil.uploadFile("site/" + SessionUtil.getUeUploadParam1() + "/ue/" + DateUtil.currentDate((String)"yyyyMMdd") + "/" + fileName, fileInputStream);
                }
                catch (FileNotFoundException e) {
                    ConsoleUtil.error("upload file to AttachmentUtil.mode: kuozhan, FileNotFoundException.");
                }
                catch (NumberFormatException e) {
                    ConsoleUtil.error("upload file to AttachmentUtil.mode: kuozhan, NumberFormatException.");
                }
                catch (IOException e) {
                    ConsoleUtil.error("upload file to AttachmentUtil.mode: kuozhan, IOException." + e.getMessage());
                }
                if (uploadFileVO != null && uploadFileVO.getResult() - 1 == 0) {
                    state.putInfo("url", uploadFileVO.getUrl());
                    ConsoleUtil.debug("\u4e0a\u4f20\u5230\u81ea\u5b9a\u4e49AttachmentUtil\u7684\u5b58\u50a8  " + uploadFileVO.getPath());
                }
                if ((uploadFile = new File(uploadFilePath = (String)this.conf.get("rootPath") + (String)stateJson.get("url"))).isFile() && uploadFile.exists()) {
                    uploadFile.delete();
                }
            } else if (AttachmentUtil.isMode("localFile")) {
                String stateStr = stateJson.getString("state");
                if (stateStr.equals("SUCCESS")) {
                    state.putInfo("url", AttachmentUtil.netUrl() + SystemUtil.getProjectName() + stateJson.getString("url"));
                    ConsoleUtil.debug("doExec--\u4e0a\u4f20\u670d\u52a1\u5668\u78c1\u76d8\uff1a " + AttachmentUtil.netUrl() + SystemUtil.getProjectName() + stateJson.getString("url"));
                }
            } else {
                ConsoleUtil.error("AttachmentUtil.mode \u672a\u53d1\u73b0\u5b58\u50a8\u65b9\u5f0f\u3002\u5f53\u524dAttachmentUtil.mode:" + AttachmentUtil.mode);
                String stateStr = stateJson.getString("state");
                if (stateStr.equals("SUCCESS")) {
                    state.putInfo("url", AttachmentUtil.netUrl() + SystemUtil.getProjectName() + stateJson.getString("url"));
                    ConsoleUtil.debug("doExec--\u4e0a\u4f20\u670d\u52a1\u5668\u78c1\u76d8\uff1a " + AttachmentUtil.netUrl() + SystemUtil.getProjectName() + stateJson.getString("url"));
                }
            }
        }
        ConsoleUtil.debug("doExec--\u6700\u540e\u8fd4\u56de\uff1a" + state.toJSONString());
        return state;
    }
}

