/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.superadmin.util.pluginManage;

import com.xnx3.wangmarket.superadmin.util.pluginManage.ScanClassesUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ComponentUtils {
    public static void removeBean(String className, String compomentName, ApplicationContext applicationContext) throws ClassNotFoundException {
        Class<?> loadClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(loadClass);
        ComponentUtils.removeBean(compomentName, beanDefinitionBuilder.getRawBeanDefinition(), applicationContext);
    }

    public static void registerBean(String compomentName, AbstractBeanDefinition beanDefinition, ApplicationContext applicationContext) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
        BeanDefinitionRegistry beanDefinitonRegistry = (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory();
        beanDefinitonRegistry.registerBeanDefinition(compomentName, (BeanDefinition)beanDefinition);
    }

    public static void addBean(String className, String compomentName, Map<Object, Object> propertyMap, ApplicationContext applicationContext) throws ClassNotFoundException {
        Class<?> loadClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(loadClass);
        if (propertyMap != null) {
            for (Map.Entry<Object, Object> entry : propertyMap.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                beanDefinitionBuilder.addPropertyValue(key, val);
            }
        }
        ComponentUtils.registerBean(compomentName, beanDefinitionBuilder.getRawBeanDefinition(), applicationContext);
    }

    public static void removeBean(String compomentName, AbstractBeanDefinition beanDefinition, ApplicationContext applicationContext) {
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
        BeanDefinitionRegistry beanDefinitonRegistry = (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory();
        beanDefinitonRegistry.removeBeanDefinition(compomentName);
    }

    public static void registerMapping(ApplicationContext applicationContext, Method method, Class componentClass, String mappingUrl) {
        String[] beanNamesForType = applicationContext.getBeanNamesForType(componentClass);
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        PatternsRequestCondition patternsRequestCondition = new PatternsRequestCondition(new String[]{mappingUrl});
        RequestMethodsRequestCondition requestMethodsRequestCondition = new RequestMethodsRequestCondition(new RequestMethod[0]);
        RequestMappingInfo mapping_info = new RequestMappingInfo(patternsRequestCondition, requestMethodsRequestCondition, null, null, null, null, null);
        if (!ComponentUtils.judgeMappingIsRegister(applicationContext, mappingUrl)) {
            requestMappingHandlerMapping.registerMapping(mapping_info, (Object)beanNamesForType[0], method);
        }
    }

    public static void registerMapping4Class(Class<?> clazz, ApplicationContext applicationContext, String mappingRegex, String mappingReplacement) {
        RequestMapping clazzMappingAnnotation = clazz.getAnnotation(RequestMapping.class);
        List<String> clazzMappingList = Arrays.asList(clazzMappingAnnotation.value());
        Iterator<String> clazzMappingIterator = clazzMappingList.iterator();
        List<Method> methodList = ScanClassesUtil.getMethodsByAnnotationExist(clazz, RequestMapping.class);
        for (Method method : methodList) {
            RequestMapping annotation = method.getAnnotation(RequestMapping.class);
            List<String> methodMappingList = Arrays.asList(annotation.value());
            Iterator<String> methodMappingIterator = methodMappingList.iterator();
            for (String classMappingValue : clazzMappingList) {
                while (methodMappingIterator.hasNext()) {
                    String mappingUrl = methodMappingIterator.next();
                    if (mappingRegex != null && mappingReplacement != null) {
                        mappingUrl = mappingUrl.replaceAll(mappingRegex, mappingReplacement);
                    }
                    ComponentUtils.registerMapping(applicationContext, method, clazz, classMappingValue + mappingUrl);
                }
            }
        }
    }

    public static void unregisterMapping(ApplicationContext applicationContext, String mappingUrl) {
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        PatternsRequestCondition patternsRequestCondition = new PatternsRequestCondition(new String[]{mappingUrl});
        RequestMethodsRequestCondition requestMethodsRequestCondition = new RequestMethodsRequestCondition(new RequestMethod[0]);
        RequestMappingInfo mapping_info = new RequestMappingInfo(patternsRequestCondition, requestMethodsRequestCondition, null, null, null, null, null);
        if (ComponentUtils.judgeMappingIsRegister(applicationContext, mappingUrl)) {
            requestMappingHandlerMapping.unregisterMapping((Object)mapping_info);
        }
    }

    public static void unregisterMapping4Class(Class<?> clazz, ApplicationContext applicationContext, String mappingRegex, String mappingReplacement) {
        RequestMapping clazzMappingAnnotation = clazz.getAnnotation(RequestMapping.class);
        List<String> clazzMappingList = Arrays.asList(clazzMappingAnnotation.value());
        Iterator<String> clazzMappingIterator = clazzMappingList.iterator();
        List<Method> methodList = ScanClassesUtil.getMethodsByAnnotationExist(clazz, RequestMapping.class);
        for (Method method : methodList) {
            RequestMapping annotation = method.getAnnotation(RequestMapping.class);
            List<String> methodMappingList = Arrays.asList(annotation.value());
            Iterator<String> methodMappingIterator = methodMappingList.iterator();
            for (String clazzMappingValue : clazzMappingList) {
                while (methodMappingIterator.hasNext()) {
                    String mappingUrl = methodMappingIterator.next();
                    if (mappingRegex != null && mappingReplacement != null) {
                        mappingUrl = mappingUrl.replaceAll(mappingRegex, mappingReplacement);
                    }
                    ComponentUtils.unregisterMapping(applicationContext, clazzMappingValue + mappingUrl);
                }
            }
        }
    }

    public static boolean judgeMappingIsRegister(ApplicationContext applicationContext, String mappingName) {
        RequestMappingHandlerMapping mappingHandler = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        Map handlerMethods = mappingHandler.getHandlerMethods();
        Set keySet = handlerMethods.keySet();
        for (RequestMappingInfo requestMappingInfo : keySet) {
            PatternsRequestCondition patternsCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsCondition.getPatterns();
            for (String mapping : patterns) {
                if (!mapping.equals(mappingName)) continue;
                return true;
            }
        }
        return false;
    }
}

