/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.superadmin.controller.admin;

import com.xnx3.j2ee.controller.BaseController;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.service.UserService;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.service.SiteService;
import com.xnx3.wangmarket.domain.bean.MQBean;
import com.xnx3.wangmarket.domain.bean.SimpleSite;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/site"})
public class AdminSiteController
extends BaseController {
    @Resource
    private SqlService sqlService;
    @Resource
    private UserService userService;
    @Resource
    private SiteService siteService;

    @RequiresPermissions(value={"adminSiteList"})
    @RequestMapping(value={"list${url.suffix}"})
    public String list(HttpServletRequest request, Model model) {
        Sql sql = new Sql(request);
        sql.setSearchTable("site");
        sql.setSearchColumn(new String[]{"userid=", "state=", "name", "phone", "client=", "bind_domain", "domain"});
        int count = this.sqlService.count("site", sql.getWhere());
        Page page = new Page(count, 12, request);
        sql.setSelectFromAndPage("SELECT * FROM site", page);
        sql.setOrderByField(new String[]{"id", "expiretime", "addtime"});
        sql.setOrderBy("site.id DESC");
        List list = this.sqlService.findBySql(sql, Site.class);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0\uff0c\u7f51\u7ad9\u7ba1\u7406,\u7f51\u7ad9\u5217\u8868");
        model.addAttribute("list", (Object)list);
        model.addAttribute("page", (Object)page);
        return "/superadmin/site/list";
    }

    @RequiresPermissions(value={"adminSiteView"})
    @RequestMapping(value={"view${url.suffix}"})
    public String view(HttpServletRequest request, Model model, @RequestParam(value="id", required=true, defaultValue="") int id) {
        Site site = (Site)this.sqlService.findById(Site.class, id);
        ActionLogUtil.insert((HttpServletRequest)request, (Integer)site.getId(), (String)"\u603b\u7ba1\u7406\u540e\u53f0\uff0c\u7f51\u7ad9\u7ba1\u7406,\u7f51\u7ad9\u8be6\u60c5", (String)site.getName());
        model.addAttribute("site", (Object)site);
        return "/superadmin/site/view";
    }

    @RequiresPermissions(value={"adminSiteList"})
    @RequestMapping(value={"siteFreeze.json"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO sitePause(HttpServletRequest request, @RequestParam(value="siteid", required=true) int siteid) {
        Site site = (Site)this.sqlService.findById(Site.class, siteid);
        User user = (User)this.sqlService.findById(User.class, (Object)site.getUserid());
        if (user == null) {
            return this.error("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (site.getState() - Site.STATE_NORMAL != 0) {
            return this.error("\u5f53\u524d\u7f51\u7ad9\u7684\u72b6\u6001\u4e0d\u7b26\uff0c\u6682\u505c\u5931\u8d25");
        }
        site.setState(Site.STATE_FREEZE);
        this.sqlService.save((Object)site);
        this.userService.freezeUser(site.getUserid().intValue());
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)site.getId(), (String)("userid:" + this.getUser().getId() + ",\u5c06\u7f51\u7ad9" + site.getName() + "\u6682\u505c"));
        MQBean mqBean = new MQBean();
        mqBean.setType(3);
        mqBean.setSimpleSite(new SimpleSite(site));
        this.siteService.updateDomainServers(mqBean);
        return this.success();
    }

    @RequiresPermissions(value={"adminSiteList"})
    @RequestMapping(value={"siteUnFreeze.json"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO siteRemovePause(HttpServletRequest request, @RequestParam(value="siteid", required=true) int siteid) {
        Site site = (Site)this.sqlService.findById(Site.class, siteid);
        User user = (User)this.sqlService.findById(User.class, (Object)site.getUserid());
        if (user == null) {
            return this.error("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (site.getState() - Site.STATE_FREEZE != 0) {
            return this.error("\u5f53\u524d\u7f51\u7ad9\u7684\u72b6\u6001\u4e0d\u7b26\uff0c\u6682\u505c\u5931\u8d25");
        }
        site.setState(Site.STATE_NORMAL);
        this.sqlService.save((Object)site);
        this.userService.unfreezeUser(site.getUserid().intValue());
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)site.getId(), (String)("userid:" + this.getUser().getId() + ",\u5c06\u6682\u505c\u7684\u7f51\u7ad9" + site.getName() + "\u6062\u590d\u6b63\u5e38"));
        MQBean mqBean = new MQBean();
        mqBean.setType(3);
        mqBean.setSimpleSite(new SimpleSite(site));
        this.siteService.updateDomainServers(mqBean);
        return this.success();
    }

    @RequiresPermissions(value={"adminSiteList"})
    @RequestMapping(value={"siteUpdateRemark${api.suffix}"})
    @ResponseBody
    public BaseVO siteUpdateRemark(HttpServletRequest request, @RequestParam(value="siteid", required=true) int siteid, @RequestParam(value="remark", required=true) String remark) {
        Site site = (Site)this.sqlService.findById(Site.class, siteid);
        if (site == null) {
            return this.error("\u7f51\u7ad9\u4e0d\u5b58\u5728");
        }
        site.setRemark(SafetyUtil.xssFilter((String)remark));
        this.sqlService.save((Object)site);
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)siteid, (String)"\u603b\u540e\u53f0\u7ed9\u67d0\u4e2a\u7ad9\u70b9\u66f4\u6539\u5907\u6ce8", (String)remark);
        return this.success();
    }
}

