/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.superadmin.controller.admin;

import com.xnx3.StringUtil;
import com.xnx3.j2ee.controller.BaseController;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.wangmarket.admin.Func;
import com.xnx3.wangmarket.admin.entity.News;
import com.xnx3.wangmarket.admin.entity.NewsData;
import com.xnx3.wangmarket.admin.entity.Site;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/news"})
public class AdminNewsController
extends BaseController {
    @Resource
    private SqlService sqlService;

    @RequiresPermissions(value={"adminNewsList"})
    @RequestMapping(value={"list${url.suffix}"})
    public String list(HttpServletRequest request, Model model) {
        Sql sql = new Sql(request);
        sql.setSearchTable("news");
        sql.setSearchColumn(new String[]{"userid=", "title", "type=", "status=", "cid=", "siteid=", "legitimate="});
        int count = this.sqlService.count("news", sql.getWhere());
        Page page = new Page(count, 12, request);
        sql.setSelectFromAndPage("SELECT * FROM news", page);
        sql.setOrderBy("news.id DESC");
        List list = this.sqlService.findBySql(sql, News.class);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0\uff0cNews \u6587\u7ae0\u7ba1\u7406\uff0c\u67e5\u770b\u6587\u7ae0\u5217\u8868");
        model.addAttribute("list", (Object)list);
        model.addAttribute("page", (Object)page);
        return "/superadmin/news/list";
    }

    @RequiresPermissions(value={"adminNewsView"})
    @RequestMapping(value={"view${url.suffix}"})
    public String view(HttpServletRequest request, @RequestParam(value="id", required=true, defaultValue="") int id, Model model) {
        News news = (News)this.sqlService.findById(News.class, id);
        if (news == null) {
            return this.error(model, "\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        NewsData newsData = (NewsData)this.sqlService.findById(NewsData.class, id);
        Site site = (Site)this.sqlService.findById(Site.class, (Object)news.getSiteid());
        if (site == null) {
            return this.error(model, "\u4fe1\u606f\u6240\u5c5e\u7f51\u7ad9\u4e0d\u5b58\u5728");
        }
        ActionLogUtil.insert((HttpServletRequest)request, (Integer)news.getId(), (String)"\u603b\u7ba1\u7406\u540e\u53f0\uff0cNews \u6587\u7ae0\u7ba1\u7406\uff0c\u67e5\u770b\u6587\u7ae0\u6587\u7ae0\u8be6\u60c5", (String)news.getTitle());
        model.addAttribute("text", (Object)StringUtil.filterXss((String)newsData.getText()));
        model.addAttribute("news", (Object)news);
        model.addAttribute("site", (Object)site);
        model.addAttribute("AttachmentFileUrl", (Object)AttachmentUtil.netUrl());
        return "/superadmin/news/view";
    }

    @RequiresPermissions(value={"adminNewsDelete"})
    @RequestMapping(value={"delete${url.suffix}"})
    @ResponseBody
    public String delete(HttpServletRequest request, @RequestParam(value="id", required=true, defaultValue="") int id, Model model) {
        News news = (News)this.sqlService.findById(News.class, id);
        if (news == null) {
            return "\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)news.getId(), (String)"\u603b\u7ba1\u7406\u540e\u53f0\uff0cNews \u6587\u7ae0\u7ba1\u7406\uff0c\u5220\u9664\u6587\u7ae0", (String)news.getTitle());
        this.sqlService.delete((Object)news);
        return this.success(model, "\u5220\u9664\u6210\u529f");
    }

    @RequiresPermissions(value={"adminNewsCancelLegitimate"})
    @RequestMapping(value={"cancelLegitimate${url.suffix}"})
    public String cancelLegitimate(HttpServletRequest request, @RequestParam(value="id", required=true, defaultValue="") int id, Model model) {
        News news = (News)this.sqlService.findById(News.class, id);
        if (news == null) {
            return "\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        news.setLegitimate((short)1);
        this.sqlService.save((Object)news);
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)news.getId(), (String)"\u603b\u7ba1\u7406\u540e\u53f0\uff0cNews \u6587\u7ae0\u7ba1\u7406\uff0c\u53d6\u6d88\u8fdd\u89c4\u6807\u793a\uff0c\u5c06\u5176\u6539\u4e3a\u5408\u6cd5\u72b6\u6001", (String)news.getTitle());
        return this.success(model, "\u64cd\u4f5c\u6210\u529f", "admin/news/view.do?id=" + id);
    }

    @RequiresPermissions(value={"adminNewsView"})
    @RequestMapping(value={"perview${url.suffix}"})
    public String perview(HttpServletRequest request, @RequestParam(value="id", required=true, defaultValue="0") int id, Model model) {
        News news = (News)this.sqlService.findById(News.class, id);
        if (news == null) {
            return this.error(model, "\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Site site = (Site)this.sqlService.findById(Site.class, (Object)news.getSiteid());
        if (site == null) {
            return this.error(model, "\u4fe1\u606f\u6240\u5c5e\u7f51\u7ad9\u4e0d\u5b58\u5728");
        }
        ActionLogUtil.insert((HttpServletRequest)request, (Integer)news.getId(), (String)"\u67e5\u770b\u6b64\u6761\u6587\u7ae0\u7684\u7f51\u7ad9\u524d\u7aef\uff0c\u5bf9\u5916\u7684\u7f51\u7ad9\u6587\u7ae0\u9875\u9762", (String)news.getTitle());
        return this.redirect("http://" + Func.getDomain(site) + "/" + id + ".html");
    }
}

