/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.superadmin.controller;

import com.Application;
import com.xnx3.BaseVO;
import com.xnx3.DateUtil;
import com.xnx3.FileUtil;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.Global;
import com.xnx3.j2ee.pluginManage.PluginManage;
import com.xnx3.j2ee.pluginManage.PluginRegister;
import com.xnx3.j2ee.pluginManage.controller.BasePluginController;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.AttachmentMode.LocalServerMode;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.util.VersionUtil;
import com.xnx3.net.HttpResponse;
import com.xnx3.net.HttpUtil;
import com.xnx3.wangmarket.Authorization;
import com.xnx3.wangmarket.admin.G;
import com.xnx3.wangmarket.superadmin.bean.PluginRegisterBean;
import com.xnx3.wangmarket.superadmin.cache.YunPluginMessageCache;
import com.xnx3.wangmarket.superadmin.util.pluginManage.ComponentUtils;
import com.xnx3.wangmarket.superadmin.util.pluginManage.ScanClassesUtil;
import com.xnx3.wangmarket.superadmin.util.pluginManage.TomcatUtil;
import com.xnx3.wangmarket.superadmin.util.pluginManage.ZipUtils;
import com.xnx3.wangmarket.superadmin.vo.InstallApplicationVO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Resource;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.hibernate.MappingException;
import org.hibernate.metamodel.internal.MetamodelImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/plugin/pluginManage/"})
public class PluginManageController
extends BasePluginController {
    @Resource
    SqlService sqlService;
    @Autowired
    private ApplicationContext applicationContext;

    @ResponseBody
    @RequestMapping(value={"/upgradePlugin${url.suffix}"})
    public BaseVO upgradePlugin(HttpServletRequest request, @RequestParam(value="plugin_id", required=false, defaultValue="") String pluginId, @RequestParam(value="version", required=false, defaultValue="") String version) throws ClassNotFoundException, IOException {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error("\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        pluginId = SafetyUtil.xssFilter((String)pluginId);
        version = SafetyUtil.xssFilter((String)version);
        if (pluginId == null || pluginId.trim().equals("")) {
            return this.error("\u63d2\u4ef6ID\u9519\u8bef");
        }
        if (version == null || version.trim().equals("")) {
            return this.error("\u63d2\u4ef6\u5347\u7ea7\u7248\u672c\u9519\u8bef");
        }
        int minVersionInt = YunPluginMessageCache.applicationMap.get(pluginId).getWangmarketVersionMin();
        int currentVersionInt = VersionUtil.strToInt((String)G.VERSION);
        if (currentVersionInt < minVersionInt) {
            return this.error("\u5f53\u524d\u7f51\u5e02\u573a\u7248\u8f83\u4f4e\uff0c\u8be5\u63d2\u4ef6\u652f\u6301\u7f51\u5e02\u573av" + VersionUtil.intToStr((int)minVersionInt) + " \u53ca\u66f4\u9ad8\u7248\u672c");
        }
        com.xnx3.wangmarket.superadmin.bean.Application application = YunPluginMessageCache.applicationMap.get(pluginId);
        if (Authorization.copyright.booleanValue() && application.getSupportFreeVersion() - 1 != 0) {
            return this.error("\u8be5\u63d2\u4ef6\u672a\u7ecf\u6388\u6743\u7528\u6237\u4e0d\u53ef\u7528");
        }
        if (currentVersionInt - minVersionInt == 0) {
            return this.error("\u60a8\u76ee\u524d\u5b89\u88c5\u5df2\u662f\u6700\u65b0\u7248\u672c\uff0c\u65e0\u9700\u66f4\u65b0");
        }
        BaseVO unIstallBaseVO = this.unIstallPlugin(request, pluginId);
        if (unIstallBaseVO.getResult() == 0) {
            return this.error("\u63d2\u4ef6\u5378\u8f7d\u5df2\u5b89\u88c5\u7248\u672c\u65f6\u51fa\u9519");
        }
        BaseVO istallBaseVO = this.installYunPlugin(request, pluginId);
        if (istallBaseVO.getResult() == 0) {
            return this.error("\u63d2\u4ef6\u5b89\u88c5\u6700\u65b0\u7248\u672c\u65f6\u51fa\u9519");
        }
        String className = "com.xnx3.wangmarket.plugin." + pluginId + ".Plugin";
        Class<?> forName = Class.forName(className);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406\uff0c\u5347\u7ea7\u63d2\u4ef6", (String)("\u5347\u7ea7ID\u4e3a" + pluginId + "\u7684\u63d2\u4ef6"));
        return this.success();
    }

    @ResponseBody
    @RequestMapping(value={"/unIstallPlugin${url.suffix}"})
    public BaseVO unIstallPlugin(HttpServletRequest request, @RequestParam(value="plugin_id", required=false, defaultValue="") String pluginId) throws ClassNotFoundException, IOException {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error("\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        if ((pluginId = SafetyUtil.xssFilter((String)pluginId)) == null || pluginId.trim().equals("")) {
            return this.error("\u63d2\u4ef6\u4fe1\u606f\u9519\u8bef");
        }
        List<Class<?>> classList = this.getPluginComponent(pluginId);
        Iterator<Class<?>> iterator = classList.iterator();
        String compomentName = null;
        while (iterator.hasNext()) {
            Class<?> compomentClass = iterator.next();
            compomentName = compomentClass.getSimpleName();
            compomentName = compomentName.substring(0, 1).toLowerCase() + compomentName.substring(1, compomentName.length());
            try {
                if (compomentClass.getAnnotation(Entity.class) == null) {
                    ComponentUtils.removeBean(compomentClass.getName(), compomentName, this.applicationContext);
                }
                if (compomentClass.getAnnotation(Controller.class) == null) continue;
                ComponentUtils.unregisterMapping4Class(compomentClass, this.applicationContext, "\\$\\{url.suffix}", ".do");
            }
            catch (Exception e) {
                System.out.println("\u5728\u5bb9\u5668\u4e2d\u5df2\u6ca1\u6709\u8be5\u7ec4\u4ef6");
                e.printStackTrace();
            }
        }
        Map<String, String> pathMap = this.getPluginPath(request, pluginId);
        String classPath = pathMap.get("classPath");
        String jspPath = pathMap.get("jspPath");
        String staticPath = pathMap.get("staticPath");
        String metaJspPath = pathMap.get("metaJspPath");
        LinkedList<String> filePathList = new LinkedList<String>();
        filePathList.add(classPath);
        filePathList.add(jspPath);
        filePathList.add(staticPath);
        if (metaJspPath != null) {
            filePathList.add(metaJspPath);
        }
        List<File> deleteFileList = this.getPluginFile(pluginId, filePathList);
        for (File file : deleteFileList) {
            this.deleteDirectory(file, false);
        }
        PluginManage.removePluginCache((String)pluginId);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406-\u5378\u8f7d\u63d2\u4ef6", (String)("\u5378\u8f7dID\u4e3a" + pluginId + "\u7684\u63d2\u4ef6"));
        return this.success();
    }

    private List<File> getPluginFile(String pluginId, List<String> filePathList) {
        LinkedList<File> deleteFileList = new LinkedList<File>();
        PluginFileFilter pluginFileFilter = new PluginFileFilter(pluginId);
        File[] listFiles = null;
        for (String filePath : filePathList) {
            if (!new File(filePath).exists()) continue;
            listFiles = new File(filePath).listFiles(pluginFileFilter);
            deleteFileList.addAll(Arrays.asList(listFiles));
        }
        return deleteFileList;
    }

    private void deleteDirectory(File file, boolean keepFile) {
        if (!file.exists()) {
            return;
        }
        File[] childFile = file.listFiles();
        if (childFile == null) {
            return;
        }
        for (int i = 0; i < childFile.length; ++i) {
            File nowfile = childFile[i];
            if (nowfile.getName().endsWith(File.separator) || nowfile.isDirectory()) {
                this.deleteDirectory(nowfile, false);
                continue;
            }
            nowfile.delete();
        }
        if (!keepFile) {
            file.delete();
        }
    }

    @ResponseBody
    @RequestMapping(value={"/installPlugin${url.suffix}"})
    public BaseVO installPlugin(HttpServletRequest request, @RequestParam(value="plugin_id", required=false, defaultValue="") String pluginId) throws IOException, ClassNotFoundException {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error("\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        if ((pluginId = SafetyUtil.xssFilter((String)pluginId)) == null || pluginId.trim().equals("")) {
            return this.error("\u63d2\u4ef6ID\u9519\u8bef");
        }
        if (PluginManage.getAllInstallPlugin().get(pluginId) != null) {
            return this.error("\u8be5\u63d2\u4ef6\u60a8\u5df2\u5b89\u88c5\u6216\u8005\u4e0e\u672c\u5730\u63d2\u4ef6ID\u53d1\u751f\u51b2\u7a81\u3002");
        }
        String fileName = pluginId + ".zip";
        String realPath = request.getServletContext().getRealPath("/");
        Map<String, String> pluginPath = this.getPluginPath(request, pluginId);
        try {
            if (!new File(realPath + "installPlugin" + File.separator).exists()) {
                new File(realPath + "installPlugin" + File.separator).mkdirs();
            }
            this.unZip(new File(realPath + "myPlugin" + File.separator + fileName), realPath + "installPlugin" + File.separator);
            this.copyPluginFile(realPath, pluginPath, pluginId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error("\u63d2\u4ef6\u7684\u538b\u7f29\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        List<Class<?>> classList = this.getPluginComponent(pluginId);
        Iterator<Class<?>> iterator = classList.iterator();
        String compomentName = null;
        boolean restartApplication = false;
        while (iterator.hasNext()) {
            Class<?> compomentClass = iterator.next();
            compomentName = compomentClass.getSimpleName();
            compomentName = compomentName.substring(0, 1).toLowerCase() + compomentName.substring(1, compomentName.length());
            ComponentUtils.addBean(compomentClass.getName(), compomentName, new HashMap<Object, Object>(), this.applicationContext);
            if (compomentClass.getAnnotation(Controller.class) != null) {
                ComponentUtils.registerMapping4Class(compomentClass, this.applicationContext, "\\$\\{url.suffix}", ".do");
            }
            if (compomentClass.getAnnotation(Entity.class) == null) continue;
            EntityManager entityManager = (EntityManager)this.applicationContext.getBean(EntityManager.class);
            MetamodelImpl metamodel = (MetamodelImpl)entityManager.getMetamodel();
            try {
                metamodel.entityPersister(compomentClass);
            }
            catch (MappingException e) {
                restartApplication = true;
                e.printStackTrace();
            }
        }
        String className = "com.xnx3.wangmarket.plugin." + pluginId + ".Plugin";
        Class<?> forName = Class.forName(className);
        try {
            PluginManage.registerPlugin(forName);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return this.error(e.getMessage());
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406-\u5b89\u88c5\u63d2\u4ef6", (String)("\u5b89\u88c5ID\u4e3a" + pluginId + "\u7684\u63d2\u4ef6"));
        if (restartApplication) {
            return this.success("restart");
        }
        return this.success();
    }

    @ResponseBody
    @RequestMapping(value={"/installYunPlugin${url.suffix}"})
    public BaseVO installYunPlugin(HttpServletRequest request, @RequestParam(value="plugin_id", required=false, defaultValue="") String pluginId) throws IOException, ClassNotFoundException {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error("\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        if ((pluginId = SafetyUtil.xssFilter((String)pluginId)) == null || pluginId.trim().equals("")) {
            return this.error("\u63d2\u4ef6ID\u9519\u8bef");
        }
        String dataBaseType = this.applicationContext.getEnvironment().getProperty("spring.datasource.url");
        if (dataBaseType.indexOf("mysql") > -1 && YunPluginMessageCache.applicationMap.get(pluginId).getSupportMysql() == 0) {
            return this.error("\u8be5\u63d2\u4ef6\u4e0d\u652f\u6301MySQL\u6570\u636e\u5e93");
        }
        if (dataBaseType.indexOf("sqlite") > -1 && YunPluginMessageCache.applicationMap.get(pluginId).getSupportSqlite() == 0) {
            return this.error("\u8be5\u63d2\u4ef6\u4e0d\u652f\u6301Sqlite\u6570\u636e\u5e93");
        }
        int minVersionInt = YunPluginMessageCache.applicationMap.get(pluginId).getWangmarketVersionMin();
        int currentVersionInt = VersionUtil.strToInt((String)G.VERSION);
        if (currentVersionInt < minVersionInt) {
            return this.error("\u5f53\u524d\u7f51\u5e02\u573a\u7248\u8f83\u4f4e\uff0c\u8be5\u63d2\u4ef6\u652f\u6301\u7f51\u5e02\u573av" + VersionUtil.intToStr((int)minVersionInt) + " \u53ca\u66f4\u9ad8\u7248\u672c");
        }
        if (PluginManage.getAllInstallPlugin().get(pluginId) != null) {
            return this.error("\u8be5\u63d2\u4ef6\u60a8\u5df2\u5b89\u88c5\u6216\u8005\u4e0e\u672c\u5730\u63d2\u4ef6ID\u53d1\u751f\u51b2\u7a81\u3002");
        }
        com.xnx3.wangmarket.superadmin.bean.Application application = YunPluginMessageCache.applicationMap.get(pluginId);
        if (Authorization.copyright.booleanValue() && application.getSupportFreeVersion() - 1 != 0) {
            return this.error("\u8be5\u63d2\u4ef6\u672a\u7ecf\u6388\u6743\u7528\u6237\u4e0d\u53ef\u7528");
        }
        String fileName = pluginId + ".zip";
        HttpUtil httpUtil = new HttpUtil();
        HttpResponse httpResponse = httpUtil.get("http://cloud.wscso.com/application?action=down&plugin_id=" + pluginId + "&auth_id=" + Authorization.auth_id + "&domain=" + SystemUtil.get((String)"AUTO_ASSIGN_DOMAIN"));
        if (httpResponse.getCode() - 200 != 0) {
            return this.error("\u4e91\u7aef\u63d2\u4ef6\u5e93\u5f02\u5e38\uff0c\u8f7b\u7a0d\u540e\u91cd\u8bd5");
        }
        JSONObject contentJson = JSONObject.fromObject((Object)httpResponse.getContent());
        if (contentJson.getInt("result") == 0) {
            return this.error(contentJson.getString("info"));
        }
        String downUrl = contentJson.getString("url");
        String realPath = request.getServletContext().getRealPath("/");
        Map<String, String> pluginPath = this.getPluginPath(request, pluginId);
        if (!new File(realPath + "yunPlugin" + File.separator).exists()) {
            new File(realPath + "yunPlugin" + File.separator).mkdirs();
        }
        if (!new File(realPath + "yunPlugin" + File.separator + fileName).exists()) {
            new File(realPath + "yunPlugin" + File.separator + fileName).createNewFile();
        }
        FileUtil.downFile((String)downUrl, (String)(realPath + "yunPlugin" + File.separator + fileName));
        try {
            if (!new File(realPath + "installPlugin").exists()) {
                new File(realPath + "installPlugin").mkdirs();
            }
            this.unZip(new File(realPath + "yunPlugin" + File.separator + fileName), realPath + "installPlugin" + File.separator);
            this.copyPluginFile(realPath, pluginPath, pluginId);
            this.deleteDirectory(new File(realPath + "yunPlugin" + File.separator), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error("\u63d2\u4ef6\u7684\u538b\u7f29\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        List<Class<?>> classList = this.getPluginComponent(pluginId);
        Iterator<Class<?>> iterator = classList.iterator();
        String compomentName = null;
        boolean restartApplication = false;
        while (iterator.hasNext()) {
            Class<?> compomentClass = iterator.next();
            compomentName = compomentClass.getSimpleName();
            compomentName = compomentName.substring(0, 1).toLowerCase() + compomentName.substring(1, compomentName.length());
            ComponentUtils.addBean(compomentClass.getName(), compomentName, new HashMap<Object, Object>(), this.applicationContext);
            if (compomentClass.getAnnotation(Controller.class) != null) {
                ComponentUtils.registerMapping4Class(compomentClass, this.applicationContext, "\\$\\{url.suffix}", ".do");
            }
            if (compomentClass.getAnnotation(Entity.class) == null) continue;
            EntityManager entityManager = (EntityManager)this.applicationContext.getBean(EntityManager.class);
            MetamodelImpl metamodel = (MetamodelImpl)entityManager.getMetamodel();
            try {
                metamodel.entityPersister(compomentClass);
            }
            catch (MappingException e) {
                restartApplication = true;
            }
        }
        String className = "com.xnx3.wangmarket.plugin." + pluginId + ".Plugin";
        Class<?> forName = Class.forName(className);
        PluginManage.removePluginCache((String)pluginId);
        try {
            if (!PluginManage.registerPlugin(forName)) {
                return this.error("\u63d2\u4ef6\u6ce8\u518c\u5931\u8d25\uff01");
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return this.error(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return this.error(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return this.error(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return this.error(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return this.error(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return this.error(e.getMessage());
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406\uff0c\u5b89\u88c5\u63d2\u4ef6", (String)("\u5b89\u88c5ID\u4e3a" + pluginId + "\u7684\u63d2\u4ef6"));
        if (restartApplication) {
            return this.success("restart");
        }
        return this.success();
    }

    @ResponseBody
    @RequestMapping(value={"/restart${url.suffix}"})
    public BaseVO restartApplication(HttpServletRequest request) {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error("\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406-\u91cd\u542fTomcat", (String)"\u56e0\u4e3a\u5b89\u88c5\u65b0\u63d2\u4ef6\u4e8c\u91cd\u542f\u670d\u52a1\u5668");
        if (this.getPluginPath(request, "").get("environment").equals("tomcat")) {
            HashMap<String, String> environmentMap = new HashMap<String, String>();
            environmentMap.put("runtimeEnvironment", this.applicationContext.getEnvironment().getProperty("os.name"));
            String realPath = request.getServletContext().getRealPath("/");
            environmentMap.put("realPath", realPath);
            new TomcatUtil(environmentMap).run();
        } else {
            Application.restart();
        }
        return this.success();
    }

    private void copyPluginFile(String realPath, Map<String, String> pluginPath, String pluginId) throws IOException {
        String classPath = realPath + "installPlugin" + File.separator + "ROOT" + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "com" + File.separator + "xnx3" + File.separator + "wangmarket" + File.separator + "plugin" + File.separator;
        String jspPath = realPath + "installPlugin" + File.separator + "ROOT" + File.separator + "WEB-INF" + File.separator + "view" + File.separator + "plugin" + File.separator;
        String staticPath = realPath + "installPlugin" + File.separator + "ROOT" + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "static" + File.separator + "plugin" + File.separator;
        this.copyDir(classPath, pluginPath.get("classPath"));
        this.copyDir(jspPath, pluginPath.get("jspPath"));
        if (pluginPath.get("metaJspPath") != null) {
            this.copyDir(jspPath, pluginPath.get("metaJspPath"));
        }
        if (new File(staticPath).exists()) {
            this.copyDir(staticPath, pluginPath.get("staticPath"));
        }
        this.deleteDirectory(new File(realPath + "installPlugin" + File.separator), false);
    }

    private List<Class<?>> getPluginComponent(String pluginId) throws IOException {
        String rootPackage = "com.xnx3.wangmarket.plugin";
        String packageDirName = rootPackage.replace('.', '/');
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
        List<File> fileList = null;
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            File[] files = new File(url.getPath()).listFiles(new PluginFileFilter(pluginId));
            fileList = Arrays.asList(files);
        }
        List<Class<?>> pluginClassList = ScanClassesUtil.getPluginClassList(fileList, rootPackage);
        String[] annotations = new String[]{"Controller", "Component", "Service", "Mapper", "Repository", "Entity"};
        List<Class<?>> pluClasses = ScanClassesUtil.getClassSearchAnnotationsName(pluginClassList, Arrays.asList(annotations));
        return pluClasses;
    }

    @ResponseBody
    @RequestMapping(value={"/uploadZip${url.suffix}"})
    public BaseVO uploadZip(HttpServletRequest request, @RequestParam(value="plugin_id", required=false, defaultValue="") String pluginId, @RequestParam(value="file", required=false) MultipartFile file) throws IllegalStateException, IOException {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error("\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        if ((pluginId = SafetyUtil.xssFilter((String)pluginId)) == null || pluginId.trim().equals("")) {
            return this.error("\u63d2\u4ef6\u4fe1\u606f\u9519\u8bef");
        }
        if (file == null) {
            return this.error("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38");
        }
        com.xnx3.wangmarket.superadmin.bean.Application application = (com.xnx3.wangmarket.superadmin.bean.Application)this.sqlService.findAloneByProperty(com.xnx3.wangmarket.superadmin.bean.Application.class, "id", (Object)pluginId);
        String realPath = request.getServletContext().getRealPath("/");
        new File(realPath + File.separator + "myPlugin").mkdirs();
        File uploadFile = new File(realPath + "myPlugin" + File.separator + pluginId + ".zip");
        if (!uploadFile.exists()) {
            uploadFile.createNewFile();
        }
        file.transferTo(uploadFile);
        this.sqlService.save((Object)application);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u529f\u80fd\u63d2\u4ef6-\u4e0a\u4f20\u63d2\u4ef6", (String)("\u4e0a\u4f20ID\u4e3a" + pluginId + "\u7684\u63d2\u4ef6\u538b\u7f29\u5305"));
        return this.success();
    }

    @ResponseBody
    @RequestMapping(value={"addByZip${url.suffix}"})
    public BaseVO uploadPluginZip(MultipartFile file, HttpServletRequest request) throws IOException {
        File uploadFile;
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error("\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        String realPath = request.getServletContext().getRealPath("/");
        File shortTimeFile = new File(realPath + "shortTimeFile.zip");
        if (!shortTimeFile.exists()) {
            shortTimeFile.createNewFile();
        }
        file.transferTo(shortTimeFile);
        ZipFile zipFile = new ZipFile(shortTimeFile, Charset.forName("UTF-8"));
        ZipEntry entry = zipFile.getEntry("ROOT/system.txt");
        if (entry == null) {
            return this.error("\u538b\u7f29\u5305\u5185\u7f3a\u5c11system.txt\u914d\u7f6e\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        InputStream inputStream = zipFile.getInputStream(entry);
        byte[] buff = new byte[1024];
        StringBuffer sBuffer = new StringBuffer("");
        while (inputStream.read(buff) != -1) {
            sBuffer.append(new String(buff, 0, buff.length));
        }
        inputStream.close();
        zipFile.close();
        String content = sBuffer.toString();
        content = StringUtil.utf8ToString((String)content);
        JSONObject systemObject = JSONObject.fromObject((Object)content);
        String pluginId = systemObject.getString("pluginId");
        String menuTitle = systemObject.getString("menuTitle");
        if (YunPluginMessageCache.applicationMap.get(pluginId) != null) {
            return this.error("\u8be5\u63d2\u4ef6ID\u4e0e\u4e91\u63d2\u4ef6\u5e93id\u91cd\u590d\uff0c\u8bf7\u66f4\u6362ID\u540e\u4e0a\u4f20");
        }
        com.xnx3.wangmarket.superadmin.bean.Application application = (com.xnx3.wangmarket.superadmin.bean.Application)this.sqlService.findAloneByProperty(com.xnx3.wangmarket.superadmin.bean.Application.class, "id", (Object)pluginId);
        if (application != null) {
            return this.error("\u8be5ID\u63d2\u4ef6\u5df2\u5728\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u3002");
        }
        if (!new File(realPath + File.separator + "myPlugin").exists()) {
            new File(realPath + File.separator + "myPlugin").mkdirs();
        }
        if (!(uploadFile = new File(realPath + "myPlugin" + File.separator + pluginId + ".zip")).exists()) {
            uploadFile.createNewFile();
        }
        FileUtil.copyFile((String)shortTimeFile.getAbsolutePath(), (String)uploadFile.getAbsolutePath());
        boolean delete = shortTimeFile.delete();
        if (!delete) {
            shortTimeFile.delete();
        }
        application = new com.xnx3.wangmarket.superadmin.bean.Application();
        application.setId(pluginId);
        application.setMenuTitle(new String(menuTitle.getBytes(), "utf-8"));
        this.sqlService.save((Object)application);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406-\u6dfb\u52a0\u63d2\u4ef6", (String)("\u6dfb\u52a0ID\u4e3a" + pluginId + "\u7684\u63d2\u4ef6"));
        return this.success();
    }

    @RequestMapping(value={"/index${url.suffix}"})
    public String index(HttpServletRequest request, Model model) {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error(model, "\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u8fdb\u5165\u603b\u7ba1\u7406\u540e\u53f0-\u529f\u80fd\u63d2\u4ef6 \u9996\u9875");
        return "/superadmin/pluginManage/index";
    }

    @RequestMapping(value={"/myList${url.suffix}"})
    public String myList(HttpServletRequest request, Model model) {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error(model, "\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        Map installedPluginMap = PluginManage.getAllInstallPlugin();
        HashMap localPluginMap = new HashMap();
        Map<String, com.xnx3.wangmarket.superadmin.bean.Application> yunPluginMap = YunPluginMessageCache.applicationMap;
        for (Map.Entry entry : installedPluginMap.entrySet()) {
            if (yunPluginMap.get(entry.getKey()) != null) continue;
            localPluginMap.put(entry.getKey(), new PluginRegisterBean((PluginRegister)entry.getValue()));
        }
        ArrayList localList = new ArrayList();
        for (Map.Entry entry : localPluginMap.entrySet()) {
            localList.add(entry.getValue());
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406\uff0c\u67e5\u770b\u81ea\u5df1\u4e8c\u6b21\u5f00\u53d1\u7684\u63d2\u4ef6", (String)"\u67e5\u770b\u63d2\u4ef6\u5217\u8868");
        model.addAttribute("list", localList);
        return "/superadmin/pluginManage/myList/list";
    }

    @RequestMapping(value={"/installList${url.suffix}"})
    public String installList(HttpServletRequest request, Model model, @RequestParam(value="menu_title", required=false, defaultValue="") String menuTitle) {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error(model, "\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        ArrayList<InstallApplicationVO> pluginList = new ArrayList<InstallApplicationVO>();
        Map installPluginMap = PluginManage.getAllInstallPlugin();
        for (Map.Entry entry : installPluginMap.entrySet()) {
            if (entry.getValue() == null || ((PluginRegister)entry.getValue()).menuTitle() == null || ((PluginRegister)entry.getValue()).menuTitle().indexOf(menuTitle) == -1) continue;
            com.xnx3.wangmarket.superadmin.bean.Application app = YunPluginMessageCache.applicationMap.get(entry.getKey());
            InstallApplicationVO vo = new InstallApplicationVO();
            if (app != null && app.getVersion() > VersionUtil.strToInt((String)((PluginRegister)entry.getValue()).version())) {
                vo.setFindNewVersion(true);
            } else {
                vo.setFindNewVersion(false);
            }
            vo.setPluginRegisterBean(new PluginRegisterBean((PluginRegister)entry.getValue()));
            pluginList.add(vo);
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406\uff0c\u67e5\u770b\u5f53\u524d\u7f51\u5e02\u573a\u5df2\u7ecf\u5b89\u88c5\u7684\u63d2\u4ef6\u5217\u8868");
        model.addAttribute("pluginList", pluginList);
        return "/superadmin/pluginManage/installList/list";
    }

    @RequestMapping(value={"/yunList${url.suffix}"})
    public String yunList(HttpServletRequest request, Model model, @RequestParam(value="menu_title", required=false, defaultValue="") String menuTitle) {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error(model, "\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        LinkedList<com.xnx3.wangmarket.superadmin.bean.Application> list = new LinkedList<com.xnx3.wangmarket.superadmin.bean.Application>();
        list.addAll(YunPluginMessageCache.applicationList);
        if (menuTitle != null && !menuTitle.trim().equals("")) {
            for (com.xnx3.wangmarket.superadmin.bean.Application application : YunPluginMessageCache.applicationList) {
                if (application.getMenuTitle().contains(menuTitle)) continue;
                list.remove(application);
            }
        }
        String dataBaseType = this.applicationContext.getEnvironment().getProperty("spring.datasource.url");
        ArrayList<String> noSupportPluginIdList = new ArrayList<String>();
        if (dataBaseType.indexOf("mysql") > -1) {
            for (com.xnx3.wangmarket.superadmin.bean.Application application : YunPluginMessageCache.applicationList) {
                if (application.getSupportMysql() != 0) continue;
                noSupportPluginIdList.add(application.getId());
            }
        }
        if (dataBaseType.indexOf("sqlite") > -1) {
            for (com.xnx3.wangmarket.superadmin.bean.Application application : YunPluginMessageCache.applicationList) {
                if (application.getSupportSqlite() != 0) continue;
                noSupportPluginIdList.add(application.getId());
            }
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406\uff0c\u67e5\u770b\u7f51\u5e02\u573a\u4e91\u7aef\u63d2\u4ef6\u5217\u8868");
        model.addAttribute("list", list);
        model.addAttribute("page", (Object)YunPluginMessageCache.page);
        model.addAttribute("isUnAuth", (Object)Authorization.copyright);
        model.addAttribute("pluginIds", (Object)PluginManage.getAllInstallPlugin().toString());
        model.addAttribute("unSupportPluginId", noSupportPluginIdList);
        return "/superadmin/pluginManage/yunList/list";
    }

    @RequestMapping(value={"queryYunPluginById${url.suffix}"})
    public String queryYunPluginById(Model model, HttpServletRequest request, @RequestParam(value="plugin_id", required=false, defaultValue="") String pluginId) {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error(model, "\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406\uff0c\u67e5\u8be2\u4e91\u63d2\u4ef6\u63d2\u4ef6\u8be6\u60c5");
        pluginId = SafetyUtil.xssFilter((String)pluginId.trim());
        model.addAttribute("plugin", (Object)YunPluginMessageCache.applicationMap.get(pluginId));
        return "/superadmin/pluginManage/yunList/view";
    }

    @ResponseBody
    @RequestMapping(value={"/deletePlugin${url.suffix}"})
    public BaseVO deletePlugin(HttpServletRequest request, @RequestParam(value="plugin_id", required=false, defaultValue="") String pluginId) {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error("\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        if ((pluginId = SafetyUtil.xssFilter((String)pluginId)) == null || pluginId.trim().equals("")) {
            return this.error("\u63d2ID\u9519\u8bef");
        }
        com.xnx3.wangmarket.superadmin.bean.Application plugin = (com.xnx3.wangmarket.superadmin.bean.Application)this.sqlService.findAloneByProperty(com.xnx3.wangmarket.superadmin.bean.Application.class, "id", (Object)pluginId);
        this.sqlService.delete((Object)plugin);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406\uff0c\u5220\u9664\u63d2\u4ef6", (String)("\u5220\u9664ID\u4e3a" + plugin.getMenuTitle() + "\u7684\u63d2\u4ef6"));
        return this.success();
    }

    private List<com.xnx3.wangmarket.superadmin.bean.Application> setPluginInstallState(List<com.xnx3.wangmarket.superadmin.bean.Application> list) {
        Map installedPluginMap = PluginManage.getAllInstallPlugin();
        com.xnx3.wangmarket.superadmin.bean.Application application2 = null;
        for (com.xnx3.wangmarket.superadmin.bean.Application application2 : list) {
            if (installedPluginMap.get(application2.getId()) != null) {
                application2.setInstallState((short)1);
                continue;
            }
            application2.setInstallState((short)0);
        }
        return list;
    }

    @RequestMapping(value={"/upload${url.suffix}"})
    public String uploadZipFile(Model model, HttpServletRequest request, @RequestParam(value="plugin_id", required=false, defaultValue="") String pluginId) {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error(model, "\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406\uff0c\u8df3\u8f6c\u4e0a\u4f20\u63d2\u4ef6\u538b\u7f29\u5305\u9875\u9762");
        pluginId = SafetyUtil.xssFilter((String)pluginId.trim());
        model.addAttribute("plugin_id", (Object)pluginId);
        return "/superadmin/pluginManage/myList/upload";
    }

    @ResponseBody
    @RequestMapping(value={"/exportPlugin${url.suffix}"})
    public BaseVO exportPlugin(HttpServletRequest request, @RequestParam(value="plugin_id", required=false, defaultValue="") String pluginId) throws IOException, ClassNotFoundException {
        if (!PluginManageController.haveSuperAdminAuth()) {
            return this.error("\u60a8\u6ca1\u6709\u8be5\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        if (pluginId == null || pluginId.trim().equals("")) {
            return this.error("\u63d2\u4ef6id\u683c\u5f0f\u9519\u8bef");
        }
        com.xnx3.wangmarket.superadmin.bean.Application application = YunPluginMessageCache.applicationMap.get(pluginId);
        if (application != null) {
            return this.error("\u8be5\u63d2\u4ef6\u4e0d\u662f\u60a8\u7684\u672c\u5730\u63d2\u4ef6\uff0c\u4e0d\u652f\u6301\u5bfc\u51fa\u3002");
        }
        Map<String, String> pathMap = this.getPluginPath(request, pluginId);
        String classPath = pathMap.get("classPath") + pluginId + File.separator;
        String jspPath = pathMap.get("jspPath") + pluginId + File.separator;
        String staticPath = pathMap.get("staticPath") + pluginId + File.separator;
        File classFile = new File(classPath);
        String classPath_domain = pathMap.get("classPath") + pluginId + "_domain" + File.separator;
        String jspPath_domain = pathMap.get("jspPath") + pluginId + "_domain" + File.separator;
        if (!classFile.exists()) {
            return this.error("\u60a8\u672a\u4f7f\u7528\u8be5\u63d2\u4ef6\u6216\u8005\u63d2\u4ef6\u4fe1\u606f\u9519\u8bef");
        }
        String currentPath = new Global().getClass().getResource("/").getPath();
        String exportRelativePath = "";
        exportRelativePath = currentPath.indexOf("/target/classes/") > -1 ? "static" + File.separator + "plugin" + File.separator + "exportPlugin" + File.separator : "plugin" + File.separator + "exportPlugin" + File.separator;
        String exportAbsolutePath = SystemUtil.getCurrentDir() + File.separator + exportRelativePath;
        LocalServerMode.directoryInit((String)(exportRelativePath + DateUtil.timeForUnix10() + File.separator));
        String newClassPath = exportAbsolutePath + "ROOT" + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "com" + File.separator + "xnx3" + File.separator + "wangmarket" + File.separator + "plugin" + File.separator + pluginId;
        String newStaticPath = exportAbsolutePath + "ROOT" + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "static" + File.separator + "plugin" + File.separator + pluginId;
        String newJspPath = exportAbsolutePath + "ROOT" + File.separator + "WEB-INF" + File.separator + "view" + File.separator + "plugin" + File.separator + pluginId;
        String newClassPath_domain = exportAbsolutePath + "ROOT" + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "com" + File.separator + "xnx3" + File.separator + "wangmarket" + File.separator + "plugin" + File.separator + pluginId + "_domain";
        String newJspPath_domain = exportAbsolutePath + "ROOT" + File.separator + "WEB-INF" + File.separator + "view" + File.separator + "plugin" + File.separator + pluginId + "_domain";
        if (new File(classPath).exists()) {
            this.copyDir(classPath, newClassPath);
        }
        if (new File(jspPath).exists()) {
            this.copyDir(jspPath, newJspPath);
        }
        if (new File(staticPath).exists()) {
            this.copyDir(staticPath, newStaticPath);
        }
        if (new File(classPath_domain).exists()) {
            this.copyDir(classPath_domain, newClassPath_domain);
        }
        if (new File(jspPath_domain).exists()) {
            this.copyDir(jspPath_domain, newJspPath_domain);
        }
        String className = "com.xnx3.wangmarket.plugin." + pluginId + ".Plugin";
        PluginRegister pluginRegister = (PluginRegister)PluginManage.getAllInstallPlugin().get(pluginId);
        if (pluginRegister == null) {
            return this.error("\u672a\u53d1\u73b0\u8fd9\u4e2a\u7c7b: " + className);
        }
        File systemFile = new File(exportAbsolutePath + "ROOT" + File.separator + "system.txt");
        if (!systemFile.exists()) {
            systemFile.createNewFile();
        }
        FileOutputStream outputStream = new FileOutputStream(systemFile);
        JSONObject json = new JSONObject();
        json.put((Object)"pluginId", (Object)pluginId);
        json.put((Object)"menuTitle", (Object)pluginRegister.menuTitle());
        String content = json.toString();
        content = StringUtil.StringToUtf8((String)content);
        byte[] bytes = content.getBytes();
        outputStream.write(bytes, 0, bytes.length);
        outputStream.close();
        final String exportZipRelativePath = exportRelativePath + pluginId + ".zip";
        ZipUtils.dozip(exportAbsolutePath + "ROOT", SystemUtil.getProjectPath() + exportZipRelativePath);
        this.deleteDirectory(new File(exportAbsolutePath), false);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u5bfc\u51fa\u63d2\u4ef6", (String)("\u5bfc\u51faID\u4e3a" + pluginId + "\u7684\u63d2\u4ef6"));
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(300000L);
                    PluginManageController.this.deleteDirectory(new File(SystemUtil.getProjectPath() + exportZipRelativePath), false);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u603b\u7ba1\u7406\u540e\u53f0-\u63d2\u4ef6\u7ba1\u7406\uff0c\u5bfc\u51fa\u63d2\u4ef6");
        if (exportRelativePath.indexOf("static/") == 0) {
            exportRelativePath = exportRelativePath.replace("static/plugin", "plugin");
        }
        return this.success("/" + exportRelativePath + pluginId + ".zip");
    }

    private void copyDir(String oldPath, String newPath) throws IOException {
        File newFile = new File(newPath);
        if (!newFile.exists()) {
            System.out.println(newFile.mkdirs() + "  " + newPath);
        }
        File file = new File(oldPath);
        String[] filePath = file.list();
        if (!new File(newPath).exists()) {
            new File(newPath).mkdirs();
        }
        for (int i = 0; i < filePath.length; ++i) {
            if (new File(oldPath + File.separator + filePath[i]).isDirectory()) {
                this.copyDir(oldPath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
            }
            if (!new File(oldPath + File.separator + filePath[i]).isFile()) continue;
            FileUtil.copyFile((String)(oldPath + File.separator + filePath[i]), (String)(newPath + File.separator + filePath[i]));
        }
    }

    private void unZip(File srcFile, String destDirPath) throws RuntimeException {
        if (!srcFile.exists()) {
            throw new RuntimeException(srcFile.getPath() + ",\u6240\u6307\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(srcFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirPath = destDirPath + File.separator + entry.getName();
                    File dir = new File(dirPath);
                    dir.mkdirs();
                    continue;
                }
                File targetFile = new File(destDirPath + File.separator + entry.getName());
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                try {
                    targetFile.createNewFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                InputStream is = zipFile.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(targetFile);
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                is.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("unzip error from ZipUtils", e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Map<String, String> getPluginPath(HttpServletRequest request, String pluginId) {
        String realPath = request.getServletContext().getRealPath("/");
        HashMap<String, String> pathMap = new HashMap<String, String>();
        String classPath = null;
        String jspPath = null;
        String staticPath = null;
        String rootPath = null;
        String metaJspPath = null;
        String environment = null;
        if (realPath.indexOf("main" + File.separator + "webapp" + File.separator) > -1) {
            rootPath = realPath.substring(0, realPath.length() - 16) + "target" + File.separator + "classes" + File.separator;
            classPath = rootPath + "com" + File.separator + "xnx3" + File.separator + "wangmarket" + File.separator + "plugin" + File.separator;
            jspPath = rootPath + "META-INF" + File.separator + "resources" + File.separator + "WEB-INF" + File.separator + "view" + File.separator + "plugin" + File.separator;
            staticPath = rootPath + "static" + File.separator + "plugin" + File.separator;
            environment = "eclipse";
        } else {
            rootPath = realPath;
            classPath = realPath + "WEB-INF" + File.separator + "classes" + File.separator + "com" + File.separator + "xnx3" + File.separator + "wangmarket" + File.separator + "plugin" + File.separator;
            jspPath = realPath + "WEB-INF" + File.separator + "view" + File.separator + "plugin" + File.separator;
            metaJspPath = realPath + "WEB-INF" + File.separator + "classes" + File.separator + "META-INF" + File.separator + "resources" + File.separator + "WEB-INF" + File.separator + "view" + File.separator;
            staticPath = realPath + "static" + File.separator + "plugin" + File.separator;
            environment = "tomcat";
        }
        pathMap.put("rootPath", rootPath);
        pathMap.put("classPath", classPath);
        pathMap.put("jspPath", jspPath);
        pathMap.put("metaJspPath", metaJspPath);
        pathMap.put("staticPath", staticPath);
        pathMap.put("environment", environment);
        return pathMap;
    }

    class PluginFileFilter
    implements FilenameFilter {
        private String pluginId;

        public PluginFileFilter(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.pluginId) || name.startsWith(this.pluginId + "_");
        }
    }
}

