/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.plugin.templateDevelop.controller;

import com.xnx3.DateUtil;
import com.xnx3.FileUtil;
import com.xnx3.StringUtil;
import com.xnx3.ZipUtil;
import com.xnx3.j2ee.pluginManage.controller.BasePluginController;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.util.AttachmentMode.LocalServerMode;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.LanguageUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.j2ee.vo.UploadFileVO;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.entity.Template;
import com.xnx3.wangmarket.admin.entity.TemplatePage;
import com.xnx3.wangmarket.admin.entity.TemplateVar;
import com.xnx3.wangmarket.admin.service.TemplateService;
import com.xnx3.wangmarket.admin.util.ActionLogUtil;
import com.xnx3.wangmarket.admin.util.SessionUtil;
import com.xnx3.wangmarket.admin.util.TemplateUtil;
import com.xnx3.wangmarket.admin.vo.TemplatePageListVO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/plugin/templateDevelop/"})
public class TemplateDevelopController
extends BasePluginController {
    @Resource
    private SqlService sqlService;
    @Resource
    private TemplateService templateService;
    private static String exportPath = null;

    private static String getExportPath() {
        if (exportPath == null) {
            if (SystemUtil.getProjectPath().indexOf("/target/classes") > -1) {
                exportPath = "websiteTemplate/";
                File file = new File(SystemUtil.getProjectPath() + "websiteTemplate/");
                if (!file.exists()) {
                    file.mkdir();
                    ConsoleUtil.info((String)"\u5f00\u53d1\u73af\u5883\u4e0b\uff0c\u81ea\u52a8\u521b\u5efa websiteTemplate \u6587\u4ef6\u5939\uff0c\u5728 target/classes/ \u4e0b");
                }
            } else {
                exportPath = "websiteTemplate/";
            }
        }
        ConsoleUtil.info((String)("exportPath:" + exportPath));
        return exportPath;
    }

    @RequestMapping(value={"index${url.suffix}"})
    public String index(HttpServletRequest request, Model model) {
        if (!TemplateDevelopController.haveSiteAuth()) {
            return this.error(model, "\u65e0\u6743\u64cd\u4f5c");
        }
        if (!this.clientCheck(request)) {
            return this.error(model, "\u6a21\u7248\u5f00\u53d1\u4ec5\u9650\u672c\u5730\u8fd0\u884c\u4f7f\u7528\uff01\u4ec5\u9650 localhost \u8bbf\u95ee\u65f6\u53ef\u7528\u3002");
        }
        Site site = SessionUtil.getSite();
        model.addAttribute("site", (Object)site);
        TemplatePageListVO tpvo = this.templateService.getTemplatePageListByCache(request);
        model.addAttribute("haveTemplate", (Object)(tpvo.getList() == null || tpvo.getList().size() == 0 ? "0" : "1"));
        String projectPath = SystemUtil.getProjectPath();
        if (System.getProperties().getProperty("os.name").trim().toLowerCase().indexOf("window") > -1 && projectPath.indexOf("/") == 0) {
            projectPath = projectPath.substring(1, projectPath.length());
        }
        model.addAttribute("projectPath", (Object)projectPath);
        model.addAttribute("exportPath", (Object)TemplateDevelopController.getExportPath());
        return "plugin/templateDevelop/index";
    }

    @RequestMapping(value={"saveTemplateName${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO saveTemplateName(HttpServletRequest request, @RequestParam(value="templateName", required=false, defaultValue="") String templateName) {
        if (!TemplateDevelopController.haveSiteAuth()) {
            return this.error("\u65e0\u6743\u64cd\u4f5c");
        }
        if (!this.clientCheck(request)) {
            return this.error("\u6a21\u7248\u5f00\u53d1\u4ec5\u9650\u672c\u5730\u8fd0\u884c\u4f7f\u7528\uff01");
        }
        if ((templateName = StringUtil.filterXss((String)templateName)).length() == 0) {
            return this.error("\u60a8\u8fd8\u6ca1\u586b\u5199\u6a21\u7248\u7f16\u7801\u5462");
        }
        Site site = SessionUtil.getSite();
        Template template = (Template)this.sqlService.findAloneByProperty(Template.class, "name", (Object)templateName);
        if (template != null) {
            return this.error("\u6a21\u7248\u5df2\u5b58\u5728\uff01\u8bf7\u91cd\u65b0\u8d77\u4e2a\u540d\u5427");
        }
        if (site.getTemplateName() != null && site.getTemplateName().length() > 0) {
            System.out.println(SystemUtil.getProjectPath() + TemplateDevelopController.getExportPath() + site.getTemplateName());
            if (!FileUtil.exists((String)(SystemUtil.getProjectPath() + TemplateDevelopController.getExportPath() + site.getTemplateName()))) {
                return this.error("\u6ca1\u6709\u53d1\u73b0\u6a21\u7248\u8d44\u6e90\u6587\u4ef6\uff01\u6a21\u7248\u662f\u4f60\u505a\u7684\u5417\uff1f");
            }
            System.out.println("old----- " + SystemUtil.getProjectPath() + TemplateDevelopController.getExportPath() + site.getTemplateName());
            File file = new File(SystemUtil.getProjectPath() + TemplateDevelopController.getExportPath() + site.getTemplateName());
            file.renameTo(new File(SystemUtil.getProjectPath() + TemplateDevelopController.getExportPath() + templateName));
            System.out.println("new------ " + SystemUtil.getProjectPath() + TemplateDevelopController.getExportPath() + templateName);
        } else {
            File file = new File(SystemUtil.getProjectPath() + TemplateDevelopController.getExportPath() + templateName);
            file.mkdir();
            new File(SystemUtil.getProjectPath() + TemplateDevelopController.getExportPath() + templateName + "/css").mkdir();
            new File(SystemUtil.getProjectPath() + TemplateDevelopController.getExportPath() + templateName + "/js").mkdir();
            new File(SystemUtil.getProjectPath() + TemplateDevelopController.getExportPath() + templateName + "/images").mkdir();
        }
        template = new Template();
        template.setAddtime(DateUtil.timeForUnix10());
        template.setName(templateName);
        template.setUserid(this.getUserId());
        template.setIscommon(Template.ISCOMMON_YES);
        this.sqlService.save((Object)template);
        site = (Site)this.sqlService.findById(Site.class, (Object)site.getId());
        site.setTemplateName(templateName);
        this.sqlService.save((Object)site);
        SessionUtil.setSite(site);
        this.sqlService.updateByHql(TemplatePage.class, "templateName", templateName, "siteid", (Object)site.getId());
        this.sqlService.updateByHql(TemplateVar.class, "templateName", templateName, "siteid", (Object)site.getId());
        TemplateUtil.updateDatabaseTemplateMap(template);
        ActionLogUtil.insertUpdateDatabase(request, site.getId(), "\u6a21\u7248\u5f00\u53d1-\u4fdd\u5b58\u6a21\u7248\u7f16\u7801");
        return this.success();
    }

    @RequestMapping(value={"exportTemplate${url.suffix}"})
    @ResponseBody
    public BaseVO exportTemplate(HttpServletRequest request, HttpServletResponse response, Template temp) throws IOException {
        BaseVO vo;
        if (!TemplateDevelopController.haveSiteAuth()) {
            return this.error("\u65e0\u6743\u64cd\u4f5c");
        }
        if (!this.clientCheck(request)) {
            return this.error("\u6a21\u7248\u5f00\u53d1\u4ec5\u9650\u672c\u5730\u8fd0\u884c\u4f7f\u7528\uff01");
        }
        Site site = SessionUtil.getSite();
        if (site.getTemplateName() == null || site.getTemplateName().length() == 0 || site.getTemplateName().equals("null")) {
            return this.error("\u8bf7\u5148\u8bbe\u7f6e\u7b2c\u4e00\u6b65\uff0c\u8bbe\u7f6e\u6a21\u7248\u540d\u5b57");
        }
        Template template = (Template)this.sqlService.findAloneByProperty(Template.class, "name", (Object)site.getTemplateName());
        if (template == null) {
            template = new Template();
        }
        template.setCompanyname(temp.getCompanyname());
        template.setName(site.getTemplateName());
        template.setRemark(temp.getRemark());
        template.setSiteurl(temp.getSiteurl());
        template.setTerminalDisplay(temp.getTerminalDisplay());
        template.setTerminalIpad(temp.getTerminalIpad());
        template.setTerminalMobile(temp.getTerminalMobile());
        template.setTerminalPc(temp.getTerminalPc());
        template.setType(temp.getType());
        template.setUsername(temp.getUsername());
        this.sqlService.save((Object)template);
        String exportPath = TemplateDevelopController.getExportPath() + site.getTemplateName() + "/";
        LocalServerMode.directoryInit((String)exportPath);
        LocalServerMode.directoryInit((String)"plugin_data/templateDevelop/");
        if (FileUtil.exists((String)(SystemUtil.getProjectPath() + "plugin_data/templateDevelop/template_" + site.getTemplateName() + ".zip"))) {
            FileUtil.deleteFile((String)(SystemUtil.getProjectPath() + "plugin_data/templateDevelop/template_" + site.getTemplateName() + ".zip"));
        }
        if ((vo = this.templateService.exportTemplate(request)).getResult() - 0 == 0) {
            return vo;
        }
        FileUtil.write((String)(SystemUtil.getProjectPath() + exportPath + "template.wscso"), (String)vo.getInfo(), (String)"UTF-8");
        String downUrl = SystemUtil.get((String)"MASTER_SITE_URL") + "plugin_data/templateDevelop/template_" + site.getTemplateName() + ".zip";
        try {
            ZipUtil.zip((String)(SystemUtil.getProjectPath() + exportPath), (String)(SystemUtil.getProjectPath() + "plugin_data/templateDevelop/"), (String)("template_" + site.getTemplateName() + ".zip"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.error(e.getMessage());
        }
        if (downUrl.indexOf("plugin_data") == 0) {
            downUrl = "/" + downUrl;
        }
        return this.success(downUrl);
    }

    @RequestMapping(value={"uploadPreview${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public UploadFileVO uploadPreview(Model model, HttpServletRequest request) {
        UploadFileVO uploadFileVO = new UploadFileVO();
        if (!TemplateDevelopController.haveSiteAuth()) {
            uploadFileVO.setBaseVO(0, "\u65e0\u6743\u64cd\u4f5c");
            return uploadFileVO;
        }
        if (!this.clientCheck(request)) {
            uploadFileVO.setBaseVO(0, "\u6a21\u7248\u5f00\u53d1\u4ec5\u9650\u672c\u5730\u8fd0\u884c\u4f7f\u7528\uff01");
            return uploadFileVO;
        }
        Site site = SessionUtil.getSite();
        if (!AttachmentUtil.isMode((String)"localFile")) {
            uploadFileVO.setBaseVO(0, "\u5b58\u50a8\u65b9\u5f0f\u8bf7\u4f7f\u7528\u670d\u52a1\u5668\u672c\u5730\u5b58\u50a8\u3002\u8bf7\u6309\u7167\u6211\u4eec\u7684\u8bf4\u660e\uff0c\u4f7f\u7528\u672c\u5730\u4e00\u952e\u8fd0\u884c\u5305\u8fdb\u884c\u6a21\u7248\u5f00\u53d1\uff01");
            return uploadFileVO;
        }
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            List imageList = multipartRequest.getFiles("image");
            if (imageList.size() > 0 && !((MultipartFile)imageList.get(0)).isEmpty()) {
                MultipartFile multi = (MultipartFile)imageList.get(0);
                try {
                    uploadFileVO = AttachmentUtil.put((String)(TemplateDevelopController.getExportPath() + site.getTemplateName() + "/preview.jpg"), (InputStream)multi.getInputStream());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                uploadFileVO.setResult(2);
                uploadFileVO.setInfo(LanguageUtil.show((String)"oss_uploadNotFile"));
            }
        } else {
            uploadFileVO.setResult(2);
            uploadFileVO.setInfo(LanguageUtil.show((String)"oss_uploadNotFile"));
        }
        if (uploadFileVO.getResult() == 1) {
            ActionLogUtil.insert(request, "\u6a21\u7248\u5f00\u53d1\uff0c\u4e0a\u4f20preview.jpg\uff1a", uploadFileVO.getUrl());
        }
        return uploadFileVO;
    }

    private boolean clientCheck(HttpServletRequest request) {
        String domain = request.getServerName().toLowerCase();
        return domain.equals("localhost") || domain.equals("127.0.0.1");
    }
}

