/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.plugin.newsSearch.controller;

import com.xnx3.j2ee.pluginManage.controller.BasePluginController;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.wangmarket.admin.entity.News;
import com.xnx3.wangmarket.admin.entity.SiteColumn;
import com.xnx3.wangmarket.plugin.newsSearch.vo.SearchResultVO;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/newsSearch/"})
public class NewsSearchPluginController
extends BasePluginController {
    @Resource
    private SqlService sqlService;

    @RequestMapping(value={"search${url.suffix}"})
    @ResponseBody
    public SearchResultVO search(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="siteid", required=false, defaultValue="0") int siteid, @RequestParam(value="title", required=false, defaultValue="") String title, @RequestParam(value="everyPageNumber", required=false, defaultValue="10") int everyPageNumber) {
        response.addHeader("Access-Control-Allow-Origin", "*");
        SearchResultVO vo = new SearchResultVO();
        if (siteid == 0) {
            vo.setBaseVO(0, "\u8bf7\u4f20\u5165\u7ad9\u70b9\u7f16\u53f7{site.id}");
            return vo;
        }
        if (title.length() == 0) {
            vo.setBaseVO(0, "\u8bf7\u4f20\u5165\u8981\u641c\u7d22\u7684\u5173\u952e\u8bcd");
            return vo;
        }
        if (everyPageNumber > 30 || everyPageNumber < 2) {
            vo.setBaseVO(0, "everyPageNumber \u6bcf\u9875\u663e\u793a\u591a\u5c11\u6761\u4fe1\u606f\uff0c\u8303\u56f4\u5fc5\u987b\u5728 2\uff5e30 \u4e4b\u95f4");
            return vo;
        }
        Sql sql = new Sql(request);
        sql.setSearchTable("news");
        sql.appendWhere("siteid = " + siteid + " AND status = " + News.STATUS_NORMAL);
        sql.appendWhere("( type = " + News.TYPE_NEWS + " OR type = " + News.TYPE_IMAGENEWS + " OR type = " + SiteColumn.TYPE_LIST + ")");
        sql.setSearchColumn(new String[]{"title"});
        int count = this.sqlService.count("news", sql.getWhere());
        Page page = new Page(count, everyPageNumber, request);
        sql.setSelectFromAndPage("SELECT id,addtime,title,titlepic,intro,cid FROM news", page);
        sql.setDefaultOrderBy("addtime DESC");
        List list = this.sqlService.findMapBySql(sql);
        vo.setList(list);
        vo.setPage(page);
        return vo;
    }
}

