/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.domain.mq;

import com.xnx3.DateUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.wangmarket.domain.mq.JavaMQReceive;
import com.xnx3.wangmarket.domain.mq.JavaQueueBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JavaMQUtils {
    public static Map<String, JavaMQReceive> receiveInterfaceMap = new HashMap<String, JavaMQReceive>();
    public static Map<String, List<JavaQueueBean>> cacheMap = new HashMap<String, List<JavaQueueBean>>();
    public static final int EXPIRE_TIME = 1;

    public static void sendMessage(String pluginId, String content) {
        if (cacheMap.get(pluginId) == null) {
            cacheMap.put(pluginId, new ArrayList());
        }
        JavaQueueBean queue = new JavaQueueBean();
        queue.setAddtime(DateUtil.timeForUnix10());
        queue.setContent(content);
        cacheMap.get(pluginId).add(queue);
        if (receiveInterfaceMap.get(pluginId) != null) {
            receiveInterfaceMap.get(pluginId).receive(content);
        }
    }

    public static void addReceiveListener(String pluginId, JavaMQReceive receive) {
        receiveInterfaceMap.put(pluginId, receive);
    }

    static {
        System.out.println("static");
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("start domain update thread -- javamq");
                ConsoleUtil.info((String)"start domain update thread -- javamq");
                block2: while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    int currentTime = DateUtil.timeForUnix10();
                    Iterator<Map.Entry<String, List<JavaQueueBean>>> iterator = cacheMap.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        Map.Entry<String, List<JavaQueueBean>> entry = iterator.next();
                        List<JavaQueueBean> list = entry.getValue();
                        if (list == null || list.size() <= 0) continue;
                        JavaQueueBean queue = list.get(0);
                        while (queue != null && currentTime - queue.getAddtime() > 1) {
                            list.remove(0);
                            if (list.size() > 0) {
                                queue = list.get(0);
                                continue;
                            }
                            queue = null;
                        }
                        cacheMap.put(entry.getKey(), list);
                    }
                    break;
                }
            }
        }).start();
    }
}

