/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.domain.mq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.xnx3.wangmarket.admin.util.RabbitUtil;
import com.xnx3.wangmarket.domain.bean.PluginMQ;
import com.xnx3.wangmarket.domain.mq.JavaMQReceive;
import com.xnx3.wangmarket.domain.mq.JavaMQUtil;
import com.xnx3.wangmarket.domain.mq.ReceiveDomainMQ;
import com.xnx3.wangmarket.domain.util.PluginCache;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.sf.json.JSONObject;

public class DomainMQ {
    public static RabbitUtil rabbitUtil = new RabbitUtil();

    public static void send(String pluginId, String content) {
        System.out.println(content);
        if (RabbitUtil.isUse) {
            RabbitUtil.sendTopicMessage("com.xnx3.wangmarket.plugin." + pluginId, content);
        } else {
            JavaMQUtil.sendMessage(pluginId, content);
        }
    }

    public static void receive(String pluginId, final ReceiveDomainMQ receiveDomainMQ) {
        if (RabbitUtil.isUse) {
            try {
                RabbitUtil.receive("com.xnx3.wangmarket.plugin." + pluginId, (Consumer)new DefaultConsumer(RabbitUtil.rabbitUtil.getChannel()){

                    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                        String content = new String(body, "UTF-8");
                        try {
                            receiveDomainMQ.receive(content);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        } else {
            JavaMQUtil.addReceiveListener(pluginId, new JavaMQReceive(){

                @Override
                public void receive(String content) {
                    receiveDomainMQ.receive(content);
                }
            });
        }
    }

    public static void receive(final String pluginId) {
        if (RabbitUtil.isUse) {
            try {
                RabbitUtil.receive("com.xnx3.wangmarket.plugin." + pluginId, (Consumer)new DefaultConsumer(RabbitUtil.rabbitUtil.getChannel()){

                    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                        String content = new String(body, "UTF-8");
                        DomainMQ.receiveContentDispose(pluginId, content);
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        } else {
            JavaMQUtil.addReceiveListener(pluginId, new JavaMQReceive(){

                @Override
                public void receive(String content) {
                    DomainMQ.receiveContentDispose(pluginId, content);
                }
            });
        }
    }

    protected static void receiveContentDispose(String pluginId, String content) {
        PluginMQ mq = new PluginMQ(content);
        Map<String, Object> map = PluginCache.getPluginMap(mq.getSiteid(), pluginId);
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        JSONObject json = mq.getMqContentJson();
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.equals("siteid") || key.equals("domain") || key.equals("bindDomain")) continue;
            String value = null;
            value = json.get(key) == null ? "" : json.get(key).toString();
            map.put(key, value);
        }
        PluginCache.setPluginMap(mq.getSiteid(), pluginId, map);
    }
}

