/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.domain.controller;

import com.xnx3.DateUtil;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.func.ApplicationProperties;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.IpUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.util.TerminalDetection;
import com.xnx3.net.OSSUtil;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.domain.G;
import com.xnx3.wangmarket.domain.Log;
import com.xnx3.wangmarket.domain.bean.RequestInfo;
import com.xnx3.wangmarket.domain.bean.SimpleSite;
import com.xnx3.wangmarket.domain.bean.TextBean;
import com.xnx3.wangmarket.domain.controller.BaseController;
import com.xnx3.wangmarket.domain.pluginManage.interfaces.manage.DomainPluginManage;
import com.xnx3.wangmarket.domain.util.GainSource;
import com.xnx3.wangmarket.domain.vo.SImpleSiteVO;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/"})
public class PublicController
extends BaseController {
    @Resource
    private SqlService sqlService;
    @Value(value="masterSiteUrl")
    private String masterSiteUrl;

    @RequestMapping(value={"*.html"})
    public String dns(HttpServletRequest request, HttpServletResponse response, Model model, @RequestParam(value="htmlFile", required=false, defaultValue="") String htmlFile) {
        boolean isMobile;
        if (htmlFile.length() == 0) {
            htmlFile = request.getServletPath();
            htmlFile = htmlFile.replace("/", "");
        } else {
            htmlFile = htmlFile + ".html";
        }
        SImpleSiteVO simpleSiteVO = this.getCurrentSimpleSite(request);
        if (htmlFile.equals("index.html") && (simpleSiteVO == null || simpleSiteVO.getResult() - 1 != 0) && SystemUtil.get((String)"MASTER_SITE_URL").indexOf("://" + request.getServerName()) > 0) {
            return this.redirect("login.do");
        }
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setHtmlFile(htmlFile);
        requestInfo.setIp(IpUtil.getIpAddress((HttpServletRequest)request));
        requestInfo.setReferer(request.getHeader("referer"));
        requestInfo.setServerName(request.getServerName());
        requestInfo.setTime(DateUtil.timeForUnix10());
        requestInfo.setUserAgent(request.getHeader("User-Agent"));
        Log.requestLog(request, requestInfo, simpleSiteVO);
        if (simpleSiteVO.getResult() - 0 == 0) {
            if (!this.isUnInstallRequest()) {
                return "domain/welcome";
            }
            model.addAttribute("adminUrl", (Object)this.getAdminLoginUrl());
            return "domain/notFindDomain";
        }
        SimpleSite simpleSite = simpleSiteVO.getSimpleSite();
        if (simpleSite.getState() != null && simpleSite.getState() - Site.STATE_FREEZE == 0) {
            model.addAttribute("url", (Object)(simpleSiteVO.getServerName() + "/" + htmlFile));
            return "domain/pause";
        }
        String html = GainSource.get(simpleSite, htmlFile).getText();
        if (html == null) {
            if (AttachmentUtil.isMode((String)"aliyunOSS") && OSSUtil.getOSSClient() == null) {
                System.out.println("\u60a8\u672a\u5f00\u542fOSS\u5bf9\u8c61\u5b58\u50a8\u670d\u52a1\uff01\u7f51\u7ad9\u8bbf\u95ee\u662f\u5fc5\u987b\u901a\u8fc7\u8bfbOSS\u6570\u636e\u624d\u80fd\u5c55\u73b0\u51fa\u6765\u7684\u3002\u5f00\u542f\u53ef\u53c2\u8003\uff1ahttp://www.guanleiming.com/2327.html");
            }
            if (htmlFile.equals("index.html")) {
                if (!this.isUnInstallRequest()) {
                    return "domain/welcome";
                }
                model.addAttribute("adminUrl", (Object)this.getAdminLoginUrl());
                return "domain/notFindIndexHtml";
            }
            return "domain/404";
        }
        if (simpleSite.getTemplateId() - 6 == 0 && html.indexOf("<meta name=\"viewport\"") == -1) {
            String equiv = "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">";
            int ins = -1;
            int equivInt = html.indexOf(equiv);
            if (equivInt > -1) {
                ins = equivInt + equiv.length();
            }
            html = StringUtil.insert((String)html, (String)"<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, user-scalable=no\">", (int)ins);
        }
        html = this.replaceHtmlTag(simpleSite, html);
        try {
            html = DomainPluginManage.manage(html, simpleSite, requestInfo);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        model.addAttribute("html", (Object)html);
        if (simpleSite.getClient() - Site.CLIENT_WAP == 0 && !(isMobile = TerminalDetection.checkMobileOrPc((HttpServletRequest)request))) {
            model.addAttribute("url", (Object)(AttachmentUtil.netUrl() + "site/" + simpleSite.getId() + "/" + htmlFile));
            return "domain/pcPreview";
        }
        return "domain/display";
    }

    private String getAdminLoginUrl() {
        String rabbitmqHost = ApplicationProperties.getProperty((String)"spring.rabbitmq.host");
        if (rabbitmqHost == null || rabbitmqHost.length() == 0) {
            return "/";
        }
        return SystemUtil.get((String)"MASTER_SITE_URL");
    }

    private boolean isUnInstallRequest() {
        return SystemUtil.get((String)"IW_AUTO_INSTALL_USE") == null || !SystemUtil.get((String)"IW_AUTO_INSTALL_USE").equals("true");
    }

    @RequestMapping(value={"sitemap.xml"})
    public String sitemap(HttpServletRequest request, Model model) {
        SImpleSiteVO simpleSiteVO = this.getCurrentSimpleSite(request);
        if (simpleSiteVO.getResult() - 0 == 0) {
            return this.error404();
        }
        this.alonePageRequestLog(request, "sitemap.xml", simpleSiteVO);
        TextBean textBean = GainSource.get(simpleSiteVO.getSimpleSite(), "sitemap.xml");
        String sitemapXml = textBean.getText();
        if (sitemapXml == null || sitemapXml.length() == 0) {
            return this.error404();
        }
        model.addAttribute("html", (Object)sitemapXml);
        return "domain/display";
    }

    @RequestMapping(value={"robots.txt"})
    public String robots(HttpServletRequest request, HttpServletResponse response, Model model) {
        SImpleSiteVO simpleSiteVO = this.getCurrentSimpleSite(request);
        if (simpleSiteVO.getResult() - 0 == 0) {
            return this.error404();
        }
        this.alonePageRequestLog(request, "robots.txt", simpleSiteVO);
        TextBean textBean = GainSource.get(simpleSiteVO.getSimpleSite(), "robots.txt");
        String content = textBean.getText();
        if (content == null || content.length() == 0) {
            return this.error404();
        }
        model.addAttribute("html", (Object)content);
        return "domain/robots";
    }

    private void alonePageRequestLog(HttpServletRequest request, String requestFileName, SImpleSiteVO simpleSiteVO) {
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setHtmlFile(requestFileName);
        requestInfo.setIp(IpUtil.getIpAddress((HttpServletRequest)request));
        requestInfo.setReferer(request.getHeader("referer"));
        requestInfo.setServerName(request.getServerName());
        requestInfo.setTime(DateUtil.timeForUnix10());
        requestInfo.setUserAgent(request.getHeader("User-Agent"));
        Log.requestLog(request, requestInfo, simpleSiteVO);
    }

    private SImpleSiteVO getCurrentSimpleSite(HttpServletRequest request) {
        SImpleSiteVO vo;
        String serverName = request.getParameter("domain");
        if (serverName == null || serverName.length() == 0) {
            serverName = request.getServerName();
        }
        if ((vo = (SImpleSiteVO)request.getSession().getAttribute("SImpleSiteVO")) != null) {
            vo.setSourceBySession(true);
            return vo;
        }
        vo = new SImpleSiteVO();
        if (serverName == null || serverName.length() == 0) {
            serverName = request.getServerName();
        }
        vo.setServerName(serverName);
        SimpleSite simpleSite = null;
        if (!serverName.equals("localhost") && !serverName.equals("127.0.0.1")) {
            String twoDomain = null;
            for (int i = 0; i < G.getAutoAssignDomain().length; ++i) {
                if (serverName.indexOf("." + G.getAutoAssignDomain()[i]) <= -1) continue;
                twoDomain = serverName.replace("." + G.getAutoAssignDomain()[i], "");
            }
            if (twoDomain != null) {
                simpleSite = G.getDomain(twoDomain);
            }
            if (simpleSite == null) {
                simpleSite = G.getBindDomain(serverName);
            }
        }
        if (simpleSite == null) {
            vo.setBaseVO(0, "\u7f51\u7ad9\u6ca1\u53d1\u73b0\uff0c\u8fc7\u4f1a\u5728\u6765\u770b\u770b\u5427");
            return vo;
        }
        vo.setSimpleSite(simpleSite);
        request.getSession().setAttribute("SImpleSiteVO", (Object)vo);
        return vo;
    }

    public String replaceHtmlTag(SimpleSite simpleSite, String html) {
        html = html.replaceAll("src=\"data/", "src=\"" + AttachmentUtil.netUrl() + "site/" + simpleSite.getId() + "/data/");
        html = html.replaceAll("src=\"news/", "src=\"" + AttachmentUtil.netUrl() + "site/" + simpleSite.getId() + "/news/");
        html = html.replaceAll("/\\*(.*?)\\*/", "");
        return html;
    }
}

