/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.domain.bean;

import com.xnx3.wangmarket.admin.entity.Site;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;

public class SimpleSite
implements Serializable {
    private int id;
    private String domain;
    private String bindDomain;
    private int client;
    private int templateId;
    private Short state;
    private int siteid;
    private Map<String, Map<String, Object>> plugin = new HashMap<String, Map<String, Object>>();

    public SimpleSite(Site site) {
        if (site != null) {
            this.siteid = this.id = site.getId().intValue();
            this.domain = site.getDomain();
            this.client = site.getClient().shortValue();
            this.bindDomain = site.getBindDomain();
            this.templateId = site.getTemplateId() != null ? site.getTemplateId() : 0;
            this.state = site.getState();
        }
    }

    public SimpleSite() {
    }

    public void clone(SimpleSite originalSimpleSite) {
        this.bindDomain = originalSimpleSite.getBindDomain();
        this.client = originalSimpleSite.getClient();
        this.domain = originalSimpleSite.getDomain();
        this.id = originalSimpleSite.getId();
        this.plugin = originalSimpleSite.getPlugin();
        this.state = originalSimpleSite.getState();
        this.templateId = originalSimpleSite.getTemplateId();
        this.siteid = this.id;
        if (this.plugin == null) {
            this.plugin = new HashMap<String, Map<String, Object>>();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.siteid = id;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        if (domain.equals("null")) {
            this.domain = "";
        }
        this.domain = domain;
    }

    public int getClient() {
        return this.client;
    }

    public void setClient(int client) {
        this.client = client;
    }

    public String getBindDomain() {
        return this.bindDomain;
    }

    public void setBindDomain(String bindDomain) {
        if (bindDomain.equals("null")) {
            this.bindDomain = "";
        }
        this.bindDomain = bindDomain;
    }

    @Column(name="template_id")
    public int getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    public Short getState() {
        return this.state;
    }

    public void setState(Short state) {
        this.state = state;
    }

    public Map<String, Map<String, Object>> getPlugin() {
        if (this.plugin == null) {
            return new HashMap<String, Map<String, Object>>();
        }
        return this.plugin;
    }

    public void setPlugin(Map<String, Map<String, Object>> plugin) {
        this.plugin = plugin;
    }

    public boolean isUsePlugin(String pluginId) {
        if (this.plugin == null) {
            return false;
        }
        return this.plugin.get(pluginId) != null;
    }

    public int getSiteid() {
        return this.siteid;
    }

    public void setSiteid(int siteid) {
        this.id = siteid;
        this.siteid = siteid;
    }

    public String toString() {
        return "SimpleSite [id=" + this.id + ", domain=" + this.domain + ", bindDomain=" + this.bindDomain + ", client=" + this.client + ", templateId=" + this.templateId + ", state=" + this.state + ", plugin=" + this.plugin + "]";
    }
}

