/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.agencyadmin.service.impl;

import com.xnx3.DateUtil;
import com.xnx3.MD5Util;
import com.xnx3.StringUtil;
import com.xnx3.exception.NotReturnValueException;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.entity.UserRole;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.IpUtil;
import com.xnx3.j2ee.util.LanguageUtil;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.service.SiteService;
import com.xnx3.wangmarket.admin.vo.SiteVO;
import com.xnx3.wangmarket.admin.vo.UserVO;
import com.xnx3.wangmarket.agencyadmin.Func;
import com.xnx3.wangmarket.agencyadmin.entity.Agency;
import com.xnx3.wangmarket.agencyadmin.entity.SiteSizeChange;
import com.xnx3.wangmarket.agencyadmin.service.TransactionalService;
import com.xnx3.wangmarket.agencyadmin.util.SessionUtil;
import com.xnx3.wangmarket.agencyadmin.util.SiteSizeChangeLog;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="transactionalService")
@Transactional
public class TransactionalServiceImpl
implements TransactionalService {
    @Resource
    private SqlDAO sqlDAO;
    @Resource
    private SiteService siteService;

    @Override
    public BaseVO transferSiteSizeToSubAgency(HttpServletRequest request, int targetAgencyId, int transferSiteSize) {
        BaseVO vo = new BaseVO();
        if (transferSiteSize < 1) {
            vo.setBaseVO(0, "\u8bf7\u8f93\u5165\u8981\u5145\u503c\u7ad9\u5e01\u7684\u6570\u91cf\uff01");
            return vo;
        }
        Agency shiroMyAgency = Func.getMyAgency();
        Agency myAgency = (Agency)this.sqlDAO.findById(Agency.class, (Object)shiroMyAgency.getId());
        if (myAgency.getSiteSize() - transferSiteSize <= 0) {
            vo.setBaseVO(0, "\u60a8\u5f53\u524d\u53ea\u62e5\u6709" + myAgency.getSiteSize() + "\u7ad9\u5e01\uff01\u7ed9\u4e0b\u7ea7\u5145\u503c\u91d1\u989d\u8d85\u51fa\uff0c\u5145\u503c\u5931\u8d25\uff01");
            ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)myAgency.getId(), (String)"warn", (String)("\u7ed9\u4e0b\u7ea7\u4ee3\u7406\u5145\u503c\u7ad9\u5e01\uff1a" + vo.getInfo()));
            return vo;
        }
        Agency agency = (Agency)this.sqlDAO.findById(Agency.class, targetAgencyId);
        if (agency.getParentId() - myAgency.getId() != 0) {
            vo.setBaseVO(0, "\u8981\u5145\u503c\u7684\u4ee3\u7406\u4e0d\u662f\u60a8\u7684\u76f4\u5c5e\u4e0b\u7ea7\uff0c\u65e0\u6cd5\u5145\u503c");
            ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)myAgency.getId(), (String)"warn", (String)("\u7ed9\u4e0b\u7ea7\u4ee3\u7406\u5145\u503c\u7ad9\u5e01\uff1a" + vo.getInfo()));
            return vo;
        }
        myAgency.setSiteSize(myAgency.getSiteSize() - transferSiteSize);
        this.sqlDAO.save((Object)myAgency);
        SiteSizeChange ssc = new SiteSizeChange();
        ssc.setAddtime(DateUtil.timeForUnix10());
        ssc.setAgencyId(myAgency.getId());
        ssc.setChangeAfter(myAgency.getSiteSize());
        ssc.setChangeBefore(myAgency.getSiteSize() + transferSiteSize);
        ssc.setGoalid(agency.getId());
        ssc.setSiteSizeChange(0 - transferSiteSize);
        ssc.setUserid(myAgency.getUserid());
        this.sqlDAO.save((Object)ssc);
        agency.setSiteSize(agency.getSiteSize() + transferSiteSize);
        this.sqlDAO.save((Object)agency);
        SiteSizeChange ssc_other = new SiteSizeChange();
        ssc_other.setAddtime(DateUtil.timeForUnix10());
        ssc_other.setAgencyId(agency.getId());
        ssc_other.setChangeAfter(agency.getSiteSize());
        ssc_other.setChangeBefore(agency.getSiteSize() - transferSiteSize);
        ssc_other.setGoalid(myAgency.getId());
        ssc_other.setSiteSizeChange(transferSiteSize);
        ssc_other.setUserid(agency.getUserid());
        this.sqlDAO.save((Object)ssc_other);
        String ip = IpUtil.getIpAddress((HttpServletRequest)request);
        SiteSizeChangeLog.xiaofei(myAgency.getName(), "\u7ed9\u4e0b\u7ea7\u4ee3\u7406" + agency.getName() + "\u5145\u503c\u7ad9\u5e01", ssc.getSiteSizeChange(), myAgency.getSiteSize() + transferSiteSize, myAgency.getSiteSize(), agency.getId(), ip);
        User user = (User)this.sqlDAO.findById(User.class, (Object)agency.getUserid());
        SiteSizeChangeLog.chongzhi(user.getId(), user.getUsername(), agency.getName(), "\u76f4\u5c5e\u4e0a\u7ea7\u7ed9\u5145\u503c\u7ad9\u5e01", transferSiteSize, agency.getSiteSize() - transferSiteSize, agency.getSiteSize(), myAgency.getId(), ip);
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)agency.getId(), (String)("\u7ed9\u4e0b\u7ea7\u4ee3\u7406" + agency.getName() + "\u5145\u503c\u7ad9\u5e01\uff1a" + transferSiteSize));
        SessionUtil.setAgency(myAgency);
        return vo;
    }

    @Override
    public BaseVO siteXuFei(HttpServletRequest request, int siteid, int year) {
        BaseVO vo = new BaseVO();
        if (year < 1) {
            vo.setBaseVO(0, "\u8bf7\u8f93\u5165\u8981\u7eed\u8d39\u7684\u5e74\u6570\uff0c1\uff5e10");
            return vo;
        }
        if (year > 10) {
            vo.setBaseVO(0, "\u8bf7\u8f93\u5165\u8981\u7eed\u8d39\u7684\u5e74\u6570\uff0c1\uff5e10\uff0c\u6700\u5927\u53ef\u5f80\u540e\u7eed\u8d3910\u5e74");
            return vo;
        }
        Agency shiroMyAgency = Func.getMyAgency();
        Agency myAgency = (Agency)this.sqlDAO.findById(Agency.class, (Object)shiroMyAgency.getId());
        if (myAgency.getSiteSize() - year <= 0) {
            vo.setBaseVO(0, "\u60a8\u5f53\u524d\u53ea\u62e5\u6709" + myAgency.getSiteSize() + "\u7ad9\u5e01\uff01\u7eed\u8d39\u82b1\u8d39\u7684\u91d1\u989d\u8d85\u51fa\uff0c\u7eed\u8d39\u5931\u8d25\uff01");
            return vo;
        }
        Site site = (Site)this.sqlDAO.findById(Site.class, siteid);
        User user = (User)this.sqlDAO.findById(User.class, (Object)site.getUserid());
        if (user.getReferrerid() - myAgency.getUserid() != 0) {
            vo.setBaseVO(0, "\u8981\u7eed\u8d39\u7684\u7f51\u7ad9\u4e0d\u662f\u60a8\u7684\u76f4\u5c5e\u4e0b\u7ea7\uff0c\u65e0\u6cd5\u7eed\u8d39");
            ActionLogUtil.insertError((HttpServletRequest)request, (String)("myAgency.id:" + myAgency.getId() + ",\u7ed9\u6211\u5f00\u901a\u7684\u7ad9\u70b9\u7eed\u8d39\uff1a" + vo.getInfo()));
            return vo;
        }
        long expiretime = site.getExpiretime().intValue();
        System.out.println(expiretime += (long)(year * 31622400));
        if (expiretime > Integer.MAX_VALUE) {
            vo.setBaseVO(0, "\u7f51\u7ad9\u5f80\u540e\u7eed\u8d39\u6700\u5927\u53ef\u7eed\u8d39\u52302038\u5e74\uff01\u6b64\u5e74\u4efd\u540e\u5c06\u5f00\u542f\u5168\u65b0\u5efa\u7ad9\u65f6\u4ee3\u3002");
            return vo;
        }
        if (expiretime > (long)(DateUtil.timeForUnix10() + 316224000)) {
            vo.setBaseVO(0, "\u7f51\u7ad9\u5f80\u540e\u7eed\u8d39\u6700\u5927\u4e3a10\u5e74\uff01\u5f53\u524d\u7f51\u7ad9\u5df2\u7ecf\u5ef6\u671f\u5f88\u591a\u5e74\u4e86\uff0c\u4e0d\u9700\u8981\u5728\u8fdb\u884c\u5ef6\u671f\u4e86");
            return vo;
        }
        String ip = IpUtil.getIpAddress((HttpServletRequest)request);
        myAgency.setSiteSize(myAgency.getSiteSize() - year);
        this.sqlDAO.save((Object)myAgency);
        SiteSizeChange ssc = new SiteSizeChange();
        ssc.setAddtime(DateUtil.timeForUnix10());
        ssc.setAgencyId(myAgency.getId());
        ssc.setChangeAfter(myAgency.getSiteSize());
        ssc.setChangeBefore(myAgency.getSiteSize() + year);
        ssc.setGoalid(site.getId());
        ssc.setSiteSizeChange(0 - year);
        ssc.setUserid(myAgency.getUserid());
        this.sqlDAO.save((Object)ssc);
        SiteSizeChangeLog.xiaofei(myAgency.getName(), "\u7ed9\u7f51\u7ad9" + site.getName() + "\u7eed\u8d39" + year + "\u5e74", year, myAgency.getSiteSize() + year, myAgency.getSiteSize(), site.getId(), ip);
        site.setExpiretime(site.getExpiretime() + year * 31622400);
        this.sqlDAO.save((Object)site);
        String daoqishijian = "";
        try {
            daoqishijian = DateUtil.dateFormat((long)site.getExpiretime().intValue(), (String)"yyyy\u5e74MM\u6708dd\u65e5");
        }
        catch (NotReturnValueException e) {
            e.printStackTrace();
        }
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)site.getId(), (String)("\u7ed9\u7f51\u7ad9" + site.getName() + "\u7eed\u8d39" + year + "\u5e74\u3002\u7f51\u7ad9\u7eed\u8d39\u540e\uff0c\u65e5\u671f\u5230" + daoqishijian));
        SessionUtil.setAgency(myAgency);
        return vo;
    }

    @Override
    public BaseVO agencyCreateSite(HttpServletRequest request, Agency agency, User user, Site site, String email) {
        BaseVO vo = new BaseVO();
        if (agency.getSiteSize() == 0) {
            vo.setBaseVO(0, "\u60a8\u7684\u8d26\u6237\u4f59\u989d\u8fd8\u5269 " + agency.getSiteSize() + " \u7ad9\uff0c\u4e0d\u8db3\u4ee5\u518d\u5f00\u901a\u7f51\u7ad9\uff01\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u5145\u503c");
            return vo;
        }
        if (site.getClient() == 0) {
            vo.setBaseVO(0, "\u8bf7\u9009\u62e9\u7ad9\u70b9\u7c7b\u578b\uff0c\u662f\u7535\u8111\u7f51\u7ad9\u5462\uff0c\u8fd8\u662f\u624b\u673a\u7f51\u7ad9\u5462\uff1f");
            return vo;
        }
        if (site.getName().length() == 0 || site.getName().length() > 30) {
            vo.setBaseVO(0, "\u8bf7\u8f93\u51651\uff5e30\u4e2a\u5b57\u7b26\u7684\u8981\u5efa\u7acb\u7684\u7ad9\u70b9\u540d\u5b57");
            return vo;
        }
        user.setPhone(StringUtil.filterXss((String)Sql.filter((String)site.getPhone())));
        user.setEmail(StringUtil.filterXss((String)Sql.filter((String)email)));
        user.setReferrerid(agency.getUserid());
        UserVO userVO = this.regUser(user, request, false);
        if (userVO.getResult() == 1) {
            site.setExpiretime(DateUtil.timeForUnix10() + 31622400);
            site.setmShowBanner(Site.MSHOWBANNER_SHOW);
            SiteVO siteVO = this.siteService.saveSite(site, userVO.getUser().getId(), request);
            if (siteVO.getResult() - 1 == 0) {
                agency.setSiteSize(agency.getSiteSize() - 1);
                this.sqlDAO.save((Object)agency);
                SiteSizeChange ssc = new SiteSizeChange();
                ssc.setAddtime(DateUtil.timeForUnix10());
                ssc.setAgencyId(agency.getId());
                ssc.setChangeAfter(agency.getSiteSize());
                ssc.setChangeBefore(agency.getSiteSize() + 1);
                ssc.setGoalid(siteVO.getSite().getId());
                ssc.setSiteSizeChange(-1);
                ssc.setUserid(agency.getUserid());
                this.sqlDAO.save((Object)ssc);
                SiteSizeChangeLog.xiaofei(agency.getName(), "\u4ee3\u7406\u5f00\u901a\u7f51\u7ad9\uff1a" + site.getName(), ssc.getSiteSizeChange(), ssc.getChangeBefore(), ssc.getChangeAfter(), ssc.getGoalid(), IpUtil.getIpAddress((HttpServletRequest)request));
                ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)site.getId(), (String)("\u5f00\u901a\u7f51\u7ad9\uff1a" + site.getName()));
                vo.setInfo(userVO.getUser().getId() + "_" + TransactionalServiceImpl.passwordMD5(userVO.getUser().getPassword()));
            } else {
                vo.setBaseVO(0, "\u6dfb\u52a0\u7528\u6237\u6210\u529f\uff0c\u4f46\u6dfb\u52a0\u7ad9\u70b9\u5931\u8d25\uff01");
            }
        } else {
            vo.setBaseVO(0, userVO.getInfo());
        }
        return vo;
    }

    @Override
    public UserVO regUser(User user, HttpServletRequest request, boolean isAgency) {
        UserVO baseVO = new UserVO();
        user.setUsername(StringUtil.filterXss((String)user.getUsername()));
        user.setEmail(SafetyUtil.filter((String)user.getEmail()));
        user.setPhone(SafetyUtil.filter((String)user.getPhone()));
        if (user.getUsername() == null || user.getUsername().equals("")) {
            baseVO.setBaseVO(0, LanguageUtil.show((String)"user_userNameToLong"));
        }
        if (this.sqlDAO.findByProperty(User.class, "username", (Object)user.getUsername()).size() > 0) {
            baseVO.setBaseVO(0, LanguageUtil.show((String)"user_regFailureForUsernameAlreadyExist"));
            return baseVO;
        }
        if (this.sqlDAO.findByProperty(User.class, "email", (Object)user.getEmail()).size() > 0) {
            user.setEmail("");
        }
        if (user.getPhone() != null && user.getPhone().length() > 0 && this.sqlDAO.findByProperty(User.class, "phone", (Object)user.getPhone()).size() > 0) {
            if (isAgency) {
                baseVO.setBaseVO(0, LanguageUtil.show((String)"user_regFailureForPhoneAlreadyExist"));
                return baseVO;
            }
            user.setPhone("");
        }
        user.setRegip(IpUtil.getIpAddress((HttpServletRequest)request));
        user.setLastip(IpUtil.getIpAddress((HttpServletRequest)request));
        user.setRegtime(Integer.valueOf(DateUtil.timeForUnix10()));
        user.setLasttime(Integer.valueOf(DateUtil.timeForUnix10()));
        user.setNickname(user.getUsername());
        user.setAuthority(isAgency ? SystemUtil.get((String)"AGENCY_ROLE") + "" : SystemUtil.get((String)"USER_REG_ROLE"));
        user.setCurrency(Integer.valueOf(0));
        user.setFreezemoney(Integer.valueOf(0));
        user.setMoney(Integer.valueOf(0));
        user.setIsfreeze(User.ISFREEZE_NORMAL);
        user.setHead("default.png");
        Random random = new Random();
        user.setSalt(random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "");
        String md5Password = new Md5Hash((Object)user.getPassword(), (Object)user.getSalt(), 2).toString();
        user.setPassword(md5Password);
        this.sqlDAO.save((Object)user);
        if (user.getId() > 0) {
            UserRole userRole = new UserRole();
            int roleid = 0;
            roleid = isAgency ? SystemUtil.getInt((String)"AGENCY_ROLE") : SystemUtil.getInt((String)"USER_REG_ROLE");
            userRole.setRoleid(Integer.valueOf(roleid));
            userRole.setUserid(user.getId());
            this.sqlDAO.save((Object)userRole);
            baseVO.setBaseVO(1, LanguageUtil.show((String)"user_regSuccess"));
            baseVO.setUser(user);
        } else {
            baseVO.setBaseVO(0, LanguageUtil.show((String)"user_regFailure"));
        }
        return baseVO;
    }

    private static String passwordMD5(String password) {
        String p1 = password.substring(0, 8);
        String p2 = password.substring(8, 16);
        String p3 = password.substring(16, 24);
        String p4 = password.substring(24, 32);
        return MD5Util.MD5((String)p1) + MD5Util.MD5((String)p2) + MD5Util.MD5((String)p3) + MD5Util.MD5((String)p4);
    }
}

