/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.agencyadmin.controller;

import com.aliyun.openservices.log.exception.LogException;
import com.xnx3.DateUtil;
import com.xnx3.Lang;
import com.xnx3.MD5Util;
import com.xnx3.StringUtil;
import com.xnx3.exception.NotReturnValueException;
import com.xnx3.j2ee.entity.User;
import com.xnx3.j2ee.entity.UserRole;
import com.xnx3.j2ee.service.ApiService;
import com.xnx3.j2ee.service.SqlService;
import com.xnx3.j2ee.service.UserService;
import com.xnx3.j2ee.util.ActionLogUtil;
import com.xnx3.j2ee.util.IpUtil;
import com.xnx3.j2ee.util.LanguageUtil;
import com.xnx3.j2ee.util.Page;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.net.AliyunLogPageUtil;
import com.xnx3.wangmarket.admin.Func;
import com.xnx3.wangmarket.admin.G;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.service.SiteService;
import com.xnx3.wangmarket.admin.vo.SiteVO;
import com.xnx3.wangmarket.admin.vo.UserVO;
import com.xnx3.wangmarket.agencyadmin.controller.BaseController;
import com.xnx3.wangmarket.agencyadmin.entity.Agency;
import com.xnx3.wangmarket.agencyadmin.entity.SiteSizeChange;
import com.xnx3.wangmarket.agencyadmin.service.TransactionalService;
import com.xnx3.wangmarket.agencyadmin.util.SiteSizeChangeLog;
import com.xnx3.wangmarket.domain.bean.MQBean;
import com.xnx3.wangmarket.domain.bean.SimpleSite;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/agency"})
public class AgencyUserController
extends BaseController {
    @Resource
    private SqlService sqlService;
    @Resource
    private UserService userService;
    @Resource
    private SiteService siteService;
    @Resource
    private TransactionalService transactionalService;
    @Resource
    private ApiService apiService;

    @RequiresPermissions(value={"agencySubAgencyList"})
    @RequestMapping(value={"subAgencyList${url.suffix}"})
    public String subAgencyList(HttpServletRequest request, Model model) {
        Agency agency = this.getMyAgency();
        Sql sql = new Sql(request);
        sql.setSearchTable("agency");
        sql.appendWhere("agency.parent_id = " + agency.getId());
        sql.setSearchColumn(new String[]{"name", "phone"});
        int count = this.sqlService.count("agency", sql.getWhere());
        Page page = new Page(count, 12, request);
        sql.setSelectFromAndPage("SELECT agency.*, user.username FROM agency,user", page);
        sql.appendWhere("user.id = agency.userid");
        sql.setOrderByField(new String[]{"id", "expiretime", "addtime"});
        List list = this.sqlService.findMapBySql(sql);
        ActionLogUtil.insert((HttpServletRequest)request, (Integer)agency.getId(), (String)"\u67e5\u770b\u6211\u7684\u4e0b\u7ea7\u4ee3\u7406\u5217\u8868");
        model.addAttribute("list", (Object)list);
        model.addAttribute("page", (Object)page);
        return "agency/subAgencyList";
    }

    @RequiresPermissions(value={"agencyAdd"})
    @RequestMapping(value={"add${url.suffix}"})
    public String add(HttpServletRequest request, Model model) {
        this.userService.regInit(request);
        Agency agency = this.getMyAgency();
        if (agency.getSiteSize() == 0) {
            return this.error(model, "\u60a8\u7684\u8d26\u6237\u4f59\u989d\u8fd8\u5269 " + agency.getSiteSize() + " \u7ad9\uff0c\u4e0d\u8db3\u4ee5\u518d\u5f00\u901a\u7f51\u7ad9\uff01\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u5145\u503c");
        }
        ActionLogUtil.insert((HttpServletRequest)request, (Integer)agency.getId(), (String)"\u8fdb\u5165\u6dfb\u52a0\u7ad9\u70b9\u7684\u9875\u9762");
        return "agency/add";
    }

    @RequiresPermissions(value={"AgencyNormalAdd"})
    @RequestMapping(value={"addAgency${url.suffix}"})
    public String addAgency(HttpServletRequest request, Model model) {
        Agency myAgency = this.getMyAgency();
        if (myAgency.getSiteSize() < G.agencyAddSubAgency_siteSize) {
            return this.error(model, "\u60a8\u7684\u8d26\u6237\u4f59\u989d\u8fd8\u5269 " + myAgency.getSiteSize() + " \u7ad9\u5e01\uff0c\u4e0d\u8db3\u4ee5\u518d\u5f00\u901a\u4e0b\u7ea7\uff01\u8bf7\u8054\u7cfb\u60a8\u7684\u4e0a\u7ea7\u5145\u503c");
        }
        this.userService.regInit(request);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u8fdb\u5165\u6dfb\u52a0\u4e0b\u7ea7\u4ee3\u7406\u7684\u9875\u9762");
        return "agency/addAgency";
    }

    @RequiresPermissions(value={"agencyAdd"})
    @RequestMapping(value={"addSubmit${url.suffix}"})
    @ResponseBody
    public BaseVO addSubmit(HttpServletRequest request, User user, @RequestParam(value="client", required=false, defaultValue="0") Short client, @RequestParam(value="siteName", required=false, defaultValue="") String siteName, @RequestParam(value="contactUsername", required=false, defaultValue="") String contactUsername, @RequestParam(value="sitePhone", required=false, defaultValue="") String sitePhone, @RequestParam(value="siteQQ", required=false, defaultValue="") String siteQQ, @RequestParam(value="address", required=false, defaultValue="") String address, @RequestParam(value="companyName", required=false, defaultValue="") String companyName, @RequestParam(value="email", required=false, defaultValue="") String email, @RequestParam(value="templateName", required=false, defaultValue="") String templateName) {
        Agency agency = (Agency)this.sqlService.findById(Agency.class, (Object)this.getMyAgency().getId());
        if (agency.getSiteSize() == 0) {
            return this.error("\u60a8\u7684\u8d26\u6237\u4f59\u989d\u8fd8\u5269 " + agency.getSiteSize() + " \u7ad9\uff0c\u4e0d\u8db3\u4ee5\u518d\u5f00\u901a\u7f51\u7ad9\uff01\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u5145\u503c");
        }
        if (client == 0) {
            return this.error("\u8bf7\u9009\u62e9\u7ad9\u70b9\u7c7b\u578b\uff0c\u662f\u7535\u8111\u7f51\u7ad9\u5462\uff0c\u8fd8\u662f\u624b\u673a\u7f51\u7ad9\u5462\uff1f");
        }
        if (siteName.length() == 0 || siteName.length() > 20) {
            return this.error("\u8bf7\u8f93\u51651\uff5e30\u4e2a\u5b57\u7b26\u7684\u8981\u5efa\u7acb\u7684\u7ad9\u70b9\u540d\u5b57");
        }
        user.setReferrerid(agency.getUserid());
        Site site = new Site();
        site.setName(this.filter(siteName));
        site.setPhone(this.filter(sitePhone));
        site.setQq(this.filter(siteQQ));
        site.setAddress(this.filter(address));
        site.setClient(client);
        site.setUsername(this.filter(contactUsername));
        site.setCompanyName(this.filter(companyName));
        site.setTemplateName(this.filter(templateName));
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)agency.getId(), (String)"\u4ee3\u7406\u540e\u53f0\u521b\u5efa\u7f51\u7ad9", (String)site.getName());
        return this.createSite(request, agency, user, site, email);
    }

    private BaseVO createSite(HttpServletRequest request, Agency agency, User user, Site site, String email) {
        if (user.getUsername() == null || user.getUsername().length() < 1) {
            return this.error("\u8bf7\u586b\u5199\u767b\u5f55\u7528\u6237\u540d");
        }
        if (user.getPassword() == null || user.getPassword().length() < 1) {
            return this.error("\u8bf7\u586b\u5199\u767b\u5f55\u5bc6\u7801");
        }
        if (agency.getSiteSize() == 0) {
            return this.error("\u60a8\u7684\u8d26\u6237\u4f59\u989d\u8fd8\u5269 " + agency.getSiteSize() + " \u7ad9\uff0c\u4e0d\u8db3\u4ee5\u518d\u5f00\u901a\u7f51\u7ad9\uff01\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u5145\u503c");
        }
        if (site.getName().length() == 0 || site.getName().length() > 30) {
            return this.error("\u8bf7\u8f93\u51651\uff5e30\u4e2a\u5b57\u7b26\u7684\u8981\u5efa\u7acb\u7684\u7ad9\u70b9\u540d\u5b57");
        }
        site.setClient(Site.CLIENT_CMS);
        user.setPhone(this.filter(site.getPhone()));
        user.setEmail(this.filter(email));
        UserVO vo = this.transactionalService.regUser(user, request, false);
        if (vo.getResult() == 1) {
            site.setExpiretime(DateUtil.timeForUnix10() + 31622400);
            site.setmShowBanner(Site.MSHOWBANNER_SHOW);
            SiteVO siteVO = this.siteService.saveSite(site, vo.getUser().getId(), request);
            if (siteVO.getResult() == 1) {
                agency.setSiteSize(agency.getSiteSize() - 1);
                this.sqlService.save((Object)agency);
                if (this.getUserId() > 0) {
                    Func.getUserBeanForShiroSession().setMyAgency(agency);
                }
                SiteSizeChange ssc = new SiteSizeChange();
                ssc.setAddtime(DateUtil.timeForUnix10());
                ssc.setAgencyId(agency.getId());
                ssc.setChangeAfter(agency.getSiteSize());
                ssc.setChangeBefore(agency.getSiteSize() + 1);
                ssc.setGoalid(siteVO.getSite().getId());
                ssc.setSiteSizeChange(-1);
                ssc.setUserid(agency.getUserid());
                this.sqlService.save((Object)ssc);
                SiteSizeChangeLog.xiaofei(agency.getName(), "\u4ee3\u7406\u5f00\u901a\u7f51\u7ad9\uff1a" + site.getName(), ssc.getSiteSizeChange(), ssc.getChangeBefore(), ssc.getChangeAfter(), ssc.getGoalid(), IpUtil.getIpAddress((HttpServletRequest)request));
                ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)site.getId(), (String)"\u4ee3\u7406\u540e\u53f0\u521b\u5efa\u7f51\u7ad9", (String)site.getName());
                return this.success(vo.getUser().getId() + "_" + AgencyUserController.passwordMD5(vo.getUser().getPassword()));
            }
            return this.error("\u6dfb\u52a0\u7528\u6237\u6210\u529f\uff0c\u4f46\u6dfb\u52a0\u7ad9\u70b9\u5931\u8d25\uff01");
        }
        return this.error(vo.getInfo());
    }

    private UserVO apiIdentityVerify(String key) {
        UserVO vo = new UserVO();
        if (key.length() < 128 || key.indexOf("_") == -1) {
            vo.setBaseVO(0, "key\u9519\u8bef1");
            return vo;
        }
        String[] ks = key.split("_");
        if (ks[0].length() == 0 || ks[1].length() == 0) {
            vo.setBaseVO(0, "key\u9519\u8bef2");
            return vo;
        }
        int userid = Lang.stringToInt((String)ks[0], (int)0);
        if (userid == 0) {
            vo.setBaseVO(0, "key\u9519\u8bef3");
            return vo;
        }
        String pwd = StringUtil.removeBlank((String)ks[1]);
        if (pwd.length() != 128) {
            vo.setBaseVO(0, "key\u9519\u8bef4");
            return vo;
        }
        User user = (User)this.sqlService.findById(User.class, userid);
        if (user == null) {
            vo.setBaseVO(0, "key\u9519\u8bef5");
            return vo;
        }
        if (!AgencyUserController.passwordMD5(user.getPassword()).equals(pwd)) {
            vo.setBaseVO(0, "key\u9519\u8bef6");
            return vo;
        }
        vo.setUser(user);
        return vo;
    }

    private static String passwordMD5(String password) {
        String p1 = password.substring(0, 8);
        String p2 = password.substring(8, 16);
        String p3 = password.substring(16, 24);
        String p4 = password.substring(24, 32);
        return MD5Util.MD5((String)p1) + MD5Util.MD5((String)p2) + MD5Util.MD5((String)p3) + MD5Util.MD5((String)p4);
    }

    @RequiresPermissions(value={"AgencyNormalAdd"})
    @RequestMapping(value={"addAgencySave${url.suffix}"})
    @ResponseBody
    public BaseVO addAgencySave(HttpServletRequest request, Model model, User user, @RequestParam(value="contactUsername", required=false, defaultValue="") String contactUsername, @RequestParam(value="phone", required=false, defaultValue="") String phone, @RequestParam(value="qq", required=false, defaultValue="") String qq, @RequestParam(value="address", required=false, defaultValue="") String address, @RequestParam(value="companyName", required=false, defaultValue="") String companyName, @RequestParam(value="email", required=false, defaultValue="") String email) {
        if (contactUsername == null || companyName.trim().equals("")) {
            return this.error("\u8bf7\u8f93\u5165\u8054\u7cfb\u4eba\u59d3\u540d");
        }
        if (phone == null || phone.trim().equals("")) {
            return this.error("\u8bf7\u8f93\u5165\u8054\u7cfb\u4eba\u624b\u673a\u53f7");
        }
        if (contactUsername == null || companyName.trim().equals("")) {
            return this.error("\u8bf7\u8f93\u5165\u8054\u7cfb\u4eba\u59d3\u540d");
        }
        if (address == null || address.trim().equals("")) {
            return this.error("\u8bf7\u8f93\u5165\u516c\u53f8\u5730\u5740");
        }
        if (companyName == null || companyName.trim().equals("")) {
            return this.error("\u8bf7\u8f93\u5165\u516c\u53f8\u540d\u79f0");
        }
        Agency myAgency = (Agency)this.sqlService.findById(Agency.class, (Object)this.getMyAgency().getId());
        if (myAgency.getSiteSize() < G.agencyAddSubAgency_siteSize) {
            return this.error("\u60a8\u7684\u8d26\u6237\u4f59\u989d\u8fd8\u5269 " + myAgency.getSiteSize() + " \u7ad9\u5e01\uff0c\u4e0d\u8db3\u4ee5\u518d\u5f00\u901a\u4e0b\u7ea7\uff01\u8bf7\u8054\u7cfb\u60a8\u7684\u4e0a\u7ea7\u5145\u503c");
        }
        user.setPhone(this.filter(phone));
        user.setEmail(this.filter(email));
        user.setReferrerid(myAgency.getUserid());
        UserVO vo = this.transactionalService.regUser(user, request, true);
        if (vo.getResult() == 1) {
            Agency agency = new Agency();
            agency.setName(this.filter(companyName));
            agency.setPhone(this.filter(phone));
            agency.setUserid(vo.getUser().getId());
            agency.setQq(this.filter(qq));
            agency.setAddress(this.filter(address));
            agency.setSiteSize(0);
            agency.setParentId(myAgency.getId());
            agency.setAddtime(DateUtil.timeForUnix10());
            agency.setExpiretime(DateUtil.timeForUnix10() + 31622400);
            agency.setState(Agency.STATE_NORMAL);
            this.sqlService.save((Object)agency);
            if (agency.getId() != null && agency.getId() > 0) {
                myAgency.setSiteSize(myAgency.getSiteSize() - G.agencyAddSubAgency_siteSize);
                this.sqlService.save((Object)myAgency);
                Func.getUserBeanForShiroSession().setMyAgency(myAgency);
                SiteSizeChange ssc = new SiteSizeChange();
                ssc.setAddtime(DateUtil.timeForUnix10());
                ssc.setAgencyId(myAgency.getId());
                ssc.setChangeAfter(myAgency.getSiteSize());
                ssc.setChangeBefore(myAgency.getSiteSize() + G.agencyAddSubAgency_siteSize);
                ssc.setGoalid(agency.getId());
                ssc.setSiteSizeChange(0 - G.agencyAddSubAgency_siteSize);
                ssc.setUserid(myAgency.getUserid());
                this.sqlService.save((Object)ssc);
                SiteSizeChangeLog.xiaofei(myAgency.getName(), "\u5f00\u901a\u4e0b\u7ea7\u4ee3\u7406\uff1a" + agency.getName(), ssc.getSiteSizeChange(), ssc.getChangeBefore(), ssc.getChangeAfter(), ssc.getGoalid(), IpUtil.getIpAddress((HttpServletRequest)request));
                ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)agency.getId(), (String)"\u5f00\u901a\u4e0b\u7ea7\u4ee3\u7406\u6210\u529f", (String)agency.getName());
                return this.success();
            }
            return this.error("\u521b\u5efa\u7528\u6237\u4fe1\u606f\u6210\u529f\uff0c\u4f46\u662f\u521b\u5efa\u4ee3\u7406\u8bb0\u5f55\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u5b98\u7f51");
        }
        return this.error(vo.getInfo());
    }

    private UserVO regUsersss(User user, HttpServletRequest request, boolean isAgency) {
        UserVO baseVO = new UserVO();
        user.setUsername(this.filter(user.getUsername()));
        user.setEmail(this.filter(user.getEmail()));
        user.setPhone(this.filter(user.getPhone()));
        if (user.getUsername() == null || user.getUsername().equals("")) {
            baseVO.setBaseVO(0, LanguageUtil.show((String)"user_userNameToLong"));
        }
        if (this.sqlService.findByProperty(User.class, "username", (Object)user.getUsername()).size() > 0) {
            baseVO.setBaseVO(0, LanguageUtil.show((String)"user_regFailureForUsernameAlreadyExist"));
            return baseVO;
        }
        if (this.sqlService.findByProperty(User.class, "email", (Object)user.getEmail()).size() > 0) {
            user.setEmail("");
        }
        if (user.getPhone() != null && user.getPhone().length() > 0 && this.sqlService.findByProperty(User.class, "phone", (Object)user.getPhone()).size() > 0) {
            if (isAgency) {
                baseVO.setBaseVO(0, LanguageUtil.show((String)"user_regFailureForPhoneAlreadyExist"));
                return baseVO;
            }
            user.setPhone("");
        }
        user.setRegip(IpUtil.getIpAddress((HttpServletRequest)request));
        user.setLastip(IpUtil.getIpAddress((HttpServletRequest)request));
        user.setRegtime(Integer.valueOf(DateUtil.timeForUnix10()));
        user.setLasttime(Integer.valueOf(DateUtil.timeForUnix10()));
        user.setNickname(user.getUsername());
        user.setAuthority(isAgency ? SystemUtil.get((String)"AGENCY_ROLE") + "" : SystemUtil.get((String)"USER_REG_ROLE"));
        user.setCurrency(Integer.valueOf(0));
        user.setFreezemoney(Integer.valueOf(0));
        user.setMoney(Integer.valueOf(0));
        user.setIsfreeze(User.ISFREEZE_NORMAL);
        user.setHead("default.png");
        if (this.getUserId() > 0) {
            user.setReferrerid(Integer.valueOf(this.getUserId()));
        }
        Random random = new Random();
        user.setSalt(random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10) + "");
        String md5Password = new Md5Hash((Object)user.getPassword(), (Object)user.getSalt(), 2).toString();
        user.setPassword(md5Password);
        this.sqlService.save((Object)user);
        if (user.getId() > 0) {
            UserRole userRole = new UserRole();
            int roleid = 0;
            roleid = isAgency ? SystemUtil.getInt((String)"AGENCY_ROLE") : SystemUtil.getInt((String)"USER_REG_ROLE");
            userRole.setRoleid(Integer.valueOf(roleid));
            userRole.setUserid(user.getId());
            this.sqlService.save((Object)userRole);
            baseVO.setBaseVO(1, LanguageUtil.show((String)"user_regSuccess"));
            baseVO.setUser(user);
        } else {
            baseVO.setBaseVO(0, LanguageUtil.show((String)"user_regFailure"));
        }
        return baseVO;
    }

    @RequestMapping(value={"zengzhifuwu${url.suffix}"})
    public String zengzhifuwu(HttpServletRequest request, Model model) {
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u8fdb\u5165\u589e\u503c\u670d\u52a1\u9875\u9762");
        return "agency/zengzhifuwu";
    }

    @RequiresPermissions(value={"agencyActionLogList"})
    @RequestMapping(value={"actionLogList${url.suffix}"})
    public String actionLogList(HttpServletRequest request, Model model) throws LogException {
        if (ActionLogUtil.aliyunLogUtil == null) {
            return this.error(model, "\u672a\u5f00\u542f\u65e5\u5fd7\u670d\u52a1");
        }
        AliyunLogPageUtil log = new AliyunLogPageUtil(ActionLogUtil.aliyunLogUtil);
        JSONArray jsonArray = log.list("userid=" + this.getUserId(), "", false, 15, request);
        Page page = log.getPage();
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u83b7\u53d6\u4ee3\u7406\u64cd\u4f5c\u8bb0\u5f55");
        model.addAttribute("list", (Object)jsonArray);
        model.addAttribute("page", (Object)page);
        return "agency/actionLogList";
    }

    @RequiresPermissions(value={"agencySiteSizeLogList"})
    @RequestMapping(value={"siteSizeLogList${url.suffix}"})
    public String siteSizeLogList(HttpServletRequest request, Model model) throws LogException {
        if (SiteSizeChangeLog.aliyunLogUtil == null) {
            return this.error(model, "\u672a\u5f00\u542f\u65e5\u5fd7\u670d\u52a1");
        }
        String query = "userid=" + this.getUserId();
        AliyunLogPageUtil log = new AliyunLogPageUtil(SiteSizeChangeLog.aliyunLogUtil);
        JSONArray jsonArray = log.list(query, "", true, 15, request);
        Page page = log.getPage();
        page.setListNumber(2);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u67e5\u770b\u8d44\u91d1\u53d8\u52a8\u65e5\u5fd7");
        model.addAttribute("list", (Object)jsonArray);
        model.addAttribute("page", (Object)page);
        return "agency/siteSizeLogList";
    }

    @RequiresPermissions(value={"agencyUserList"})
    @RequestMapping(value={"userList${url.suffix}"})
    public String userList(HttpServletRequest request, Model model) {
        Sql sql = new Sql(request);
        sql.setSearchTable("user");
        sql.appendWhere("user.referrerid = " + this.getUserId() + " AND user.authority = " + SystemUtil.getInt((String)"USER_REG_ROLE"));
        sql.setSearchColumn(new String[]{"username", "email", "phone", "userid="});
        int count = this.sqlService.count("user", sql.getWhere());
        Page page = new Page(count, 12, request);
        sql.setSelectFromAndPage("SELECT site.*, user.lasttime, user.username AS userusername  FROM site,user", page);
        sql.appendWhere("user.id = site.userid");
        sql.setOrderByField(new String[]{"id", "expiretime", "addtime"});
        sql.setDefaultOrderBy("site.expiretime ASC");
        List list = this.sqlService.findMapBySql(sql);
        ActionLogUtil.insert((HttpServletRequest)request, (String)"\u4ee3\u7406\u5546\u540e\u53f0\uff0c\u67e5\u770b\u5c5e\u4e8e\u6211\u7684\u7ad9\u70b9\u5217\u8868");
        model.addAttribute("list", (Object)list);
        model.addAttribute("page", (Object)page);
        return "agency/userList";
    }

    @RequiresPermissions(value={"agencyTransferSiteSizeToSubAgencyList"})
    @RequestMapping(value={"transferSiteSizeToSubAgency${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO transferSiteSizeToSubAgency(HttpServletRequest request, Model model, @RequestParam(value="targetAgencyId", required=true) int targetAgencyId, @RequestParam(value="transferSiteSize", required=false, defaultValue="0") int transferSiteSize) {
        BaseVO vo = this.transactionalService.transferSiteSizeToSubAgency(request, targetAgencyId, transferSiteSize);
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (String)"\u8f6c\u79fb\u7ad9\u5e01\u5230\u5b50\u4ee3\u7406\u8d26\u6237\uff0c\u5411\u81ea\u5df1\u7684\u4e0b\u7ea7\u4ee3\u7406\u8f6c\u8d26\uff08\u7ad9\u5e01\uff09\uff0c\u4e3a\u5176\u5145\u503c\u7ad9\u5e01", (String)vo.toString());
        return vo;
    }

    @RequiresPermissions(value={"agencySiteXuFie"})
    @RequestMapping(value={"siteXuFie${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO siteXuFie(HttpServletRequest request, Model model, @RequestParam(value="siteid", required=true) int siteid, @RequestParam(value="year", required=false, defaultValue="0") int year) {
        BaseVO vo = this.transactionalService.siteXuFei(request, siteid, year);
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (String)"\u7ad9\u70b9\u7eed\u8d39\uff0c\u7ed9\u81ea\u5df1\u5f00\u901a\u7684\u7ad9\u70b9\u7eed\u8d39\u65f6\u957f", (String)vo.toString());
        return vo;
    }

    @RequiresPermissions(value={"agencySiteFreeze"})
    @RequestMapping(value={"siteFreeze${url.suffix}"})
    @ResponseBody
    public BaseVO sitePause(HttpServletRequest request, @RequestParam(value="siteid", required=true) int siteid) {
        Site site = (Site)this.sqlService.findById(Site.class, siteid);
        User user = (User)this.sqlService.findById(User.class, (Object)site.getUserid());
        if (user == null) {
            return this.error("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (user.getReferrerid() - this.getMyAgency().getUserid() != 0) {
            return this.error("\u8981\u6682\u505c\u7684\u7f51\u7ad9\u4e0d\u662f\u60a8\u7684\u76f4\u5c5e\u4e0b\u7ea7\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (site.getState() - Site.STATE_NORMAL != 0) {
            return this.error("\u5f53\u524d\u7f51\u7ad9\u7684\u72b6\u6001\u4e0d\u7b26\uff0c\u6682\u505c\u5931\u8d25");
        }
        site.setState(Site.STATE_FREEZE);
        this.sqlService.save((Object)site);
        this.userService.freezeUser(site.getUserid().intValue());
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)site.getId(), (String)(this.getMyAgency().getName() + "\u5c06\u7f51\u7ad9" + site.getName() + "\u6682\u505c"));
        MQBean mqBean = new MQBean();
        mqBean.setType(3);
        mqBean.setSimpleSite(new SimpleSite(site));
        this.siteService.updateDomainServers(mqBean);
        return this.success();
    }

    @RequiresPermissions(value={"agencySiteFreeze"})
    @RequestMapping(value={"siteUnFreeze${url.suffix}"})
    @ResponseBody
    public BaseVO siteRemovePause(HttpServletRequest request, @RequestParam(value="siteid", required=true) int siteid) {
        Site site = (Site)this.sqlService.findById(Site.class, siteid);
        User user = (User)this.sqlService.findById(User.class, (Object)site.getUserid());
        if (user == null) {
            return this.error("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (user.getReferrerid() - this.getMyAgency().getUserid() != 0) {
            return this.error("\u8981\u6682\u505c\u7684\u7f51\u7ad9\u4e0d\u662f\u60a8\u7684\u76f4\u5c5e\u4e0b\u7ea7\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (site.getState() - Site.STATE_FREEZE != 0) {
            return this.error("\u5f53\u524d\u7f51\u7ad9\u7684\u72b6\u6001\u4e0d\u7b26\uff0c\u6682\u505c\u5931\u8d25");
        }
        site.setState(Site.STATE_NORMAL);
        this.sqlService.save((Object)site);
        this.userService.unfreezeUser(site.getUserid().intValue());
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)site.getId(), (String)(this.getMyAgency().getName() + "\u5c06\u6682\u505c\u7684\u7f51\u7ad9" + site.getName() + "\u6062\u590d\u6b63\u5e38"));
        MQBean mqBean = new MQBean();
        mqBean.setType(3);
        mqBean.setSimpleSite(new SimpleSite(site));
        this.siteService.updateDomainServers(mqBean);
        return this.success();
    }

    @RequiresPermissions(value={"agencySiteUpdatePassword"})
    @RequestMapping(value={"siteUpdatePassword${url.suffix}"})
    @ResponseBody
    public BaseVO siteUpdatePassword(HttpServletRequest request, @RequestParam(value="userid", required=true) int userid, @RequestParam(value="newPassword", required=true) String newPassword) {
        User user = (User)this.sqlService.findById(User.class, userid);
        if (user == null) {
            return this.error("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (user.getReferrerid() - this.getMyAgency().getUserid() != 0) {
            return this.error("\u8981\u66f4\u6539\u5bc6\u7801\u7684\u7f51\u7ad9\u4e0d\u662f\u60a8\u7684\u76f4\u5c5e\u4e0b\u7ea7\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)userid, (String)"\u4ee3\u7406\u5546\u7ed9\u5176\u4e0b\u7684\u67d0\u4e2a\u7ad9\u70b9\u66f4\u6539\u5bc6\u7801", (String)newPassword);
        return this.userService.updatePassword(userid, newPassword);
    }

    @RequiresPermissions(value={"agencyYanQi"})
    @RequestMapping(value={"agencyYanQi${url.suffix}"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseVO agencyYanQi(HttpServletRequest request, Model model, @RequestParam(value="agencyId", required=true) int agencyId, @RequestParam(value="year", required=false, defaultValue="0") int year) {
        if (year < 1) {
            return this.error("\u8bf7\u8f93\u5165\u8981\u7eed\u8d39\u7684\u5e74\u6570\uff0c1\uff5e10");
        }
        if (year > 10) {
            return this.error("\u8bf7\u8f93\u5165\u8981\u7eed\u8d39\u7684\u5e74\u6570\uff0c1\uff5e10\uff0c\u6700\u5927\u53ef\u5f80\u540e\u7eed\u8d3910\u5e74");
        }
        Agency myAgency = (Agency)this.sqlService.findById(Agency.class, (Object)this.getMyAgency().getId());
        int xufeiZhanBi = year * 20;
        if (myAgency.getSiteSize() - xufeiZhanBi <= 0) {
            return this.error("\u60a8\u5f53\u524d\u53ea\u62e5\u6709" + myAgency.getSiteSize() + "\u7ad9\u5e01\uff01\u7eed\u8d39\u82b1\u8d39\u7684\u91d1\u989d\u8d85\u51fa\uff0c\u7eed\u8d39\u5931\u8d25\uff01");
        }
        Agency subAgency = (Agency)this.sqlService.findById(Agency.class, agencyId);
        User subUser = (User)this.sqlService.findById(User.class, (Object)subAgency.getUserid());
        if (subUser.getReferrerid() - myAgency.getUserid() != 0) {
            return this.error("\u8981\u5ef6\u671f\u7684\u4ee3\u7406\u4e0d\u662f\u60a8\u7684\u76f4\u5c5e\u4e0b\u7ea7\uff0c\u4e3a\u5176\u5ef6\u671f\u5931\u8d25");
        }
        if (subAgency.getExpiretime() + year * 31622400 > DateUtil.timeForUnix10() + 316224000) {
            return this.error("\u4ee3\u7406\u8d44\u683c\u5f80\u540e\u5ef6\u671f\u7684\u6700\u5927\u671f\u9650\u4e3a10\u5e74\uff01");
        }
        String ip = IpUtil.getIpAddress((HttpServletRequest)request);
        myAgency.setSiteSize(myAgency.getSiteSize() - xufeiZhanBi);
        this.sqlService.save((Object)myAgency);
        SiteSizeChange ssc = new SiteSizeChange();
        ssc.setAddtime(DateUtil.timeForUnix10());
        ssc.setAgencyId(myAgency.getId());
        ssc.setChangeAfter(myAgency.getSiteSize());
        ssc.setChangeBefore(myAgency.getSiteSize() + xufeiZhanBi);
        ssc.setGoalid(subAgency.getId());
        ssc.setSiteSizeChange(0 - xufeiZhanBi);
        ssc.setUserid(myAgency.getUserid());
        this.sqlService.save((Object)ssc);
        SiteSizeChangeLog.xiaofei(myAgency.getName(), "\u7ed9\u4ee3\u7406" + subAgency.getName() + "\u5ef6\u957f\u4f7f\u7528\u671f\u9650" + year + "\u5e74", ssc.getSiteSizeChange(), ssc.getChangeBefore(), ssc.getChangeAfter(), ssc.getGoalid(), ip);
        subAgency.setExpiretime(subAgency.getExpiretime() + year * 31622400);
        this.sqlService.save((Object)subAgency);
        String daoqishijian = "";
        try {
            daoqishijian = DateUtil.dateFormat((long)subAgency.getExpiretime().intValue(), (String)"yyyy\u5e74MM\u6708dd\u65e5");
        }
        catch (NotReturnValueException e) {
            e.printStackTrace();
        }
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)ssc.getId(), (String)("\u7ed9\u4ee3\u7406" + subAgency.getName() + "\u5ef6\u957f\u4f7f\u7528\u671f\u9650" + year + "\u5e74\u3002\u4ee3\u7406\u8d44\u683c\u5ef6\u671f\u540e\uff0c\u65e5\u671f\u5230" + daoqishijian));
        Func.getUserBeanForShiroSession().setMyAgency(myAgency);
        return this.success();
    }

    @RequiresPermissions(value={"agencyAgencyFreeze"})
    @RequestMapping(value={"agencyFreeze${url.suffix}"})
    @ResponseBody
    public BaseVO agencyFreeze(HttpServletRequest request, @RequestParam(value="agencyId", required=true) int agencyId) {
        Agency subAgency = (Agency)this.sqlService.findById(Agency.class, agencyId);
        User subUser = (User)this.sqlService.findById(User.class, (Object)subAgency.getUserid());
        if (subUser == null) {
            return this.error("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (subUser.getReferrerid() - this.getMyAgency().getUserid() != 0) {
            return this.error("\u8981\u51bb\u7ed3\u7684\u4ee3\u7406\u4e0d\u662f\u60a8\u7684\u76f4\u5c5e\u4e0b\u7ea7\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (subAgency.getState() - Site.STATE_NORMAL != 0) {
            return this.error("\u5f53\u524d\u7f51\u7ad9\u7684\u72b6\u6001\u4e0d\u7b26\uff0c\u6682\u505c\u5931\u8d25");
        }
        subAgency.setState(Agency.STATE_FREEZE);
        this.sqlService.save((Object)subAgency);
        this.userService.freezeUser(subAgency.getUserid().intValue());
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)subAgency.getId(), (String)(this.getMyAgency().getName() + "\u5c06\u4ee3\u7406" + subAgency.getName() + "\u6682\u505c\u3001\u51bb\u7ed3"));
        return this.success();
    }

    @RequiresPermissions(value={"agencyAgencyUnFreeze"})
    @RequestMapping(value={"agencyUnFreeze${url.suffix}"})
    @ResponseBody
    public BaseVO agencyUnFreeze(HttpServletRequest request, @RequestParam(value="agencyId", required=true) int agencyId) {
        Agency subAgency = (Agency)this.sqlService.findById(Agency.class, agencyId);
        User subUser = (User)this.sqlService.findById(User.class, (Object)subAgency.getUserid());
        if (subUser == null) {
            return this.error("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (subUser.getReferrerid() - this.getMyAgency().getUserid() != 0) {
            return this.error("\u8981\u6062\u590d\u7684\u4ee3\u7406\u4e0d\u662f\u60a8\u7684\u76f4\u5c5e\u4e0b\u7ea7\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (subAgency.getState() - Agency.STATE_FREEZE != 0) {
            return this.error("\u5f53\u524d\u4ee3\u7406\u7684\u72b6\u6001\u4e0d\u7b26\uff0c\u662f\u6b63\u5e38\u72b6\u6001\uff0c\u65e0\u9700\u6062\u590d\u6b63\u5e38");
        }
        subAgency.setState(Agency.STATE_NORMAL);
        this.sqlService.save((Object)subAgency);
        this.userService.unfreezeUser(subAgency.getUserid().intValue());
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)subAgency.getId(), (String)(this.getMyAgency().getName() + "\u5c06\u51bb\u7ed3\u7684\u4ee3\u7406" + subAgency.getName() + "\u6062\u590d\u6b63\u5e38"));
        return this.success();
    }

    @RequiresPermissions(value={"agencyUserList"})
    @RequestMapping(value={"siteUpdateRemark.json"})
    @ResponseBody
    public BaseVO siteUpdateRemark(HttpServletRequest request, @RequestParam(value="siteid", required=true) int siteid, @RequestParam(value="remark", required=true) String remark) {
        Site site = (Site)this.sqlService.findById(Site.class, siteid);
        if (site == null) {
            return this.error("\u7f51\u7ad9\u4e0d\u5b58\u5728");
        }
        User user = (User)this.sqlService.findById(User.class, (Object)site.getUserid());
        if (user.getReferrerid() - this.getMyAgency().getUserid() != 0) {
            return this.error("\u8981\u66f4\u6539\u5907\u6ce8\u7684\u7f51\u7ad9\u4e0d\u662f\u60a8\u7684\u76f4\u5c5e\u4e0b\u7ea7\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        site.setRemark(SafetyUtil.xssFilter((String)remark));
        this.sqlService.save((Object)site);
        ActionLogUtil.insertUpdateDatabase((HttpServletRequest)request, (Integer)siteid, (String)"\u4ee3\u7406\u5546\u7ed9\u5176\u4e0b\u7684\u67d0\u4e2a\u7ad9\u70b9\u66f4\u6539\u5907\u6ce8", (String)remark);
        return this.success();
    }
}

