/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.vo;

import com.xnx3.DateUtil;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.json.JSONUtil;
import com.xnx3.wangmarket.admin.entity.InputModel;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.entity.SiteColumn;
import com.xnx3.wangmarket.admin.entity.Template;
import com.xnx3.wangmarket.admin.util.SessionUtil;
import com.xnx3.wangmarket.admin.vo.bean.template.TemplatePage;
import com.xnx3.wangmarket.admin.vo.bean.template.TemplateVar;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class TemplateVO
extends BaseVO {
    private Site currentSite;
    private String text;
    private List<TemplatePage> templatePageList;
    private List<TemplateVar> templateVarList;
    private List<InputModel> inputModelList;
    private List<SiteColumn> siteColumnList;
    private JSONObject siteVarJson;
    private String systemVersion;
    private int time;
    private String templateName;
    private String sourceUrl;
    private String plugin;
    private Template template;
    private boolean isUtf8Encode;

    public Site getCurrentSite() {
        return this.currentSite;
    }

    public void setCurrentSite(Site currentSite) {
        this.currentSite = currentSite;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<TemplatePage> getTemplatePageList() {
        return this.templatePageList;
    }

    public void setTemplatePageList(List<TemplatePage> templatePageList) {
        this.templatePageList = templatePageList;
    }

    public List<TemplateVar> getTemplateVarList() {
        return this.templateVarList;
    }

    public void setTemplateVarList(List<TemplateVar> templateVarList) {
        this.templateVarList = templateVarList;
    }

    public List<InputModel> getInputModelList() {
        return this.inputModelList;
    }

    public void setInputModelList(List<InputModel> inputModelList) {
        this.inputModelList = inputModelList;
    }

    public List<SiteColumn> getSiteColumnList() {
        return this.siteColumnList;
    }

    public void setSiteColumnList(List<SiteColumn> siteColumnList) {
        this.siteColumnList = siteColumnList;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public void setSystemVersion(String systemVersion) {
        this.systemVersion = systemVersion;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public boolean importText(String text) {
        JSONObject j;
        int i;
        JSONObject tempJson;
        String utf8Encode;
        this.currentSite = SessionUtil.getSite();
        if (this.currentSite == null) {
            this.currentSite = new Site();
        }
        this.text = text;
        JSONObject jo = JSONObject.fromObject((Object)text);
        if (jo.get("useUtf8Encode") != null && (utf8Encode = jo.getString("useUtf8Encode")).equals("true")) {
            this.isUtf8Encode = true;
        }
        if (jo.get("plugin") != null) {
            this.plugin = this.getJsonStringAndSafetyFilter(jo.getString("plugin"));
        }
        this.templateName = jo.get("templateName") != null ? this.getJsonStringAndFilterXSS(jo, "templateName") : "";
        this.systemVersion = jo.get("systemVersion") != null ? this.getJsonStringAndSafetyFilter(jo.getString("systemVersion")) : "";
        if (jo.get("time") != null) {
            this.time = jo.getInt("time");
        }
        this.sourceUrl = jo.get("sourceUrl") != null ? this.getJsonStringAndFilterXSS(jo, "sourceUrl") : "";
        if (jo.get("template") != null && (tempJson = jo.getJSONObject("template")).get("type") != null) {
            this.template = new Template();
            this.template.setAddtime(tempJson.getInt("addtime"));
            this.template.setCompanyname(this.getJsonStringAndFilterXSS(tempJson, "companyname"));
            this.template.setName(this.getJsonStringAndFilterXSS(tempJson, "name"));
            this.template.setPreviewUrl(this.getJsonStringAndFilterXSS(tempJson, "previewUrl"));
            this.template.setRemark(this.getJsonStringAndFilterXSS(tempJson, "remark"));
            this.template.setSiteurl(this.getJsonStringAndFilterXSS(tempJson, "siteurl"));
            this.template.setTerminalDisplay((short)tempJson.getInt("terminalDisplay"));
            this.template.setTerminalIpad((short)tempJson.getInt("terminalIpad"));
            this.template.setTerminalMobile((short)tempJson.getInt("terminalMobile"));
            this.template.setTerminalPc((short)tempJson.getInt("terminalPc"));
            this.template.setType(tempJson.getInt("type"));
            this.template.setUsername(this.getJsonStringAndFilterXSS(tempJson, "username"));
            this.template.setPreviewPic(this.getJsonStringAndFilterXSS(tempJson, "previewPic"));
            this.template.setZipDownUrl(this.getJsonStringAndFilterXSS(tempJson, "zipDownUrl"));
            this.template.setWscsoDownUrl(this.getJsonStringAndFilterXSS(tempJson, "wscsoDownUrl"));
            if (tempJson.get("iscommon") != null) {
                this.template.setIscommon((short)tempJson.getInt("iscommon"));
            } else {
                this.template.setIscommon(Template.ISCOMMON_NO);
            }
            if (tempJson.get("resourceImport") == null) {
                this.template.setResourceImport("private");
            } else {
                this.template.setResourceImport(this.getJsonStringAndFilterXSS(tempJson, "resourceImport"));
            }
            if (this.templateName == null || this.templateName.length() == 0) {
                this.templateName = this.template.getName();
            }
        }
        this.templatePageList = new ArrayList<TemplatePage>();
        if (jo.get("templatePageList") != null) {
            JSONArray templatePageArray = jo.getJSONArray("templatePageList");
            for (i = 0; i < templatePageArray.size(); ++i) {
                j = templatePageArray.getJSONObject(i);
                com.xnx3.wangmarket.admin.entity.TemplatePage ntp = new com.xnx3.wangmarket.admin.entity.TemplatePage();
                ntp.setName(this.getJsonStringAndFilterXSS(j, "name"));
                ntp.setSiteid(this.currentSite.getId());
                ntp.setTemplateName(this.templateName);
                ntp.setType((short)j.getInt("type"));
                ntp.setUserid(this.currentSite.getUserid());
                if (j.get("remark") != null) {
                    ntp.setRemark(this.getJsonStringAndFilterXSS(j, "remark"));
                }
                if (j.get("editMode") != null) {
                    ntp.setEditMode((short)j.getInt("editMode"));
                } else {
                    ntp.setEditMode(com.xnx3.wangmarket.admin.entity.TemplatePage.EDIT_MODE_VISUAL);
                }
                TemplatePage tp = new TemplatePage();
                tp.setTemplatePage(ntp);
                tp.setText(this.getJsonString(j.getString("text")));
                this.templatePageList.add(tp);
            }
        }
        this.templateVarList = new ArrayList<TemplateVar>();
        if (jo.get("templateVarList") != null) {
            JSONArray templateVarArray = jo.getJSONArray("templateVarList");
            for (i = 0; i < templateVarArray.size(); ++i) {
                j = templateVarArray.getJSONObject(i);
                com.xnx3.wangmarket.admin.entity.TemplateVar tv = new com.xnx3.wangmarket.admin.entity.TemplateVar();
                tv.setAddtime(DateUtil.timeForUnix10());
                tv.setRemark(this.getJsonStringAndFilterXSS(j, "remark"));
                tv.setTemplateName(this.templateName);
                tv.setUpdatetime(tv.getAddtime());
                tv.setUserid(this.currentSite.getUserid());
                tv.setVarName(this.getJsonStringAndFilterXSS(j, "var_name"));
                tv.setSiteid(this.currentSite.getId());
                TemplateVar t = new TemplateVar();
                t.setTemplateVar(tv);
                t.setText(this.getJsonString(j.getString("text")));
                this.templateVarList.add(t);
            }
        }
        this.inputModelList = new ArrayList<InputModel>();
        if (jo.get("inputModelList") != null) {
            JSONArray inputModelArray = jo.getJSONArray("inputModelList");
            for (i = 0; i < inputModelArray.size(); ++i) {
                j = inputModelArray.getJSONObject(i);
                InputModel im = new InputModel();
                im.setCodeName(this.getJsonStringAndFilterXSS(j, "codeName"));
                im.setRemark(this.getJsonStringAndFilterXSS(j, "remark"));
                im.setSiteid(this.currentSite.getId());
                im.setText(this.getJsonString(j.getString("text")));
                this.inputModelList.add(im);
            }
        }
        if (jo.get("siteVar") != null) {
            JSONObject siteVarJson = jo.getJSONObject("siteVar");
            JSONObject newSiteVar = new JSONObject();
            for (Map.Entry entry : siteVarJson.entrySet()) {
                JSONObject textObj = (JSONObject)entry.getValue();
                JSONObject uft8SubJson = new JSONObject();
                for (Map.Entry subEntry : textObj.entrySet()) {
                    uft8SubJson.put(subEntry.getKey(), (Object)StringUtil.utf8ToString((String)((String)subEntry.getValue())));
                }
                newSiteVar.put(entry.getKey(), (Object)uft8SubJson);
            }
            this.siteVarJson = newSiteVar;
        }
        this.siteColumnList = new ArrayList<SiteColumn>();
        if (jo.get("siteColumnList") != null) {
            JSONArray siteColumnArray = jo.getJSONArray("siteColumnList");
            for (int i2 = 0; i2 < siteColumnArray.size(); ++i2) {
                j = siteColumnArray.getJSONObject(i2);
                Short type = (short)j.getInt("type");
                SiteColumn nsc = new SiteColumn();
                nsc.setName(this.getJsonStringAndFilterXSS(j, "name"));
                nsc.setRank(j.getInt("rank"));
                nsc.setUsed((short)j.getInt("used"));
                nsc.setSiteid(this.currentSite.getId());
                nsc.setUserid(this.currentSite.getUserid());
                nsc.setType(type);
                nsc.setTemplatePageListName(this.getJsonStringAndFilterXSS(j, "templatePageListName"));
                nsc.setTemplatePageViewName(this.getJsonStringAndFilterXSS(j, "templatePageViewName"));
                nsc.setCodeName(this.getJsonStringAndFilterXSS(j, "codeName"));
                nsc.setParentCodeName(this.getJsonStringAndFilterXSS(j, "parentCodeName"));
                nsc.setListNum(j.getInt("listNum"));
                nsc.setEditMode((short)(j.get("editMode") == null ? 0 : j.getInt("editMode")));
                if (j.get("inputModelCodeName") != null) {
                    nsc.setInputModelCodeName(this.getJsonStringAndFilterXSS(j, "inputModelCodeName"));
                }
                if (j.get("listRank") != null) {
                    nsc.setListRank((short)j.getInt("listRank"));
                } else {
                    nsc.setListRank(SiteColumn.LIST_RANK_ADDTIME_ASC);
                }
                if (nsc.getType() - SiteColumn.TYPE_NEWS == 0) {
                    nsc.setEditUseText(SiteColumn.USED_ENABLE);
                    nsc.setType(SiteColumn.TYPE_LIST);
                }
                if (nsc.getType() - SiteColumn.TYPE_IMAGENEWS == 0) {
                    nsc.setEditUseText(SiteColumn.USED_ENABLE);
                    nsc.setEditUseTitlepic(SiteColumn.USED_ENABLE);
                    nsc.setType(SiteColumn.TYPE_LIST);
                }
                if (nsc.getType() - SiteColumn.TYPE_PAGE == 0) {
                    nsc.setEditUseText(SiteColumn.USED_ENABLE);
                    nsc.setType(SiteColumn.TYPE_ALONEPAGE);
                }
                if (j.get("editUseTitlepic") != null) {
                    nsc.setEditUseTitlepic((short)j.getInt("editUseTitlepic"));
                }
                if (j.get("editUseIntro") != null) {
                    nsc.setEditUseIntro((short)j.getInt("editUseIntro"));
                }
                if (j.get("editUseText") != null) {
                    nsc.setEditUseText((short)j.getInt("editUseText"));
                }
                if (j.get("editUseExtendPhotos") != null) {
                    nsc.setEditUseExtendPhotos((short)j.getInt("editUseExtendPhotos"));
                }
                if (j.get("useGenerateView") != null) {
                    nsc.setUseGenerateView((short)j.getInt("useGenerateView"));
                } else {
                    nsc.setUseGenerateView(SiteColumn.USED_ENABLE);
                }
                if (j.get("icon") != null) {
                    nsc.setIcon(j.getString("icon"));
                } else {
                    nsc.setIcon("");
                }
                if (j.get("adminNewsUsed") != null) {
                    nsc.setAdminNewsUsed((short)JSONUtil.getInt((JSONObject)j, (String)"adminNewsUsed"));
                } else {
                    nsc.setAdminNewsUsed((short)1);
                }
                if (j.get("templateCodeColumnUsed") == null) {
                    nsc.setTemplateCodeColumnUsed((short)JSONUtil.getInt((JSONObject)j, (String)"templateCodeColumnUsed"));
                } else {
                    nsc.setTemplateCodeColumnUsed((short)1);
                }
                if (j.get("keywords") != null) {
                    nsc.setKeywords(JSONUtil.getString((JSONObject)j, (String)"keywords"));
                }
                if (j.get("description") != null) {
                    nsc.setDescription(JSONUtil.getString((JSONObject)j, (String)"description"));
                }
                this.siteColumnList.add(nsc);
            }
        }
        return true;
    }

    public String getJsonString(String text) {
        if (text == null) {
            return "";
        }
        if (this.isUtf8Encode) {
            text = StringUtil.utf8ToString((String)text);
        }
        return text;
    }

    public String getJsonStringAndFilterXSS(JSONObject json, String key) {
        if (json == null) {
            return "";
        }
        if (json.get(key) == null) {
            return "";
        }
        return StringUtil.filterXss((String)this.getJsonString(json.getString(key)));
    }

    public String getJsonStringAndSafetyFilter(String text) {
        if (text == null) {
            return "";
        }
        return SafetyUtil.filter((String)this.getJsonString(text));
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public JSONObject getSiteVarJson() {
        if (this.siteVarJson == null) {
            return new JSONObject();
        }
        return this.siteVarJson;
    }

    public void setSiteVarJson(JSONObject siteVarJson) {
        this.siteVarJson = siteVarJson;
    }
}

