/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.util;

import com.xnx3.Lang;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.net.HttpResponse;
import com.xnx3.net.HttpUtil;
import com.xnx3.wangmarket.admin.entity.Template;
import com.xnx3.wangmarket.admin.util.interfaces.TemplateUtilFileMove;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class TemplateUtil {
    public static Map<Integer, Map<String, Template>> cloudTemplateMapForType = new HashMap<Integer, Map<String, Template>>();
    public static Map<String, Template> cloudTemplateMapForName = new HashMap<String, Template>();
    public static Map<String, Template> databaseTemplateMapForName = new HashMap<String, Template>();
    public static Map<Integer, Map<String, Template>> databaseTemplateMapForType = new HashMap<Integer, Map<String, Template>>();
    public static final String[] allowSuffixArray = new String[]{"js", "xml", "swf", "css", "png", "jpg", "bmp", "jpeg", "gif", "eot", "svg", "ttf", "woff", "woff2", "otf", "wscso"};
    private String name;
    private TemplateUtilFileMove templateUtilFileMove;

    public static void updateDatabaseTemplateMap(Template template) {
        if (template == null) {
            return;
        }
        if (template.getIscommon() - Template.ISCOMMON_NO == 0) {
            if (databaseTemplateMapForName.get(template.getName()) != null) {
                databaseTemplateMapForName.remove(template.getName());
            }
            if (databaseTemplateMapForType.get(template.getType()) != null && databaseTemplateMapForType.get(template.getType()).get(template.getName()) != null) {
                databaseTemplateMapForType.get(template.getType()).remove(template.getName());
            }
            return;
        }
        Template temp = databaseTemplateMapForName.get(template.getName());
        if (temp == null) {
            databaseTemplateMapForName.put(template.getName(), template);
            if (databaseTemplateMapForType.get(template.getType()) == null) {
                databaseTemplateMapForType.put(template.getType(), new HashMap());
            }
            databaseTemplateMapForType.get(template.getType()).put(template.getName(), template);
        } else {
            databaseTemplateMapForName.put(template.getName(), template);
            databaseTemplateMapForType.get(template.getType()).remove(template.getName());
            databaseTemplateMapForType.get(template.getType()).put(template.getName(), template);
        }
    }

    public static Map<String, Template> getTemplateList(int templateType) {
        HashMap<String, Template> map = new HashMap<String, Template>();
        String useCloudTemplate = SystemUtil.get((String)"PLUGIN_TEMPLATECENTER_USE_ClOUDTEMPLATE");
        if (useCloudTemplate == null || !useCloudTemplate.equals("0")) {
            if (templateType > -1) {
                TemplateUtil.mapClone(map, cloudTemplateMapForType.get(templateType));
            } else {
                TemplateUtil.mapClone(map, cloudTemplateMapForName);
            }
        }
        if (templateType > -1) {
            TemplateUtil.mapClone(map, databaseTemplateMapForType.get(templateType));
        } else {
            TemplateUtil.mapClone(map, databaseTemplateMapForName);
        }
        return map;
    }

    public static Template getTemplateByName(String name) {
        Template template = databaseTemplateMapForName.get(name);
        if (template == null) {
            template = cloudTemplateMapForName.get(name);
        }
        return template;
    }

    public static BaseVO getTemplateWscso(Template template) {
        BaseVO vo = new BaseVO();
        if (template.getWscsoDownUrl() != null && template.getWscsoDownUrl().length() > 3) {
            HttpResponse hr;
            HttpUtil http = new HttpUtil("UTF-8");
            String wscsoUrl = template.getWscsoDownUrl();
            if (wscsoUrl != null && wscsoUrl.indexOf("//") == 0) {
                wscsoUrl = "http:" + wscsoUrl;
            }
            if ((hr = http.get(wscsoUrl)).getCode() - 404 == 0) {
                vo.setBaseVO(0, "\u6a21\u7248\u4e0d\u5b58\u5728");
                return vo;
            }
            vo.setInfo(hr.getContent());
        } else {
            String text = AttachmentUtil.getTextByPath((String)("websiteTemplate/" + template.getName() + "/template.wscso"));
            vo.setInfo(text);
        }
        return vo;
    }

    public TemplateUtil(String name) {
        this.name = name;
    }

    public TemplateUtil(String name, TemplateUtilFileMove templateUtilFileMove) {
        this.name = name;
        this.templateUtilFileMove = templateUtilFileMove;
    }

    public void filterTemplateFile(File file) {
        File[] subFileList = file.listFiles();
        for (int i = 0; i < subFileList.length; ++i) {
            File subFile = subFileList[i];
            if (subFile.isDirectory()) {
                this.filterTemplateFile(subFile);
                continue;
            }
            String subFileSuffix = null;
            subFileSuffix = Lang.findFileSuffix((String)subFile.getName());
            boolean hefa = false;
            if (subFileSuffix != null) {
                subFileSuffix = subFileSuffix.toLowerCase();
                for (int j = 0; j < allowSuffixArray.length; ++j) {
                    if (!allowSuffixArray[j].equals(subFileSuffix)) continue;
                    hefa = true;
                    break;
                }
            }
            if (hefa) {
                String subFilePath = subFile.getPath();
                int index = subFilePath.indexOf("/classes/templateTemporaryFile/");
                String temp = subFilePath.substring(index + 31, subFilePath.length());
                String jutiFile = temp.substring(temp.indexOf("/") + 1, temp.length());
                try {
                    this.templateUtilFileMove.move("websiteTemplate/" + this.name + "/" + jutiFile, new FileInputStream(subFile));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                continue;
            }
            subFile.delete();
        }
    }

    public static Map<String, Template> mapClone(Map<String, Template> mapOriginal, Map<String, Template> mapAdd) {
        if (mapAdd == null) {
            return mapOriginal;
        }
        for (Map.Entry<String, Template> entry : mapAdd.entrySet()) {
            mapOriginal.put(entry.getKey(), entry.getValue());
        }
        return mapOriginal;
    }
}

