/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.util;

import com.rabbitmq.client.Consumer;
import com.xnx3.Lang;
import com.xnx3.j2ee.func.ApplicationProperties;
import com.xnx3.j2ee.util.ConsoleUtil;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.springframework.stereotype.Component;

@Component
public class RabbitUtil {
    public static String EXCHANGE_NAME = "amq.direct";
    public static boolean isUse = false;
    public static com.xnx3.rabbitmq.RabbitUtil rabbitUtil = null;

    public RabbitUtil() {
        String host = ApplicationProperties.getProperty((String)"spring.rabbitmq.host");
        if (host == null) {
            isUse = false;
            return;
        }
        int port = Lang.stringToInt((String)ApplicationProperties.getProperty((String)"spring.rabbitmq.port"), (int)5672);
        String username = ApplicationProperties.getProperty((String)"spring.rabbitmq.username");
        String password = ApplicationProperties.getProperty((String)"spring.rabbitmq.password");
        rabbitUtil = new com.xnx3.rabbitmq.RabbitUtil(host, username, password, port);
        isUse = true;
    }

    public static void sendTopicMessage(String routingKey, String content) {
        try {
            rabbitUtil.getChannel().basicPublish(EXCHANGE_NAME, routingKey, null, content.getBytes());
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
        }
    }

    public static void receive(String routingKey, Consumer consumer) throws IOException, TimeoutException {
        String queue = "queue_" + Lang.uuid();
        rabbitUtil.getChannel().queueDeclare(queue, true, false, false, null);
        ConsoleUtil.info((String)("\u521b\u5efa\u961f\u5217\uff0c routingKey\uff1a" + routingKey + " , queue: " + queue));
        rabbitUtil.getChannel().queueBind(queue, EXCHANGE_NAME, routingKey);
        rabbitUtil.getChannel().basicConsume(queue, true, consumer);
    }
}

