/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.service.impl;

import com.xnx3.DateUtil;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.ConsoleUtil;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.j2ee.util.Sql;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.wangmarket.admin.Func;
import com.xnx3.wangmarket.admin.G;
import com.xnx3.wangmarket.admin.bean.News;
import com.xnx3.wangmarket.admin.bean.NewsDataBean;
import com.xnx3.wangmarket.admin.cache.TemplateCMS;
import com.xnx3.wangmarket.admin.cache.generateSite.DefaultGenerateHtmlInterfaceImpl;
import com.xnx3.wangmarket.admin.cache.generateSite.GenerateHtmlInterface;
import com.xnx3.wangmarket.admin.entity.InputModel;
import com.xnx3.wangmarket.admin.entity.NewsData;
import com.xnx3.wangmarket.admin.entity.Site;
import com.xnx3.wangmarket.admin.entity.SiteColumn;
import com.xnx3.wangmarket.admin.entity.SiteVar;
import com.xnx3.wangmarket.admin.entity.Template;
import com.xnx3.wangmarket.admin.entity.TemplatePageData;
import com.xnx3.wangmarket.admin.entity.TemplateVar;
import com.xnx3.wangmarket.admin.entity.TemplateVarData;
import com.xnx3.wangmarket.admin.pluginManage.interfaces.manage.GenerateHtmlStorateInterfaceManage;
import com.xnx3.wangmarket.admin.service.InputModelService;
import com.xnx3.wangmarket.admin.service.SiteColumnService;
import com.xnx3.wangmarket.admin.service.SiteVarService;
import com.xnx3.wangmarket.admin.service.TemplateService;
import com.xnx3.wangmarket.admin.util.SessionUtil;
import com.xnx3.wangmarket.admin.util.TemplateUtil;
import com.xnx3.wangmarket.admin.vo.GenerateSiteVO;
import com.xnx3.wangmarket.admin.vo.SiteColumnTreeVO;
import com.xnx3.wangmarket.admin.vo.TemplatePageListVO;
import com.xnx3.wangmarket.admin.vo.TemplatePageVO;
import com.xnx3.wangmarket.admin.vo.TemplateVO;
import com.xnx3.wangmarket.admin.vo.TemplateVarAndDataMapVO;
import com.xnx3.wangmarket.admin.vo.TemplateVarListVO;
import com.xnx3.wangmarket.admin.vo.TemplateVarVO;
import com.xnx3.wangmarket.admin.vo.bean.template.TemplatePage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;

@Service(value="TemplateService")
public class TemplateServiceImpl
implements TemplateService {
    public static String sessionTemplatePageListVO = "templatePageListVO";
    public static String html = "<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"utf-8\">\n<title>\u6a21\u7248\u9875\u9762</title>\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\">\n<!--XNX3HTMLEDIT--></head>\n<body>\n\n\n\u6a21\u7248\u7684\u5185\u5bb9\n\n\n</body>\n</html>";
    @Resource
    private SqlDAO sqlDAO;
    @Resource
    private InputModelService inputModelService;
    @Resource
    private SiteColumnService siteColumnService;
    @Resource
    private SiteVarService siteVarService;

    @Override
    public TemplatePageListVO getTemplatePageListByCache(HttpServletRequest request) {
        Site site = SessionUtil.getSite();
        TemplatePageListVO vo = (TemplatePageListVO)request.getSession().getAttribute(sessionTemplatePageListVO);
        if (vo == null) {
            String templateNameWhere = "";
            if (site.getTemplateName() != null && site.getTemplateName().length() > 0) {
                templateNameWhere = " AND template_page.template_name = '" + site.getTemplateName() + "'";
            }
            List templateList = this.sqlDAO.findBySqlQuery("SELECT * FROM template_page WHERE siteid = " + site.getId() + templateNameWhere, com.xnx3.wangmarket.admin.entity.TemplatePage.class);
            ArrayList<TemplatePageVO> templatePageVOList = new ArrayList<TemplatePageVO>();
            for (int i = 0; i < templateList.size(); ++i) {
                TemplatePageVO templatePageVO = new TemplatePageVO();
                templatePageVO.setTemplatePage((com.xnx3.wangmarket.admin.entity.TemplatePage)templateList.get(i));
                templatePageVOList.add(templatePageVO);
            }
            vo = new TemplatePageListVO();
            vo.setList(templatePageVOList);
            request.getSession().setAttribute(sessionTemplatePageListVO, (Object)vo);
        }
        return vo;
    }

    @Override
    public TemplatePageListVO getTemplatePageListByDatabase(Site site) {
        TemplatePageListVO vo = new TemplatePageListVO();
        String templateNameWhere = "";
        if (site.getTemplateName() != null && site.getTemplateName().length() > 0) {
            templateNameWhere = " AND template_page.template_name = '" + site.getTemplateName() + "'";
        }
        List templateList = this.sqlDAO.findBySqlQuery("SELECT * FROM template_page WHERE siteid = " + site.getId() + templateNameWhere, com.xnx3.wangmarket.admin.entity.TemplatePage.class);
        ArrayList<TemplatePageVO> templatePageVOList = new ArrayList<TemplatePageVO>();
        for (int i = 0; i < templateList.size(); ++i) {
            TemplatePageVO templatePageVO = new TemplatePageVO();
            templatePageVO.setTemplatePage((com.xnx3.wangmarket.admin.entity.TemplatePage)templateList.get(i));
            templatePageVOList.add(templatePageVO);
        }
        vo.setList(templatePageVOList);
        return vo;
    }

    @Override
    public BaseVO updateTemplatePageForCache(com.xnx3.wangmarket.admin.entity.TemplatePage templatePage, TemplatePageData templatePageData, HttpServletRequest request) {
        TemplatePageListVO vo = (TemplatePageListVO)request.getSession().getAttribute(sessionTemplatePageListVO);
        if (vo == null) {
            vo = this.getTemplatePageListByCache(request);
        }
        List<TemplatePageVO> templatePageVOList = vo.getList();
        boolean find = false;
        for (int i = 0; i < templatePageVOList.size(); ++i) {
            TemplatePageVO templatePageVO = templatePageVOList.get(i);
            if (templatePageVO.getTemplatePage().getId() - templatePage.getId() != 0) continue;
            templatePageVO.setTemplatePage(templatePage);
            if (templatePageData != null) {
                templatePageVO.setTemplatePageData(templatePageData);
            }
            find = true;
            break;
        }
        if (!find) {
            TemplatePageVO tpv = new TemplatePageVO();
            tpv.setTemplatePage(templatePage);
            tpv.setTemplatePageData(templatePageData);
            templatePageVOList.add(tpv);
        }
        request.getSession().setAttribute(sessionTemplatePageListVO, (Object)vo);
        return new BaseVO();
    }

    @Override
    public String getTemplatePageTextByCache(int templatePageId, HttpServletRequest request) {
        TemplatePageListVO vo = (TemplatePageListVO)request.getSession().getAttribute(sessionTemplatePageListVO);
        if (vo == null) {
            vo = this.getTemplatePageListByCache(request);
        }
        List<TemplatePageVO> templatePageVOList = vo.getList();
        for (int i = 0; i < templatePageVOList.size(); ++i) {
            TemplatePageVO templatePageVO = templatePageVOList.get(i);
            if (templatePageVO.getTemplatePage().getId() - templatePageId != 0) continue;
            if (templatePageVO.getTemplatePageData() != null) {
                return templatePageVO.getTemplatePageData().getText();
            }
            TemplatePageData tpd = (TemplatePageData)this.sqlDAO.findById(TemplatePageData.class, templatePageId);
            if (tpd == null) {
                tpd = new TemplatePageData();
                tpd.setId(templatePageId);
                tpd.setText("<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"utf-8\">\n<title>\u65b0\u5efa\u9875\u9762</title>\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\">\n<!--XNX3HTMLEDIT--></head>\n<body>\n\n\n\u9875\u9762\u5185\u5bb9\n\n\n</body>\n</html>");
            }
            templatePageVO.setTemplatePageData(tpd);
            request.getSession().setAttribute(sessionTemplatePageListVO, (Object)vo);
            return tpd.getText();
        }
        return null;
    }

    @Override
    public TemplatePageVO saveTemplatePageText(String fileName, String html, HttpServletRequest request) {
        TemplatePageVO vo = new TemplatePageVO();
        if ((fileName = SafetyUtil.filter((String)fileName)) == null || fileName.length() == 0) {
            vo.setBaseVO(0, "\u51fa\u9519\uff0c\u4f60\u8981\u4fee\u6539\u7684\u662f\u54ea\u4e2a\u6a21\u7248\u5462\uff1f");
            return vo;
        }
        Site site = SessionUtil.getSite();
        com.xnx3.wangmarket.admin.entity.TemplatePage templatePage = (com.xnx3.wangmarket.admin.entity.TemplatePage)this.sqlDAO.findAloneBySqlQuery("SELECT * FROM template_page WHERE siteid = " + site.getId() + " AND name = '" + fileName + "'", com.xnx3.wangmarket.admin.entity.TemplatePage.class);
        if (templatePage == null) {
            vo.setBaseVO(0, "\u8981\u4fdd\u5b58\u7684\u6a21\u7248\u9875\u4e0d\u5b58\u5728\uff01\u8bf7\u624b\u52a8\u590d\u5236\u4fdd\u5b58\u597d\u60a8\u5f53\u524d\u6240\u7f16\u8f91\u7684\u6a21\u7248\u9875\u5185\u5bb9\uff01");
            return vo;
        }
        TemplatePageData templatePageData = (TemplatePageData)this.sqlDAO.findAloneBySqlQuery("SELECT * FROM template_page_data WHERE id = " + templatePage.getId(), TemplatePageData.class);
        if (templatePageData == null) {
            templatePageData = new TemplatePageData();
            templatePageData.setId(templatePage.getId());
        }
        TemplateCMS templateCMS = new TemplateCMS(site, TemplateUtil.getTemplateByName(site.getTemplateName()));
        html = html.replaceAll(templateCMS.getTemplatePath(), "{templatePath}");
        if (templatePage.getEditMode() == null || templatePage.getEditMode() - com.xnx3.wangmarket.admin.entity.TemplatePage.EDIT_MODE_CODE != 0) {
            int htmledit_start = html.indexOf("<!--XNX3HTMLEDIT-->");
            if (htmledit_start > 0) {
                int htmledit_head = html.indexOf("</head>");
                if (htmledit_head != -1) {
                    html = html.substring(0, htmledit_start) + html.substring(htmledit_head, html.length());
                }
                html = html.indexOf("<body contenteditable=\"true\">") > -1 ? html.replace("<body contenteditable=\"true\">", "<body>") : html.replaceAll(" contenteditable=\"true\"", "");
            }
            if (html.indexOf("<!--templateVarStart-->") > -1) {
                com.xnx3.wangmarket.admin.cache.Template temp = new com.xnx3.wangmarket.admin.cache.Template(site);
                Pattern p = Pattern.compile("<!--templateVarStart-->([\\s|\\S]*?)<!--templateVarEnd-->");
                Matcher m = p.matcher(html);
                while (m.find()) {
                    String templateVarText = m.group(1);
                    String templateVarName = com.xnx3.wangmarket.admin.cache.Template.getConfigValue(templateVarText, "templateVarName");
                    templateVarName = Sql.filter((String)templateVarName);
                    templateVarText = templateVarText.replace("<!--templateVarName=" + templateVarName + "-->", "");
                    String content = null;
                    TemplateVarVO tvVO = this.getTemplateVarByCache(templateVarName);
                    if (tvVO.getResult() - 1 != 0) {
                        vo.setBaseVO(0, "\u5176\u4e2d\u4f7f\u7528\u7684\u6a21\u7248\u53d8\u91cf\u201c" + templateVarName + "\u201d\u4e0d\u5b58\u5728\uff01\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u518d\u5c1d\u8bd5\u4fdd\u5b58");
                        return vo;
                    }
                    content = tvVO.getInfo();
                    if (!content.replaceAll("\r|\n|\t", "").equals(templateVarText.replaceAll("\r|\n|\t", ""))) {
                        TemplateVar tv;
                        String templateNameWhere = "";
                        if (site.getTemplateName() != null && site.getTemplateName().length() > 0) {
                            templateNameWhere = " AND template_var.template_name = '" + site.getTemplateName() + "'";
                        }
                        if ((tv = (TemplateVar)this.sqlDAO.findAloneBySqlQuery("SELECT * FROM template_var WHERE siteid = " + site.getId() + templateNameWhere + " AND var_name = '" + templateVarName + "'", TemplateVar.class)) != null) {
                            tv.setUpdatetime(DateUtil.timeForUnix10());
                            this.sqlDAO.save((Object)tv);
                            TemplateVarData templateVarData = (TemplateVarData)this.sqlDAO.findById(TemplateVarData.class, (Object)tv.getId());
                            templateVarData.setText(templateVarText);
                            this.sqlDAO.save((Object)templateVarData);
                            this.updateTemplateVarForCache(tv, templateVarData);
                        }
                    }
                    html = html.replaceAll("<!--templateVarStart--><!--templateVarName=" + templateVarName + "-->([\\s|\\S]*?)<!--templateVarEnd-->", "{include=" + templateVarName + "}");
                }
            }
        }
        templatePageData.setText(html);
        this.sqlDAO.save((Object)templatePageData);
        this.updateTemplatePageForCache(templatePage, templatePageData, request);
        vo.setTemplatePage(templatePage);
        vo.setTemplatePageData(templatePageData);
        return vo;
    }

    @Override
    public String getTemplatePageTextByCache(String templatePageName, HttpServletRequest request) {
        templatePageName = SafetyUtil.filter((String)templatePageName);
        TemplatePageListVO vo = (TemplatePageListVO)request.getSession().getAttribute(sessionTemplatePageListVO);
        if (vo == null) {
            vo = this.getTemplatePageListByCache(request);
        }
        List<TemplatePageVO> templatePageVOList = vo.getList();
        for (int i = 0; i < templatePageVOList.size(); ++i) {
            TemplatePageVO templatePageVO = templatePageVOList.get(i);
            if (!templatePageVO.getTemplatePage().getName().equals(templatePageName)) continue;
            if (templatePageVO.getTemplatePageData() != null) {
                return templatePageVO.getTemplatePageData().getText();
            }
            TemplatePageData tpd = (TemplatePageData)this.sqlDAO.findById(TemplatePageData.class, (Object)templatePageVO.getTemplatePage().getId());
            templatePageVO.setTemplatePageData(tpd);
            request.getSession().setAttribute(sessionTemplatePageListVO, (Object)vo);
            return tpd.getText();
        }
        return null;
    }

    @Override
    public TemplatePageVO getTemplatePageIndexByCache(HttpServletRequest request) {
        TemplatePageListVO templatePageListVO = this.getTemplatePageListByCache(request);
        return this.getTemplatePageIndexByTemplatePageListVO(templatePageListVO);
    }

    private TemplatePageVO getTemplatePageIndexByTemplatePageListVO(TemplatePageListVO templatePageListVO) {
        for (int i = 0; i < templatePageListVO.getList().size(); ++i) {
            TemplatePageVO templatePageVO = templatePageListVO.getList().get(i);
            if (templatePageVO.getTemplatePage().getType() - com.xnx3.wangmarket.admin.entity.TemplatePage.TYPE_INDEX != 0) continue;
            return templatePageVO;
        }
        TemplatePageVO templatePageVO = new TemplatePageVO();
        templatePageVO.setBaseVO(0, "\u672a\u53d1\u73b0\u9996\u9875\u6a21\u7248");
        return templatePageVO;
    }

    public void generateViewHtmlForTemplate(Site site, com.xnx3.wangmarket.admin.entity.News news, SiteColumn siteColumn, NewsDataBean newsDataBean, HttpServletRequest request) {
        String templateHtml = this.getTemplatePageTextByCache(siteColumn.getTemplatePageViewName(), request);
        if (templateHtml == null) {
            return;
        }
        TemplateCMS template = new TemplateCMS(site, TemplateUtil.getTemplateByName(site.getTemplateName()));
        template.setSiteVar(this.siteVarService.getVar(site.getId()));
        String pageHtml = template.assemblyTemplateVar(templateHtml, this.getTemplateVarAndDataByDatabase(site).getCompileMap());
        pageHtml = template.replaceSiteColumnTag(pageHtml, siteColumn);
        pageHtml = template.replacePublicTag(pageHtml);
        pageHtml = template.replaceNewsTag(pageHtml, news, siteColumn, newsDataBean);
        pageHtml = pageHtml.replaceAll(com.xnx3.wangmarket.admin.cache.Template.regex("title"), news.getTitle() + "_" + site.getName());
        pageHtml = pageHtml.replaceAll(com.xnx3.wangmarket.admin.cache.Template.regex("keywords"), news.getTitle() + "," + site.getKeywords());
        pageHtml = pageHtml.replaceAll(com.xnx3.wangmarket.admin.cache.Template.regex("description"), news.getIntro());
        pageHtml = pageHtml.replaceAll(com.xnx3.wangmarket.admin.cache.Template.regex("text"), template.replaceNewsText(newsDataBean.getText()));
        String generateUrl = "";
        generateUrl = news.getType() - com.xnx3.wangmarket.admin.entity.News.TYPE_PAGE == 0 ? "site/" + site.getId() + "/c" + news.getCid() + ".html" : "site/" + site.getId() + "/" + news.getId() + ".html";
        AttachmentUtil.putStringFile((String)generateUrl, (String)pageHtml);
    }

    @Override
    public void updateTemplateVarForCache(TemplateVar templateVar, TemplateVarData templateVarData) {
        if (SessionUtil.getTemplateVarMapForOriginal() == null || SessionUtil.getTemplateVarCompileDataMap() == null) {
            this.loadDatabaseTemplateVarToCache();
        }
        SessionUtil.getTemplateVarCompileDataMap().put(templateVar.getVarName(), templateVarData.getText());
        Map<String, String> compileDataMap = SessionUtil.getTemplateVarCompileDataMap();
        compileDataMap.put(templateVar.getVarName(), templateVarData.getText());
        SessionUtil.getTemplateVarCompileDataMap().put(templateVar.getVarName(), templateVarData.getText());
        SessionUtil.setTemplateVarCompileDataMap(compileDataMap);
        TemplateVarVO templateVarVO = new TemplateVarVO();
        templateVarVO.setTemplateVar(templateVar);
        templateVarVO.setTemplateVarData(templateVarData);
        SessionUtil.getTemplateVarMapForOriginal().put(templateVar.getVarName(), templateVarVO);
        Map<String, TemplateVarVO> originalMap = SessionUtil.getTemplateVarMapForOriginal();
        originalMap.put(templateVar.getVarName(), templateVarVO);
        SessionUtil.setTemplateVarMapForOriginal(originalMap);
    }

    @Override
    public void loadDatabaseTemplateVarToCache() {
        Site site;
        TemplateVarAndDataMapVO vo;
        if (SessionUtil.getTemplateVarMapForOriginal() == null && (vo = this.getTemplateVarAndDataByDatabase(site = SessionUtil.getSite())).getResult() - 1 == 0) {
            SessionUtil.setTemplateVarCompileDataMap(vo.getCompileMap());
            SessionUtil.setTemplateVarMapForOriginal(vo.getTemplateVarMapForOriginal());
        }
    }

    @Override
    public BaseVO changeTemplate(Site mysite, String templateName, boolean copySiteColumn) {
        BaseVO vo = new BaseVO();
        if ((templateName = SafetyUtil.filter((String)templateName)).length() == 0) {
            vo.setBaseVO(0, "\u8bf7\u9009\u62e9\u66f4\u6539\u4e3a\u7684\u6a21\u7248");
            return vo;
        }
        return vo;
    }

    @Override
    public BaseVO addNewDefaultTemplatePageForIndex(Site site) {
        BaseVO vo = new BaseVO();
        com.xnx3.wangmarket.admin.entity.TemplatePage templatePage = new com.xnx3.wangmarket.admin.entity.TemplatePage();
        templatePage.setName("index");
        templatePage.setSiteid(site.getId());
        templatePage.setTemplateName(site.getTemplateName());
        templatePage.setType(com.xnx3.wangmarket.admin.entity.TemplatePage.TYPE_INDEX);
        templatePage.setUserid(site.getUserid());
        this.sqlDAO.save((Object)templatePage);
        if (templatePage.getId() != null && templatePage.getId() > 0) {
            TemplatePageData tpd = new TemplatePageData();
            tpd.setId(templatePage.getId());
            tpd.setText(html);
            this.sqlDAO.save((Object)tpd);
        } else {
            vo.setBaseVO(0, "\u9996\u9875\u6a21\u7248\u521b\u5efa\u5931\u8d25");
        }
        return vo;
    }

    @Override
    public TemplateVarVO getTemplateVarByCache(String templateVarName) {
        TemplateVarVO vo = new TemplateVarVO();
        if (SessionUtil.getTemplateVarMapForOriginal() == null) {
            this.loadDatabaseTemplateVarToCache();
        }
        if (SessionUtil.getTemplateVarMapForOriginal().get(templateVarName) == null) {
            vo.setBaseVO(0, "\u6a21\u7248\u53d8\u91cf\u4e0d\u5b58\u5728");
        } else {
            vo = SessionUtil.getTemplateVarMapForOriginal().get(templateVarName);
        }
        return vo;
    }

    @Override
    public BaseVO exportTemplate(HttpServletRequest request) {
        BaseVO vo = new BaseVO();
        Site site = SessionUtil.getSite();
        TemplatePageListVO tplVO = this.getTemplatePageAndDateListByCache(request);
        ArrayList templatePageList = new ArrayList();
        for (int i = 0; i < tplVO.getList().size(); ++i) {
            TemplatePageVO tpv = tplVO.getList().get(i);
            com.xnx3.wangmarket.admin.entity.TemplatePage tp = tpv.getTemplatePage();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", StringUtil.StringToUtf8((String)tp.getName()));
            map.put("remark", StringUtil.StringToUtf8((String)tp.getRemark()));
            map.put("type", tp.getType());
            map.put("text", StringUtil.StringToUtf8((String)tpv.getTemplatePageData().getText()));
            map.put("editMode", tp.getEditMode() == null ? com.xnx3.wangmarket.admin.entity.TemplatePage.EDIT_MODE_VISUAL : tp.getEditMode());
            templatePageList.add(map);
        }
        TemplateVarListVO tvlVO = this.getTemplateVarAndDateListByCache();
        ArrayList templateVarList = new ArrayList();
        for (int i = 0; i < tvlVO.getList().size(); ++i) {
            TemplateVarVO tvv = tvlVO.getList().get(i);
            TemplateVar tv = tvv.getTemplateVar();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("remark", StringUtil.StringToUtf8((String)tv.getRemark()));
            map.put("var_name", StringUtil.StringToUtf8((String)tv.getVarName()));
            map.put("text", StringUtil.StringToUtf8((String)tvv.getTemplateVarData().getText()));
            templateVarList.add(map);
        }
        List<SiteColumn> siteColumnList_Original = this.siteColumnService.getSiteColumnListByCache();
        ArrayList<SiteColumn> siteColumnList = new ArrayList<SiteColumn>();
        for (int i = 0; i < siteColumnList_Original.size(); ++i) {
            SiteColumn sc_ori = siteColumnList_Original.get(i);
            SiteColumn sc = new SiteColumn();
            sc.setName(StringUtil.StringToUtf8((String)sc_ori.getName()));
            sc.setTemplatePageListName(StringUtil.StringToUtf8((String)sc_ori.getTemplatePageListName()));
            sc.setTemplatePageViewName(StringUtil.StringToUtf8((String)sc_ori.getTemplatePageViewName()));
            sc.setCodeName(StringUtil.StringToUtf8((String)sc_ori.getCodeName()));
            sc.setParentCodeName(StringUtil.StringToUtf8((String)sc_ori.getParentCodeName()));
            sc.setInputModelCodeName(StringUtil.StringToUtf8((String)sc_ori.getInputModelCodeName()));
            sc.setRank(sc_ori.getRank());
            sc.setUsed(sc_ori.getUsed());
            sc.setType(sc_ori.getType());
            sc.setListNum(sc_ori.getListNum());
            sc.setEditMode(sc_ori.getEditMode());
            sc.setInputModelCodeName(sc_ori.getInputModelCodeName());
            sc.setListRank(sc_ori.getListRank() == null ? SiteColumn.LIST_RANK_ADDTIME_ASC : sc_ori.getListRank());
            sc.setEditUseExtendPhotos(sc_ori.getEditUseExtendPhotos() == null ? SiteColumn.USED_UNABLE : sc_ori.getEditUseExtendPhotos());
            sc.setEditUseIntro(sc_ori.getEditUseIntro() == null ? SiteColumn.USED_UNABLE : sc_ori.getEditUseIntro());
            sc.setEditUseText(sc_ori.getEditUseText() == null ? SiteColumn.USED_UNABLE : sc_ori.getEditUseText());
            sc.setEditUseTitlepic(sc_ori.getEditUseTitlepic() == null ? SiteColumn.USED_UNABLE : sc_ori.getEditUseTitlepic());
            sc.setUseGenerateView(sc_ori.getUseGenerateView() == null ? SiteColumn.USED_ENABLE : sc_ori.getUseGenerateView());
            sc.setIcon(sc_ori.getIcon() == null ? "" : sc_ori.getIcon());
            sc.setKeywords(sc_ori.getKeywords() == null ? "" : sc_ori.getKeywords());
            sc.setDescription(sc_ori.getDescription() == null ? "" : sc_ori.getDescription());
            sc.setTemplateCodeColumnUsed(sc_ori.getTemplateCodeColumnUsed());
            sc.setAdminNewsUsed(sc_ori.getAdminNewsUsed());
            siteColumnList.add(sc);
        }
        List<InputModel> inputModelList_Original = this.inputModelService.getInputModelListForSession();
        ArrayList<InputModel> inputModelList = new ArrayList<InputModel>();
        for (int i = 0; i < inputModelList_Original.size(); ++i) {
            InputModel im_ori = inputModelList_Original.get(i);
            InputModel im = new InputModel();
            im.setCodeName(StringUtil.StringToUtf8((String)im_ori.getCodeName()));
            im.setRemark(StringUtil.StringToUtf8((String)im_ori.getRemark()));
            im.setText(StringUtil.StringToUtf8((String)im_ori.getText()));
            inputModelList.add(im);
        }
        JSONObject siteVarJson = this.siteVarService.getVar(site.getId());
        JSONObject utf8SiteVar = new JSONObject();
        for (Map.Entry entry : siteVarJson.entrySet()) {
            JSONObject textObj = (JSONObject)entry.getValue();
            JSONObject uft8SubJson = new JSONObject();
            for (Map.Entry subEntry : textObj.entrySet()) {
                uft8SubJson.put(subEntry.getKey(), (Object)StringUtil.StringToUtf8((String)((String)subEntry.getValue())));
            }
            utf8SiteVar.put(entry.getKey(), (Object)uft8SubJson);
        }
        JSONObject jo = new JSONObject();
        jo.put((Object)"systemVersion", (Object)G.VERSION);
        jo.put((Object)"time", (Object)DateUtil.timeForUnix10());
        jo.put((Object)"templateName", (Object)StringUtil.StringToUtf8((String)site.getTemplateName()));
        jo.put((Object)"sourceUrl", (Object)StringUtil.StringToUtf8((String)Func.getDomain(site)));
        jo.put((Object)"useUtf8Encode", (Object)"true");
        Template template = (Template)this.sqlDAO.findAloneByProperty(Template.class, "name", (Object)site.getTemplateName());
        if (template != null) {
            JSONObject tempJson = new JSONObject();
            tempJson.put((Object)"addtime", (Object)template.getAddtime());
            tempJson.put((Object)"companyname", (Object)(template.getCompanyname() == null ? "" : StringUtil.StringToUtf8((String)template.getCompanyname())));
            tempJson.put((Object)"iscommon", (Object)template.getIscommon());
            tempJson.put((Object)"previewUrl", (Object)(template.getPreviewUrl() == null ? "" : StringUtil.StringToUtf8((String)template.getPreviewUrl())));
            tempJson.put((Object)"remark", (Object)StringUtil.StringToUtf8((String)template.getRemark()));
            tempJson.put((Object)"siteurl", (Object)(template.getSiteurl() == null ? "" : StringUtil.StringToUtf8((String)template.getSiteurl())));
            tempJson.put((Object)"terminalDisplay", (Object)template.getTerminalDisplay());
            tempJson.put((Object)"terminalIpad", (Object)template.getTerminalIpad());
            tempJson.put((Object)"terminalMobile", (Object)template.getTerminalMobile());
            tempJson.put((Object)"terminalPc", (Object)template.getTerminalPc());
            tempJson.put((Object)"type", (Object)template.getType());
            tempJson.put((Object)"username", (Object)(template.getUsername() == null ? "" : StringUtil.StringToUtf8((String)template.getUsername())));
            tempJson.put((Object)"name", (Object)StringUtil.StringToUtf8((String)template.getName()));
            tempJson.put((Object)"previewPic", (Object)StringUtil.StringToUtf8((String)template.getPreviewPic()));
            tempJson.put((Object)"wscsoDownUrl", (Object)StringUtil.StringToUtf8((String)template.getWscsoDownUrl()));
            tempJson.put((Object)"zipDownUrl", (Object)StringUtil.StringToUtf8((String)template.getZipDownUrl()));
            tempJson.put((Object)"resourceImport", (Object)(template.getResourceImport() != null ? template.getResourceImport() : "private"));
            jo.put((Object)"template", (Object)tempJson);
        }
        jo.put((Object)"templatePageList", templatePageList);
        jo.put((Object)"templateVarList", templateVarList);
        jo.put((Object)"siteColumnList", siteColumnList);
        jo.put((Object)"inputModelList", inputModelList);
        jo.put((Object)"siteVar", (Object)utf8SiteVar);
        vo.setInfo(jo.toString());
        return vo;
    }

    @Override
    public BaseVO importTemplate(String templateText, boolean copySiteColumn, HttpServletRequest request) {
        int i;
        BaseVO vo = new BaseVO();
        TemplatePageListVO tpl = this.getTemplatePageListByCache(request);
        if (tpl.getList().size() > 0) {
            vo.setBaseVO(0, "\u8be5\u7f51\u7ad9\u5df2\u6709\u6a21\u7248\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u5bfc\u5165\u3002\u53ef\u6309 F5 \u952e\u5237\u65b0");
            return vo;
        }
        TemplateVO tvo = new TemplateVO();
        tvo.importText(templateText);
        for (i = 0; i < tvo.getTemplatePageList().size(); ++i) {
            TemplatePage templatePageBean = tvo.getTemplatePageList().get(i);
            com.xnx3.wangmarket.admin.entity.TemplatePage ntp = templatePageBean.getTemplatePage();
            this.sqlDAO.save((Object)ntp);
            if (ntp.getId() == null || ntp.getId() == 0) {
                System.out.println("\u6a21\u7248\u9875\u590d\u5236\u51fa\u9519\uff0c\u6ca1\u4fdd\u5b58\u6210\u529f\u8fdb\u6570\u636e\u5e93:" + ntp.toString());
                continue;
            }
            TemplatePageData tpd = new TemplatePageData();
            tpd.setId(ntp.getId());
            tpd.setText(templatePageBean.getText());
            this.sqlDAO.save((Object)tpd);
        }
        for (i = 0; i < tvo.getTemplateVarList().size(); ++i) {
            com.xnx3.wangmarket.admin.vo.bean.template.TemplateVar templateVarBean = tvo.getTemplateVarList().get(i);
            TemplateVar tv = templateVarBean.getTemplateVar();
            this.sqlDAO.save((Object)tv);
            if (tv.getId() == null || tv.getId() == 0) {
                System.out.println("\u6a21\u7248\u53d8\u91cf\u590d\u5236\u51fa\u9519\uff0c\u6ca1\u4fdd\u5b58\u6210\u529f\u8fdb\u6570\u636e\u5e93:" + tv.toString());
                continue;
            }
            TemplateVarData tvd = new TemplateVarData();
            tvd.setId(tv.getId());
            tvd.setText(templateVarBean.getText());
            this.sqlDAO.save((Object)tvd);
        }
        for (i = 0; i < tvo.getInputModelList().size(); ++i) {
            InputModel inputModel = tvo.getInputModelList().get(i);
            this.sqlDAO.save((Object)inputModel);
        }
        if (tvo.getSiteVarJson().size() > 0) {
            this.sqlDAO.executeSql("DELETE FROM site_var WHERE id = " + tvo.getCurrentSite().getId());
            SiteVar siteVar = new SiteVar();
            siteVar.setId(tvo.getCurrentSite().getId());
            siteVar.setText(tvo.getSiteVarJson().toString());
            this.sqlDAO.save((Object)siteVar);
        }
        if (copySiteColumn) {
            for (int i2 = 0; i2 < tvo.getSiteColumnList().size(); ++i2) {
                SiteColumn siteColumn = tvo.getSiteColumnList().get(i2);
                this.sqlDAO.save((Object)siteColumn);
                if (siteColumn.getType() - SiteColumn.TYPE_NEWS == 0 || siteColumn.getType() - SiteColumn.TYPE_IMAGENEWS == 0 || siteColumn.getType() - SiteColumn.TYPE_LIST == 0 || siteColumn.getType() - SiteColumn.TYPE_PAGE != 0 && siteColumn.getType() - SiteColumn.TYPE_ALONEPAGE != 0) continue;
                if (siteColumn.getId() == null || siteColumn.getId() == 0) {
                    System.out.println("\u521b\u5efa\u680f\u76ee\u5931\u8d25\uff01\uff01" + siteColumn.toString());
                    continue;
                }
                com.xnx3.wangmarket.admin.entity.News news = new com.xnx3.wangmarket.admin.entity.News();
                news.setAddtime(DateUtil.timeForUnix10());
                news.setCid(siteColumn.getId());
                news.setIntro(siteColumn.getName());
                news.setSiteid(tvo.getCurrentSite().getId());
                news.setStatus(com.xnx3.wangmarket.admin.entity.News.STATUS_NORMAL);
                news.setTitle(siteColumn.getName());
                news.setType(SiteColumn.TYPE_ALONEPAGE);
                news.setUserid(tvo.getCurrentSite().getUserid());
                this.sqlDAO.save((Object)news);
                if (news.getId() == null || news.getId() <= 0) continue;
                NewsData newsData = new NewsData();
                newsData.setId(news.getId());
                newsData.setText("\u8fd9\u662f" + news.getTitle() + "\u7684\u5185\u5bb9\uff0c\u8bf7\u767b\u5f55\u7f51\u7ad9\u7ba1\u7406\u540e\u53f0\uff0c\u627e\u5230\u5185\u5bb9\u7ba1\u7406\uff0c\u81ea\u884c\u4fee\u6539\u8fd9\u4e9b\u5185\u5bb9");
                this.sqlDAO.save((Object)newsData);
            }
        }
        if (tvo.getPlugin() == null || tvo.getPlugin().length() < 2) {
            Site s = (Site)this.sqlDAO.findById(Site.class, (Object)tvo.getCurrentSite().getId());
            s.setTemplateName(tvo.getTemplateName());
            this.sqlDAO.save((Object)s);
            SessionUtil.setSite(s);
        }
        this.reloadTemplateVarCache(request);
        this.reloadTemplatePageCache(request);
        return vo;
    }

    public void reloadTemplatePageCache(HttpServletRequest request) {
        request.getSession().setAttribute(sessionTemplatePageListVO, null);
        this.getTemplatePageListByCache(request);
    }

    public void reloadTemplateVarCache(HttpServletRequest request) {
        SessionUtil.setTemplateVarMapForOriginal(null);
        SessionUtil.setTemplateVarCompileDataMap(null);
        this.getTemplateVarAndDateListByCache();
    }

    @Override
    public List<TemplateVar> getTemplateVarList() {
        Site site = SessionUtil.getSite();
        String templateNameWhere = "";
        if (site.getTemplateName() != null && site.getTemplateName().length() > 0) {
            templateNameWhere = " AND template_var.template_name = '" + site.getTemplateName() + "'";
        }
        return this.sqlDAO.findBySqlQuery("SELECT * FROM template_var WHERE siteid = " + site.getId() + templateNameWhere + " ORDER BY id DESC", TemplateVar.class);
    }

    @Override
    public BaseVO deleteTemplatePageForCache(int templatePageId, HttpServletRequest request) {
        TemplatePageListVO vo = this.getTemplatePageListByCache(request);
        int deleteId = -1;
        for (int i = 0; i < vo.getList().size(); ++i) {
            if (vo.getList().get(i).getTemplatePage().getId() - templatePageId != 0) continue;
            deleteId = i;
            break;
        }
        if (deleteId > -1) {
            vo.getList().remove(deleteId);
            request.getSession().setAttribute(sessionTemplatePageListVO, (Object)vo);
        }
        return new BaseVO();
    }

    @Override
    public TemplatePageVO getTemplatePageByNameForCache(HttpServletRequest request, String templatePageName) {
        TemplatePageVO vo = new TemplatePageVO();
        if (templatePageName == null || templatePageName.length() == 0) {
            vo.setBaseVO(0, "\u8981\u8c03\u53d6\u7684\u6a21\u7248\u9875\u7684\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TemplatePageListVO tpl = this.getTemplatePageListByCache(request);
        for (int i = 0; i < tpl.getList().size(); ++i) {
            TemplatePageVO tpVO = tpl.getList().get(i);
            if (!templatePageName.equals(tpVO.getTemplatePage().getName())) continue;
            TemplatePageData tpd = new TemplatePageData();
            String tpd_S = this.getTemplatePageTextByCache(tpVO.getTemplatePage().getId(), request);
            tpd.setId(tpVO.getTemplatePage().getId());
            tpd.setText(tpd_S == null ? "<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"utf-8\">\n<title>\u65b0\u5efa\u9875\u9762</title>\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\">\n<!--XNX3HTMLEDIT--></head>\n<body>\n\n\n\u9875\u9762\u5185\u5bb9\n\n\n</body>\n</html>" : tpd_S);
            tpVO.setTemplatePageData(tpd);
            return tpVO;
        }
        vo.setBaseVO(0, "\u8981\u8c03\u53d6\u7684\u6a21\u7248\u9875\u4e0d\u5b58\u5728");
        return vo;
    }

    @Override
    public TemplateVarListVO getTemplateVarListByCache() {
        if (SessionUtil.getTemplateVarMapForOriginal() == null) {
            this.loadDatabaseTemplateVarToCache();
        }
        TemplateVarListVO listVO = new TemplateVarListVO();
        ArrayList<TemplateVarVO> list = new ArrayList<TemplateVarVO>();
        for (Map.Entry<String, TemplateVarVO> entry : SessionUtil.getTemplateVarMapForOriginal().entrySet()) {
            list.add(entry.getValue());
        }
        listVO.setList(list);
        return listVO;
    }

    @Override
    public TemplatePageListVO getTemplatePageAndDateListByCache(HttpServletRequest request) {
        TemplatePageListVO vo = this.getTemplatePageListByCache(request);
        boolean usedSqlQuery = false;
        for (int i = 0; i < vo.getList().size(); ++i) {
            if (vo.getList().get(i).getTemplatePageData() != null) continue;
            usedSqlQuery = true;
            break;
        }
        if (usedSqlQuery) {
            int i;
            Site site = SessionUtil.getSite();
            String templateNameWhere = "";
            if (site.getTemplateName() != null && site.getTemplateName().length() > 0) {
                templateNameWhere = " AND template_page.template_name = '" + site.getTemplateName() + "'";
            }
            List tpdList = this.sqlDAO.findBySqlQuery("SELECT template_page_data.* FROM template_page, template_page_data WHERE template_page.id = template_page_data.id AND siteid = " + site.getId() + templateNameWhere, TemplatePageData.class);
            HashMap<Integer, TemplatePageData> tpdMap = new HashMap<Integer, TemplatePageData>();
            for (i = 0; i < tpdList.size(); ++i) {
                TemplatePageData tpd = (TemplatePageData)tpdList.get(i);
                tpdMap.put(tpd.getId(), tpd);
            }
            for (i = 0; i < vo.getList().size(); ++i) {
                TemplatePageVO tpvo = vo.getList().get(i);
                tpvo.setTemplatePageData((TemplatePageData)tpdMap.get(tpvo.getTemplatePage().getId()));
            }
        }
        return vo;
    }

    @Override
    public TemplateVarListVO getTemplateVarAndDateListByCache() {
        TemplateVarListVO vo = this.getTemplateVarListByCache();
        boolean usedSqlQuery = false;
        for (int i = 0; i < vo.getList().size(); ++i) {
            if (vo.getList().get(i).getTemplateVarData() != null) continue;
            usedSqlQuery = true;
            break;
        }
        if (usedSqlQuery) {
            int i;
            Site site = SessionUtil.getSite();
            String templateNameWhere = "";
            if (site.getTemplateName() != null && site.getTemplateName().length() > 0) {
                templateNameWhere = " AND template_var.template_name = '" + site.getTemplateName() + "'";
            }
            List tvdList = this.sqlDAO.findBySqlQuery("SELECT template_var_data.* FROM template_var, template_var_data WHERE template_var.id = template_var_data.id AND siteid = " + site.getId() + templateNameWhere, TemplateVarData.class);
            HashMap<Integer, TemplateVarData> tvdMap = new HashMap<Integer, TemplateVarData>();
            for (i = 0; i < tvdList.size(); ++i) {
                TemplateVarData tvd = (TemplateVarData)tvdList.get(i);
                tvdMap.put(tvd.getId(), tvd);
            }
            for (i = 0; i < vo.getList().size(); ++i) {
                TemplateVarVO tvvo = vo.getList().get(i);
                tvvo.setTemplateVarData((TemplateVarData)tvdMap.get(tvvo.getTemplateVar().getId()));
            }
        }
        return vo;
    }

    @Override
    public BaseVO deleteTemplateVarForCache(int templateVarId) {
        String deleteVarName = null;
        for (Map.Entry<String, TemplateVarVO> entry : SessionUtil.getTemplateVarMapForOriginal().entrySet()) {
            if (entry.getValue().getTemplateVar().getId() - templateVarId != 0) continue;
            deleteVarName = entry.getValue().getTemplateVar().getVarName();
        }
        SessionUtil.getTemplateVarMapForOriginal().remove(deleteVarName);
        if (SessionUtil.getTemplateVarCompileDataMap() != null && SessionUtil.getTemplateVarCompileDataMap().get(deleteVarName) != null) {
            SessionUtil.getTemplateVarCompileDataMap().remove(deleteVarName);
        }
        return new BaseVO();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GenerateSiteVO generateSiteHTML(HttpServletRequest request, Site site) {
        SiteColumnTreeVO sct;
        SiteColumnTreeVO scTree;
        Object siteColumn;
        int i;
        void var16_22;
        GenerateSiteVO vo = new GenerateSiteVO();
        boolean useDatabase = false;
        if (site == null) {
            site = SessionUtil.getSite();
            useDatabase = false;
        } else {
            useDatabase = true;
        }
        if (site == null) {
            vo.setBaseVO(0, "\u5c1a\u672a\u767b\u9646");
            return vo;
        }
        GenerateHtmlInterface generateHtmlInterface = null;
        try {
            generateHtmlInterface = GenerateHtmlStorateInterfaceManage.getGenerateHtmlInterfaceImpl(request, site);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (generateHtmlInterface == null) {
            System.out.println("generateHtmlInterface == null");
            generateHtmlInterface = new DefaultGenerateHtmlInterfaceImpl(site);
        }
        ConsoleUtil.log((String)generateHtmlInterface.toString());
        TemplateCMS template = new TemplateCMS(site, TemplateUtil.getTemplateByName(site.getTemplateName()));
        template.setGenerateHtmlInterface(generateHtmlInterface);
        template.setSiteVar(this.siteVarService.getVar(site.getId()));
        TemplatePageVO templatePageIndexVO = null;
        TemplatePageListVO templatePageListVO = null;
        templatePageListVO = useDatabase ? this.getTemplatePageListByDatabase(site) : this.getTemplatePageListByCache(request);
        templatePageIndexVO = this.getTemplatePageIndexByTemplatePageListVO(templatePageListVO);
        List siteColumnList = this.sqlDAO.findBySqlQuery("SELECT * FROM site_column WHERE siteid = " + site.getId() + " ORDER BY rank ASC", SiteColumn.class);
        List newsList = this.sqlDAO.findBySqlQuery("SELECT * FROM news WHERE siteid = " + site.getId() + " AND status = " + com.xnx3.wangmarket.admin.entity.News.STATUS_NORMAL + " ORDER BY addtime DESC", com.xnx3.wangmarket.admin.entity.News.class);
        List newsDataList = this.sqlDAO.findBySqlQuery("SELECT news_data.* FROM news,news_data WHERE news.siteid = " + site.getId() + " AND news.status = " + com.xnx3.wangmarket.admin.entity.News.STATUS_NORMAL + " AND news.id = news_data.id ORDER BY news.id DESC", NewsData.class);
        HashMap<String, SiteColumn> columnMap = new HashMap<String, SiteColumn>();
        HashMap<String, List<com.xnx3.wangmarket.admin.entity.News>> columnNewsMap = new HashMap<String, List<com.xnx3.wangmarket.admin.entity.News>>();
        for (int i2 = 0; i2 < siteColumnList.size(); ++i2) {
            SiteColumn siteColumn2 = (SiteColumn)siteColumnList.get(i2);
            ArrayList<com.xnx3.wangmarket.admin.entity.News> arrayList = new ArrayList<com.xnx3.wangmarket.admin.entity.News>();
            for (int j = 0; j < newsList.size(); ++j) {
                com.xnx3.wangmarket.admin.entity.News news = (com.xnx3.wangmarket.admin.entity.News)newsList.get(j);
                if (news.getCid() - siteColumn2.getId() != 0) continue;
                arrayList.add(news);
                newsList.remove(j);
                --j;
            }
            if (siteColumn2.getListRank() != null && siteColumn2.getListRank() - SiteColumn.LIST_RANK_ADDTIME_ASC == 0) {
                Collections.sort(arrayList, new Comparator<com.xnx3.wangmarket.admin.entity.News>(){

                    @Override
                    public int compare(com.xnx3.wangmarket.admin.entity.News n1, com.xnx3.wangmarket.admin.entity.News n2) {
                        return n1.getAddtime() - n2.getAddtime();
                    }
                });
            }
            columnMap.put(siteColumn2.getCodeName(), siteColumn2);
            columnNewsMap.put(siteColumn2.getCodeName(), arrayList);
        }
        HashMap<Integer, SiteColumn> columnMapForId = new HashMap<Integer, SiteColumn>();
        for (Map.Entry entry : columnMap.entrySet()) {
            columnMapForId.put(((SiteColumn)entry.getValue()).getId(), (SiteColumn)entry.getValue());
        }
        HashMap<Integer, NewsDataBean> newsDataMap = new HashMap<Integer, NewsDataBean>();
        boolean bl = false;
        while (var16_22 < newsDataList.size()) {
            NewsData nd = (NewsData)newsDataList.get((int)var16_22);
            newsDataMap.put(nd.getId(), new NewsDataBean(nd));
            ++var16_22;
        }
        HashMap<String, SiteColumnTreeVO> hashMap = new HashMap<String, SiteColumnTreeVO>();
        for (i = 0; i < siteColumnList.size(); ++i) {
            siteColumn = (SiteColumn)siteColumnList.get(i);
            if (((SiteColumn)siteColumn).getParentCodeName() != null && ((SiteColumn)siteColumn).getParentCodeName().length() != 0) continue;
            scTree = new SiteColumnTreeVO();
            scTree.setSiteColumn((SiteColumn)siteColumn);
            scTree.setList(new ArrayList<SiteColumnTreeVO>());
            scTree.setLevel(1);
            hashMap.put(((SiteColumn)siteColumn).getCodeName(), scTree);
        }
        for (i = 0; i < siteColumnList.size(); ++i) {
            siteColumn = (SiteColumn)siteColumnList.get(i);
            if (((SiteColumn)siteColumn).getParentCodeName() == null || ((SiteColumn)siteColumn).getParentCodeName().length() <= 0) continue;
            scTree = new SiteColumnTreeVO();
            scTree.setSiteColumn((SiteColumn)siteColumn);
            scTree.setList(new ArrayList<SiteColumnTreeVO>());
            scTree.setLevel(2);
            if (hashMap.get(((SiteColumn)siteColumn).getParentCodeName()) == null) continue;
            ((SiteColumnTreeVO)((Object)hashMap.get(((SiteColumn)siteColumn).getParentCodeName()))).getList().add(scTree);
        }
        HashMap columnTreeNewsMap = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            sct = (SiteColumnTreeVO)((Object)entry.getValue());
            if (sct.getList().size() <= 0) continue;
            columnTreeNewsMap.put(sct.getSiteColumn().getCodeName(), new ArrayList());
            for (int i4 = 0; i4 < sct.getList().size(); ++i4) {
                SiteColumnTreeVO subSct = sct.getList().get(i4);
                if (subSct.getSiteColumn().getType() - SiteColumn.TYPE_LIST != 0) continue;
                ArrayList<News> nList = new ArrayList<News>();
                List oList = (List)columnNewsMap.get(subSct.getSiteColumn().getCodeName());
                for (int j = 0; j < oList.size(); ++j) {
                    News n = new News();
                    com.xnx3.wangmarket.admin.entity.News news = (com.xnx3.wangmarket.admin.entity.News)oList.get(j);
                    n.setNews(news);
                    n.setRank(news.getId());
                    nList.add(n);
                }
                ((List)columnTreeNewsMap.get(sct.getSiteColumn().getCodeName())).addAll(nList);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            sct = (SiteColumnTreeVO)((Object)entry.getValue());
            if (sct.getList().size() <= 0) continue;
            Collections.sort((List)columnTreeNewsMap.get(sct.getSiteColumn().getCodeName()), new Comparator<News>(){

                @Override
                public int compare(News n1, News n2) {
                    if (sct.getSiteColumn().getListRank() != null && sct.getSiteColumn().getListRank() - SiteColumn.LIST_RANK_ADDTIME_ASC == 0) {
                        return n2.getNews().getAddtime() - n1.getNews().getAddtime();
                    }
                    return n1.getNews().getAddtime() - n2.getNews().getAddtime();
                }
            });
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            sct = (SiteColumnTreeVO)((Object)entry.getValue());
            if (sct.getList().size() <= 0) continue;
            List nList = (List)columnTreeNewsMap.get(sct.getSiteColumn().getCodeName());
            for (int i5 = nList.size() - 1; i5 >= 0; --i5) {
                ((List)columnNewsMap.get(sct.getSiteColumn().getCodeName())).add(((News)nList.get(i5)).getNews());
            }
        }
        TemplatePageListVO tplVO = this.getTemplatePageListByCache(request);
        if (tplVO == null || tplVO.getList().size() == 0) {
            vo.setBaseVO(0, "\u5f53\u524d\u7f51\u7ad9\u5c1a\u672a\u9009\u62e9/\u5bfc\u5165/\u589e\u52a0\u6a21\u7248\uff0c\u751f\u6210\u5931\u8d25\uff01\u7f51\u7ad9\u6709\u6a21\u7248\u540e\u624d\u80fd\u6839\u636e\u6a21\u7248\u751f\u6210\u6574\u7ad9\uff01");
            return vo;
        }
        Map<String, TemplateVarVO> templateVarVOMapForOriginal = null;
        Map<String, String> templateVarCompileDataMap = null;
        if (useDatabase) {
            TemplateVarAndDataMapVO templateVarAndDataMapVO = this.getTemplateVarAndDataByDatabase(site);
            templateVarVOMapForOriginal = templateVarAndDataMapVO.getTemplateVarMapForOriginal();
            templateVarCompileDataMap = templateVarAndDataMapVO.getCompileMap();
        } else {
            templateVarVOMapForOriginal = SessionUtil.getTemplateVarMapForOriginal();
            templateVarCompileDataMap = SessionUtil.getTemplateVarCompileDataMap();
            if (templateVarVOMapForOriginal == null) {
                templateVarVOMapForOriginal = new HashMap<String, TemplateVarVO>();
                templateVarCompileDataMap = new HashMap<String, String>();
                SessionUtil.setTemplateVarMapForOriginal(templateVarVOMapForOriginal);
                SessionUtil.setTemplateVarCompileDataMap(templateVarCompileDataMap);
            }
        }
        for (Map.Entry<String, TemplateVarVO> entry : templateVarVOMapForOriginal.entrySet()) {
            String v = template.replacePublicTag(entry.getValue().getTemplateVarData().getText());
            v = template.replaceSiteColumnBlock(v, columnNewsMap, columnMap, hashMap, true, null, newsDataMap);
            templateVarCompileDataMap.put(entry.getKey(), v);
        }
        if (!useDatabase) {
            SessionUtil.setTemplateVarCompileDataMap(templateVarCompileDataMap);
        }
        HashMap<String, String> templateCacheMap = new HashMap<String, String>();
        for (int i6 = 0; i6 < templatePageListVO.getList().size(); ++i6) {
            TemplatePageVO tpVO = templatePageListVO.getList().get(i6);
            String text = null;
            if (tpVO.getTemplatePageData() == null) {
                TemplatePageData tpd = (TemplatePageData)this.sqlDAO.findById(TemplatePageData.class, (Object)tpVO.getTemplatePage().getId());
                if (tpd != null) {
                    text = tpd.getText();
                }
            } else {
                text = tpVO.getTemplatePageData().getText();
            }
            if (text == null) {
                vo.setBaseVO(0, "\u6a21\u7248\u9875" + tpVO.getTemplatePage().getName() + "\u7684\u5185\u5bb9\u4e0d\u5b58\u5728\uff01\u8bf7\u5148\u68c0\u67e5\u6b64\u6a21\u7248\u9875");
                return vo;
            }
            text = template.replacePublicTag(text);
            text = template.replaceSiteColumnBlock(text, columnNewsMap, columnMap, hashMap, true, null, newsDataMap);
            text = template.assemblyTemplateVar(text, templateVarCompileDataMap);
            templateCacheMap.put(tpVO.getTemplatePage().getName(), text);
        }
        String indexHtml = "";
        if (templatePageIndexVO.getResult() - 0 == 0) {
            indexHtml = "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"><title>\u6a21\u677f\u4e2d\u6ca1\u6709\u9996\u9875\u6a21\u677f</title></head><body>\t\u60a8\u597d\uff0c\u770b\u5230\u6b64\u9875\u9762\uff0c\u8bf4\u660e\u60a8\u7684\u6a21\u677f\u4e2d\u6ca1\u6709\u9996\u9875\u6a21\u677f\uff01\u4f60\u53ef\u4ee5\u767b\u5f55\u4f60\u7f51\u7ad9\u7ba1\u7406\u540e\u53f0\uff0c\u627e\u5230\u5de6\u4fa7\u6a21\u677f\u7ba1\u7406-\u6a21\u677f\u9875\u9762\uff0c\u770b\u770b\u91cc\u9762\u7684\u7c7b\u578b\u4e00\u680f\uff0c\u662f\u4e0d\u662f\u6ca1\u6709\u9996\u9875\u6a21\u677f</body></html>";
        } else {
            indexHtml = (String)templateCacheMap.get(templatePageIndexVO.getTemplatePage().getName());
            indexHtml = template.replaceSiteColumnBlock(indexHtml, columnNewsMap, columnMap, hashMap, true, null, newsDataMap);
            indexHtml = template.replacePublicTag(indexHtml);
        }
        generateHtmlInterface.putStringFile(indexHtml, "index.html");
        for (SiteColumn siteColumn3 : columnMap.values()) {
            if (siteColumn3.getCodeName() == null || siteColumn3.getCodeName().length() == 0) {
                vo.setBaseVO(0, "\u680f\u76ee[" + siteColumn3.getName() + "]\u7684\u201c\u680f\u76ee\u4ee3\u7801\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u4e3a\u5176\u8bbe\u7f6e\u680f\u76ee\u4ee3\u7801");
                return vo;
            }
            List columnNewsList = (List)columnNewsMap.get(siteColumn3.getCodeName());
            String viewTemplateHtml = (String)templateCacheMap.get(siteColumn3.getTemplatePageViewName());
            if (viewTemplateHtml == null) {
                vo.setBaseVO(0, "\u680f\u76ee[" + siteColumn3.getName() + "]\u672a\u7ed1\u5b9a\u9875\u9762\u5185\u5bb9\u6a21\u7248\uff0c\u8bf7\u53bb\u7ed1\u5b9a");
                return vo;
            }
            viewTemplateHtml = template.replaceSiteColumnBlock(viewTemplateHtml, columnNewsMap, columnMap, hashMap, false, siteColumn3, newsDataMap);
            if (siteColumn3.getType() - SiteColumn.TYPE_LIST == 0 || siteColumn3.getType() - SiteColumn.TYPE_NEWS == 0 || siteColumn3.getType() - SiteColumn.TYPE_IMAGENEWS == 0) {
                String listTemplateHtml = (String)templateCacheMap.get(siteColumn3.getTemplatePageListName());
                if (listTemplateHtml == null) {
                    vo.setBaseVO(0, "\u680f\u76ee[" + siteColumn3.getName() + "]\u672a\u7ed1\u5b9a\u6a21\u7248\u5217\u8868\u9875\u9762\uff0c\u8bf7\u53bb\u7ed1\u5b9a\uff0c\u6216\u5220\u9664\u8fd9\u4e2a\u680f\u76ee");
                    return vo;
                }
                listTemplateHtml = template.replaceSiteColumnBlock(listTemplateHtml, columnNewsMap, columnMap, hashMap, false, siteColumn3, newsDataMap);
                template.generateListHtmlForWholeSite(listTemplateHtml, siteColumn3, columnNewsList, newsDataMap, columnMapForId);
                if (siteColumn3.getUseGenerateView() != null && siteColumn3.getUseGenerateView() - SiteColumn.USED_ENABLE != 0) continue;
                for (int i7 = 0; i7 < columnNewsList.size(); ++i7) {
                    com.xnx3.wangmarket.admin.entity.News news = (com.xnx3.wangmarket.admin.entity.News)columnNewsList.get(i7);
                    if (siteColumn3.getId() - news.getCid() != 0) continue;
                    com.xnx3.wangmarket.admin.entity.News upNews = null;
                    com.xnx3.wangmarket.admin.entity.News nextNews = null;
                    if (i7 > 0) {
                        upNews = (com.xnx3.wangmarket.admin.entity.News)columnNewsList.get(i7 - 1);
                    }
                    if (i7 + 1 < columnNewsList.size()) {
                        nextNews = (com.xnx3.wangmarket.admin.entity.News)columnNewsList.get(i7 + 1);
                    }
                    template.generateViewHtmlForTemplateForWholeSite(news, siteColumn3, (NewsDataBean)newsDataMap.get(news.getId()), viewTemplateHtml, upNews, nextNews);
                }
                continue;
            }
            if (siteColumn3.getType() - SiteColumn.TYPE_ALONEPAGE != 0 && siteColumn3.getType() - SiteColumn.TYPE_PAGE != 0) continue;
            if (siteColumn3.getEditMode() - SiteColumn.EDIT_MODE_TEMPLATE == 0) {
                template.generateViewHtmlForTemplateForWholeSite(null, siteColumn3, new NewsDataBean(null), viewTemplateHtml, null, null);
                continue;
            }
            for (int i8 = 0; i8 < columnNewsList.size(); ++i8) {
                com.xnx3.wangmarket.admin.entity.News news = (com.xnx3.wangmarket.admin.entity.News)columnNewsList.get(i8);
                template.generateViewHtmlForTemplateForWholeSite(news, siteColumn3, (NewsDataBean)newsDataMap.get(news.getId()), viewTemplateHtml, null, null);
            }
        }
        vo.setNewsDataMap(newsDataMap);
        vo.setNewsMap(columnNewsMap);
        vo.setSiteColumnMap(columnMap);
        return vo;
    }

    @Override
    public Map<String, TemplateVarVO> getTemplateVarVoMapByCache() {
        if (Func.getUserBeanForShiroSession().getTemplateVarMapForOriginal() == null) {
            this.getTemplateVarAndDateListByCache();
        }
        Map<String, TemplateVarVO> templateVarVOMap = Func.getUserBeanForShiroSession().getTemplateVarMapForOriginal();
        return templateVarVOMap;
    }

    @Override
    public TemplateVarAndDataMapVO getTemplateVarAndDataByDatabase(Site site) {
        TemplateVarAndDataMapVO vo = new TemplateVarAndDataMapVO();
        if (site == null) {
            vo.setBaseVO(0, "\u7f51\u7ad9\u4e0d\u5b58\u5728");
            return vo;
        }
        String templateNameWhere = "";
        if (site.getTemplateName() != null && site.getTemplateName().length() > 0) {
            templateNameWhere = " AND template_var.template_name = '" + site.getTemplateName() + "'";
        }
        List templateVarList = this.sqlDAO.findBySqlQuery("SELECT * FROM template_var WHERE siteid = " + site.getId() + templateNameWhere, TemplateVar.class);
        List templateVarDataList = this.sqlDAO.findBySqlQuery("SELECT template_var_data.* FROM template_var,template_var_data WHERE template_var.siteid = " + site.getId() + " AND template_var.id = template_var_data.id" + templateNameWhere, TemplateVarData.class);
        HashMap<Integer, TemplateVarData> tvdMap = new HashMap<Integer, TemplateVarData>();
        for (int i = 0; i < templateVarDataList.size(); ++i) {
            TemplateVarData templateVarData = (TemplateVarData)templateVarDataList.get(i);
            tvdMap.put(templateVarData.getId(), templateVarData);
        }
        HashMap<String, String> compileMap = new HashMap<String, String>();
        HashMap<String, TemplateVarVO> templateVarMapForOriginal = new HashMap<String, TemplateVarVO>();
        for (int i = 0; i < templateVarList.size(); ++i) {
            TemplateVar templateVar = (TemplateVar)templateVarList.get(i);
            TemplateVarVO tvvo = new TemplateVarVO();
            tvvo.setTemplateVar(templateVar);
            tvvo.setTemplateVarData((TemplateVarData)tvdMap.get(templateVar.getId()));
            compileMap.put(templateVar.getVarName(), tvvo.getTemplateVarData().getText());
            templateVarMapForOriginal.put(templateVar.getVarName(), tvvo);
        }
        vo.setTemplateVarMapForOriginal(templateVarMapForOriginal);
        vo.setCompileMap(compileMap);
        return vo;
    }
}

