/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.wangmarket.admin.service.impl;

import com.xnx3.DateUtil;
import com.xnx3.FileUtil;
import com.xnx3.StringUtil;
import com.xnx3.j2ee.dao.SqlDAO;
import com.xnx3.j2ee.util.AttachmentUtil;
import com.xnx3.j2ee.util.SafetyUtil;
import com.xnx3.j2ee.util.SystemUtil;
import com.xnx3.j2ee.vo.BaseVO;
import com.xnx3.wangmarket.admin.bean.NewsDataBean;
import com.xnx3.wangmarket.admin.cache.GenerateHTML;
import com.xnx3.wangmarket.admin.cache.Site;
import com.xnx3.wangmarket.admin.cache.Template;
import com.xnx3.wangmarket.admin.cache.pc.IndexAboutUs;
import com.xnx3.wangmarket.admin.cache.pc.IndexNews;
import com.xnx3.wangmarket.admin.entity.Carousel;
import com.xnx3.wangmarket.admin.entity.News;
import com.xnx3.wangmarket.admin.entity.NewsData;
import com.xnx3.wangmarket.admin.entity.SiteColumn;
import com.xnx3.wangmarket.admin.entity.SiteData;
import com.xnx3.wangmarket.admin.service.NewsService;
import com.xnx3.wangmarket.admin.service.SiteColumnService;
import com.xnx3.wangmarket.admin.service.SiteService;
import com.xnx3.wangmarket.admin.service.TemplateService;
import com.xnx3.wangmarket.admin.util.SessionUtil;
import com.xnx3.wangmarket.admin.vo.IndexVO;
import com.xnx3.wangmarket.admin.vo.SiteRemainHintVO;
import com.xnx3.wangmarket.admin.vo.SiteVO;
import com.xnx3.wangmarket.admin.vo.bean.TemplateCommon;
import com.xnx3.wangmarket.agencyadmin.entity.Agency;
import com.xnx3.wangmarket.domain.bean.MQBean;
import com.xnx3.wangmarket.domain.bean.SimpleSite;
import com.xnx3.wangmarket.domain.mq.DomainMQ;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service(value="siteService")
public class SiteServiceImpl
implements SiteService {
    @Resource
    private SqlDAO sqlDAO;
    @Resource
    private NewsService newsService;
    @Resource
    private SiteColumnService siteColumnService;
    @Resource
    private TemplateService templateService;

    @Override
    public void generateSiteIndex(com.xnx3.wangmarket.admin.entity.Site site) {
        GenerateHTML gh = new GenerateHTML(site);
        String html = null;
        if (site.getClient() - com.xnx3.wangmarket.admin.entity.Site.CLIENT_PC != 0 && site.getClient() - com.xnx3.wangmarket.admin.entity.Site.CLIENT_WAP == 0) {
            html = gh.wapIndex();
        }
        if (html != null) {
            AttachmentUtil.putStringFile((String)("site/" + site.getId() + "/index.html"), (String)html);
        }
    }

    @Override
    public BaseVO refreshSiteGenerateHtml(HttpServletRequest request) {
        com.xnx3.wangmarket.admin.entity.Site site = SessionUtil.getSite();
        List siteColumnList = this.sqlDAO.findBySqlQuery("SELECT * FROM site_column WHERE siteid = " + site.getId() + " AND used = " + SiteColumn.USED_ENABLE, SiteColumn.class);
        HashMap<Integer, SiteColumn> siteColumnMap = new HashMap<Integer, SiteColumn>();
        for (int i = 0; i < siteColumnList.size(); ++i) {
            SiteColumn siteColumn = (SiteColumn)siteColumnList.get(i);
            siteColumnMap.put(siteColumn.getId(), siteColumn);
            if (siteColumn.getType() - SiteColumn.TYPE_NEWS != 0 && siteColumn.getType() - SiteColumn.TYPE_IMAGENEWS != 0) continue;
            this.newsService.generateListHtml(site, siteColumn);
        }
        List listNews = this.sqlDAO.findBySqlQuery("SELECT news.* FROM news WHERE news.siteid = " + site.getId() + " AND news.status = " + News.STATUS_NORMAL + " ORDER BY news.id DESC", News.class);
        List listNewsData = this.sqlDAO.findBySqlQuery("SELECT news_data.* FROM news,news_data WHERE news.id = news_data.id AND news.siteid = " + site.getId() + " AND news.status = " + News.STATUS_NORMAL, NewsData.class);
        for (int i = 0; i < listNews.size(); ++i) {
            News news = (News)listNews.get(i);
            NewsData newsData = (NewsData)listNewsData.get(i);
            this.newsService.generateViewHtml(site, news, (SiteColumn)siteColumnMap.get(news.getCid()), new NewsDataBean(newsData), request);
        }
        if (site.getClient() == com.xnx3.wangmarket.admin.entity.Site.CLIENT_WAP) {
            this.generateSiteIndex(site);
        } else {
            News aboutUsNews = (News)this.sqlDAO.findAloneBySqlQuery("SELECT * FROM news WHERE cid = " + site.getAboutUsCid(), News.class);
            NewsData aboutUsNewsData = null;
            if (aboutUsNews != null) {
                aboutUsNewsData = (NewsData)this.sqlDAO.findAloneBySqlQuery("SELECT * FROM news_data WHERE id = " + aboutUsNews.getId(), NewsData.class);
            }
            SiteColumn aboutUsSiteColumn = (SiteColumn)this.sqlDAO.findAloneBySqlQuery("SELECT * FROM site_column WHERE id = " + site.getAboutUsCid(), SiteColumn.class);
            SiteColumn NewsSiteColumn = null;
            SiteColumn ImagesSiteColumn = null;
            for (int i = 0; i < siteColumnList.size(); ++i) {
                SiteColumn sc = (SiteColumn)siteColumnList.get(i);
                if (NewsSiteColumn == null && sc.getType() - SiteColumn.TYPE_NEWS == 0) {
                    NewsSiteColumn = sc;
                    continue;
                }
                if (ImagesSiteColumn != null || sc.getType() - SiteColumn.TYPE_IMAGENEWS != 0) continue;
                ImagesSiteColumn = sc;
            }
            SiteData siteData = (SiteData)this.sqlDAO.findById(SiteData.class, (Object)site.getId());
            if (siteData == null) {
                siteData = new SiteData();
                siteData.setId(site.getId());
                siteData.setIndexDescription(site.getName());
                this.sqlDAO.save((Object)siteData);
            }
            this.generateSitePcIndex(site, aboutUsSiteColumn, NewsSiteColumn, ImagesSiteColumn, siteData);
            NewsData ndAU = aboutUsNewsData;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            IndexAboutUs.refreshIndexData(site, aboutUsSiteColumn, aboutUsNews, ndAU.getText());
            ArrayList<News> newsList = new ArrayList<News>();
            ArrayList<News> imagesList = new ArrayList<News>();
            for (int i = 0; i < listNews.size() && (newsList.size() != 10 || imagesList.size() != 10); ++i) {
                News news = (News)listNews.get(i);
                if (newsList.size() < 10 && NewsSiteColumn != null && news.getCid() - NewsSiteColumn.getId() == 0) {
                    newsList.add(news);
                    continue;
                }
                if (imagesList.size() >= 10 || ImagesSiteColumn == null || news.getCid() - ImagesSiteColumn.getId() != 0) continue;
                imagesList.add(news);
            }
            SiteColumn scNews = NewsSiteColumn;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            IndexNews.refreshIndexData(site, scNews, newsList);
            SiteColumn scImages = ImagesSiteColumn;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            IndexNews.refreshIndexData(site, scImages, imagesList);
        }
        return new BaseVO();
    }

    @Override
    public BaseVO refreshIndex(com.xnx3.wangmarket.admin.entity.Site site) {
        IndexVO indexVO_image;
        IndexVO indexVO_aboutus;
        BaseVO vo = new BaseVO();
        if (site == null) {
            vo.setBaseVO(0, "\u4f20\u5165\u7684\u7ad9\u70b9\u4e0d\u5b58\u5728");
            return vo;
        }
        GenerateHTML gh = new GenerateHTML(site);
        String indexHtml = gh.pcIndex();
        News aboutUsNews = (News)this.sqlDAO.findAloneBySqlQuery("SELECT * FROM news WHERE cid = " + site.getAboutUsCid(), News.class);
        NewsData aboutUsNewsData = null;
        if (aboutUsNews != null) {
            aboutUsNewsData = (NewsData)this.sqlDAO.findAloneBySqlQuery("SELECT * FROM news_data WHERE id = " + aboutUsNews.getId(), NewsData.class);
        }
        SiteColumn aboutUsSiteColumn = (SiteColumn)this.sqlDAO.findAloneBySqlQuery("SELECT * FROM site_column WHERE id = " + site.getAboutUsCid(), SiteColumn.class);
        SiteColumn newsSiteColumn = null;
        SiteColumn imagesSiteColumn = null;
        List siteColumnList = this.sqlDAO.findBySqlQuery("SELECT * FROM site_column WHERE siteid = " + site.getId() + " AND used = " + SiteColumn.USED_ENABLE, SiteColumn.class);
        for (int i = 0; i < siteColumnList.size(); ++i) {
            SiteColumn sc = (SiteColumn)siteColumnList.get(i);
            if (newsSiteColumn == null && sc.getType() - SiteColumn.TYPE_NEWS == 0) {
                newsSiteColumn = sc;
                continue;
            }
            if (imagesSiteColumn != null || sc.getType() - SiteColumn.TYPE_IMAGENEWS != 0) continue;
            imagesSiteColumn = sc;
        }
        indexHtml = indexHtml.replaceAll("<!--Index_Content_AboutUs_Start--><!--id=0-->", "<!--Index_Content_AboutUs_Start--><!--id=" + (aboutUsSiteColumn == null ? "0" : "" + aboutUsSiteColumn.getId()) + "-->");
        indexHtml = indexHtml.replaceAll("<!--Index_Content_NewsList_Start--><!--id=0-->", "<!--Index_Content_NewsList_Start--><!--id=" + (newsSiteColumn == null ? "0" : "" + newsSiteColumn.getId()) + "-->");
        indexHtml = indexHtml.replaceAll("<!--Index_Content_NewsImageList_Start--><!--id=0-->", "<!--Index_Content_NewsImageList_Start--><!--id=" + (imagesSiteColumn == null ? "0" : "" + imagesSiteColumn.getId()) + "-->");
        SiteData siteData = (SiteData)this.sqlDAO.findById(SiteData.class, (Object)site.getId());
        if (siteData == null) {
            siteData = new SiteData();
            siteData.setId(site.getId());
            siteData.setIndexDescription(site.getName());
            this.sqlDAO.save((Object)siteData);
        }
        if ((indexVO_aboutus = IndexAboutUs.refreshIndexData(site, aboutUsSiteColumn, aboutUsNews, aboutUsNewsData.getText(), indexHtml)).getResult() == 1) {
            indexHtml = indexVO_aboutus.getText();
        }
        List listNews = this.sqlDAO.findBySqlQuery("SELECT news.* FROM news WHERE news.siteid = " + site.getId() + " AND news.status = " + News.STATUS_NORMAL + " ORDER BY news.id DESC", News.class);
        ArrayList<News> newsList = new ArrayList<News>();
        ArrayList<News> imagesList = new ArrayList<News>();
        for (int i = 0; i < listNews.size() && (newsList.size() != 10 || imagesList.size() != 10); ++i) {
            News news = (News)listNews.get(i);
            if (newsList.size() < 10 && newsSiteColumn != null && news.getCid() - newsSiteColumn.getId() == 0) {
                newsList.add(news);
                continue;
            }
            if (imagesList.size() >= 10 || imagesSiteColumn == null || news.getCid() - imagesSiteColumn.getId() != 0) continue;
            imagesList.add(news);
        }
        IndexVO indexVO_news = IndexNews.refreshIndexData(site, newsSiteColumn, newsList, indexHtml);
        if (indexVO_news.getResult() == 1) {
            indexHtml = indexVO_news.getText();
        }
        if ((indexVO_image = IndexNews.refreshIndexData(site, imagesSiteColumn, imagesList, indexHtml)).getResult() == 1) {
            indexHtml = indexVO_image.getText();
        }
        gh.generateIndexHtml(indexHtml, siteData);
        return new BaseVO();
    }

    @Override
    public TemplateCommon getTemplateCommonHtml(com.xnx3.wangmarket.admin.entity.Site site, String title, Model model) {
        if (site == null) {
            site = new com.xnx3.wangmarket.admin.entity.Site();
            site.setId(0);
            site.setName("");
            site.setTemplateId(1);
        }
        TemplateCommon tc = new TemplateCommon();
        GenerateHTML gh = new GenerateHTML(site);
        Template temp = new Template(site);
        gh.setEditMode(true);
        String headHtml = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + gh.templateId + "/common/head.html"));
        headHtml = gh.replacePublicTag(headHtml);
        headHtml = headHtml.replaceAll(GenerateHTML.regex("title"), title);
        headHtml = temp.replaceForEditModeTag(headHtml);
        String topHtml = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + gh.templateId + "/common/top.html"));
        topHtml = gh.replacePublicTag(topHtml);
        topHtml = topHtml.replaceAll(GenerateHTML.regex("title"), title);
        topHtml = temp.replaceForEditModeTag(topHtml);
        String footHtml = FileUtil.read((String)(SystemUtil.getProjectPath() + "/static/template/" + gh.templateId + "/common/foot.html"));
        footHtml = gh.replacePublicTag(footHtml);
        footHtml = temp.replaceForEditModeTag(footHtml);
        model.addAttribute("headHtml", (Object)headHtml);
        model.addAttribute("topHtml", (Object)topHtml);
        model.addAttribute("footHtml", (Object)footHtml);
        return tc;
    }

    @Override
    public SiteVO saveSite(com.xnx3.wangmarket.admin.entity.Site s, int siteUserId, HttpServletRequest request) {
        com.xnx3.wangmarket.admin.entity.Site site;
        SiteVO baseVO = new SiteVO();
        String name = "";
        if (s.getName() != null && s.getName().length() > 0) {
            name = StringUtil.filterXss((String)s.getName());
        }
        if (name.length() == 0) {
            baseVO.setBaseVO(0, "\u60a8\u7684\u7ad9\u70b9\u53eb\u4ec0\u4e48\u540d\u5b57\u5462?");
            return baseVO;
        }
        if (s.getId() != null && s.getId() > 0) {
            com.xnx3.wangmarket.admin.entity.Site currentLoginSite = SessionUtil.getSite();
            site = (com.xnx3.wangmarket.admin.entity.Site)this.sqlDAO.findById(com.xnx3.wangmarket.admin.entity.Site.class, (Object)s.getId());
            if (site == null) {
                baseVO.setBaseVO(0, "\u8981\u7f16\u8f91\u7684\u7ad9\u70b9\u4e0d\u5b58\u5728");
                return baseVO;
            }
            if (site.getId() - currentLoginSite.getId() != 0) {
                baseVO.setBaseVO(0, "\u7ad9\u70b9\u4e0d\u5c5e\u4e8e\u60a8\uff0c\u65e0\u6cd5\u64cd\u4f5c\uff01");
                return baseVO;
            }
        } else {
            site = new com.xnx3.wangmarket.admin.entity.Site();
            site.setAddtime(DateUtil.timeForUnix10());
            site.setUserid(siteUserId);
            site.setDomain(siteUserId + DateUtil.currentDate((String)"mmss"));
        }
        site.setAddress(s.getAddress());
        site.setCompanyName(s.getCompanyName());
        site.setUsername(StringUtil.filterXss((String)s.getUsername()));
        site.setName(name);
        site.setmShowBanner(s.getmShowBanner());
        site.setPhone(s.getPhone());
        site.setQq(StringUtil.filterXss((String)s.getQq()));
        site.setBindDomain(s.getBindDomain() == null ? "" : StringUtil.filterXss((String)s.getBindDomain()));
        site.setExpiretime(s.getExpiretime());
        if (s.getClient() - com.xnx3.wangmarket.admin.entity.Site.CLIENT_PC == 0) {
            site.setClient(s.getClient());
        } else if (s.getClient() - com.xnx3.wangmarket.admin.entity.Site.CLIENT_CMS == 0) {
            site.setTemplateName(StringUtil.filterXss((String)s.getTemplateName()));
            site.setClient(s.getClient());
        } else {
            site.setClient(com.xnx3.wangmarket.admin.entity.Site.CLIENT_WAP);
        }
        if (s.getClient() - com.xnx3.wangmarket.admin.entity.Site.CLIENT_CMS != 0) {
            if (s.getTemplateId() != null && s.getTemplateId() > 0) {
                site.setTemplateId(s.getTemplateId());
            } else if (s.getId() == null || s.getId() == 0) {
                if (site.getClient() - com.xnx3.wangmarket.admin.entity.Site.CLIENT_PC == 0) {
                    site.setTemplateId(6);
                } else {
                    site.setTemplateId(1);
                }
            }
            site.setTemplateName("");
        } else {
            site.setTemplateId(0);
        }
        String keywords = s.getKeywords();
        if (keywords == null || keywords.length() == 0) {
            keywords = site.getName();
            if (site.getCompanyName() != null && !site.getName().equals(site.getCompanyName()) && site.getCompanyName().length() > 0) {
                keywords = keywords + "," + site.getCompanyName();
            }
            if (site.getUsername() != null && !site.getName().equals(site.getUsername()) && site.getUsername().length() > 0) {
                keywords = keywords + "," + site.getUsername();
            }
        }
        site.setKeywords(SafetyUtil.filter((String)keywords));
        if (site.getLogo() == null) {
            site.setLogo("");
        }
        if (site.getColumnId() == null) {
            site.setColumnId("");
        }
        if (site.getAboutUsCid() == null) {
            site.setAboutUsCid(0);
        }
        this.sqlDAO.save((Object)site);
        if (site.getId() > 0) {
            ArrayList<SiteColumn> columnList = new ArrayList<SiteColumn>();
            if (s.getId() > 0) {
                if (s.getClient() - com.xnx3.wangmarket.admin.entity.Site.CLIENT_CMS != 0) {
                    this.generateSiteIndex(site);
                }
            } else {
                if (s.getClient() - com.xnx3.wangmarket.admin.entity.Site.CLIENT_CMS != 0) {
                    String description = site.getName();
                    if (site.getCompanyName() != null && !site.getName().equals(site.getCompanyName()) && site.getCompanyName().length() > 0) {
                        description = description + "\uff0c\u96b6\u5c5e\u4e8e" + site.getCompanyName();
                    }
                    if (site.getAddress() != null && !site.getName().equals(site.getAddress()) && site.getAddress().length() > 0) {
                        description = description + "\uff0c\u5730\u7406\u4f4d\u7f6e\u4f4d\u4e8e" + site.getAddress();
                    }
                    if (site.getUsername() != null && !site.getName().equals(site.getUsername()) && site.getUsername().length() > 0) {
                        description = description + "\uff0c\u4e1a\u52a1\u8d1f\u8d23\u4eba\uff1a" + site.getUsername();
                    }
                    if (site.getPhone() != null && site.getPhone().length() > 0) {
                        description = description + "\uff0c\u8054\u7cfb\u7535\u8bdd\uff1a" + site.getPhone();
                    }
                    SiteData siteData = new SiteData();
                    siteData.setId(site.getId());
                    siteData.setIndexDescription(description);
                    this.sqlDAO.save((Object)siteData);
                    SiteColumn sc = new SiteColumn();
                    sc.setIcon(SystemUtil.get((String)"MASTER_SITE_URL") + "default/aboutUs.jpg");
                    sc.setName("\u5173\u4e8e\u6211\u4eec");
                    sc.setParentid(0);
                    sc.setRank(1);
                    sc.setSiteid(site.getId());
                    sc.setType(SiteColumn.TYPE_PAGE);
                    sc.setUsed(SiteColumn.USED_ENABLE);
                    sc.setUserid(siteUserId);
                    this.sqlDAO.save((Object)sc);
                    News news = new News();
                    news.setAddtime(DateUtil.timeForUnix10());
                    news.setCid(sc.getId());
                    news.setIntro(sc.getName());
                    news.setSiteid(site.getId());
                    news.setStatus(News.STATUS_NORMAL);
                    news.setTitle(sc.getName());
                    news.setTitlepic(SystemUtil.get((String)"MASTER_SITE_URL") + "default/aboutUs.jpg");
                    news.setType(News.TYPE_PAGE);
                    news.setUserid(siteUserId);
                    news.setLegitimate((short)1);
                    this.sqlDAO.save((Object)news);
                    NewsData newsData = new NewsData(news.getId(), news.getIntro());
                    this.sqlDAO.save((Object)newsData);
                    ArrayList<Carousel> carouselList = new ArrayList<Carousel>();
                    Carousel carousel = new Carousel();
                    carousel.setAddtime(DateUtil.timeForUnix10());
                    carousel.setImage(AttachmentUtil.netUrl() + "default/banner.jpg");
                    carousel.setIsshow((short)1);
                    carousel.setSiteid(site.getId());
                    carousel.setUserid(siteUserId);
                    carousel.setUrl("");
                    carousel.setType((short)1);
                    this.sqlDAO.save((Object)carousel);
                    carouselList.add(carousel);
                    new Site().carousel(carouselList, site);
                    site.setAboutUsCid(sc.getId());
                    this.sqlDAO.save((Object)site);
                    if (site.getClient() == com.xnx3.wangmarket.admin.entity.Site.CLIENT_PC) {
                        GenerateHTML gh = new GenerateHTML(site);
                        Template temp = new Template(site);
                        String index = gh.pcIndex();
                        SiteColumn newsSiteColumn = new SiteColumn();
                        newsSiteColumn.setIcon(AttachmentUtil.netUrl() + "image/default_newsColumn.png");
                        newsSiteColumn.setName("\u65b0\u95fb\u54a8\u8be2");
                        newsSiteColumn.setParentid(0);
                        newsSiteColumn.setRank(2);
                        newsSiteColumn.setSiteid(site.getId());
                        newsSiteColumn.setType(SiteColumn.TYPE_NEWS);
                        newsSiteColumn.setUrl("");
                        newsSiteColumn.setUsed(SiteColumn.USED_ENABLE);
                        newsSiteColumn.setUserid(site.getUserid());
                        this.sqlDAO.save((Object)newsSiteColumn);
                        News xwNews = new News();
                        xwNews.setAddtime(DateUtil.timeForUnix10());
                        xwNews.setCid(newsSiteColumn.getId());
                        xwNews.setSiteid(site.getId());
                        xwNews.setStatus(News.STATUS_NORMAL);
                        xwNews.setTitle("\u70ed\u70c8\u5e86\u795d" + site.getName() + "\u7f51\u7ad9\u6210\u7acb");
                        xwNews.setIntro(xwNews.getTitle() + ",\u5404\u65cf\u4eba\u6c11\u524d\u6765\u6b22\u5e86\u3002");
                        xwNews.setTitlepic(AttachmentUtil.netUrl() + "image/default_news_titlepic.png");
                        xwNews.setType(News.TYPE_NEWS);
                        xwNews.setUserid(siteUserId);
                        xwNews.setLegitimate((short)1);
                        this.sqlDAO.save((Object)xwNews);
                        NewsData xwNewsData = new NewsData(xwNews.getId(), xwNews.getIntro());
                        this.sqlDAO.save((Object)xwNewsData);
                        site.setColumnId(this.getSiteColumnId(newsSiteColumn, site));
                        SiteColumn imageSiteColumn = new SiteColumn();
                        imageSiteColumn.setIcon(AttachmentUtil.netUrl() + "image/default_project_column.png");
                        imageSiteColumn.setName("\u4ea7\u54c1\u5c55\u793a");
                        imageSiteColumn.setParentid(0);
                        imageSiteColumn.setRank(3);
                        imageSiteColumn.setSiteid(site.getId());
                        imageSiteColumn.setType(SiteColumn.TYPE_IMAGENEWS);
                        imageSiteColumn.setUrl("");
                        imageSiteColumn.setUsed(SiteColumn.USED_ENABLE);
                        imageSiteColumn.setUserid(site.getUserid());
                        this.sqlDAO.save((Object)imageSiteColumn);
                        News productNews = new News();
                        productNews.setAddtime(DateUtil.timeForUnix10());
                        productNews.setCid(imageSiteColumn.getId());
                        productNews.setSiteid(site.getId());
                        productNews.setStatus(News.STATUS_NORMAL);
                        productNews.setTitle("\u70ed\u70c8\u5e86\u795d" + site.getName() + "\u7f51\u7ad9\u6210\u7acb");
                        productNews.setIntro(xwNews.getTitle() + ",\u5404\u65cf\u4eba\u6c11\u524d\u6765\u6b22\u5e86\u3002");
                        productNews.setTitlepic(AttachmentUtil.netUrl() + "image/default_news_titlepic.png");
                        productNews.setType(News.TYPE_IMAGENEWS);
                        productNews.setUserid(siteUserId);
                        productNews.setLegitimate((short)1);
                        this.sqlDAO.save((Object)productNews);
                        NewsData productNewsData = new NewsData(productNews.getId(), productNews.getIntro());
                        this.sqlDAO.save((Object)productNewsData);
                        site.setColumnId(this.getSiteColumnId(imageSiteColumn, site));
                        site.setDomain("s" + site.getId());
                        this.sqlDAO.save((Object)site);
                        SiteColumn lxSC = new SiteColumn();
                        lxSC.setIcon(AttachmentUtil.netUrl() + "image/lianxi.jpeg");
                        lxSC.setName("\u8054\u7cfb\u6211\u4eec");
                        lxSC.setParentid(0);
                        lxSC.setRank(4);
                        lxSC.setSiteid(site.getId());
                        lxSC.setType(SiteColumn.TYPE_PAGE);
                        lxSC.setUsed(SiteColumn.USED_ENABLE);
                        lxSC.setUserid(siteUserId);
                        this.sqlDAO.save((Object)lxSC);
                        News lxNews = new News();
                        lxNews.setAddtime(DateUtil.timeForUnix10());
                        lxNews.setCid(lxSC.getId());
                        lxNews.setIntro(lxSC.getName());
                        lxNews.setSiteid(site.getId());
                        lxNews.setStatus(News.STATUS_NORMAL);
                        lxNews.setTitle(lxSC.getName());
                        lxNews.setTitlepic(lxSC.getIcon());
                        lxNews.setType(News.TYPE_PAGE);
                        lxNews.setUserid(siteUserId);
                        lxNews.setLegitimate((short)1);
                        this.sqlDAO.save((Object)lxNews);
                        NewsData lxNewsData = new NewsData(lxNews.getId(), lxNews.getIntro());
                        this.sqlDAO.save((Object)lxNewsData);
                        this.siteColumnService.resetColumnRankAndJs(site);
                    } else {
                        columnList.add(sc);
                        new Site().siteColumn(columnList, site);
                        new Site().siteColumnRank(site, sc.getId() + "");
                    }
                    SessionUtil.setSite(site);
                    this.refreshSiteGenerateHtml(request);
                }
                MQBean mqBean = new MQBean();
                mqBean.setType(4);
                mqBean.setSimpleSite(new SimpleSite(site));
                this.updateDomainServers(mqBean);
            }
            SessionUtil.setSite(site);
            baseVO.setBaseVO(1, s.getId() > 0 ? "\u4fdd\u5b58\u7f51\u7ad9\u6210\u529f\uff01" : "\u521b\u5efa\u7f51\u7ad9\u6210\u529f\uff01");
            baseVO.setSite(site);
            return baseVO;
        }
        baseVO.setBaseVO(0, "\u4fdd\u5b58\u5931\u8d25\uff01");
        return baseVO;
    }

    @Override
    public String getSiteColumnId(SiteColumn sc, com.xnx3.wangmarket.admin.entity.Site site) {
        if (sc.getType() - SiteColumn.TYPE_IMAGENEWS == 0 || sc.getType() - SiteColumn.TYPE_NEWS == 0) {
            if (sc.getUsed() - SiteColumn.USED_ENABLE == 0) {
                if (site.getColumnId() == null || site.getColumnId().indexOf("," + sc.getId() + ",") == -1) {
                    if (site.getColumnId() == null) {
                        site.setColumnId("," + sc.getId() + ",");
                    } else {
                        site.setColumnId(site.getColumnId() + sc.getId() + ",");
                    }
                    if (site.getColumnId().length() < 80) {
                        return site.getColumnId();
                    }
                }
            } else if (site.getColumnId() != null && site.getColumnId().indexOf("," + sc.getId() + ",") > -1) {
                site.setColumnId(site.getColumnId().replaceAll("," + sc.getId() + ",", ","));
                return site.getColumnId();
            }
        }
        return null;
    }

    @Override
    public void generateSitePcIndex(com.xnx3.wangmarket.admin.entity.Site site, SiteColumn aboutUsColumn, SiteColumn newsColumn, SiteColumn imagesColumn, SiteData siteData) {
        GenerateHTML gh = new GenerateHTML(site);
        String html = gh.pcIndex();
        html = html.replaceAll("<!--Index_Content_AboutUs_Start--><!--id=0-->", "<!--Index_Content_AboutUs_Start--><!--id=" + (aboutUsColumn == null ? "0" : "" + aboutUsColumn.getId()) + "-->");
        html = html.replaceAll("<!--Index_Content_NewsList_Start--><!--id=0-->", "<!--Index_Content_NewsList_Start--><!--id=" + (newsColumn == null ? "0" : "" + newsColumn.getId()) + "-->");
        html = html.replaceAll("<!--Index_Content_NewsImageList_Start--><!--id=0-->", "<!--Index_Content_NewsImageList_Start--><!--id=" + (imagesColumn == null ? "0" : "" + imagesColumn.getId()) + "-->");
        gh.generateIndexHtml(html, siteData);
    }

    @Override
    public boolean isPcClient(com.xnx3.wangmarket.admin.entity.Site site) {
        if (site.getClient() == null) {
            return false;
        }
        return site.getClient() == com.xnx3.wangmarket.admin.entity.Site.CLIENT_PC;
    }

    @Override
    public void refreshSiteMap(com.xnx3.wangmarket.admin.entity.Site site) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset\n\txmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9\n\t\thttp://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\">\n";
        String indexUrl = "";
        indexUrl = site.getBindDomain() != null && site.getBindDomain().length() > 3 ? "http://" + site.getBindDomain() : "http://" + site.getDomain() + ".wang.market";
        xml = xml + this.getSitemapUrl(indexUrl, "1.00");
        List siteColumnList = this.sqlDAO.findBySqlQuery("SELECT * FROM site_column WHERE siteid = " + site.getId() + " AND used = " + SiteColumn.USED_ENABLE, SiteColumn.class);
        for (int i = 0; i < siteColumnList.size(); ++i) {
            SiteColumn siteColumn = (SiteColumn)siteColumnList.get(i);
            xml = xml + this.getSitemapUrl(indexUrl + "/lc" + siteColumn.getId() + "_1.html", "0.4");
        }
        List listNews = this.sqlDAO.findBySqlQuery("SELECT news.* FROM news WHERE news.siteid = " + site.getId() + " AND news.status = " + News.STATUS_NORMAL + " ORDER BY news.id DESC", News.class);
        for (int i = 0; i < listNews.size(); ++i) {
            News news = (News)listNews.get(i);
            xml = news.getType() - News.TYPE_PAGE == 0 ? xml + this.getSitemapUrl(indexUrl + "/c" + news.getCid() + ".html", "0.8") : xml + this.getSitemapUrl(indexUrl + "/" + news.getId() + ".html", "0.5");
        }
        xml = xml + "</urlset>";
        AttachmentUtil.putStringFile((String)("site/" + site.getId() + "/sitemap.xml"), (String)xml);
    }

    private String getSitemapUrl(String loc, String priority) {
        if (loc.indexOf("http:") == -1) {
            loc = "http://" + loc;
        }
        return "<url>\n\t<loc>" + loc + "</loc>\n\t<priority>" + priority + "</priority>\n</url>\n";
    }

    @Override
    public SiteRemainHintVO getSiteRemainHint(com.xnx3.wangmarket.admin.entity.Site site, Agency agency) {
        int remain;
        SiteRemainHintVO vo = new SiteRemainHintVO();
        if (agency == null) {
            vo.setResult(1);
            return vo;
        }
        vo.setCompanyName(agency.getName());
        vo.setPhone(agency.getPhone());
        vo.setQq(agency.getQq());
        if (site.getExpiretime() != null && site.getExpiretime() > 0 && (remain = site.getExpiretime() - DateUtil.timeForUnix10()) < 5184000) {
            if (remain < 1) {
                vo.setResult(3);
                vo.setRemainTimeString("\u5df2\u5230\u671f");
            } else {
                vo.setResult(0);
                vo.setRemainTimeString("\u8fd8\u5269<span style=\"font-size: 38px; font-style: oblique; padding: 5px; color:red; padding-right: 12px;\">" + (int)Math.ceil(remain / 86400) + "</span>\u5929\u5230\u671f");
            }
        }
        return vo;
    }

    @Override
    public String getSiteRemainHintForJavaScript(com.xnx3.wangmarket.admin.entity.Site site, Agency agency) {
        SiteRemainHintVO vo = this.getSiteRemainHint(site, agency);
        if (vo.getResult() - 0 == 0) {
            return "<script type=\"text/javascript\">layer.open({ type: 1 , title: '\u7f51\u7ad9\u5373\u5c06\u5230\u671f\uff0c\u7eed\u8d39\u63d0\u793a', offset: 'rb' ,content: '<div style=\"padding: 10px 30px; padding-bottom: 60px;\">\u7f51\u7ad9" + vo.getRemainTimeString() + "\uff01<br/>\u8bf7\u8054\u7cfb" + agency.getName() + "\u7eed\u8d39<br/>\u8054\u7cfb\u7535\u8bdd\uff1a" + agency.getPhone() + "<br/>\u8054\u7cfbQQ\uff1a" + agency.getQq() + "<br/>\u6240\u5728\u5730\u5740\uff1a" + agency.getAddress() + "</div>' ,shade: 0});</script>";
        }
        return "";
    }

    @Override
    public void updateDomainServers(MQBean mqBean) {
        DomainMQ.send("domain", JSONObject.fromObject((Object)mqBean).toString());
    }
}

